/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.plugin;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.utils.FileUtils;
import com.efs.sdk.plugin.EfsCollector;
import com.efs.sdk.plugin.EfsExtension;
import com.efs.sdk.plugin.EfsTracer;
import com.efs.sdk.plugin.util.Log;
import com.efs.sdk.plugin.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Project;

public class EfsTransform
extends Transform {
    private static final String TAG = "EfsPluginTransform";
    private Project project;
    private EfsExtension extension;

    public EfsTransform(Project project, EfsExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        Log.i(TAG, "begin efs transform.", new Object[0]);
        super.transform(transformInvocation);
        long start = System.currentTimeMillis();
        boolean isIncremental = transformInvocation.isIncremental();
        Collection inputs = transformInvocation.getInputs();
        TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
        ConcurrentHashMap<File, File> collectorDirFileMap = new ConcurrentHashMap<File, File>();
        ConcurrentHashMap<File, File> collectorJarFileMap = new ConcurrentHashMap<File, File>();
        for (TransformInput transformInput : inputs) {
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                File dirInput = directoryInput.getFile();
                File dirOutput = transformOutputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                if (this.extension.isEnable()) {
                    CollectDirectoryInput collectDirectoryInput = new CollectDirectoryInput(directoryInput, dirInput, dirOutput, isIncremental);
                    collectDirectoryInput.collect(collectorDirFileMap);
                    continue;
                }
                Log.i(TAG, "enable is false, src end.", new Object[0]);
                FileUtils.copyDirectory((File)dirInput, (File)dirOutput);
            }
            for (JarInput jarInput : transformInput.getJarInputs()) {
                File jarInputFile = jarInput.getFile();
                File jarOutputFile = transformOutputProvider.getContentLocation(jarInput.getFile().getAbsolutePath(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                if (this.extension.isEnable()) {
                    CollectJarInput collectJarInput = new CollectJarInput(jarInput, jarInputFile, jarOutputFile, isIncremental);
                    collectJarInput.collect(collectorJarFileMap);
                    continue;
                }
                Log.i(TAG, "enable is false, jar end.", new Object[0]);
                FileUtils.copyFile((File)jarInputFile, (File)jarOutputFile);
            }
        }
        EfsCollector efsCollector = new EfsCollector();
        efsCollector.collect(collectorDirFileMap.keySet(), collectorJarFileMap.keySet());
        EfsTracer efsTracer = new EfsTracer(efsCollector.getCollectedClassExtendMap(), this.extension.getWhiteList(), this.extension.getBlackList());
        efsTracer.trace(collectorDirFileMap, collectorJarFileMap);
        long cost = System.currentTimeMillis() - start;
        Log.i(TAG, "end efs transform, time is : %sms", cost);
    }

    public String getName() {
        return TAG;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public boolean isIncremental() {
        return true;
    }

    private class CollectJarInput {
        private static final String TAG = "EfsPluginCollectJarInput";
        private JarInput inputJar;
        private File jarInput;
        private File jarOutput;
        private boolean isIncremental;

        public CollectJarInput(JarInput inputJar, File jarInput, File jarOutput, boolean isIncremental) {
            this.inputJar = inputJar;
            this.jarInput = jarInput;
            this.jarOutput = jarOutput;
            this.isIncremental = isIncremental;
        }

        public void collect(Map<File, File> collectorJarFileMap) throws IOException {
            if (Utils.isRealZipOrJar(this.jarInput)) {
                if (this.isIncremental) {
                    if (this.inputJar.getStatus() == Status.ADDED || this.inputJar.getStatus() == Status.CHANGED) {
                        collectorJarFileMap.put(this.jarInput, this.jarOutput);
                    } else if (this.inputJar.getStatus() == Status.REMOVED) {
                        this.jarOutput.delete();
                    }
                } else {
                    collectorJarFileMap.put(this.jarInput, this.jarOutput);
                }
            }
        }
    }

    private class CollectDirectoryInput {
        private static final String TAG = "EfsPluginCollectDirectoryInput";
        private DirectoryInput directoryInput;
        private File dirInput;
        private File dirOutput;
        private boolean isIncremental;

        public CollectDirectoryInput(DirectoryInput directoryInput, File dirInput, File dirOutput, boolean isIncremental) {
            this.directoryInput = directoryInput;
            this.dirInput = dirInput;
            this.dirOutput = dirOutput;
            this.isIncremental = isIncremental;
        }

        public void collect(Map<File, File> collectorDirFileMap) throws IOException {
            if (this.isIncremental) {
                Map fileStatusMap = this.directoryInput.getChangedFiles();
                for (Map.Entry entry : fileStatusMap.entrySet()) {
                    Status status = (Status)entry.getValue();
                    File changedFileInput = (File)entry.getKey();
                    String changedFileInputFullPath = changedFileInput.getAbsolutePath();
                    String inputFullPath = this.dirInput.getAbsolutePath();
                    String outputFullPath = this.dirOutput.getAbsolutePath();
                    File changedFileOutput = new File(changedFileInputFullPath.replace(inputFullPath, outputFullPath));
                    if (status == Status.ADDED || status == Status.CHANGED) {
                        collectorDirFileMap.put(changedFileInput, changedFileOutput);
                        Log.i(TAG, "add or changed is " + changedFileInputFullPath, new Object[0]);
                        continue;
                    }
                    if (status != Status.REMOVED) continue;
                    changedFileOutput.delete();
                    Log.i(TAG, "removed is " + changedFileInputFullPath, new Object[0]);
                }
            } else {
                collectorDirFileMap.put(this.dirInput, this.dirOutput);
            }
        }
    }
}

