/*
 * Decompiled with CFR 0.152.
 */
package org.android.spdy;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class SoInstallMgrSdk {
    private static final String ARMEABI = "armeabi";
    private static final String X86 = "x86";
    private static final String MIPS = "mips";
    static Context mContext = null;
    private static final int EventID_SO_INIT = 21033;
    static final String LOGTAG = "INIT_SO";

    public static void init(Context c) {
        mContext = c;
    }

    public static boolean initSo(String libName, int version) {
        return SoInstallMgrSdk.initSo(libName, version, null);
    }

    public static boolean initSo(String libName, int version, ClassLoader classLoader) {
        boolean InitSuc = false;
        try {
            if (classLoader == null) {
                System.loadLibrary(libName);
            } else {
                Runtime runtime = Runtime.getRuntime();
                Class[] args = new Class[]{String.class, ClassLoader.class};
                Method method = Runtime.class.getDeclaredMethod("loadLibrary", args);
                method.setAccessible(true);
                method.invoke((Object)runtime, libName, classLoader);
            }
            InitSuc = true;
        }
        catch (Exception e) {
            InitSuc = false;
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e2) {
            InitSuc = false;
            e2.printStackTrace();
        }
        catch (Error e3) {
            InitSuc = false;
            e3.printStackTrace();
        }
        try {
            if (!InitSuc) {
                String cpuType;
                if (SoInstallMgrSdk.isExist(libName, version)) {
                    boolean res = SoInstallMgrSdk._loadUnzipSo(libName, version, classLoader);
                    if (res) {
                        return res;
                    }
                    SoInstallMgrSdk.removeSoIfExit(libName, version);
                }
                if (!(cpuType = SoInstallMgrSdk._cpuType()).equalsIgnoreCase(MIPS) && !cpuType.equalsIgnoreCase(X86)) {
                    try {
                        InitSuc = SoInstallMgrSdk.unZipSelectedFiles(libName, version, classLoader);
                    }
                    catch (ZipException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            InitSuc = false;
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e2) {
            InitSuc = false;
            e2.printStackTrace();
        }
        catch (Error e3) {
            InitSuc = false;
            e3.printStackTrace();
        }
        if (!InitSuc) {
            // empty if block
        }
        return InitSuc;
    }

    private static String _getFieldReflectively(Build build, String fieldName) {
        try {
            Field field = Build.class.getField(fieldName);
            return field.get(build).toString();
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }

    private static String _cpuType() {
        String abi = SoInstallMgrSdk._getFieldReflectively(new Build(), "CPU_ABI");
        if (abi == null || abi.length() == 0 || abi.equals("Unknown")) {
            abi = ARMEABI;
        }
        abi = abi.toLowerCase();
        return abi;
    }

    static String _targetSoFile(String libname, int version) {
        Context context = mContext;
        if (null == context) {
            return "";
        }
        String path = "/data/data/" + context.getPackageName() + "/files";
        File f = context.getFilesDir();
        if (f != null) {
            path = f.getPath();
        }
        return path + "/lib" + libname + "bk" + version + ".so";
    }

    static void removeSoIfExit(String libname, int version) {
        String file = SoInstallMgrSdk._targetSoFile(libname, version);
        File a = new File(file);
        if (a.exists()) {
            a.delete();
        }
    }

    static boolean isExist(String libname, int version) {
        String file = SoInstallMgrSdk._targetSoFile(libname, version);
        File a = new File(file);
        return a.exists();
    }

    static boolean _loadUnzipSo(String libname, int version, ClassLoader classLoader) {
        boolean initSuc = false;
        try {
            if (SoInstallMgrSdk.isExist(libname, version)) {
                if (classLoader == null) {
                    System.load(SoInstallMgrSdk._targetSoFile(libname, version));
                } else {
                    Runtime runtime = Runtime.getRuntime();
                    Class[] args = new Class[]{String.class, ClassLoader.class};
                    Method method = Runtime.class.getDeclaredMethod("load", args);
                    method.setAccessible(true);
                    method.invoke((Object)runtime, SoInstallMgrSdk._targetSoFile(libname, version), classLoader);
                }
            }
            initSuc = true;
        }
        catch (Exception e) {
            initSuc = false;
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e2) {
            initSuc = false;
            e2.printStackTrace();
        }
        catch (Error e3) {
            initSuc = false;
            e3.printStackTrace();
        }
        return initSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unZipSelectedFiles(String libname, int version, ClassLoader classLoader) throws ZipException, IOException {
        String sourcePath = "lib/armeabi/lib" + libname + ".so";
        try {
            String zipPath = "";
            Context context = mContext;
            if (context == null) {
                return false;
            }
            ApplicationInfo aInfo = context.getApplicationInfo();
            if (null != aInfo) {
                zipPath = aInfo.sourceDir;
            }
            ZipFile zf = new ZipFile(zipPath);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String path = entry.getName();
                if (path.contains("..") || path.contains("\\") || path.contains("%")) {
                    return false;
                }
                if (!entry.getName().startsWith(sourcePath)) continue;
                InputStream in = null;
                FileOutputStream os = null;
                AbstractInterruptibleChannel channel = null;
                int total = 0;
                try {
                    int realLength;
                    SoInstallMgrSdk.removeSoIfExit(libname, version);
                    in = zf.getInputStream(entry);
                    os = context.openFileOutput("lib" + libname + "bk" + version + ".so", 0);
                    channel = os.getChannel();
                    byte[] buffers = new byte[1024];
                    while ((realLength = in.read(buffers)) > 0) {
                        ((FileChannel)channel).write(ByteBuffer.wrap(buffers, 0, realLength));
                        total += realLength;
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (zf != null) {
                        zf.close();
                        zf = null;
                    }
                }
                if (total > 0) {
                    return SoInstallMgrSdk._loadUnzipSo(libname, version, classLoader);
                }
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

