/*
 * Decompiled with CFR 0.152.
 */
package com.umang.fcmclient;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import com.umang.fcmclient.AppLifecycleObserver;
import com.umang.fcmclient.AsyncExecutor;
import com.umang.fcmclient.FcmClientHelper;
import com.umang.fcmclient.listeners.FirebaseMessageListener;
import com.umang.fcmclient.repository.Provider;
import com.umang.fcmclient.util.Logger;
import com.umang.fcmclient.util.UtilsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ$\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\r\u0010\u001c\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001dJ\r\u0010\u001e\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b!J\u0015\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u0012H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002J\u000e\u0010(\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\b\u0010)\u001a\u00020\u0012H\u0002J\b\u0010*\u001a\u00020\u0012H\u0002J\u0014\u0010+\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0-J\u0014\u0010.\u001a\u00020\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/umang/fcmclient/FcmClientHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isAppInForeground", "", "listeners", "", "Lcom/umang/fcmclient/listeners/FirebaseMessageListener;", "logger", "Lcom/umang/fcmclient/util/Logger;", "retryInterval", "", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "addListener", "", "listener", "initialise", "application", "Landroid/app/Application;", "logLevel", "Lcom/umang/fcmclient/util/Logger$LogLevel;", "notifyListeners", "token", "", "onAppBackground", "onAppBackground$fcm_client_release", "onAppForeGround", "onAppForeGround$fcm_client_release", "onNewToken", "onNewToken$fcm_client_release", "onPushReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onPushReceived$fcm_client_release", "registerForPush", "registerForPushIfRequired", "removeListener", "scheduleRetry", "shutdownRetryScheduler", "subscribeToTopics", "topics", "", "unSubscribeTopic", "Companion", "fcm-client_release"})
public final class FcmClientHelper {
    private final Logger logger;
    private final List<FirebaseMessageListener> listeners;
    private ScheduledExecutorService scheduledExecutor;
    private boolean isAppInForeground;
    private long retryInterval;
    private Context context;
    private static FcmClientHelper instance;
    public static final Companion Companion;

    public final void addListener(@NotNull FirebaseMessageListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final void removeListener(@NotNull FirebaseMessageListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    @Deprecated(message="This API has been deprecated since 2.1.00", replaceWith=@ReplaceWith(imports={"com.umang.fcmclient.FcmClientHelper"}, expression="FcmClientHelper.getInstance(applicationContext).initialise()"), level=DeprecationLevel.WARNING)
    public final void initialise(@NotNull Application application, @NotNull Logger.LogLevel logLevel, long retryInterval) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        try {
            this.initialise(logLevel, retryInterval);
        }
        catch (Exception e) {
            this.logger.error(" initialise() ", e);
        }
    }

    public static /* synthetic */ void initialise$default(FcmClientHelper fcmClientHelper, Application application, Logger.LogLevel logLevel, long l, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = Logger.LogLevel.ERROR;
        }
        if ((n & 4) != 0) {
            l = 30L;
        }
        fcmClientHelper.initialise(application, logLevel, l);
    }

    public final void initialise(@NotNull Logger.LogLevel logLevel, long retryInterval) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        try {
            LifecycleOwner lifecycleOwner = ProcessLifecycleOwner.get();
            Intrinsics.checkNotNullExpressionValue((Object)lifecycleOwner, (String)"ProcessLifecycleOwner.get()");
            Lifecycle lifecycle = lifecycleOwner.getLifecycle();
            Context context = this.context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context.applicationContext");
            lifecycle.addObserver((LifecycleObserver)new AppLifecycleObserver(context));
            Logger.Companion.setLogLevel$fcm_client_release(logLevel);
            Context context2 = this.context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            Logger.Companion.setLogEnabled$fcm_client_release(UtilsKt.isDebugBuild(context2));
            if (retryInterval >= (long)5) {
                this.retryInterval = retryInterval;
            }
            this.logger.verbose(" initialise() Initialising fcm client library. Log level - " + (Object)((Object)logLevel));
        }
        catch (Exception e) {
            this.logger.error(" initialise() ", e);
        }
    }

    public static /* synthetic */ void initialise$default(FcmClientHelper fcmClientHelper, Logger.LogLevel logLevel, long l, int n, Object object) {
        if ((n & 1) != 0) {
            logLevel = Logger.LogLevel.ERROR;
        }
        if ((n & 2) != 0) {
            l = 30L;
        }
        fcmClientHelper.initialise(logLevel, l);
    }

    public final synchronized void onPushReceived$fcm_client_release(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkNotNullParameter((Object)remoteMessage, (String)"remoteMessage");
        for (FirebaseMessageListener listener : this.listeners) {
            try {
                listener.onPushReceived(remoteMessage);
            }
            catch (Exception e) {
                this.logger.error("onPushReceived() ", e);
            }
        }
    }

    public final void subscribeToTopics(@NotNull List<String> topics) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        AsyncExecutor.INSTANCE.submit((Function0)new Function0<Unit>(this, topics){
            final /* synthetic */ FcmClientHelper this$0;
            final /* synthetic */ List $topics;

            public final void invoke() {
                try {
                    for (String topic : this.$topics) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose("Subscribing to " + topic);
                        FirebaseMessaging.getInstance().subscribeToTopic(topic).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(this){
                            final /* synthetic */ subscribeToTopics.1 this$0;

                            public final void onComplete(@NotNull Task<Void> task) {
                                Intrinsics.checkNotNullParameter(task, (String)"task");
                                FcmClientHelper.access$getLogger$p(this.this$0.this$0).verbose("subscribeToTopic() isSuccess " + task.isSuccessful());
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error(" subscribeToTopic() ", e);
                }
            }
            {
                this.this$0 = fcmClientHelper;
                this.$topics = list;
                super(0);
            }
        });
    }

    public final void unSubscribeTopic(@NotNull List<String> topics) {
        Intrinsics.checkNotNullParameter(topics, (String)"topics");
        AsyncExecutor.INSTANCE.submit((Function0)new Function0<Unit>(this, topics){
            final /* synthetic */ FcmClientHelper this$0;
            final /* synthetic */ List $topics;

            public final void invoke() {
                try {
                    for (String topic : this.$topics) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose("Un-subscribing to " + topic);
                        FirebaseMessaging.getInstance().unsubscribeFromTopic(topic);
                    }
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error(" unSubscribeTopic() ", e);
                }
            }
            {
                this.this$0 = fcmClientHelper;
                this.$topics = list;
                super(0);
            }
        });
    }

    public final void onNewToken$fcm_client_release(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        AsyncExecutor.INSTANCE.submit((Function0)new Function0<Unit>(this, token){
            final /* synthetic */ FcmClientHelper this$0;
            final /* synthetic */ String $token;

            public final void invoke() {
                try {
                    Provider.INSTANCE.getRepository$fcm_client_release(FcmClientHelper.access$getContext$p(this.this$0)).saveToken$fcm_client_release(this.$token);
                    FcmClientHelper.access$notifyListeners(this.this$0, this.$token);
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error(" onNewToken() ", e);
                }
            }
            {
                this.this$0 = fcmClientHelper;
                this.$token = string;
                super(0);
            }
        });
    }

    private final void registerForPushIfRequired() {
        String savedToken = Provider.INSTANCE.getRepository$fcm_client_release(this.context).getToken$fcm_client_release();
        CharSequence charSequence = savedToken;
        boolean bl = false;
        if (charSequence.length() == 0) {
            this.registerForPush();
        }
    }

    public final void onAppForeGround$fcm_client_release() {
        try {
            this.logger.verbose("onAppForeGround(): Application coming to foreground.");
            this.registerForPush();
            this.isAppInForeground = true;
        }
        catch (Exception e) {
            this.logger.error(" onAppForeGround(): Exception: ", e);
        }
    }

    public final void onAppBackground$fcm_client_release() {
        try {
            this.logger.verbose("onAppBackground(): Application going to background.");
            this.isAppInForeground = false;
            this.shutdownRetryScheduler();
            this.registerForPushIfRequired();
        }
        catch (Exception e) {
            this.logger.error(" onAppBackground(): Exception: ", e);
        }
    }

    private final void registerForPush() {
        this.logger.verbose(" registerForPush(): Will register for push.");
        FirebaseMessaging firebaseMessaging = FirebaseMessaging.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)firebaseMessaging, (String)"FirebaseMessaging.getInstance()");
        firebaseMessaging.getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(this){
            final /* synthetic */ FcmClientHelper this$0;

            public final void onComplete(@NotNull Task<String> task) {
                Intrinsics.checkNotNullParameter(task, (String)"task");
                try {
                    if (!task.isSuccessful()) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose(" registerForPush(): Token registration failed.");
                        FcmClientHelper.access$scheduleRetry(this.this$0);
                        return;
                    }
                    String token = (String)task.getResult();
                    CharSequence charSequence = token;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose(" registerForPush(): Token null or empty.");
                        FcmClientHelper.access$scheduleRetry(this.this$0);
                        return;
                    }
                    FcmClientHelper.access$getLogger$p(this.this$0).info(" registerForPush() Token: " + token);
                    this.this$0.onNewToken$fcm_client_release(token);
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error("registerForPush(): ", e);
                    FcmClientHelper.access$scheduleRetry(this.this$0);
                }
            }
            {
                this.this$0 = fcmClientHelper;
            }
        });
    }

    private final void scheduleRetry() {
        if (!this.isAppInForeground) {
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"scheduledExecutor");
        if (scheduledExecutorService.isShutdown()) {
            this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        }
        this.logger.verbose(" scheduleRetry() Will schedule retry.");
        this.scheduledExecutor.schedule(new Runnable(this){
            final /* synthetic */ FcmClientHelper this$0;

            public final void run() {
                FcmClientHelper.access$registerForPush(this.this$0);
            }
            {
                this.this$0 = fcmClientHelper;
            }
        }, this.retryInterval, TimeUnit.SECONDS);
    }

    private final void shutdownRetryScheduler() {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"scheduledExecutor");
        if (!scheduledExecutorService.isShutdown()) {
            this.logger.verbose(" shutdownRetryScheduler() Shutting down retry scheduler.");
            this.scheduledExecutor.shutdownNow();
        }
    }

    private final void notifyListeners(String token) {
        try {
            this.logger.verbose(" notifyListenersIfRequired() : Notifying listeners");
            for (FirebaseMessageListener listener : this.listeners) {
                try {
                    listener.onTokenAvailable(token);
                }
                catch (Exception e) {
                    this.logger.error(" notifyListenersIfRequired() : ", e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(" notifyListenersIfRequired() ", e);
        }
    }

    public FcmClientHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.logger = Logger.Companion.getLogger$fcm_client_release("FcmClientHelper");
        boolean bl = false;
        this.listeners = new ArrayList();
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        this.retryInterval = 30L;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(FcmClientHelper $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Context access$getContext$p(FcmClientHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$setContext$p(FcmClientHelper $this, Context context) {
        $this.context = context;
    }

    public static final /* synthetic */ void access$notifyListeners(FcmClientHelper $this, String token) {
        $this.notifyListeners(token);
    }

    public static final /* synthetic */ void access$scheduleRetry(FcmClientHelper $this) {
        $this.scheduleRetry();
    }

    public static final /* synthetic */ void access$registerForPush(FcmClientHelper $this) {
        $this.registerForPush();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/umang/fcmclient/FcmClientHelper$Companion;", "", "()V", "instance", "Lcom/umang/fcmclient/FcmClientHelper;", "getInstance", "context", "Landroid/content/Context;", "fcm-client_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final FcmClientHelper getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            FcmClientHelper fcmClientHelper = instance;
            if (fcmClientHelper == null) {
                Class<FcmClientHelper> clazz = FcmClientHelper.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    FcmClientHelper fcmClientHelper2 = instance;
                    if (fcmClientHelper2 == null) {
                        fcmClientHelper2 = new FcmClientHelper(context);
                    }
                    FcmClientHelper inst = fcmClientHelper2;
                    instance = inst;
                    FcmClientHelper fcmClientHelper3 = inst;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                    fcmClientHelper = fcmClientHelper3;
                }
            }
            return fcmClientHelper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

