/*
 * Decompiled with CFR 0.152.
 */
package com.umang.fcmclient;

import android.app.Application;
import android.content.Context;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import com.umang.fcmclient.ActivityLifecycleCallbacks;
import com.umang.fcmclient.AsyncExecutor;
import com.umang.fcmclient.listeners.FirebaseMessageListener;
import com.umang.fcmclient.repository.Repository;
import com.umang.fcmclient.util.Logger;
import com.umang.fcmclient.util.UtilsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\"\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\u0015\u0010\"\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020\u0017H\u0002J\b\u0010-\u001a\u00020\u0017H\u0002J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fJ\b\u0010/\u001a\u00020\u0017H\u0002J\b\u00100\u001a\u00020\u0017H\u0002J\u0014\u00101\u001a\u00020\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00020 03J\u0014\u00104\u001a\u00020\u00172\f\u00102\u001a\b\u0012\u0004\u0012\u00020 03R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/umang/fcmclient/FcmClientHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "activityCounter", "", "isAppInForeground", "", "()Z", "listeners", "", "Lcom/umang/fcmclient/listeners/FirebaseMessageListener;", "logger", "Lcom/umang/fcmclient/util/Logger;", "repository", "Lcom/umang/fcmclient/repository/Repository;", "retryInterval", "", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "addListener", "", "listener", "initialise", "application", "Landroid/app/Application;", "logLevel", "Lcom/umang/fcmclient/util/Logger$LogLevel;", "notifyListenersIfRequired", "token", "", "onAppBackground", "onNewToken", "onNewToken$fcm_client_release", "onPushReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onPushReceived$fcm_client_release", "onStart", "onStart$fcm_client_release", "onStop", "onStop$fcm_client_release", "registerForPush", "registerForPushIfRequired", "removeListener", "scheduleRetry", "shutdownRetryScheduler", "subscribeToTopics", "topics", "", "unSubscribeTopic", "Companion", "fcm-client_release"})
public final class FcmClientHelper {
    private final Logger logger;
    private int activityCounter;
    private final List<FirebaseMessageListener> listeners;
    private ScheduledExecutorService scheduledExecutor;
    private final Repository repository;
    private long retryInterval;
    private Context context;
    private static FcmClientHelper instance;
    public static final Companion Companion;

    private final boolean isAppInForeground() {
        return this.activityCounter > 0;
    }

    public final void addListener(@NotNull FirebaseMessageListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final void removeListener(@NotNull FirebaseMessageListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    public final void initialise(@NotNull Application application, @NotNull Logger.LogLevel logLevel, long retryInterval) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)((Object)logLevel), (String)"logLevel");
        try {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacks());
            Logger.Companion.setLogLevel$fcm_client_release(logLevel);
            Context context = application.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"application.applicationContext");
            Logger.Companion.setLogEnabled$fcm_client_release(UtilsKt.isDebugBuild(context));
            if (retryInterval >= (long)5) {
                this.retryInterval = retryInterval;
            }
            this.logger.verbose(" initialise() Initialising fcm client library. Log level - " + (Object)((Object)logLevel));
        }
        catch (Exception e) {
            this.logger.error(" initialise() ", e);
        }
    }

    public static /* synthetic */ void initialise$default(FcmClientHelper fcmClientHelper, Application application, Logger.LogLevel logLevel, long l, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = Logger.LogLevel.ERROR;
        }
        if ((n & 4) != 0) {
            l = 30L;
        }
        fcmClientHelper.initialise(application, logLevel, l);
    }

    public final synchronized void onPushReceived$fcm_client_release(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkParameterIsNotNull((Object)remoteMessage, (String)"remoteMessage");
        for (FirebaseMessageListener listener : this.listeners) {
            try {
                listener.onPushReceived(remoteMessage);
            }
            catch (Exception e) {
                this.logger.error("onPushReceived() ", e);
            }
        }
    }

    public final void subscribeToTopics(@NotNull List<String> topics) {
        Intrinsics.checkParameterIsNotNull(topics, (String)"topics");
        AsyncExecutor.INSTANCE.submit((Function0)new Function0<Unit>(this, topics){
            final /* synthetic */ FcmClientHelper this$0;
            final /* synthetic */ List $topics;

            public final void invoke() {
                try {
                    for (String topic : this.$topics) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose("Subscribing to " + topic);
                        FirebaseMessaging.getInstance().subscribeToTopic(topic);
                    }
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error(" subscribeToTopic() ", e);
                }
            }
            {
                this.this$0 = fcmClientHelper;
                this.$topics = list;
                super(0);
            }
        });
    }

    public final void unSubscribeTopic(@NotNull List<String> topics) {
        Intrinsics.checkParameterIsNotNull(topics, (String)"topics");
        AsyncExecutor.INSTANCE.submit((Function0)new Function0<Unit>(this, topics){
            final /* synthetic */ FcmClientHelper this$0;
            final /* synthetic */ List $topics;

            public final void invoke() {
                try {
                    for (String topic : this.$topics) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose("Un-subscribing to " + topic);
                        FirebaseMessaging.getInstance().unsubscribeFromTopic(topic);
                    }
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error(" unSubscribeTopic() ", e);
                }
            }
            {
                this.this$0 = fcmClientHelper;
                this.$topics = list;
                super(0);
            }
        });
    }

    public final void onStart$fcm_client_release() {
        try {
            if (this.activityCounter == 0) {
                this.registerForPush();
            }
            int n = this.activityCounter;
            this.activityCounter = n + 1;
            this.logger.verbose("onStart(): activity counter: " + this.activityCounter);
        }
        catch (Exception e) {
            this.logger.error(" onStart() ", e);
        }
    }

    public final void onStop$fcm_client_release() {
        try {
            int n = this.activityCounter;
            this.activityCounter = n + -1;
            this.logger.verbose("onStop(): activity counter: " + this.activityCounter);
            if (this.activityCounter == 0) {
                this.onAppBackground();
            }
        }
        catch (Exception e) {
            this.logger.error(" onStop() ", e);
        }
    }

    public final void onNewToken$fcm_client_release(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        try {
            this.notifyListenersIfRequired(token);
            this.repository.saveToken(token);
        }
        catch (Exception e) {
            this.logger.error(" onNewToken() ", e);
        }
    }

    private final void registerForPushIfRequired() {
        String savedToken = this.repository.getToken();
        CharSequence charSequence = savedToken;
        boolean bl = false;
        if (charSequence.length() == 0) {
            this.registerForPush();
        }
    }

    private final void onAppBackground() {
        this.shutdownRetryScheduler();
        this.registerForPushIfRequired();
    }

    private final void registerForPush() {
        this.logger.verbose(" registerForPush(): Will register for push.");
        FirebaseInstanceId firebaseInstanceId = FirebaseInstanceId.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseInstanceId, (String)"FirebaseInstanceId.getInstance()");
        firebaseInstanceId.getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(this){
            final /* synthetic */ FcmClientHelper this$0;

            public final void onComplete(@NotNull Task<InstanceIdResult> task) {
                Intrinsics.checkParameterIsNotNull(task, (String)"task");
                try {
                    if (!task.isSuccessful()) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose(" registerForPush(): Token registration failed.");
                        FcmClientHelper.access$scheduleRetry(this.this$0);
                        return;
                    }
                    InstanceIdResult instanceIdResult = (InstanceIdResult)task.getResult();
                    String token = instanceIdResult != null ? instanceIdResult.getToken() : null;
                    CharSequence charSequence = token;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        FcmClientHelper.access$getLogger$p(this.this$0).verbose(" registerForPush(): Token null or empty.");
                        FcmClientHelper.access$scheduleRetry(this.this$0);
                        return;
                    }
                    FcmClientHelper.access$getLogger$p(this.this$0).info(" registerForPush() Token: " + token);
                    this.this$0.onNewToken$fcm_client_release(token);
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error("registerForPush(): ", e);
                    FcmClientHelper.access$scheduleRetry(this.this$0);
                }
            }
            {
                this.this$0 = fcmClientHelper;
            }
        });
    }

    private final void scheduleRetry() {
        if (!this.isAppInForeground()) {
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"scheduledExecutor");
        if (scheduledExecutorService.isShutdown()) {
            this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        }
        this.logger.verbose(" scheduleRetry() Will schedule retry.");
        this.scheduledExecutor.schedule(new Runnable(this){
            final /* synthetic */ FcmClientHelper this$0;

            public final void run() {
                FcmClientHelper.access$registerForPush(this.this$0);
            }
            {
                this.this$0 = fcmClientHelper;
            }
        }, this.retryInterval, TimeUnit.SECONDS);
    }

    private final void shutdownRetryScheduler() {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"scheduledExecutor");
        if (!scheduledExecutorService.isShutdown()) {
            this.logger.verbose(" shutdownRetryScheduler() Shutting down retry scheduler.");
            this.scheduledExecutor.shutdownNow();
        }
    }

    private final void notifyListenersIfRequired(String token) {
        AsyncExecutor.INSTANCE.submit((Function0)new Function0<Unit>(this, token){
            final /* synthetic */ FcmClientHelper this$0;
            final /* synthetic */ String $token;

            public final void invoke() {
                try {
                    String savedToken = FcmClientHelper.access$getRepository$p(this.this$0).getToken();
                    if (Intrinsics.areEqual((Object)this.$token, (Object)savedToken)) {
                        return;
                    }
                    FcmClientHelper.access$getLogger$p(this.this$0).verbose(" notifyListenersIfRequired() : Notifying listeners");
                    for (FirebaseMessageListener listener : FcmClientHelper.access$getListeners$p(this.this$0)) {
                        try {
                            listener.onTokenAvailable(this.$token);
                        }
                        catch (Exception e) {
                            FcmClientHelper.access$getLogger$p(this.this$0).error(" notifyListenersIfRequired() : ", e);
                        }
                    }
                }
                catch (Exception e) {
                    FcmClientHelper.access$getLogger$p(this.this$0).error(" notifyListenersIfRequired() ", e);
                }
            }
            {
                this.this$0 = fcmClientHelper;
                this.$token = string;
                super(0);
            }
        });
    }

    public FcmClientHelper(@NotNull Context context) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.logger = Logger.Companion.getLogger("FcmClientHelper");
        FcmClientHelper fcmClientHelper = this;
        boolean bl = false;
        fcmClientHelper.listeners = list = (List)new ArrayList();
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        this.repository = new Repository(this.context);
        this.retryInterval = 30L;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(FcmClientHelper $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$scheduleRetry(FcmClientHelper $this) {
        $this.scheduleRetry();
    }

    public static final /* synthetic */ void access$registerForPush(FcmClientHelper $this) {
        $this.registerForPush();
    }

    public static final /* synthetic */ Repository access$getRepository$p(FcmClientHelper $this) {
        return $this.repository;
    }

    public static final /* synthetic */ List access$getListeners$p(FcmClientHelper $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/umang/fcmclient/FcmClientHelper$Companion;", "", "()V", "instance", "Lcom/umang/fcmclient/FcmClientHelper;", "getInstance", "context", "Landroid/content/Context;", "fcm-client_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final FcmClientHelper getInstance(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (instance == null) {
                Class<FcmClientHelper> clazz = FcmClientHelper.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (instance == null) {
                        instance = new FcmClientHelper(context);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            FcmClientHelper fcmClientHelper = instance;
            if (fcmClientHelper == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.umang.fcmclient.FcmClientHelper");
            }
            return fcmClientHelper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

