/*
 * Decompiled with CFR 0.152.
 */
package com.umang.fcmclient;

import android.app.Application;
import android.content.Context;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.RemoteMessage;
import com.umang.fcmclient.FCMClientLibActivityLifecycleCallbacks;
import com.umang.fcmclient.FCMClientLibWorker;
import com.umang.fcmclient.SharedPref;
import com.umang.logger.SmartLogHelper;
import com.umang.logger.SmartLogger;
import com.umang.logger.SmartLoggerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 -2\u00020\u0001:\u0003-./B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000bH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0015\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\r\u0010\u001c\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001dJ\r\u0010\u001e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u000bH\u0002J\u000e\u0010&\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010(\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0014\u0010*\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0016\u0010+\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/umang/fcmclient/FCMClientHelper;", "Lcom/umang/logger/SmartLogger;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "pushReceivedListener", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/umang/fcmclient/FCMClientHelper$PushReceivedListener;", "tokenReceivedListener", "Lcom/umang/fcmclient/FCMClientHelper$TokenReceivedListener;", "disableLogs", "", "enableLogs", "enableLogsForSignedBuild", "forceRegisterForPush", "getSubscribedTopics", "", "", "initializeFCMClient", "application", "Landroid/app/Application;", "onNewToken", "token", "onNewToken$fcm_client_release", "onPushReceived", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onPushReceived$fcm_client_release", "onStart", "onStart$fcm_client_release", "onStop", "onStop$fcm_client_release", "onTokenRegistered", "onTokenRegistered$fcm_client_release", "refreshToken", "refreshToken$fcm_client_release", "registerForPush", "registerForPushIfRequired", "registerPushReceivedListener", "registerTokenRegistrationListener", "subscribeToTopics", "topics", "unSubscribeTopic", "updateSubscribedTopics", "writeTokenToStorage", "Companion", "PushReceivedListener", "TokenReceivedListener", "fcm-client_release"})
public final class FCMClientHelper
implements SmartLogger {
    private ConcurrentLinkedQueue<TokenReceivedListener> tokenReceivedListener;
    private ConcurrentLinkedQueue<PushReceivedListener> pushReceivedListener;
    private Context context;
    private static int activityCounter;
    private static FCMClientHelper instance;
    public static final Companion Companion;

    public final void registerTokenRegistrationListener(@NotNull TokenReceivedListener tokenReceivedListener) {
        Intrinsics.checkParameterIsNotNull((Object)tokenReceivedListener, (String)"tokenReceivedListener");
        this.tokenReceivedListener.add(tokenReceivedListener);
    }

    public final void registerPushReceivedListener(@NotNull PushReceivedListener pushReceivedListener) {
        Intrinsics.checkParameterIsNotNull((Object)pushReceivedListener, (String)"pushReceivedListener");
        this.pushReceivedListener.add(pushReceivedListener);
    }

    public final synchronized void onTokenRegistered$fcm_client_release(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        if (StringsKt.equals$default((String)SharedPref.Companion.newInstance(this.context).getPushToken(), (String)token, (boolean)false, (int)2, null)) {
            return;
        }
        Iterable $receiver$iv = this.tokenReceivedListener;
        for (Object element$iv : $receiver$iv) {
            TokenReceivedListener it = (TokenReceivedListener)element$iv;
            it.onTokenReceived(token);
        }
    }

    public final void initializeFCMClient(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new FCMClientLibActivityLifecycleCallbacks());
        SmartLogHelper.INSTANCE.setLOG_TAG("FCMClient_v1100");
        SmartLogHelper.INSTANCE.initializeLogger(this.context);
    }

    public final synchronized void onPushReceived$fcm_client_release(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkParameterIsNotNull((Object)remoteMessage, (String)"remoteMessage");
        Iterable $receiver$iv = this.pushReceivedListener;
        for (Object element$iv : $receiver$iv) {
            PushReceivedListener it = (PushReceivedListener)element$iv;
            it.onPushReceived(remoteMessage);
        }
    }

    private final void registerForPushIfRequired() {
        String savedToken = SharedPref.Companion.newInstance(this.context).getPushToken();
        if (savedToken == null) {
            this.forceRegisterForPush();
        }
    }

    public final void subscribeToTopics(@NotNull List<String> topics) {
        Intrinsics.checkParameterIsNotNull(topics, (String)"topics");
        FCMClientLibWorker.Companion.subscribeToTopic(this.context, topics);
        SharedPref.Companion.newInstance(this.context).setTopics(CollectionsKt.toSet((Iterable)topics));
    }

    public final void enableLogs() {
        SmartLogHelper.INSTANCE.setLOG_LEVEL(5);
    }

    public final void disableLogs() {
        SmartLogHelper.INSTANCE.setLOG_STATUS(false);
    }

    public final void enableLogsForSignedBuild() {
        SmartLogHelper.INSTANCE.setLOG_STATUS(true);
        SmartLogHelper.INSTANCE.setLOG_LEVEL(5);
    }

    private final void forceRegisterForPush() {
        this.registerForPush();
    }

    public final void onStart$fcm_client_release() {
        if (activityCounter == 0) {
            this.forceRegisterForPush();
        }
        this.registerForPushIfRequired();
        int n = activityCounter;
        activityCounter = n + 1;
        SmartLoggerKt.verbose$default((SmartLogger)this, (String)("onStart(): activity counter: " + activityCounter), null, (int)2, null);
    }

    public final void onStop$fcm_client_release() {
        int n = activityCounter;
        activityCounter = n + -1;
        SmartLoggerKt.verbose$default((SmartLogger)this, (String)("onStop(): activity counter: " + activityCounter), null, (int)2, null);
        if (activityCounter == 0) {
            this.registerForPushIfRequired();
        }
    }

    public final void refreshToken$fcm_client_release() {
        SharedPref.Companion.newInstance(this.context).setPushToken(null);
        this.registerForPush();
    }

    private final List<String> getSubscribedTopics() {
        Set<String> subscribedSet = SharedPref.Companion.newInstance(this.context).getTopics();
        List subscribedArray = new ArrayList();
        Set<String> set = subscribedSet;
        if (set != null) {
            Iterable $receiver$iv = set;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                subscribedArray.add(it);
            }
        }
        return subscribedArray;
    }

    public final void unSubscribeTopic(@NotNull List<String> topics) {
        Intrinsics.checkParameterIsNotNull(topics, (String)"topics");
        List subscribedTopics = CollectionsKt.toMutableList((Collection)this.getSubscribedTopics());
        Collection collection = subscribedTopics;
        if (!collection.isEmpty()) {
            Iterable $receiver$iv = topics;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                if (!subscribedTopics.contains(it)) continue;
                subscribedTopics.remove(it);
            }
            this.updateSubscribedTopics(topics);
            FCMClientLibWorker.Companion.unsubscribeFromTopic(this.context, topics);
        }
    }

    private final void registerForPush() {
        FirebaseInstanceId firebaseInstanceId = FirebaseInstanceId.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseInstanceId, (String)"FirebaseInstanceId.getInstance()");
        firebaseInstanceId.getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(this){
            final /* synthetic */ FCMClientHelper this$0;

            public final void onComplete(@NotNull Task<InstanceIdResult> task) {
                Intrinsics.checkParameterIsNotNull(task, (String)"task");
                try {
                    if (task.isSuccessful()) {
                        Object object = task.getResult();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.result");
                        String token = ((InstanceIdResult)object).getToken();
                        CharSequence charSequence = token;
                        if (!(charSequence == null || charSequence.length() == 0)) {
                            SmartLoggerKt.info$default((SmartLogger)this.this$0, (String)("Push Token: " + token), null, (int)2, null);
                            String string = token;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"token");
                            this.this$0.onNewToken$fcm_client_release(string);
                        }
                    } else {
                        SmartLoggerKt.error$default((SmartLogger)this.this$0, (String)"registerForPush(): Task completion wasn't successful", null, (int)2, null);
                    }
                }
                catch (Exception e) {
                    SmartLoggerKt.error((SmartLogger)this.this$0, (String)"registerForPush(): Exception: ", (Throwable)e);
                }
            }
            {
                this.this$0 = fCMClientHelper;
            }
        });
    }

    public final void onNewToken$fcm_client_release(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        this.onTokenRegistered$fcm_client_release(token);
        this.writeTokenToStorage(token);
        this.subscribeToTopics(this.getSubscribedTopics());
    }

    private final void writeTokenToStorage(String token) {
        SharedPref.Companion.newInstance(this.context).setPushToken(token);
    }

    private final void updateSubscribedTopics(List<String> topics) {
        SharedPref.Companion.newInstance(this.context).setTopics(CollectionsKt.toSet((Iterable)topics));
    }

    public FCMClientHelper(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.tokenReceivedListener = new ConcurrentLinkedQueue();
        this.pushReceivedListener = new ConcurrentLinkedQueue();
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public String getClassName() {
        return SmartLogger.DefaultImpls.getClassName((SmartLogger)this);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/umang/fcmclient/FCMClientHelper$TokenReceivedListener;", "", "onTokenReceived", "", "token", "", "fcm-client_release"})
    public static interface TokenReceivedListener {
        public void onTokenReceived(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/umang/fcmclient/FCMClientHelper$PushReceivedListener;", "", "onPushReceived", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "fcm-client_release"})
    public static interface PushReceivedListener {
        public void onPushReceived(@NotNull RemoteMessage var1);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/umang/fcmclient/FCMClientHelper$Companion;", "", "()V", "activityCounter", "", "instance", "Lcom/umang/fcmclient/FCMClientHelper;", "newInstance", "context", "Landroid/content/Context;", "fcm-client_release"})
    public static final class Companion {
        @NotNull
        public final FCMClientHelper newInstance(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (instance == null) {
                instance = new FCMClientHelper(context);
            }
            FCMClientHelper fCMClientHelper = instance;
            if (fCMClientHelper == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.umang.fcmclient.FCMClientHelper");
            }
            return fCMClientHelper;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

