/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.HTTPHeader;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebhookLog {
    @SerializedName(value="delivery_dts")
    private String deliveryDts = null;
    @SerializedName(value="duration")
    private Integer duration = null;
    @SerializedName(value="queue_delay")
    private Long queueDelay = null;
    @SerializedName(value="request")
    private String request = null;
    @SerializedName(value="request_headers")
    private List<HTTPHeader> requestHeaders = null;
    @SerializedName(value="request_id")
    private String requestId = null;
    @SerializedName(value="response")
    private String response = null;
    @SerializedName(value="response_headers")
    private List<HTTPHeader> responseHeaders = null;
    @SerializedName(value="status_code")
    private Integer statusCode = null;
    @SerializedName(value="success")
    private Boolean success = null;
    @SerializedName(value="uri")
    private String uri = null;

    public WebhookLog deliveryDts(String deliveryDts) {
        this.deliveryDts = deliveryDts;
        return this;
    }

    @ApiModelProperty(value="Date/time of delivery")
    public String getDeliveryDts() {
        return this.deliveryDts;
    }

    public void setDeliveryDts(String deliveryDts) {
        this.deliveryDts = deliveryDts;
    }

    public WebhookLog duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(value="Number of milliseconds to process the notification")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public WebhookLog queueDelay(Long queueDelay) {
        this.queueDelay = queueDelay;
        return this;
    }

    @ApiModelProperty(value="Number of milliseconds of delay caused by queuing")
    public Long getQueueDelay() {
        return this.queueDelay;
    }

    public void setQueueDelay(Long queueDelay) {
        this.queueDelay = queueDelay;
    }

    public WebhookLog request(String request) {
        this.request = request;
        return this;
    }

    @ApiModelProperty(value="Request payload (first 100,000 characters)")
    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public WebhookLog requestHeaders(List<HTTPHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    public WebhookLog addRequestHeadersItem(HTTPHeader requestHeadersItem) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new ArrayList<HTTPHeader>();
        }
        this.requestHeaders.add(requestHeadersItem);
        return this;
    }

    @ApiModelProperty(value="Request headers sent to the server")
    public List<HTTPHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(List<HTTPHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public WebhookLog requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(value="Request id is a unique string that you can look up in the logs")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public WebhookLog response(String response) {
        this.response = response;
        return this;
    }

    @ApiModelProperty(value="Response payload (first 100,000 characters)")
    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public WebhookLog responseHeaders(List<HTTPHeader> responseHeaders) {
        this.responseHeaders = responseHeaders;
        return this;
    }

    public WebhookLog addResponseHeadersItem(HTTPHeader responseHeadersItem) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new ArrayList<HTTPHeader>();
        }
        this.responseHeaders.add(responseHeadersItem);
        return this;
    }

    @ApiModelProperty(value="Response headers received from the server")
    public List<HTTPHeader> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(List<HTTPHeader> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public WebhookLog statusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @ApiModelProperty(value="HTTP status code received from the server")
    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public WebhookLog success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="True if the delivery was successful")
    public Boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public WebhookLog uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="URI of the webhook delivered to")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookLog webhookLog = (WebhookLog)o;
        return Objects.equals(this.deliveryDts, webhookLog.deliveryDts) && Objects.equals(this.duration, webhookLog.duration) && Objects.equals(this.queueDelay, webhookLog.queueDelay) && Objects.equals(this.request, webhookLog.request) && Objects.equals(this.requestHeaders, webhookLog.requestHeaders) && Objects.equals(this.requestId, webhookLog.requestId) && Objects.equals(this.response, webhookLog.response) && Objects.equals(this.responseHeaders, webhookLog.responseHeaders) && Objects.equals(this.statusCode, webhookLog.statusCode) && Objects.equals(this.success, webhookLog.success) && Objects.equals(this.uri, webhookLog.uri);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryDts, this.duration, this.queueDelay, this.request, this.requestHeaders, this.requestId, this.response, this.responseHeaders, this.statusCode, this.success, this.uri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookLog {\n");
        sb.append("    deliveryDts: ").append(this.toIndentedString(this.deliveryDts)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    queueDelay: ").append(this.toIndentedString(this.queueDelay)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    requestHeaders: ").append(this.toIndentedString(this.requestHeaders)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    responseHeaders: ").append(this.toIndentedString(this.responseHeaders)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

