/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.ApiUserApplicationProfile;
import com.ultracart.admin.v2.models.WebhookEventCategory;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Webhook {
    @SerializedName(value="api_user_oid")
    private Integer apiUserOid = null;
    @SerializedName(value="api_version")
    private ApiVersionEnum apiVersion = null;
    @SerializedName(value="application_profile")
    private ApiUserApplicationProfile applicationProfile = null;
    @SerializedName(value="authentication_type")
    private AuthenticationTypeEnum authenticationType = null;
    @SerializedName(value="basic_password")
    private String basicPassword = null;
    @SerializedName(value="basic_username")
    private String basicUsername = null;
    @SerializedName(value="consecutive_failures")
    private Integer consecutiveFailures = null;
    @SerializedName(value="disabled")
    private Boolean disabled = null;
    @SerializedName(value="event_categories")
    private List<WebhookEventCategory> eventCategories = null;
    @SerializedName(value="iam_access_key")
    private String iamAccessKey = null;
    @SerializedName(value="iam_secret_key")
    private String iamSecretKey = null;
    @SerializedName(value="maximum_events")
    private Integer maximumEvents = null;
    @SerializedName(value="maximum_size")
    private Integer maximumSize = null;
    @SerializedName(value="merchant_id")
    private String merchantId = null;
    @SerializedName(value="next_retry_after")
    private String nextRetryAfter = null;
    @SerializedName(value="pending")
    private Integer pending = null;
    @SerializedName(value="webhook_oid")
    private Integer webhookOid = null;
    @SerializedName(value="webhook_url")
    private String webhookUrl = null;

    public Webhook apiUserOid(Integer apiUserOid) {
        this.apiUserOid = apiUserOid;
        return this;
    }

    @ApiModelProperty(value="Populated if webhook associated with an API user")
    public Integer getApiUserOid() {
        return this.apiUserOid;
    }

    public void setApiUserOid(Integer apiUserOid) {
        this.apiUserOid = apiUserOid;
    }

    public Webhook apiVersion(ApiVersionEnum apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="Version of the API objects that are sent in notifications")
    public ApiVersionEnum getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(ApiVersionEnum apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Webhook applicationProfile(ApiUserApplicationProfile applicationProfile) {
        this.applicationProfile = applicationProfile;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiUserApplicationProfile getApplicationProfile() {
        return this.applicationProfile;
    }

    public void setApplicationProfile(ApiUserApplicationProfile applicationProfile) {
        this.applicationProfile = applicationProfile;
    }

    public Webhook authenticationType(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    @ApiModelProperty(value="The type of authentication this webhook will use when communicating with your server")
    public AuthenticationTypeEnum getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
    }

    public Webhook basicPassword(String basicPassword) {
        this.basicPassword = basicPassword;
        return this;
    }

    @ApiModelProperty(value="Basic authentication password")
    public String getBasicPassword() {
        return this.basicPassword;
    }

    public void setBasicPassword(String basicPassword) {
        this.basicPassword = basicPassword;
    }

    public Webhook basicUsername(String basicUsername) {
        this.basicUsername = basicUsername;
        return this;
    }

    @ApiModelProperty(value="Basic authentication user name")
    public String getBasicUsername() {
        return this.basicUsername;
    }

    public void setBasicUsername(String basicUsername) {
        this.basicUsername = basicUsername;
    }

    public Webhook consecutiveFailures(Integer consecutiveFailures) {
        this.consecutiveFailures = consecutiveFailures;
        return this;
    }

    @ApiModelProperty(value="The number of consecutive failures that have occurred trying to deliver notifications to the target server")
    public Integer getConsecutiveFailures() {
        return this.consecutiveFailures;
    }

    public void setConsecutiveFailures(Integer consecutiveFailures) {
        this.consecutiveFailures = consecutiveFailures;
    }

    public Webhook disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @ApiModelProperty(value="True if the webhook has been disabled")
    public Boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public Webhook eventCategories(List<WebhookEventCategory> eventCategories) {
        this.eventCategories = eventCategories;
        return this;
    }

    public Webhook addEventCategoriesItem(WebhookEventCategory eventCategoriesItem) {
        if (this.eventCategories == null) {
            this.eventCategories = new ArrayList<WebhookEventCategory>();
        }
        this.eventCategories.add(eventCategoriesItem);
        return this;
    }

    @ApiModelProperty(value="The categories of events.  Individual events and subscriptions are handled in the child objects.  _placeholders parameter effects the population of this on a retrieval.")
    public List<WebhookEventCategory> getEventCategories() {
        return this.eventCategories;
    }

    public void setEventCategories(List<WebhookEventCategory> eventCategories) {
        this.eventCategories = eventCategories;
    }

    public Webhook iamAccessKey(String iamAccessKey) {
        this.iamAccessKey = iamAccessKey;
        return this;
    }

    @ApiModelProperty(value="IAM Access Key for AWS SQS Delivery")
    public String getIamAccessKey() {
        return this.iamAccessKey;
    }

    public void setIamAccessKey(String iamAccessKey) {
        this.iamAccessKey = iamAccessKey;
    }

    public Webhook iamSecretKey(String iamSecretKey) {
        this.iamSecretKey = iamSecretKey;
        return this;
    }

    @ApiModelProperty(value="IAM Secret Key for AWS SQS Delivery")
    public String getIamSecretKey() {
        return this.iamSecretKey;
    }

    public void setIamSecretKey(String iamSecretKey) {
        this.iamSecretKey = iamSecretKey;
    }

    public Webhook maximumEvents(Integer maximumEvents) {
        this.maximumEvents = maximumEvents;
        return this;
    }

    @ApiModelProperty(value="The maximum number of events in the payload that UltraCart will deliver")
    public Integer getMaximumEvents() {
        return this.maximumEvents;
    }

    public void setMaximumEvents(Integer maximumEvents) {
        this.maximumEvents = maximumEvents;
    }

    public Webhook maximumSize(Integer maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    @ApiModelProperty(value="The maximum size of the payload that UltraCart will deliver")
    public Integer getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Integer maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Webhook merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The UltraCart merchant ID that owns this webhook")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public Webhook nextRetryAfter(String nextRetryAfter) {
        this.nextRetryAfter = nextRetryAfter;
        return this;
    }

    @ApiModelProperty(value="The next time UltraCart will attempt delivery if failures have been occurring")
    public String getNextRetryAfter() {
        return this.nextRetryAfter;
    }

    public void setNextRetryAfter(String nextRetryAfter) {
        this.nextRetryAfter = nextRetryAfter;
    }

    public Webhook pending(Integer pending) {
        this.pending = pending;
        return this;
    }

    @ApiModelProperty(value="The number of pending events for this webhook")
    public Integer getPending() {
        return this.pending;
    }

    public void setPending(Integer pending) {
        this.pending = pending;
    }

    public Webhook webhookOid(Integer webhookOid) {
        this.webhookOid = webhookOid;
        return this;
    }

    @ApiModelProperty(value="The object identifier for this webhook")
    public Integer getWebhookOid() {
        return this.webhookOid;
    }

    public void setWebhookOid(Integer webhookOid) {
        this.webhookOid = webhookOid;
    }

    public Webhook webhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to deliver events to.  Must be HTTPS for customer related information.")
    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.apiUserOid, webhook.apiUserOid) && Objects.equals((Object)this.apiVersion, (Object)webhook.apiVersion) && Objects.equals(this.applicationProfile, webhook.applicationProfile) && Objects.equals((Object)this.authenticationType, (Object)webhook.authenticationType) && Objects.equals(this.basicPassword, webhook.basicPassword) && Objects.equals(this.basicUsername, webhook.basicUsername) && Objects.equals(this.consecutiveFailures, webhook.consecutiveFailures) && Objects.equals(this.disabled, webhook.disabled) && Objects.equals(this.eventCategories, webhook.eventCategories) && Objects.equals(this.iamAccessKey, webhook.iamAccessKey) && Objects.equals(this.iamSecretKey, webhook.iamSecretKey) && Objects.equals(this.maximumEvents, webhook.maximumEvents) && Objects.equals(this.maximumSize, webhook.maximumSize) && Objects.equals(this.merchantId, webhook.merchantId) && Objects.equals(this.nextRetryAfter, webhook.nextRetryAfter) && Objects.equals(this.pending, webhook.pending) && Objects.equals(this.webhookOid, webhook.webhookOid) && Objects.equals(this.webhookUrl, webhook.webhookUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiUserOid, this.apiVersion, this.applicationProfile, this.authenticationType, this.basicPassword, this.basicUsername, this.consecutiveFailures, this.disabled, this.eventCategories, this.iamAccessKey, this.iamSecretKey, this.maximumEvents, this.maximumSize, this.merchantId, this.nextRetryAfter, this.pending, this.webhookOid, this.webhookUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    apiUserOid: ").append(this.toIndentedString(this.apiUserOid)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString((Object)this.apiVersion)).append("\n");
        sb.append("    applicationProfile: ").append(this.toIndentedString(this.applicationProfile)).append("\n");
        sb.append("    authenticationType: ").append(this.toIndentedString((Object)this.authenticationType)).append("\n");
        sb.append("    basicPassword: ").append(this.toIndentedString(this.basicPassword)).append("\n");
        sb.append("    basicUsername: ").append(this.toIndentedString(this.basicUsername)).append("\n");
        sb.append("    consecutiveFailures: ").append(this.toIndentedString(this.consecutiveFailures)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString(this.disabled)).append("\n");
        sb.append("    eventCategories: ").append(this.toIndentedString(this.eventCategories)).append("\n");
        sb.append("    iamAccessKey: ").append(this.toIndentedString(this.iamAccessKey)).append("\n");
        sb.append("    iamSecretKey: ").append(this.toIndentedString(this.iamSecretKey)).append("\n");
        sb.append("    maximumEvents: ").append(this.toIndentedString(this.maximumEvents)).append("\n");
        sb.append("    maximumSize: ").append(this.toIndentedString(this.maximumSize)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    nextRetryAfter: ").append(this.toIndentedString(this.nextRetryAfter)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    webhookOid: ").append(this.toIndentedString(this.webhookOid)).append("\n");
        sb.append("    webhookUrl: ").append(this.toIndentedString(this.webhookUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AuthenticationTypeEnum {
        NONE("none"),
        BASIC("basic");

        private String value;

        private AuthenticationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AuthenticationTypeEnum fromValue(String text) {
            for (AuthenticationTypeEnum b : AuthenticationTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AuthenticationTypeEnum> {
            public void write(JsonWriter jsonWriter, AuthenticationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AuthenticationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AuthenticationTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ApiVersionEnum {
        _2017_03_01("2017-03-01");

        private String value;

        private ApiVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ApiVersionEnum fromValue(String text) {
            for (ApiVersionEnum b : ApiVersionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ApiVersionEnum> {
            public void write(JsonWriter jsonWriter, ApiVersionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ApiVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ApiVersionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

