/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.TaxCounty;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaxState {
    @SerializedName(value="accounting_code")
    private String accountingCode = null;
    @SerializedName(value="counties")
    private List<TaxCounty> counties = null;
    @SerializedName(value="country_oid")
    private Integer countryOid = null;
    @SerializedName(value="dont_collect_city")
    private Boolean dontCollectCity = null;
    @SerializedName(value="dont_collect_county")
    private Boolean dontCollectCounty = null;
    @SerializedName(value="dont_collect_postal_code")
    private Boolean dontCollectPostalCode = null;
    @SerializedName(value="dont_collect_state")
    private Boolean dontCollectState = null;
    @SerializedName(value="exempt_digital_items")
    private Boolean exemptDigitalItems = null;
    @SerializedName(value="exempt_physical_items")
    private Boolean exemptPhysicalItems = null;
    @SerializedName(value="exempt_service_items")
    private Boolean exemptServiceItems = null;
    @SerializedName(value="state_code")
    private String stateCode = null;
    @SerializedName(value="state_oid")
    private Integer stateOid = null;
    @SerializedName(value="tax_gift_charge")
    private Boolean taxGiftCharge = null;
    @SerializedName(value="tax_gift_wrap")
    private Boolean taxGiftWrap = null;
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate = null;
    @SerializedName(value="tax_rate_formatted")
    private String taxRateFormatted = null;
    @SerializedName(value="tax_shipping")
    private Boolean taxShipping = null;
    @SerializedName(value="use_ultracart_managed_rates")
    private Boolean useUltracartManagedRates = null;

    public TaxState accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @ApiModelProperty(value="Accounting code for programs such as QuickBooks")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public TaxState counties(List<TaxCounty> counties) {
        this.counties = counties;
        return this;
    }

    public TaxState addCountiesItem(TaxCounty countiesItem) {
        if (this.counties == null) {
            this.counties = new ArrayList<TaxCounty>();
        }
        this.counties.add(countiesItem);
        return this;
    }

    @ApiModelProperty(value="Counties within this state")
    public List<TaxCounty> getCounties() {
        return this.counties;
    }

    public void setCounties(List<TaxCounty> counties) {
        this.counties = counties;
    }

    public TaxState countryOid(Integer countryOid) {
        this.countryOid = countryOid;
        return this;
    }

    @ApiModelProperty(value="Tax record object identifier used internally by database")
    public Integer getCountryOid() {
        return this.countryOid;
    }

    public void setCountryOid(Integer countryOid) {
        this.countryOid = countryOid;
    }

    public TaxState dontCollectCity(Boolean dontCollectCity) {
        this.dontCollectCity = dontCollectCity;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect city tax for this state")
    public Boolean isDontCollectCity() {
        return this.dontCollectCity;
    }

    public void setDontCollectCity(Boolean dontCollectCity) {
        this.dontCollectCity = dontCollectCity;
    }

    public TaxState dontCollectCounty(Boolean dontCollectCounty) {
        this.dontCollectCounty = dontCollectCounty;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect county tax for this state")
    public Boolean isDontCollectCounty() {
        return this.dontCollectCounty;
    }

    public void setDontCollectCounty(Boolean dontCollectCounty) {
        this.dontCollectCounty = dontCollectCounty;
    }

    public TaxState dontCollectPostalCode(Boolean dontCollectPostalCode) {
        this.dontCollectPostalCode = dontCollectPostalCode;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect postal code tax for this state")
    public Boolean isDontCollectPostalCode() {
        return this.dontCollectPostalCode;
    }

    public void setDontCollectPostalCode(Boolean dontCollectPostalCode) {
        this.dontCollectPostalCode = dontCollectPostalCode;
    }

    public TaxState dontCollectState(Boolean dontCollectState) {
        this.dontCollectState = dontCollectState;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect state tax for this state")
    public Boolean isDontCollectState() {
        return this.dontCollectState;
    }

    public void setDontCollectState(Boolean dontCollectState) {
        this.dontCollectState = dontCollectState;
    }

    public TaxState exemptDigitalItems(Boolean exemptDigitalItems) {
        this.exemptDigitalItems = exemptDigitalItems;
        return this;
    }

    @ApiModelProperty(value="True if digital items are exempt from sales tax in this state.")
    public Boolean isExemptDigitalItems() {
        return this.exemptDigitalItems;
    }

    public void setExemptDigitalItems(Boolean exemptDigitalItems) {
        this.exemptDigitalItems = exemptDigitalItems;
    }

    public TaxState exemptPhysicalItems(Boolean exemptPhysicalItems) {
        this.exemptPhysicalItems = exemptPhysicalItems;
        return this;
    }

    @ApiModelProperty(value="True if physical items are exempt from sales tax in this state.")
    public Boolean isExemptPhysicalItems() {
        return this.exemptPhysicalItems;
    }

    public void setExemptPhysicalItems(Boolean exemptPhysicalItems) {
        this.exemptPhysicalItems = exemptPhysicalItems;
    }

    public TaxState exemptServiceItems(Boolean exemptServiceItems) {
        this.exemptServiceItems = exemptServiceItems;
        return this;
    }

    @ApiModelProperty(value="True if service items are exempt from sales tax in this state.")
    public Boolean isExemptServiceItems() {
        return this.exemptServiceItems;
    }

    public void setExemptServiceItems(Boolean exemptServiceItems) {
        this.exemptServiceItems = exemptServiceItems;
    }

    public TaxState stateCode(String stateCode) {
        this.stateCode = stateCode;
        return this;
    }

    @ApiModelProperty(value="State code")
    public String getStateCode() {
        return this.stateCode;
    }

    public void setStateCode(String stateCode) {
        this.stateCode = stateCode;
    }

    public TaxState stateOid(Integer stateOid) {
        this.stateOid = stateOid;
        return this;
    }

    @ApiModelProperty(value="Tax record object identifier used internally by database")
    public Integer getStateOid() {
        return this.stateOid;
    }

    public void setStateOid(Integer stateOid) {
        this.stateOid = stateOid;
    }

    public TaxState taxGiftCharge(Boolean taxGiftCharge) {
        this.taxGiftCharge = taxGiftCharge;
        return this;
    }

    @ApiModelProperty(value="True if taxation within this jurisdiction should charge tax on gift charge")
    public Boolean isTaxGiftCharge() {
        return this.taxGiftCharge;
    }

    public void setTaxGiftCharge(Boolean taxGiftCharge) {
        this.taxGiftCharge = taxGiftCharge;
    }

    public TaxState taxGiftWrap(Boolean taxGiftWrap) {
        this.taxGiftWrap = taxGiftWrap;
        return this;
    }

    @ApiModelProperty(value="True if taxation within this jurisdiction should charge tax on gift wrap")
    public Boolean isTaxGiftWrap() {
        return this.taxGiftWrap;
    }

    public void setTaxGiftWrap(Boolean taxGiftWrap) {
        this.taxGiftWrap = taxGiftWrap;
    }

    public TaxState taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty(value="Tax Rate")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxState taxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
        return this;
    }

    @ApiModelProperty(value="Tax rate formatted")
    public String getTaxRateFormatted() {
        return this.taxRateFormatted;
    }

    public void setTaxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
    }

    public TaxState taxShipping(Boolean taxShipping) {
        this.taxShipping = taxShipping;
        return this;
    }

    @ApiModelProperty(value="True if taxation within this jurisdiction should charge tax on shipping")
    public Boolean isTaxShipping() {
        return this.taxShipping;
    }

    public void setTaxShipping(Boolean taxShipping) {
        this.taxShipping = taxShipping;
    }

    public TaxState useUltracartManagedRates(Boolean useUltracartManagedRates) {
        this.useUltracartManagedRates = useUltracartManagedRates;
        return this;
    }

    @ApiModelProperty(value="If true, use UltraCart managed rates for this state")
    public Boolean isUseUltracartManagedRates() {
        return this.useUltracartManagedRates;
    }

    public void setUseUltracartManagedRates(Boolean useUltracartManagedRates) {
        this.useUltracartManagedRates = useUltracartManagedRates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxState taxState = (TaxState)o;
        return Objects.equals(this.accountingCode, taxState.accountingCode) && Objects.equals(this.counties, taxState.counties) && Objects.equals(this.countryOid, taxState.countryOid) && Objects.equals(this.dontCollectCity, taxState.dontCollectCity) && Objects.equals(this.dontCollectCounty, taxState.dontCollectCounty) && Objects.equals(this.dontCollectPostalCode, taxState.dontCollectPostalCode) && Objects.equals(this.dontCollectState, taxState.dontCollectState) && Objects.equals(this.exemptDigitalItems, taxState.exemptDigitalItems) && Objects.equals(this.exemptPhysicalItems, taxState.exemptPhysicalItems) && Objects.equals(this.exemptServiceItems, taxState.exemptServiceItems) && Objects.equals(this.stateCode, taxState.stateCode) && Objects.equals(this.stateOid, taxState.stateOid) && Objects.equals(this.taxGiftCharge, taxState.taxGiftCharge) && Objects.equals(this.taxGiftWrap, taxState.taxGiftWrap) && Objects.equals(this.taxRate, taxState.taxRate) && Objects.equals(this.taxRateFormatted, taxState.taxRateFormatted) && Objects.equals(this.taxShipping, taxState.taxShipping) && Objects.equals(this.useUltracartManagedRates, taxState.useUltracartManagedRates);
    }

    public int hashCode() {
        return Objects.hash(this.accountingCode, this.counties, this.countryOid, this.dontCollectCity, this.dontCollectCounty, this.dontCollectPostalCode, this.dontCollectState, this.exemptDigitalItems, this.exemptPhysicalItems, this.exemptServiceItems, this.stateCode, this.stateOid, this.taxGiftCharge, this.taxGiftWrap, this.taxRate, this.taxRateFormatted, this.taxShipping, this.useUltracartManagedRates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxState {\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    counties: ").append(this.toIndentedString(this.counties)).append("\n");
        sb.append("    countryOid: ").append(this.toIndentedString(this.countryOid)).append("\n");
        sb.append("    dontCollectCity: ").append(this.toIndentedString(this.dontCollectCity)).append("\n");
        sb.append("    dontCollectCounty: ").append(this.toIndentedString(this.dontCollectCounty)).append("\n");
        sb.append("    dontCollectPostalCode: ").append(this.toIndentedString(this.dontCollectPostalCode)).append("\n");
        sb.append("    dontCollectState: ").append(this.toIndentedString(this.dontCollectState)).append("\n");
        sb.append("    exemptDigitalItems: ").append(this.toIndentedString(this.exemptDigitalItems)).append("\n");
        sb.append("    exemptPhysicalItems: ").append(this.toIndentedString(this.exemptPhysicalItems)).append("\n");
        sb.append("    exemptServiceItems: ").append(this.toIndentedString(this.exemptServiceItems)).append("\n");
        sb.append("    stateCode: ").append(this.toIndentedString(this.stateCode)).append("\n");
        sb.append("    stateOid: ").append(this.toIndentedString(this.stateOid)).append("\n");
        sb.append("    taxGiftCharge: ").append(this.toIndentedString(this.taxGiftCharge)).append("\n");
        sb.append("    taxGiftWrap: ").append(this.toIndentedString(this.taxGiftWrap)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateFormatted: ").append(this.toIndentedString(this.taxRateFormatted)).append("\n");
        sb.append("    taxShipping: ").append(this.toIndentedString(this.taxShipping)).append("\n");
        sb.append("    useUltracartManagedRates: ").append(this.toIndentedString(this.useUltracartManagedRates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

