/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class TaxJarConfig {
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="api_key")
    private String apiKey = null;
    @SerializedName(value="estimate_only")
    private Boolean estimateOnly = null;
    @SerializedName(value="send_outside_nexus")
    private Boolean sendOutsideNexus = null;
    @SerializedName(value="send_test_orders")
    private Boolean sendTestOrders = null;
    @SerializedName(value="skip_channel_orders")
    private Boolean skipChannelOrders = null;
    @SerializedName(value="use_distribution_center_from")
    private Boolean useDistributionCenterFrom = null;

    public TaxJarConfig active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="True if TaxJar is active for this merchant")
    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public TaxJarConfig apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @ApiModelProperty(value="TaxJar API key")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public TaxJarConfig estimateOnly(Boolean estimateOnly) {
        this.estimateOnly = estimateOnly;
        return this;
    }

    @ApiModelProperty(value="True if this TaxJar configuration is to estimate taxes only and not report placed orders to TaxJar")
    public Boolean isEstimateOnly() {
        return this.estimateOnly;
    }

    public void setEstimateOnly(Boolean estimateOnly) {
        this.estimateOnly = estimateOnly;
    }

    public TaxJarConfig sendOutsideNexus(Boolean sendOutsideNexus) {
        this.sendOutsideNexus = sendOutsideNexus;
        return this;
    }

    @ApiModelProperty(value="Send orders outside your nexus TaxJar.  The default is to not transmit outside orders to TaxJar to reduce API calls.  However, this will prevent TaxJar from dynamically creating new Nexus when thresholds are exceeded for a state.")
    public Boolean isSendOutsideNexus() {
        return this.sendOutsideNexus;
    }

    public void setSendOutsideNexus(Boolean sendOutsideNexus) {
        this.sendOutsideNexus = sendOutsideNexus;
    }

    public TaxJarConfig sendTestOrders(Boolean sendTestOrders) {
        this.sendTestOrders = sendTestOrders;
        return this;
    }

    @ApiModelProperty(value="Send test orders through to TaxJar.  The default is to not transmit test orders to TaxJar.")
    public Boolean isSendTestOrders() {
        return this.sendTestOrders;
    }

    public void setSendTestOrders(Boolean sendTestOrders) {
        this.sendTestOrders = sendTestOrders;
    }

    public TaxJarConfig skipChannelOrders(Boolean skipChannelOrders) {
        this.skipChannelOrders = skipChannelOrders;
        return this;
    }

    @ApiModelProperty(value="Do not send channel partner orders to TaxJar.  Set this to true if your channel partner reports tax on their own.")
    public Boolean isSkipChannelOrders() {
        return this.skipChannelOrders;
    }

    public void setSkipChannelOrders(Boolean skipChannelOrders) {
        this.skipChannelOrders = skipChannelOrders;
    }

    public TaxJarConfig useDistributionCenterFrom(Boolean useDistributionCenterFrom) {
        this.useDistributionCenterFrom = useDistributionCenterFrom;
        return this;
    }

    @ApiModelProperty(value="Use distribution center from address")
    public Boolean isUseDistributionCenterFrom() {
        return this.useDistributionCenterFrom;
    }

    public void setUseDistributionCenterFrom(Boolean useDistributionCenterFrom) {
        this.useDistributionCenterFrom = useDistributionCenterFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxJarConfig taxJarConfig = (TaxJarConfig)o;
        return Objects.equals(this.active, taxJarConfig.active) && Objects.equals(this.apiKey, taxJarConfig.apiKey) && Objects.equals(this.estimateOnly, taxJarConfig.estimateOnly) && Objects.equals(this.sendOutsideNexus, taxJarConfig.sendOutsideNexus) && Objects.equals(this.sendTestOrders, taxJarConfig.sendTestOrders) && Objects.equals(this.skipChannelOrders, taxJarConfig.skipChannelOrders) && Objects.equals(this.useDistributionCenterFrom, taxJarConfig.useDistributionCenterFrom);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.apiKey, this.estimateOnly, this.sendOutsideNexus, this.sendTestOrders, this.skipChannelOrders, this.useDistributionCenterFrom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxJarConfig {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    estimateOnly: ").append(this.toIndentedString(this.estimateOnly)).append("\n");
        sb.append("    sendOutsideNexus: ").append(this.toIndentedString(this.sendOutsideNexus)).append("\n");
        sb.append("    sendTestOrders: ").append(this.toIndentedString(this.sendTestOrders)).append("\n");
        sb.append("    skipChannelOrders: ").append(this.toIndentedString(this.skipChannelOrders)).append("\n");
        sb.append("    useDistributionCenterFrom: ").append(this.toIndentedString(this.useDistributionCenterFrom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

