/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.TaxCity;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaxCounty {
    @SerializedName(value="accounting_code")
    private String accountingCode = null;
    @SerializedName(value="cities")
    private List<TaxCity> cities = null;
    @SerializedName(value="county")
    private String county = null;
    @SerializedName(value="county_oid")
    private Integer countyOid = null;
    @SerializedName(value="dont_collect_city")
    private Boolean dontCollectCity = null;
    @SerializedName(value="dont_collect_county")
    private Boolean dontCollectCounty = null;
    @SerializedName(value="dont_collect_postal_code")
    private Boolean dontCollectPostalCode = null;
    @SerializedName(value="state_oid")
    private Integer stateOid = null;
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate = null;
    @SerializedName(value="tax_rate_formatted")
    private String taxRateFormatted = null;

    public TaxCounty accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @ApiModelProperty(value="Accounting code for programs such as QuickBooks")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public TaxCounty cities(List<TaxCity> cities) {
        this.cities = cities;
        return this;
    }

    public TaxCounty addCitiesItem(TaxCity citiesItem) {
        if (this.cities == null) {
            this.cities = new ArrayList<TaxCity>();
        }
        this.cities.add(citiesItem);
        return this;
    }

    @ApiModelProperty(value="Cities within this city")
    public List<TaxCity> getCities() {
        return this.cities;
    }

    public void setCities(List<TaxCity> cities) {
        this.cities = cities;
    }

    public TaxCounty county(String county) {
        this.county = county;
        return this;
    }

    @ApiModelProperty(value="County")
    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public TaxCounty countyOid(Integer countyOid) {
        this.countyOid = countyOid;
        return this;
    }

    @ApiModelProperty(value="Tax record object identifier used internally by database")
    public Integer getCountyOid() {
        return this.countyOid;
    }

    public void setCountyOid(Integer countyOid) {
        this.countyOid = countyOid;
    }

    public TaxCounty dontCollectCity(Boolean dontCollectCity) {
        this.dontCollectCity = dontCollectCity;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect city tax for this county")
    public Boolean isDontCollectCity() {
        return this.dontCollectCity;
    }

    public void setDontCollectCity(Boolean dontCollectCity) {
        this.dontCollectCity = dontCollectCity;
    }

    public TaxCounty dontCollectCounty(Boolean dontCollectCounty) {
        this.dontCollectCounty = dontCollectCounty;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect county tax for this county")
    public Boolean isDontCollectCounty() {
        return this.dontCollectCounty;
    }

    public void setDontCollectCounty(Boolean dontCollectCounty) {
        this.dontCollectCounty = dontCollectCounty;
    }

    public TaxCounty dontCollectPostalCode(Boolean dontCollectPostalCode) {
        this.dontCollectPostalCode = dontCollectPostalCode;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect postal code tax for this county")
    public Boolean isDontCollectPostalCode() {
        return this.dontCollectPostalCode;
    }

    public void setDontCollectPostalCode(Boolean dontCollectPostalCode) {
        this.dontCollectPostalCode = dontCollectPostalCode;
    }

    public TaxCounty stateOid(Integer stateOid) {
        this.stateOid = stateOid;
        return this;
    }

    @ApiModelProperty(value="Tax record object identifier used internally by database")
    public Integer getStateOid() {
        return this.stateOid;
    }

    public void setStateOid(Integer stateOid) {
        this.stateOid = stateOid;
    }

    public TaxCounty taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty(value="Tax Rate")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxCounty taxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
        return this;
    }

    @ApiModelProperty(value="Tax rate formatted")
    public String getTaxRateFormatted() {
        return this.taxRateFormatted;
    }

    public void setTaxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxCounty taxCounty = (TaxCounty)o;
        return Objects.equals(this.accountingCode, taxCounty.accountingCode) && Objects.equals(this.cities, taxCounty.cities) && Objects.equals(this.county, taxCounty.county) && Objects.equals(this.countyOid, taxCounty.countyOid) && Objects.equals(this.dontCollectCity, taxCounty.dontCollectCity) && Objects.equals(this.dontCollectCounty, taxCounty.dontCollectCounty) && Objects.equals(this.dontCollectPostalCode, taxCounty.dontCollectPostalCode) && Objects.equals(this.stateOid, taxCounty.stateOid) && Objects.equals(this.taxRate, taxCounty.taxRate) && Objects.equals(this.taxRateFormatted, taxCounty.taxRateFormatted);
    }

    public int hashCode() {
        return Objects.hash(this.accountingCode, this.cities, this.county, this.countyOid, this.dontCollectCity, this.dontCollectCounty, this.dontCollectPostalCode, this.stateOid, this.taxRate, this.taxRateFormatted);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxCounty {\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    cities: ").append(this.toIndentedString(this.cities)).append("\n");
        sb.append("    county: ").append(this.toIndentedString(this.county)).append("\n");
        sb.append("    countyOid: ").append(this.toIndentedString(this.countyOid)).append("\n");
        sb.append("    dontCollectCity: ").append(this.toIndentedString(this.dontCollectCity)).append("\n");
        sb.append("    dontCollectCounty: ").append(this.toIndentedString(this.dontCollectCounty)).append("\n");
        sb.append("    dontCollectPostalCode: ").append(this.toIndentedString(this.dontCollectPostalCode)).append("\n");
        sb.append("    stateOid: ").append(this.toIndentedString(this.stateOid)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateFormatted: ").append(this.toIndentedString(this.taxRateFormatted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

