/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.TaxState;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaxCountry {
    @SerializedName(value="accounting_code")
    private String accountingCode = null;
    @SerializedName(value="country_code")
    private String countryCode = null;
    @SerializedName(value="country_oid")
    private Integer countryOid = null;
    @SerializedName(value="states")
    private List<TaxState> states = null;
    @SerializedName(value="tax_gift_charge")
    private Boolean taxGiftCharge = null;
    @SerializedName(value="tax_gift_wrap")
    private Boolean taxGiftWrap = null;
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate = null;
    @SerializedName(value="tax_rate_formatted")
    private String taxRateFormatted = null;
    @SerializedName(value="tax_shipping")
    private Boolean taxShipping = null;

    public TaxCountry accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @ApiModelProperty(value="Accounting code for programs such as QuickBooks")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public TaxCountry countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="Country code (2 characters")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public TaxCountry countryOid(Integer countryOid) {
        this.countryOid = countryOid;
        return this;
    }

    @ApiModelProperty(value="Tax record object identifier used internally by database")
    public Integer getCountryOid() {
        return this.countryOid;
    }

    public void setCountryOid(Integer countryOid) {
        this.countryOid = countryOid;
    }

    public TaxCountry states(List<TaxState> states) {
        this.states = states;
        return this;
    }

    public TaxCountry addStatesItem(TaxState statesItem) {
        if (this.states == null) {
            this.states = new ArrayList<TaxState>();
        }
        this.states.add(statesItem);
        return this;
    }

    @ApiModelProperty(value="States (or regions or territories) within this country")
    public List<TaxState> getStates() {
        return this.states;
    }

    public void setStates(List<TaxState> states) {
        this.states = states;
    }

    public TaxCountry taxGiftCharge(Boolean taxGiftCharge) {
        this.taxGiftCharge = taxGiftCharge;
        return this;
    }

    @ApiModelProperty(value="True if taxation within this jurisdiction should charge tax on gift charge")
    public Boolean isTaxGiftCharge() {
        return this.taxGiftCharge;
    }

    public void setTaxGiftCharge(Boolean taxGiftCharge) {
        this.taxGiftCharge = taxGiftCharge;
    }

    public TaxCountry taxGiftWrap(Boolean taxGiftWrap) {
        this.taxGiftWrap = taxGiftWrap;
        return this;
    }

    @ApiModelProperty(value="True if taxation within this jurisdiction should charge tax on gift wrap")
    public Boolean isTaxGiftWrap() {
        return this.taxGiftWrap;
    }

    public void setTaxGiftWrap(Boolean taxGiftWrap) {
        this.taxGiftWrap = taxGiftWrap;
    }

    public TaxCountry taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty(value="Tax Rate")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxCountry taxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
        return this;
    }

    @ApiModelProperty(value="Tax rate formatted")
    public String getTaxRateFormatted() {
        return this.taxRateFormatted;
    }

    public void setTaxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
    }

    public TaxCountry taxShipping(Boolean taxShipping) {
        this.taxShipping = taxShipping;
        return this;
    }

    @ApiModelProperty(value="True if taxation within this jurisdiction should charge tax on shipping")
    public Boolean isTaxShipping() {
        return this.taxShipping;
    }

    public void setTaxShipping(Boolean taxShipping) {
        this.taxShipping = taxShipping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxCountry taxCountry = (TaxCountry)o;
        return Objects.equals(this.accountingCode, taxCountry.accountingCode) && Objects.equals(this.countryCode, taxCountry.countryCode) && Objects.equals(this.countryOid, taxCountry.countryOid) && Objects.equals(this.states, taxCountry.states) && Objects.equals(this.taxGiftCharge, taxCountry.taxGiftCharge) && Objects.equals(this.taxGiftWrap, taxCountry.taxGiftWrap) && Objects.equals(this.taxRate, taxCountry.taxRate) && Objects.equals(this.taxRateFormatted, taxCountry.taxRateFormatted) && Objects.equals(this.taxShipping, taxCountry.taxShipping);
    }

    public int hashCode() {
        return Objects.hash(this.accountingCode, this.countryCode, this.countryOid, this.states, this.taxGiftCharge, this.taxGiftWrap, this.taxRate, this.taxRateFormatted, this.taxShipping);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxCountry {\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    countryOid: ").append(this.toIndentedString(this.countryOid)).append("\n");
        sb.append("    states: ").append(this.toIndentedString(this.states)).append("\n");
        sb.append("    taxGiftCharge: ").append(this.toIndentedString(this.taxGiftCharge)).append("\n");
        sb.append("    taxGiftWrap: ").append(this.toIndentedString(this.taxGiftWrap)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateFormatted: ").append(this.toIndentedString(this.taxRateFormatted)).append("\n");
        sb.append("    taxShipping: ").append(this.toIndentedString(this.taxShipping)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

