/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.TaxPostalCode;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaxCity {
    @SerializedName(value="accounting_code")
    private String accountingCode = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="city_oid")
    private Integer cityOid = null;
    @SerializedName(value="county_oid")
    private Integer countyOid = null;
    @SerializedName(value="dont_collect_city")
    private Boolean dontCollectCity = null;
    @SerializedName(value="dont_collect_postal_code")
    private Boolean dontCollectPostalCode = null;
    @SerializedName(value="postal_codes")
    private List<TaxPostalCode> postalCodes = null;
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate = null;
    @SerializedName(value="tax_rate_formatted")
    private String taxRateFormatted = null;

    public TaxCity accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @ApiModelProperty(value="Accounting code for programs such as QuickBooks")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public TaxCity city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="City")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public TaxCity cityOid(Integer cityOid) {
        this.cityOid = cityOid;
        return this;
    }

    @ApiModelProperty(value="Tax record object identifier used internally by database")
    public Integer getCityOid() {
        return this.cityOid;
    }

    public void setCityOid(Integer cityOid) {
        this.cityOid = cityOid;
    }

    public TaxCity countyOid(Integer countyOid) {
        this.countyOid = countyOid;
        return this;
    }

    @ApiModelProperty(value="Tax record object identifier used internally by database")
    public Integer getCountyOid() {
        return this.countyOid;
    }

    public void setCountyOid(Integer countyOid) {
        this.countyOid = countyOid;
    }

    public TaxCity dontCollectCity(Boolean dontCollectCity) {
        this.dontCollectCity = dontCollectCity;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect city tax for this city")
    public Boolean isDontCollectCity() {
        return this.dontCollectCity;
    }

    public void setDontCollectCity(Boolean dontCollectCity) {
        this.dontCollectCity = dontCollectCity;
    }

    public TaxCity dontCollectPostalCode(Boolean dontCollectPostalCode) {
        this.dontCollectPostalCode = dontCollectPostalCode;
        return this;
    }

    @ApiModelProperty(value="Flag instructing engine to not collect postal code tax for this city")
    public Boolean isDontCollectPostalCode() {
        return this.dontCollectPostalCode;
    }

    public void setDontCollectPostalCode(Boolean dontCollectPostalCode) {
        this.dontCollectPostalCode = dontCollectPostalCode;
    }

    public TaxCity postalCodes(List<TaxPostalCode> postalCodes) {
        this.postalCodes = postalCodes;
        return this;
    }

    public TaxCity addPostalCodesItem(TaxPostalCode postalCodesItem) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<TaxPostalCode>();
        }
        this.postalCodes.add(postalCodesItem);
        return this;
    }

    @ApiModelProperty(value="Postal Codes within this city")
    public List<TaxPostalCode> getPostalCodes() {
        return this.postalCodes;
    }

    public void setPostalCodes(List<TaxPostalCode> postalCodes) {
        this.postalCodes = postalCodes;
    }

    public TaxCity taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty(value="Tax Rate")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxCity taxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
        return this;
    }

    @ApiModelProperty(value="Tax rate formatted")
    public String getTaxRateFormatted() {
        return this.taxRateFormatted;
    }

    public void setTaxRateFormatted(String taxRateFormatted) {
        this.taxRateFormatted = taxRateFormatted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxCity taxCity = (TaxCity)o;
        return Objects.equals(this.accountingCode, taxCity.accountingCode) && Objects.equals(this.city, taxCity.city) && Objects.equals(this.cityOid, taxCity.cityOid) && Objects.equals(this.countyOid, taxCity.countyOid) && Objects.equals(this.dontCollectCity, taxCity.dontCollectCity) && Objects.equals(this.dontCollectPostalCode, taxCity.dontCollectPostalCode) && Objects.equals(this.postalCodes, taxCity.postalCodes) && Objects.equals(this.taxRate, taxCity.taxRate) && Objects.equals(this.taxRateFormatted, taxCity.taxRateFormatted);
    }

    public int hashCode() {
        return Objects.hash(this.accountingCode, this.city, this.cityOid, this.countyOid, this.dontCollectCity, this.dontCollectPostalCode, this.postalCodes, this.taxRate, this.taxRateFormatted);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxCity {\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    cityOid: ").append(this.toIndentedString(this.cityOid)).append("\n");
        sb.append("    countyOid: ").append(this.toIndentedString(this.countyOid)).append("\n");
        sb.append("    dontCollectCity: ").append(this.toIndentedString(this.dontCollectCity)).append("\n");
        sb.append("    dontCollectPostalCode: ").append(this.toIndentedString(this.dontCollectPostalCode)).append("\n");
        sb.append("    postalCodes: ").append(this.toIndentedString(this.postalCodes)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateFormatted: ").append(this.toIndentedString(this.taxRateFormatted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

