/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.PaymentsConfigurationRestrictions;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

public class PaymentsConfigurationCreditCardType {
    @SerializedName(value="accounting_code")
    private String accountingCode = null;
    @SerializedName(value="card_type_icon")
    private String cardTypeIcon = null;
    @SerializedName(value="credit_card")
    private CreditCardEnum creditCard = null;
    @SerializedName(value="deposit_to_account")
    private String depositToAccount = null;
    @SerializedName(value="enabled")
    private Boolean enabled = null;
    @SerializedName(value="processing_fee")
    private BigDecimal processingFee = null;
    @SerializedName(value="processing_percentage")
    private BigDecimal processingPercentage = null;
    @SerializedName(value="restrictions")
    private PaymentsConfigurationRestrictions restrictions = null;
    @SerializedName(value="surcharge_accounting_code")
    private String surchargeAccountingCode = null;
    @SerializedName(value="transaction_fee")
    private BigDecimal transactionFee = null;
    @SerializedName(value="transaction_percentage")
    private BigDecimal transactionPercentage = null;

    public PaymentsConfigurationCreditCardType accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @ApiModelProperty(value="Optional field used for Quickbooks integrations to match this credit card with the corresponding payment type in Quickbooks")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public PaymentsConfigurationCreditCardType cardTypeIcon(String cardTypeIcon) {
        this.cardTypeIcon = cardTypeIcon;
        return this;
    }

    @ApiModelProperty(value="Internally used icon information for this card type")
    public String getCardTypeIcon() {
        return this.cardTypeIcon;
    }

    public void setCardTypeIcon(String cardTypeIcon) {
        this.cardTypeIcon = cardTypeIcon;
    }

    public PaymentsConfigurationCreditCardType creditCard(CreditCardEnum creditCard) {
        this.creditCard = creditCard;
        return this;
    }

    @ApiModelProperty(value="Credit card type")
    public CreditCardEnum getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(CreditCardEnum creditCard) {
        this.creditCard = creditCard;
    }

    public PaymentsConfigurationCreditCardType depositToAccount(String depositToAccount) {
        this.depositToAccount = depositToAccount;
        return this;
    }

    @ApiModelProperty(value="The name of the account to deposit funds")
    public String getDepositToAccount() {
        return this.depositToAccount;
    }

    public void setDepositToAccount(String depositToAccount) {
        this.depositToAccount = depositToAccount;
    }

    public PaymentsConfigurationCreditCardType enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="If true, this card type will be accepted during checkout")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PaymentsConfigurationCreditCardType processingFee(BigDecimal processingFee) {
        this.processingFee = processingFee;
        return this;
    }

    @ApiModelProperty(value="Optional additional fee applied to order for this card")
    public BigDecimal getProcessingFee() {
        return this.processingFee;
    }

    public void setProcessingFee(BigDecimal processingFee) {
        this.processingFee = processingFee;
    }

    public PaymentsConfigurationCreditCardType processingPercentage(BigDecimal processingPercentage) {
        this.processingPercentage = processingPercentage;
        return this;
    }

    @ApiModelProperty(value="Optional additional fee applied to order for this card")
    public BigDecimal getProcessingPercentage() {
        return this.processingPercentage;
    }

    public void setProcessingPercentage(BigDecimal processingPercentage) {
        this.processingPercentage = processingPercentage;
    }

    public PaymentsConfigurationCreditCardType restrictions(PaymentsConfigurationRestrictions restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentsConfigurationRestrictions getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(PaymentsConfigurationRestrictions restrictions) {
        this.restrictions = restrictions;
    }

    public PaymentsConfigurationCreditCardType surchargeAccountingCode(String surchargeAccountingCode) {
        this.surchargeAccountingCode = surchargeAccountingCode;
        return this;
    }

    @ApiModelProperty(value="Optional field. If integrated with Quickbooks, this code will be used when informing Quickbooks about any surcharges applied to orders")
    public String getSurchargeAccountingCode() {
        return this.surchargeAccountingCode;
    }

    public void setSurchargeAccountingCode(String surchargeAccountingCode) {
        this.surchargeAccountingCode = surchargeAccountingCode;
    }

    public PaymentsConfigurationCreditCardType transactionFee(BigDecimal transactionFee) {
        this.transactionFee = transactionFee;
        return this;
    }

    @ApiModelProperty(value="An optional additional fee to charge the customer for using this card.")
    public BigDecimal getTransactionFee() {
        return this.transactionFee;
    }

    public void setTransactionFee(BigDecimal transactionFee) {
        this.transactionFee = transactionFee;
    }

    public PaymentsConfigurationCreditCardType transactionPercentage(BigDecimal transactionPercentage) {
        this.transactionPercentage = transactionPercentage;
        return this;
    }

    @ApiModelProperty(value="An optional transaction percentage to charge the customer for using this card")
    public BigDecimal getTransactionPercentage() {
        return this.transactionPercentage;
    }

    public void setTransactionPercentage(BigDecimal transactionPercentage) {
        this.transactionPercentage = transactionPercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentsConfigurationCreditCardType paymentsConfigurationCreditCardType = (PaymentsConfigurationCreditCardType)o;
        return Objects.equals(this.accountingCode, paymentsConfigurationCreditCardType.accountingCode) && Objects.equals(this.cardTypeIcon, paymentsConfigurationCreditCardType.cardTypeIcon) && Objects.equals((Object)this.creditCard, (Object)paymentsConfigurationCreditCardType.creditCard) && Objects.equals(this.depositToAccount, paymentsConfigurationCreditCardType.depositToAccount) && Objects.equals(this.enabled, paymentsConfigurationCreditCardType.enabled) && Objects.equals(this.processingFee, paymentsConfigurationCreditCardType.processingFee) && Objects.equals(this.processingPercentage, paymentsConfigurationCreditCardType.processingPercentage) && Objects.equals(this.restrictions, paymentsConfigurationCreditCardType.restrictions) && Objects.equals(this.surchargeAccountingCode, paymentsConfigurationCreditCardType.surchargeAccountingCode) && Objects.equals(this.transactionFee, paymentsConfigurationCreditCardType.transactionFee) && Objects.equals(this.transactionPercentage, paymentsConfigurationCreditCardType.transactionPercentage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountingCode, this.cardTypeIcon, this.creditCard, this.depositToAccount, this.enabled, this.processingFee, this.processingPercentage, this.restrictions, this.surchargeAccountingCode, this.transactionFee, this.transactionPercentage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentsConfigurationCreditCardType {\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    cardTypeIcon: ").append(this.toIndentedString(this.cardTypeIcon)).append("\n");
        sb.append("    creditCard: ").append(this.toIndentedString((Object)this.creditCard)).append("\n");
        sb.append("    depositToAccount: ").append(this.toIndentedString(this.depositToAccount)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    processingFee: ").append(this.toIndentedString(this.processingFee)).append("\n");
        sb.append("    processingPercentage: ").append(this.toIndentedString(this.processingPercentage)).append("\n");
        sb.append("    restrictions: ").append(this.toIndentedString(this.restrictions)).append("\n");
        sb.append("    surchargeAccountingCode: ").append(this.toIndentedString(this.surchargeAccountingCode)).append("\n");
        sb.append("    transactionFee: ").append(this.toIndentedString(this.transactionFee)).append("\n");
        sb.append("    transactionPercentage: ").append(this.toIndentedString(this.transactionPercentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CreditCardEnum {
        AMEX("AMEX"),
        DINERS_CLUB("Diners Club"),
        DISCOVER("Discover"),
        MASTERCARD("MasterCard"),
        JCB("JCB"),
        VISA("VISA");

        private String value;

        private CreditCardEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CreditCardEnum fromValue(String text) {
            for (CreditCardEnum b : CreditCardEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CreditCardEnum> {
            public void write(JsonWriter jsonWriter, CreditCardEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CreditCardEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CreditCardEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

