/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.PaymentsConfigurationCreditCardType;
import com.ultracart.admin.v2.models.PaymentsConfigurationTestMethod;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PaymentsConfigurationCreditCard {
    @SerializedName(value="accept_credit_card")
    private Boolean acceptCreditCard = null;
    @SerializedName(value="billed_by")
    private String billedBy = null;
    @SerializedName(value="charge_during_checkout")
    private Boolean chargeDuringCheckout = null;
    @SerializedName(value="collect_cvv2")
    private Boolean collectCvv2 = null;
    @SerializedName(value="configured_gateway_details")
    private String configuredGatewayDetails = null;
    @SerializedName(value="failed_attempts")
    private Integer failedAttempts = null;
    @SerializedName(value="hide_connect_single_gateway")
    private Boolean hideConnectSingleGateway = null;
    @SerializedName(value="send_customer_billing_update_on_decline")
    private Boolean sendCustomerBillingUpdateOnDecline = null;
    @SerializedName(value="supported_cards")
    private List<PaymentsConfigurationCreditCardType> supportedCards = null;
    @SerializedName(value="test_methods")
    private List<PaymentsConfigurationTestMethod> testMethods = null;

    public PaymentsConfigurationCreditCard acceptCreditCard(Boolean acceptCreditCard) {
        this.acceptCreditCard = acceptCreditCard;
        return this;
    }

    @ApiModelProperty(value="Master flag indicating whether this merchant accepts credit card payments")
    public Boolean isAcceptCreditCard() {
        return this.acceptCreditCard;
    }

    public void setAcceptCreditCard(Boolean acceptCreditCard) {
        this.acceptCreditCard = acceptCreditCard;
    }

    public PaymentsConfigurationCreditCard billedBy(String billedBy) {
        this.billedBy = billedBy;
        return this;
    }

    @ApiModelProperty(value="Description that appears on customer statements")
    public String getBilledBy() {
        return this.billedBy;
    }

    public void setBilledBy(String billedBy) {
        this.billedBy = billedBy;
    }

    public PaymentsConfigurationCreditCard chargeDuringCheckout(Boolean chargeDuringCheckout) {
        this.chargeDuringCheckout = chargeDuringCheckout;
        return this;
    }

    @ApiModelProperty(value="If false, order will be accepted and placed into Accounts Receivable without charging card first")
    public Boolean isChargeDuringCheckout() {
        return this.chargeDuringCheckout;
    }

    public void setChargeDuringCheckout(Boolean chargeDuringCheckout) {
        this.chargeDuringCheckout = chargeDuringCheckout;
    }

    public PaymentsConfigurationCreditCard collectCvv2(Boolean collectCvv2) {
        this.collectCvv2 = collectCvv2;
        return this;
    }

    @ApiModelProperty(value="UltraCart will require customer to enter cvv if this is true")
    public Boolean isCollectCvv2() {
        return this.collectCvv2;
    }

    public void setCollectCvv2(Boolean collectCvv2) {
        this.collectCvv2 = collectCvv2;
    }

    public PaymentsConfigurationCreditCard configuredGatewayDetails(String configuredGatewayDetails) {
        this.configuredGatewayDetails = configuredGatewayDetails;
        return this;
    }

    @ApiModelProperty(value="Human readable description of the credit card gateway currently configured")
    public String getConfiguredGatewayDetails() {
        return this.configuredGatewayDetails;
    }

    public void setConfiguredGatewayDetails(String configuredGatewayDetails) {
        this.configuredGatewayDetails = configuredGatewayDetails;
    }

    public PaymentsConfigurationCreditCard failedAttempts(Integer failedAttempts) {
        this.failedAttempts = failedAttempts;
        return this;
    }

    @ApiModelProperty(value="The number of failed attempts before the order is placed into Accounts Receivable for manual intervention")
    public Integer getFailedAttempts() {
        return this.failedAttempts;
    }

    public void setFailedAttempts(Integer failedAttempts) {
        this.failedAttempts = failedAttempts;
    }

    public PaymentsConfigurationCreditCard hideConnectSingleGateway(Boolean hideConnectSingleGateway) {
        this.hideConnectSingleGateway = hideConnectSingleGateway;
        return this;
    }

    @ApiModelProperty(value="This internal flag aids the UI in determining which buttons to show.")
    public Boolean isHideConnectSingleGateway() {
        return this.hideConnectSingleGateway;
    }

    public void setHideConnectSingleGateway(Boolean hideConnectSingleGateway) {
        this.hideConnectSingleGateway = hideConnectSingleGateway;
    }

    public PaymentsConfigurationCreditCard sendCustomerBillingUpdateOnDecline(Boolean sendCustomerBillingUpdateOnDecline) {
        this.sendCustomerBillingUpdateOnDecline = sendCustomerBillingUpdateOnDecline;
        return this;
    }

    @ApiModelProperty(value="UltraCart will send customers emails to update their credit card if the card is declined")
    public Boolean isSendCustomerBillingUpdateOnDecline() {
        return this.sendCustomerBillingUpdateOnDecline;
    }

    public void setSendCustomerBillingUpdateOnDecline(Boolean sendCustomerBillingUpdateOnDecline) {
        this.sendCustomerBillingUpdateOnDecline = sendCustomerBillingUpdateOnDecline;
    }

    public PaymentsConfigurationCreditCard supportedCards(List<PaymentsConfigurationCreditCardType> supportedCards) {
        this.supportedCards = supportedCards;
        return this;
    }

    public PaymentsConfigurationCreditCard addSupportedCardsItem(PaymentsConfigurationCreditCardType supportedCardsItem) {
        if (this.supportedCards == null) {
            this.supportedCards = new ArrayList<PaymentsConfigurationCreditCardType>();
        }
        this.supportedCards.add(supportedCardsItem);
        return this;
    }

    @ApiModelProperty(value="A list of credit cards the merchant wishes to accept.")
    public List<PaymentsConfigurationCreditCardType> getSupportedCards() {
        return this.supportedCards;
    }

    public void setSupportedCards(List<PaymentsConfigurationCreditCardType> supportedCards) {
        this.supportedCards = supportedCards;
    }

    public PaymentsConfigurationCreditCard testMethods(List<PaymentsConfigurationTestMethod> testMethods) {
        this.testMethods = testMethods;
        return this;
    }

    public PaymentsConfigurationCreditCard addTestMethodsItem(PaymentsConfigurationTestMethod testMethodsItem) {
        if (this.testMethods == null) {
            this.testMethods = new ArrayList<PaymentsConfigurationTestMethod>();
        }
        this.testMethods.add(testMethodsItem);
        return this;
    }

    @ApiModelProperty(value="An array of test methods for placing test orders.  The cards defined here may be real or fake, but any order placed with them will be marked as Test orders")
    public List<PaymentsConfigurationTestMethod> getTestMethods() {
        return this.testMethods;
    }

    public void setTestMethods(List<PaymentsConfigurationTestMethod> testMethods) {
        this.testMethods = testMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentsConfigurationCreditCard paymentsConfigurationCreditCard = (PaymentsConfigurationCreditCard)o;
        return Objects.equals(this.acceptCreditCard, paymentsConfigurationCreditCard.acceptCreditCard) && Objects.equals(this.billedBy, paymentsConfigurationCreditCard.billedBy) && Objects.equals(this.chargeDuringCheckout, paymentsConfigurationCreditCard.chargeDuringCheckout) && Objects.equals(this.collectCvv2, paymentsConfigurationCreditCard.collectCvv2) && Objects.equals(this.configuredGatewayDetails, paymentsConfigurationCreditCard.configuredGatewayDetails) && Objects.equals(this.failedAttempts, paymentsConfigurationCreditCard.failedAttempts) && Objects.equals(this.hideConnectSingleGateway, paymentsConfigurationCreditCard.hideConnectSingleGateway) && Objects.equals(this.sendCustomerBillingUpdateOnDecline, paymentsConfigurationCreditCard.sendCustomerBillingUpdateOnDecline) && Objects.equals(this.supportedCards, paymentsConfigurationCreditCard.supportedCards) && Objects.equals(this.testMethods, paymentsConfigurationCreditCard.testMethods);
    }

    public int hashCode() {
        return Objects.hash(this.acceptCreditCard, this.billedBy, this.chargeDuringCheckout, this.collectCvv2, this.configuredGatewayDetails, this.failedAttempts, this.hideConnectSingleGateway, this.sendCustomerBillingUpdateOnDecline, this.supportedCards, this.testMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentsConfigurationCreditCard {\n");
        sb.append("    acceptCreditCard: ").append(this.toIndentedString(this.acceptCreditCard)).append("\n");
        sb.append("    billedBy: ").append(this.toIndentedString(this.billedBy)).append("\n");
        sb.append("    chargeDuringCheckout: ").append(this.toIndentedString(this.chargeDuringCheckout)).append("\n");
        sb.append("    collectCvv2: ").append(this.toIndentedString(this.collectCvv2)).append("\n");
        sb.append("    configuredGatewayDetails: ").append(this.toIndentedString(this.configuredGatewayDetails)).append("\n");
        sb.append("    failedAttempts: ").append(this.toIndentedString(this.failedAttempts)).append("\n");
        sb.append("    hideConnectSingleGateway: ").append(this.toIndentedString(this.hideConnectSingleGateway)).append("\n");
        sb.append("    sendCustomerBillingUpdateOnDecline: ").append(this.toIndentedString(this.sendCustomerBillingUpdateOnDecline)).append("\n");
        sb.append("    supportedCards: ").append(this.toIndentedString(this.supportedCards)).append("\n");
        sb.append("    testMethods: ").append(this.toIndentedString(this.testMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

