/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

public class OrderTaxes {
    @SerializedName(value="arbitrary_tax")
    private BigDecimal arbitraryTax = null;
    @SerializedName(value="arbitrary_tax_rate")
    private BigDecimal arbitraryTaxRate = null;
    @SerializedName(value="arbitrary_taxable_subtotal")
    private BigDecimal arbitraryTaxableSubtotal = null;
    @SerializedName(value="tax_city_accounting_code")
    private String taxCityAccountingCode = null;
    @SerializedName(value="tax_country_accounting_code")
    private String taxCountryAccountingCode = null;
    @SerializedName(value="tax_county")
    private String taxCounty = null;
    @SerializedName(value="tax_county_accounting_code")
    private String taxCountyAccountingCode = null;
    @SerializedName(value="tax_gift_charge")
    private Boolean taxGiftCharge = null;
    @SerializedName(value="tax_postal_code_accounting_code")
    private String taxPostalCodeAccountingCode = null;
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate = null;
    @SerializedName(value="tax_rate_city")
    private BigDecimal taxRateCity = null;
    @SerializedName(value="tax_rate_country")
    private BigDecimal taxRateCountry = null;
    @SerializedName(value="tax_rate_county")
    private BigDecimal taxRateCounty = null;
    @SerializedName(value="tax_rate_postal_code")
    private BigDecimal taxRatePostalCode = null;
    @SerializedName(value="tax_rate_state")
    private BigDecimal taxRateState = null;
    @SerializedName(value="tax_shipping")
    private Boolean taxShipping = null;
    @SerializedName(value="tax_state_accounting_code")
    private String taxStateAccountingCode = null;

    public OrderTaxes arbitraryTax(BigDecimal arbitraryTax) {
        this.arbitraryTax = arbitraryTax;
        return this;
    }

    @ApiModelProperty(value="Arbitrary Tax, this is meaningless for updating an order.  For inserting a new order, this will override any internal tax calculations and should only be used for orders completed outside the system.")
    public BigDecimal getArbitraryTax() {
        return this.arbitraryTax;
    }

    public void setArbitraryTax(BigDecimal arbitraryTax) {
        this.arbitraryTax = arbitraryTax;
    }

    public OrderTaxes arbitraryTaxRate(BigDecimal arbitraryTaxRate) {
        this.arbitraryTaxRate = arbitraryTaxRate;
        return this;
    }

    @ApiModelProperty(value="Arbitrary tax rate, this is meaningless for updating an order.  For inserting a new order, this will override any internal tax calculations and should only be used for orders completed outside the system.")
    public BigDecimal getArbitraryTaxRate() {
        return this.arbitraryTaxRate;
    }

    public void setArbitraryTaxRate(BigDecimal arbitraryTaxRate) {
        this.arbitraryTaxRate = arbitraryTaxRate;
    }

    public OrderTaxes arbitraryTaxableSubtotal(BigDecimal arbitraryTaxableSubtotal) {
        this.arbitraryTaxableSubtotal = arbitraryTaxableSubtotal;
        return this;
    }

    @ApiModelProperty(value="Arbitrary taxable subtotal, this is meaningless for updating an order.  For inserting a new order, this will override any internal tax calculations and should only be used for orders completed outside the system.")
    public BigDecimal getArbitraryTaxableSubtotal() {
        return this.arbitraryTaxableSubtotal;
    }

    public void setArbitraryTaxableSubtotal(BigDecimal arbitraryTaxableSubtotal) {
        this.arbitraryTaxableSubtotal = arbitraryTaxableSubtotal;
    }

    public OrderTaxes taxCityAccountingCode(String taxCityAccountingCode) {
        this.taxCityAccountingCode = taxCityAccountingCode;
        return this;
    }

    @ApiModelProperty(value="QuickBooks tax city code")
    public String getTaxCityAccountingCode() {
        return this.taxCityAccountingCode;
    }

    public void setTaxCityAccountingCode(String taxCityAccountingCode) {
        this.taxCityAccountingCode = taxCityAccountingCode;
    }

    public OrderTaxes taxCountryAccountingCode(String taxCountryAccountingCode) {
        this.taxCountryAccountingCode = taxCountryAccountingCode;
        return this;
    }

    @ApiModelProperty(value="QuickBooks tax country code")
    public String getTaxCountryAccountingCode() {
        return this.taxCountryAccountingCode;
    }

    public void setTaxCountryAccountingCode(String taxCountryAccountingCode) {
        this.taxCountryAccountingCode = taxCountryAccountingCode;
    }

    public OrderTaxes taxCounty(String taxCounty) {
        this.taxCounty = taxCounty;
        return this;
    }

    @ApiModelProperty(value="County used for tax calculation purposes (only in the United States)")
    public String getTaxCounty() {
        return this.taxCounty;
    }

    public void setTaxCounty(String taxCounty) {
        this.taxCounty = taxCounty;
    }

    public OrderTaxes taxCountyAccountingCode(String taxCountyAccountingCode) {
        this.taxCountyAccountingCode = taxCountyAccountingCode;
        return this;
    }

    @ApiModelProperty(value="QuickBooks tax county code")
    public String getTaxCountyAccountingCode() {
        return this.taxCountyAccountingCode;
    }

    public void setTaxCountyAccountingCode(String taxCountyAccountingCode) {
        this.taxCountyAccountingCode = taxCountyAccountingCode;
    }

    public OrderTaxes taxGiftCharge(Boolean taxGiftCharge) {
        this.taxGiftCharge = taxGiftCharge;
        return this;
    }

    @ApiModelProperty(value="True if gift charge is taxed")
    public Boolean isTaxGiftCharge() {
        return this.taxGiftCharge;
    }

    public void setTaxGiftCharge(Boolean taxGiftCharge) {
        this.taxGiftCharge = taxGiftCharge;
    }

    public OrderTaxes taxPostalCodeAccountingCode(String taxPostalCodeAccountingCode) {
        this.taxPostalCodeAccountingCode = taxPostalCodeAccountingCode;
        return this;
    }

    @ApiModelProperty(value="QuickBooks tax postal code code")
    public String getTaxPostalCodeAccountingCode() {
        return this.taxPostalCodeAccountingCode;
    }

    public void setTaxPostalCodeAccountingCode(String taxPostalCodeAccountingCode) {
        this.taxPostalCodeAccountingCode = taxPostalCodeAccountingCode;
    }

    public OrderTaxes taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty(value="Tax rate, this is meaningless for updating an order.  For inserting a new order, if you need to override internal tax calculations, use the arbitrary fields.")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public OrderTaxes taxRateCity(BigDecimal taxRateCity) {
        this.taxRateCity = taxRateCity;
        return this;
    }

    @ApiModelProperty(value="Tax rate at the city level")
    public BigDecimal getTaxRateCity() {
        return this.taxRateCity;
    }

    public void setTaxRateCity(BigDecimal taxRateCity) {
        this.taxRateCity = taxRateCity;
    }

    public OrderTaxes taxRateCountry(BigDecimal taxRateCountry) {
        this.taxRateCountry = taxRateCountry;
        return this;
    }

    @ApiModelProperty(value="Tax rate at the country level")
    public BigDecimal getTaxRateCountry() {
        return this.taxRateCountry;
    }

    public void setTaxRateCountry(BigDecimal taxRateCountry) {
        this.taxRateCountry = taxRateCountry;
    }

    public OrderTaxes taxRateCounty(BigDecimal taxRateCounty) {
        this.taxRateCounty = taxRateCounty;
        return this;
    }

    @ApiModelProperty(value="Tax rate at the county level")
    public BigDecimal getTaxRateCounty() {
        return this.taxRateCounty;
    }

    public void setTaxRateCounty(BigDecimal taxRateCounty) {
        this.taxRateCounty = taxRateCounty;
    }

    public OrderTaxes taxRatePostalCode(BigDecimal taxRatePostalCode) {
        this.taxRatePostalCode = taxRatePostalCode;
        return this;
    }

    @ApiModelProperty(value="Tax rate at the postal code level")
    public BigDecimal getTaxRatePostalCode() {
        return this.taxRatePostalCode;
    }

    public void setTaxRatePostalCode(BigDecimal taxRatePostalCode) {
        this.taxRatePostalCode = taxRatePostalCode;
    }

    public OrderTaxes taxRateState(BigDecimal taxRateState) {
        this.taxRateState = taxRateState;
        return this;
    }

    @ApiModelProperty(value="Tax rate at the state level")
    public BigDecimal getTaxRateState() {
        return this.taxRateState;
    }

    public void setTaxRateState(BigDecimal taxRateState) {
        this.taxRateState = taxRateState;
    }

    public OrderTaxes taxShipping(Boolean taxShipping) {
        this.taxShipping = taxShipping;
        return this;
    }

    @ApiModelProperty(value="True if shipping is taxed")
    public Boolean isTaxShipping() {
        return this.taxShipping;
    }

    public void setTaxShipping(Boolean taxShipping) {
        this.taxShipping = taxShipping;
    }

    public OrderTaxes taxStateAccountingCode(String taxStateAccountingCode) {
        this.taxStateAccountingCode = taxStateAccountingCode;
        return this;
    }

    @ApiModelProperty(value="QuickBooks tax state code")
    public String getTaxStateAccountingCode() {
        return this.taxStateAccountingCode;
    }

    public void setTaxStateAccountingCode(String taxStateAccountingCode) {
        this.taxStateAccountingCode = taxStateAccountingCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderTaxes orderTaxes = (OrderTaxes)o;
        return Objects.equals(this.arbitraryTax, orderTaxes.arbitraryTax) && Objects.equals(this.arbitraryTaxRate, orderTaxes.arbitraryTaxRate) && Objects.equals(this.arbitraryTaxableSubtotal, orderTaxes.arbitraryTaxableSubtotal) && Objects.equals(this.taxCityAccountingCode, orderTaxes.taxCityAccountingCode) && Objects.equals(this.taxCountryAccountingCode, orderTaxes.taxCountryAccountingCode) && Objects.equals(this.taxCounty, orderTaxes.taxCounty) && Objects.equals(this.taxCountyAccountingCode, orderTaxes.taxCountyAccountingCode) && Objects.equals(this.taxGiftCharge, orderTaxes.taxGiftCharge) && Objects.equals(this.taxPostalCodeAccountingCode, orderTaxes.taxPostalCodeAccountingCode) && Objects.equals(this.taxRate, orderTaxes.taxRate) && Objects.equals(this.taxRateCity, orderTaxes.taxRateCity) && Objects.equals(this.taxRateCountry, orderTaxes.taxRateCountry) && Objects.equals(this.taxRateCounty, orderTaxes.taxRateCounty) && Objects.equals(this.taxRatePostalCode, orderTaxes.taxRatePostalCode) && Objects.equals(this.taxRateState, orderTaxes.taxRateState) && Objects.equals(this.taxShipping, orderTaxes.taxShipping) && Objects.equals(this.taxStateAccountingCode, orderTaxes.taxStateAccountingCode);
    }

    public int hashCode() {
        return Objects.hash(this.arbitraryTax, this.arbitraryTaxRate, this.arbitraryTaxableSubtotal, this.taxCityAccountingCode, this.taxCountryAccountingCode, this.taxCounty, this.taxCountyAccountingCode, this.taxGiftCharge, this.taxPostalCodeAccountingCode, this.taxRate, this.taxRateCity, this.taxRateCountry, this.taxRateCounty, this.taxRatePostalCode, this.taxRateState, this.taxShipping, this.taxStateAccountingCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderTaxes {\n");
        sb.append("    arbitraryTax: ").append(this.toIndentedString(this.arbitraryTax)).append("\n");
        sb.append("    arbitraryTaxRate: ").append(this.toIndentedString(this.arbitraryTaxRate)).append("\n");
        sb.append("    arbitraryTaxableSubtotal: ").append(this.toIndentedString(this.arbitraryTaxableSubtotal)).append("\n");
        sb.append("    taxCityAccountingCode: ").append(this.toIndentedString(this.taxCityAccountingCode)).append("\n");
        sb.append("    taxCountryAccountingCode: ").append(this.toIndentedString(this.taxCountryAccountingCode)).append("\n");
        sb.append("    taxCounty: ").append(this.toIndentedString(this.taxCounty)).append("\n");
        sb.append("    taxCountyAccountingCode: ").append(this.toIndentedString(this.taxCountyAccountingCode)).append("\n");
        sb.append("    taxGiftCharge: ").append(this.toIndentedString(this.taxGiftCharge)).append("\n");
        sb.append("    taxPostalCodeAccountingCode: ").append(this.toIndentedString(this.taxPostalCodeAccountingCode)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateCity: ").append(this.toIndentedString(this.taxRateCity)).append("\n");
        sb.append("    taxRateCountry: ").append(this.toIndentedString(this.taxRateCountry)).append("\n");
        sb.append("    taxRateCounty: ").append(this.toIndentedString(this.taxRateCounty)).append("\n");
        sb.append("    taxRatePostalCode: ").append(this.toIndentedString(this.taxRatePostalCode)).append("\n");
        sb.append("    taxRateState: ").append(this.toIndentedString(this.taxRateState)).append("\n");
        sb.append("    taxShipping: ").append(this.toIndentedString(this.taxShipping)).append("\n");
        sb.append("    taxStateAccountingCode: ").append(this.toIndentedString(this.taxStateAccountingCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

