/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

public class OrderPaymentCreditCard {
    @SerializedName(value="card_auth_ticket")
    private String cardAuthTicket = null;
    @SerializedName(value="card_authorization_amount")
    private BigDecimal cardAuthorizationAmount = null;
    @SerializedName(value="card_authorization_dts")
    private String cardAuthorizationDts = null;
    @SerializedName(value="card_authorization_reference_number")
    private String cardAuthorizationReferenceNumber = null;
    @SerializedName(value="card_expiration_month")
    private Integer cardExpirationMonth = null;
    @SerializedName(value="card_expiration_year")
    private Integer cardExpirationYear = null;
    @SerializedName(value="card_number")
    private String cardNumber = null;
    @SerializedName(value="card_number_token")
    private String cardNumberToken = null;
    @SerializedName(value="card_number_truncated")
    private Boolean cardNumberTruncated = null;
    @SerializedName(value="card_type")
    private CardTypeEnum cardType = null;
    @SerializedName(value="card_verification_number_token")
    private String cardVerificationNumberToken = null;

    public OrderPaymentCreditCard cardAuthTicket(String cardAuthTicket) {
        this.cardAuthTicket = cardAuthTicket;
        return this;
    }

    @ApiModelProperty(value="Card authorization ticket")
    public String getCardAuthTicket() {
        return this.cardAuthTicket;
    }

    public void setCardAuthTicket(String cardAuthTicket) {
        this.cardAuthTicket = cardAuthTicket;
    }

    public OrderPaymentCreditCard cardAuthorizationAmount(BigDecimal cardAuthorizationAmount) {
        this.cardAuthorizationAmount = cardAuthorizationAmount;
        return this;
    }

    @ApiModelProperty(value="Card authorization amount")
    public BigDecimal getCardAuthorizationAmount() {
        return this.cardAuthorizationAmount;
    }

    public void setCardAuthorizationAmount(BigDecimal cardAuthorizationAmount) {
        this.cardAuthorizationAmount = cardAuthorizationAmount;
    }

    public OrderPaymentCreditCard cardAuthorizationDts(String cardAuthorizationDts) {
        this.cardAuthorizationDts = cardAuthorizationDts;
        return this;
    }

    @ApiModelProperty(value="Card authorization date/time")
    public String getCardAuthorizationDts() {
        return this.cardAuthorizationDts;
    }

    public void setCardAuthorizationDts(String cardAuthorizationDts) {
        this.cardAuthorizationDts = cardAuthorizationDts;
    }

    public OrderPaymentCreditCard cardAuthorizationReferenceNumber(String cardAuthorizationReferenceNumber) {
        this.cardAuthorizationReferenceNumber = cardAuthorizationReferenceNumber;
        return this;
    }

    @ApiModelProperty(value="Card authorization reference number")
    public String getCardAuthorizationReferenceNumber() {
        return this.cardAuthorizationReferenceNumber;
    }

    public void setCardAuthorizationReferenceNumber(String cardAuthorizationReferenceNumber) {
        this.cardAuthorizationReferenceNumber = cardAuthorizationReferenceNumber;
    }

    public OrderPaymentCreditCard cardExpirationMonth(Integer cardExpirationMonth) {
        this.cardExpirationMonth = cardExpirationMonth;
        return this;
    }

    @ApiModelProperty(value="Card expiration month (1-12)")
    public Integer getCardExpirationMonth() {
        return this.cardExpirationMonth;
    }

    public void setCardExpirationMonth(Integer cardExpirationMonth) {
        this.cardExpirationMonth = cardExpirationMonth;
    }

    public OrderPaymentCreditCard cardExpirationYear(Integer cardExpirationYear) {
        this.cardExpirationYear = cardExpirationYear;
        return this;
    }

    @ApiModelProperty(value="Card expiration year (Four digit year)")
    public Integer getCardExpirationYear() {
        return this.cardExpirationYear;
    }

    public void setCardExpirationYear(Integer cardExpirationYear) {
        this.cardExpirationYear = cardExpirationYear;
    }

    public OrderPaymentCreditCard cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @ApiModelProperty(value="Card number (masked to last 4)")
    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public OrderPaymentCreditCard cardNumberToken(String cardNumberToken) {
        this.cardNumberToken = cardNumberToken;
        return this;
    }

    @ApiModelProperty(value="Card number token from hosted fields used to update the card number")
    public String getCardNumberToken() {
        return this.cardNumberToken;
    }

    public void setCardNumberToken(String cardNumberToken) {
        this.cardNumberToken = cardNumberToken;
    }

    public OrderPaymentCreditCard cardNumberTruncated(Boolean cardNumberTruncated) {
        this.cardNumberTruncated = cardNumberTruncated;
        return this;
    }

    @ApiModelProperty(value="True if the card has been truncated")
    public Boolean isCardNumberTruncated() {
        return this.cardNumberTruncated;
    }

    public void setCardNumberTruncated(Boolean cardNumberTruncated) {
        this.cardNumberTruncated = cardNumberTruncated;
    }

    public OrderPaymentCreditCard cardType(CardTypeEnum cardType) {
        this.cardType = cardType;
        return this;
    }

    @ApiModelProperty(value="Card type")
    public CardTypeEnum getCardType() {
        return this.cardType;
    }

    public void setCardType(CardTypeEnum cardType) {
        this.cardType = cardType;
    }

    public OrderPaymentCreditCard cardVerificationNumberToken(String cardVerificationNumberToken) {
        this.cardVerificationNumberToken = cardVerificationNumberToken;
        return this;
    }

    @ApiModelProperty(value="Card verification number token from hosted fields, only for import/insert of new orders, completely ignored for updates, and always null/empty for queries")
    public String getCardVerificationNumberToken() {
        return this.cardVerificationNumberToken;
    }

    public void setCardVerificationNumberToken(String cardVerificationNumberToken) {
        this.cardVerificationNumberToken = cardVerificationNumberToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPaymentCreditCard orderPaymentCreditCard = (OrderPaymentCreditCard)o;
        return Objects.equals(this.cardAuthTicket, orderPaymentCreditCard.cardAuthTicket) && Objects.equals(this.cardAuthorizationAmount, orderPaymentCreditCard.cardAuthorizationAmount) && Objects.equals(this.cardAuthorizationDts, orderPaymentCreditCard.cardAuthorizationDts) && Objects.equals(this.cardAuthorizationReferenceNumber, orderPaymentCreditCard.cardAuthorizationReferenceNumber) && Objects.equals(this.cardExpirationMonth, orderPaymentCreditCard.cardExpirationMonth) && Objects.equals(this.cardExpirationYear, orderPaymentCreditCard.cardExpirationYear) && Objects.equals(this.cardNumber, orderPaymentCreditCard.cardNumber) && Objects.equals(this.cardNumberToken, orderPaymentCreditCard.cardNumberToken) && Objects.equals(this.cardNumberTruncated, orderPaymentCreditCard.cardNumberTruncated) && Objects.equals((Object)this.cardType, (Object)orderPaymentCreditCard.cardType) && Objects.equals(this.cardVerificationNumberToken, orderPaymentCreditCard.cardVerificationNumberToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardAuthTicket, this.cardAuthorizationAmount, this.cardAuthorizationDts, this.cardAuthorizationReferenceNumber, this.cardExpirationMonth, this.cardExpirationYear, this.cardNumber, this.cardNumberToken, this.cardNumberTruncated, this.cardType, this.cardVerificationNumberToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPaymentCreditCard {\n");
        sb.append("    cardAuthTicket: ").append(this.toIndentedString(this.cardAuthTicket)).append("\n");
        sb.append("    cardAuthorizationAmount: ").append(this.toIndentedString(this.cardAuthorizationAmount)).append("\n");
        sb.append("    cardAuthorizationDts: ").append(this.toIndentedString(this.cardAuthorizationDts)).append("\n");
        sb.append("    cardAuthorizationReferenceNumber: ").append(this.toIndentedString(this.cardAuthorizationReferenceNumber)).append("\n");
        sb.append("    cardExpirationMonth: ").append(this.toIndentedString(this.cardExpirationMonth)).append("\n");
        sb.append("    cardExpirationYear: ").append(this.toIndentedString(this.cardExpirationYear)).append("\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    cardNumberToken: ").append(this.toIndentedString(this.cardNumberToken)).append("\n");
        sb.append("    cardNumberTruncated: ").append(this.toIndentedString(this.cardNumberTruncated)).append("\n");
        sb.append("    cardType: ").append(this.toIndentedString((Object)this.cardType)).append("\n");
        sb.append("    cardVerificationNumberToken: ").append(this.toIndentedString(this.cardVerificationNumberToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CardTypeEnum {
        AMEX("AMEX"),
        DINERS_CLUB("Diners Club"),
        DISCOVER("Discover"),
        JCB("JCB"),
        MASTERCARD("MasterCard"),
        VISA("VISA");

        private String value;

        private CardTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CardTypeEnum fromValue(String text) {
            for (CardTypeEnum b : CardTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CardTypeEnum> {
            public void write(JsonWriter jsonWriter, CardTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CardTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CardTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

