/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.Currency;
import com.ultracart.admin.v2.models.OrderPaymentCheck;
import com.ultracart.admin.v2.models.OrderPaymentCreditCard;
import com.ultracart.admin.v2.models.OrderPaymentECheck;
import com.ultracart.admin.v2.models.OrderPaymentInsurance;
import com.ultracart.admin.v2.models.OrderPaymentPurchaseOrder;
import com.ultracart.admin.v2.models.OrderPaymentTransaction;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrderPayment {
    @SerializedName(value="check")
    private OrderPaymentCheck check = null;
    @SerializedName(value="credit_card")
    private OrderPaymentCreditCard creditCard = null;
    @SerializedName(value="echeck")
    private OrderPaymentECheck echeck = null;
    @SerializedName(value="hold_for_fraud_review")
    private Boolean holdForFraudReview = null;
    @SerializedName(value="insurance")
    private OrderPaymentInsurance insurance = null;
    @SerializedName(value="payment_dts")
    private String paymentDts = null;
    @SerializedName(value="payment_method")
    private PaymentMethodEnum paymentMethod = null;
    @SerializedName(value="payment_method_accounting_code")
    private String paymentMethodAccountingCode = null;
    @SerializedName(value="payment_method_deposit_to_account")
    private String paymentMethodDepositToAccount = null;
    @SerializedName(value="payment_status")
    private PaymentStatusEnum paymentStatus = null;
    @SerializedName(value="purchase_order")
    private OrderPaymentPurchaseOrder purchaseOrder = null;
    @SerializedName(value="rotating_transaction_gateway_code")
    private String rotatingTransactionGatewayCode = null;
    @SerializedName(value="surcharge")
    private Currency surcharge = null;
    @SerializedName(value="surcharge_accounting_code")
    private String surchargeAccountingCode = null;
    @SerializedName(value="surcharge_transaction_fee")
    private BigDecimal surchargeTransactionFee = null;
    @SerializedName(value="surcharge_transaction_percentage")
    private BigDecimal surchargeTransactionPercentage = null;
    @SerializedName(value="test_order")
    private Boolean testOrder = null;
    @SerializedName(value="transactions")
    private List<OrderPaymentTransaction> transactions = null;

    public OrderPayment check(OrderPaymentCheck check) {
        this.check = check;
        return this;
    }

    @ApiModelProperty(value="")
    public OrderPaymentCheck getCheck() {
        return this.check;
    }

    public void setCheck(OrderPaymentCheck check) {
        this.check = check;
    }

    public OrderPayment creditCard(OrderPaymentCreditCard creditCard) {
        this.creditCard = creditCard;
        return this;
    }

    @ApiModelProperty(value="")
    public OrderPaymentCreditCard getCreditCard() {
        return this.creditCard;
    }

    public void setCreditCard(OrderPaymentCreditCard creditCard) {
        this.creditCard = creditCard;
    }

    public OrderPayment echeck(OrderPaymentECheck echeck) {
        this.echeck = echeck;
        return this;
    }

    @ApiModelProperty(value="")
    public OrderPaymentECheck getEcheck() {
        return this.echeck;
    }

    public void setEcheck(OrderPaymentECheck echeck) {
        this.echeck = echeck;
    }

    public OrderPayment holdForFraudReview(Boolean holdForFraudReview) {
        this.holdForFraudReview = holdForFraudReview;
        return this;
    }

    @ApiModelProperty(value="True if order has been held for fraud review")
    public Boolean isHoldForFraudReview() {
        return this.holdForFraudReview;
    }

    public void setHoldForFraudReview(Boolean holdForFraudReview) {
        this.holdForFraudReview = holdForFraudReview;
    }

    public OrderPayment insurance(OrderPaymentInsurance insurance) {
        this.insurance = insurance;
        return this;
    }

    @ApiModelProperty(value="")
    public OrderPaymentInsurance getInsurance() {
        return this.insurance;
    }

    public void setInsurance(OrderPaymentInsurance insurance) {
        this.insurance = insurance;
    }

    public OrderPayment paymentDts(String paymentDts) {
        this.paymentDts = paymentDts;
        return this;
    }

    @ApiModelProperty(value="Date/time that the payment was successfully processed, for new orders, this field is only considered if channel_partner.skip_payment_processing is true")
    public String getPaymentDts() {
        return this.paymentDts;
    }

    public void setPaymentDts(String paymentDts) {
        this.paymentDts = paymentDts;
    }

    public OrderPayment paymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="Payment method")
    public PaymentMethodEnum getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public OrderPayment paymentMethodAccountingCode(String paymentMethodAccountingCode) {
        this.paymentMethodAccountingCode = paymentMethodAccountingCode;
        return this;
    }

    @ApiModelProperty(value="Payment method QuickBooks code")
    public String getPaymentMethodAccountingCode() {
        return this.paymentMethodAccountingCode;
    }

    public void setPaymentMethodAccountingCode(String paymentMethodAccountingCode) {
        this.paymentMethodAccountingCode = paymentMethodAccountingCode;
    }

    public OrderPayment paymentMethodDepositToAccount(String paymentMethodDepositToAccount) {
        this.paymentMethodDepositToAccount = paymentMethodDepositToAccount;
        return this;
    }

    @ApiModelProperty(value="Payment method QuickBooks deposit account")
    public String getPaymentMethodDepositToAccount() {
        return this.paymentMethodDepositToAccount;
    }

    public void setPaymentMethodDepositToAccount(String paymentMethodDepositToAccount) {
        this.paymentMethodDepositToAccount = paymentMethodDepositToAccount;
    }

    public OrderPayment paymentStatus(PaymentStatusEnum paymentStatus) {
        this.paymentStatus = paymentStatus;
        return this;
    }

    @ApiModelProperty(value="Payment status")
    public PaymentStatusEnum getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(PaymentStatusEnum paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public OrderPayment purchaseOrder(OrderPaymentPurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
        return this;
    }

    @ApiModelProperty(value="")
    public OrderPaymentPurchaseOrder getPurchaseOrder() {
        return this.purchaseOrder;
    }

    public void setPurchaseOrder(OrderPaymentPurchaseOrder purchaseOrder) {
        this.purchaseOrder = purchaseOrder;
    }

    public OrderPayment rotatingTransactionGatewayCode(String rotatingTransactionGatewayCode) {
        this.rotatingTransactionGatewayCode = rotatingTransactionGatewayCode;
        return this;
    }

    @ApiModelProperty(value="Rotating transaction gateway code used to process this order")
    public String getRotatingTransactionGatewayCode() {
        return this.rotatingTransactionGatewayCode;
    }

    public void setRotatingTransactionGatewayCode(String rotatingTransactionGatewayCode) {
        this.rotatingTransactionGatewayCode = rotatingTransactionGatewayCode;
    }

    public OrderPayment surcharge(Currency surcharge) {
        this.surcharge = surcharge;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getSurcharge() {
        return this.surcharge;
    }

    public void setSurcharge(Currency surcharge) {
        this.surcharge = surcharge;
    }

    public OrderPayment surchargeAccountingCode(String surchargeAccountingCode) {
        this.surchargeAccountingCode = surchargeAccountingCode;
        return this;
    }

    @ApiModelProperty(value="Surcharge accounting code")
    public String getSurchargeAccountingCode() {
        return this.surchargeAccountingCode;
    }

    public void setSurchargeAccountingCode(String surchargeAccountingCode) {
        this.surchargeAccountingCode = surchargeAccountingCode;
    }

    public OrderPayment surchargeTransactionFee(BigDecimal surchargeTransactionFee) {
        this.surchargeTransactionFee = surchargeTransactionFee;
        return this;
    }

    @ApiModelProperty(value="Surcharge transaction fee")
    public BigDecimal getSurchargeTransactionFee() {
        return this.surchargeTransactionFee;
    }

    public void setSurchargeTransactionFee(BigDecimal surchargeTransactionFee) {
        this.surchargeTransactionFee = surchargeTransactionFee;
    }

    public OrderPayment surchargeTransactionPercentage(BigDecimal surchargeTransactionPercentage) {
        this.surchargeTransactionPercentage = surchargeTransactionPercentage;
        return this;
    }

    @ApiModelProperty(value="Surcharge transaction percentage")
    public BigDecimal getSurchargeTransactionPercentage() {
        return this.surchargeTransactionPercentage;
    }

    public void setSurchargeTransactionPercentage(BigDecimal surchargeTransactionPercentage) {
        this.surchargeTransactionPercentage = surchargeTransactionPercentage;
    }

    public OrderPayment testOrder(Boolean testOrder) {
        this.testOrder = testOrder;
        return this;
    }

    @ApiModelProperty(value="True if this is a test order")
    public Boolean isTestOrder() {
        return this.testOrder;
    }

    public void setTestOrder(Boolean testOrder) {
        this.testOrder = testOrder;
    }

    public OrderPayment transactions(List<OrderPaymentTransaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public OrderPayment addTransactionsItem(OrderPaymentTransaction transactionsItem) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<OrderPaymentTransaction>();
        }
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(value="Transactions associated with processing this payment")
    public List<OrderPaymentTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<OrderPaymentTransaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderPayment orderPayment = (OrderPayment)o;
        return Objects.equals(this.check, orderPayment.check) && Objects.equals(this.creditCard, orderPayment.creditCard) && Objects.equals(this.echeck, orderPayment.echeck) && Objects.equals(this.holdForFraudReview, orderPayment.holdForFraudReview) && Objects.equals(this.insurance, orderPayment.insurance) && Objects.equals(this.paymentDts, orderPayment.paymentDts) && Objects.equals((Object)this.paymentMethod, (Object)orderPayment.paymentMethod) && Objects.equals(this.paymentMethodAccountingCode, orderPayment.paymentMethodAccountingCode) && Objects.equals(this.paymentMethodDepositToAccount, orderPayment.paymentMethodDepositToAccount) && Objects.equals((Object)this.paymentStatus, (Object)orderPayment.paymentStatus) && Objects.equals(this.purchaseOrder, orderPayment.purchaseOrder) && Objects.equals(this.rotatingTransactionGatewayCode, orderPayment.rotatingTransactionGatewayCode) && Objects.equals(this.surcharge, orderPayment.surcharge) && Objects.equals(this.surchargeAccountingCode, orderPayment.surchargeAccountingCode) && Objects.equals(this.surchargeTransactionFee, orderPayment.surchargeTransactionFee) && Objects.equals(this.surchargeTransactionPercentage, orderPayment.surchargeTransactionPercentage) && Objects.equals(this.testOrder, orderPayment.testOrder) && Objects.equals(this.transactions, orderPayment.transactions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.check, this.creditCard, this.echeck, this.holdForFraudReview, this.insurance, this.paymentDts, this.paymentMethod, this.paymentMethodAccountingCode, this.paymentMethodDepositToAccount, this.paymentStatus, this.purchaseOrder, this.rotatingTransactionGatewayCode, this.surcharge, this.surchargeAccountingCode, this.surchargeTransactionFee, this.surchargeTransactionPercentage, this.testOrder, this.transactions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderPayment {\n");
        sb.append("    check: ").append(this.toIndentedString(this.check)).append("\n");
        sb.append("    creditCard: ").append(this.toIndentedString(this.creditCard)).append("\n");
        sb.append("    echeck: ").append(this.toIndentedString(this.echeck)).append("\n");
        sb.append("    holdForFraudReview: ").append(this.toIndentedString(this.holdForFraudReview)).append("\n");
        sb.append("    insurance: ").append(this.toIndentedString(this.insurance)).append("\n");
        sb.append("    paymentDts: ").append(this.toIndentedString(this.paymentDts)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString((Object)this.paymentMethod)).append("\n");
        sb.append("    paymentMethodAccountingCode: ").append(this.toIndentedString(this.paymentMethodAccountingCode)).append("\n");
        sb.append("    paymentMethodDepositToAccount: ").append(this.toIndentedString(this.paymentMethodDepositToAccount)).append("\n");
        sb.append("    paymentStatus: ").append(this.toIndentedString((Object)this.paymentStatus)).append("\n");
        sb.append("    purchaseOrder: ").append(this.toIndentedString(this.purchaseOrder)).append("\n");
        sb.append("    rotatingTransactionGatewayCode: ").append(this.toIndentedString(this.rotatingTransactionGatewayCode)).append("\n");
        sb.append("    surcharge: ").append(this.toIndentedString(this.surcharge)).append("\n");
        sb.append("    surchargeAccountingCode: ").append(this.toIndentedString(this.surchargeAccountingCode)).append("\n");
        sb.append("    surchargeTransactionFee: ").append(this.toIndentedString(this.surchargeTransactionFee)).append("\n");
        sb.append("    surchargeTransactionPercentage: ").append(this.toIndentedString(this.surchargeTransactionPercentage)).append("\n");
        sb.append("    testOrder: ").append(this.toIndentedString(this.testOrder)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PaymentStatusEnum {
        UNPROCESSED("Unprocessed"),
        AUTHORIZED("Authorized"),
        CAPTURE_FAILED("Capture Failed"),
        PROCESSED("Processed"),
        DECLINED("Declined"),
        VOIDED("Voided"),
        REFUNDED("Refunded"),
        SKIPPED("Skipped");

        private String value;

        private PaymentStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PaymentStatusEnum fromValue(String text) {
            for (PaymentStatusEnum b : PaymentStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PaymentStatusEnum> {
            public void write(JsonWriter jsonWriter, PaymentStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PaymentStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PaymentStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PaymentMethodEnum {
        AFFIRM("Affirm"),
        AMAZON("Amazon"),
        AMAZON_SC("Amazon SC"),
        CASH("Cash"),
        CHECK("Check"),
        COD("COD"),
        CREDIT_CARD("Credit Card"),
        EBAY("eBay"),
        ECHECK("eCheck"),
        GOOGLE_SHOPPING("Google Shopping"),
        INSURANCE("Insurance"),
        LOANHERO("LoanHero"),
        MONEY_ORDER("Money Order"),
        PAYPAL("PayPal"),
        PURCHASE_ORDER("Purchase Order"),
        QUOTE_REQUEST("Quote Request"),
        UNKNOWN("Unknown"),
        WIRE_TRANSFER("Wire Transfer"),
        WALMART("Walmart");

        private String value;

        private PaymentMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PaymentMethodEnum fromValue(String text) {
            for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PaymentMethodEnum> {
            public void write(JsonWriter jsonWriter, PaymentMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PaymentMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PaymentMethodEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

