/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.Currency;
import com.ultracart.admin.v2.models.Distance;
import com.ultracart.admin.v2.models.OrderItemEdi;
import com.ultracart.admin.v2.models.OrderItemOption;
import com.ultracart.admin.v2.models.OrderItemProperty;
import com.ultracart.admin.v2.models.OrderItemTag;
import com.ultracart.admin.v2.models.Weight;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrderItem {
    @SerializedName(value="accounting_code")
    private String accountingCode = null;
    @SerializedName(value="activation_codes")
    private List<String> activationCodes = null;
    @SerializedName(value="arbitrary_unit_cost")
    private Currency arbitraryUnitCost = null;
    @SerializedName(value="auto_order_last_rebill_dts")
    private String autoOrderLastRebillDts = null;
    @SerializedName(value="auto_order_schedule")
    private String autoOrderSchedule = null;
    @SerializedName(value="barcode")
    private String barcode = null;
    @SerializedName(value="channel_partner_item_id")
    private String channelPartnerItemId = null;
    @SerializedName(value="cogs")
    private BigDecimal cogs = null;
    @SerializedName(value="component_unit_value")
    private BigDecimal componentUnitValue = null;
    @SerializedName(value="cost")
    private Currency cost = null;
    @SerializedName(value="country_code_of_origin")
    private String countryCodeOfOrigin = null;
    @SerializedName(value="customs_description")
    private String customsDescription = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="discount")
    private Currency discount = null;
    @SerializedName(value="discount_quantity")
    private BigDecimal discountQuantity = null;
    @SerializedName(value="discount_shipping_weight")
    private Weight discountShippingWeight = null;
    @SerializedName(value="distribution_center_code")
    private String distributionCenterCode = null;
    @SerializedName(value="edi")
    private OrderItemEdi edi = null;
    @SerializedName(value="exclude_coupon")
    private Boolean excludeCoupon = null;
    @SerializedName(value="free_shipping")
    private Boolean freeShipping = null;
    @SerializedName(value="hazmat")
    private Boolean hazmat = null;
    @SerializedName(value="height")
    private Distance height = null;
    @SerializedName(value="item_reference_oid")
    private Integer itemReferenceOid = null;
    @SerializedName(value="kit")
    private Boolean kit = null;
    @SerializedName(value="kit_component")
    private Boolean kitComponent = null;
    @SerializedName(value="length")
    private Distance length = null;
    @SerializedName(value="manufacturer_sku")
    private String manufacturerSku = null;
    @SerializedName(value="max_days_time_in_transit")
    private Integer maxDaysTimeInTransit = null;
    @SerializedName(value="merchant_item_id")
    private String merchantItemId = null;
    @SerializedName(value="mix_and_match_group_name")
    private String mixAndMatchGroupName = null;
    @SerializedName(value="mix_and_match_group_oid")
    private Integer mixAndMatchGroupOid = null;
    @SerializedName(value="no_shipping_discount")
    private Boolean noShippingDiscount = null;
    @SerializedName(value="options")
    private List<OrderItemOption> options = null;
    @SerializedName(value="packed_by_user")
    private String packedByUser = null;
    @SerializedName(value="perishable_class")
    private String perishableClass = null;
    @SerializedName(value="pricing_tier_name")
    private String pricingTierName = null;
    @SerializedName(value="properties")
    private List<OrderItemProperty> properties = null;
    @SerializedName(value="quantity")
    private BigDecimal quantity = null;
    @SerializedName(value="quantity_refunded")
    private BigDecimal quantityRefunded = null;
    @SerializedName(value="quickbooks_class")
    private String quickbooksClass = null;
    @SerializedName(value="ship_separately")
    private Boolean shipSeparately = null;
    @SerializedName(value="shipped_by_user")
    private String shippedByUser = null;
    @SerializedName(value="shipped_dts")
    private String shippedDts = null;
    @SerializedName(value="shipping_status")
    private String shippingStatus = null;
    @SerializedName(value="special_product_type")
    private String specialProductType = null;
    @SerializedName(value="tags")
    private List<OrderItemTag> tags = null;
    @SerializedName(value="tax_free")
    private Boolean taxFree = null;
    @SerializedName(value="tax_product_type")
    private TaxProductTypeEnum taxProductType = null;
    @SerializedName(value="taxable_cost")
    private Currency taxableCost = null;
    @SerializedName(value="total_cost_with_discount")
    private Currency totalCostWithDiscount = null;
    @SerializedName(value="total_refunded")
    private Currency totalRefunded = null;
    @SerializedName(value="transmitted_to_distribution_center_dts")
    private String transmittedToDistributionCenterDts = null;
    @SerializedName(value="unit_cost_with_discount")
    private Currency unitCostWithDiscount = null;
    @SerializedName(value="upsell")
    private Boolean upsell = null;
    @SerializedName(value="weight")
    private Weight weight = null;
    @SerializedName(value="width")
    private Distance width = null;

    public OrderItem accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @ApiModelProperty(value="QuickBooks code")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public OrderItem activationCodes(List<String> activationCodes) {
        this.activationCodes = activationCodes;
        return this;
    }

    public OrderItem addActivationCodesItem(String activationCodesItem) {
        if (this.activationCodes == null) {
            this.activationCodes = new ArrayList<String>();
        }
        this.activationCodes.add(activationCodesItem);
        return this;
    }

    @ApiModelProperty(value="Activation codes assigned to this item")
    public List<String> getActivationCodes() {
        return this.activationCodes;
    }

    public void setActivationCodes(List<String> activationCodes) {
        this.activationCodes = activationCodes;
    }

    public OrderItem arbitraryUnitCost(Currency arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getArbitraryUnitCost() {
        return this.arbitraryUnitCost;
    }

    public void setArbitraryUnitCost(Currency arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
    }

    public OrderItem autoOrderLastRebillDts(String autoOrderLastRebillDts) {
        this.autoOrderLastRebillDts = autoOrderLastRebillDts;
        return this;
    }

    @ApiModelProperty(value="Date/time of the last rebill, used only during order insert to help project future rebills")
    public String getAutoOrderLastRebillDts() {
        return this.autoOrderLastRebillDts;
    }

    public void setAutoOrderLastRebillDts(String autoOrderLastRebillDts) {
        this.autoOrderLastRebillDts = autoOrderLastRebillDts;
    }

    public OrderItem autoOrderSchedule(String autoOrderSchedule) {
        this.autoOrderSchedule = autoOrderSchedule;
        return this;
    }

    @ApiModelProperty(value="Auto order schedule, used only during inserts supplying the recurring schedule")
    public String getAutoOrderSchedule() {
        return this.autoOrderSchedule;
    }

    public void setAutoOrderSchedule(String autoOrderSchedule) {
        this.autoOrderSchedule = autoOrderSchedule;
    }

    public OrderItem barcode(String barcode) {
        this.barcode = barcode;
        return this;
    }

    @ApiModelProperty(value="Barcode")
    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public OrderItem channelPartnerItemId(String channelPartnerItemId) {
        this.channelPartnerItemId = channelPartnerItemId;
        return this;
    }

    @ApiModelProperty(value="Channel partner item id if this order came through a channel partner and the channel partner item id was mapped to an internal item id")
    public String getChannelPartnerItemId() {
        return this.channelPartnerItemId;
    }

    public void setChannelPartnerItemId(String channelPartnerItemId) {
        this.channelPartnerItemId = channelPartnerItemId;
    }

    public OrderItem cogs(BigDecimal cogs) {
        this.cogs = cogs;
        return this;
    }

    @ApiModelProperty(value="Cost of goods sold")
    public BigDecimal getCogs() {
        return this.cogs;
    }

    public void setCogs(BigDecimal cogs) {
        this.cogs = cogs;
    }

    public OrderItem componentUnitValue(BigDecimal componentUnitValue) {
        this.componentUnitValue = componentUnitValue;
        return this;
    }

    @ApiModelProperty(value="Value of the kit component item")
    public BigDecimal getComponentUnitValue() {
        return this.componentUnitValue;
    }

    public void setComponentUnitValue(BigDecimal componentUnitValue) {
        this.componentUnitValue = componentUnitValue;
    }

    public OrderItem cost(Currency cost) {
        this.cost = cost;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getCost() {
        return this.cost;
    }

    public void setCost(Currency cost) {
        this.cost = cost;
    }

    public OrderItem countryCodeOfOrigin(String countryCodeOfOrigin) {
        this.countryCodeOfOrigin = countryCodeOfOrigin;
        return this;
    }

    @ApiModelProperty(value="Country of origin (ISO-3166 two letter code)")
    public String getCountryCodeOfOrigin() {
        return this.countryCodeOfOrigin;
    }

    public void setCountryCodeOfOrigin(String countryCodeOfOrigin) {
        this.countryCodeOfOrigin = countryCodeOfOrigin;
    }

    public OrderItem customsDescription(String customsDescription) {
        this.customsDescription = customsDescription;
        return this;
    }

    @ApiModelProperty(value="Customs description")
    public String getCustomsDescription() {
        return this.customsDescription;
    }

    public void setCustomsDescription(String customsDescription) {
        this.customsDescription = customsDescription;
    }

    public OrderItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OrderItem discount(Currency discount) {
        this.discount = discount;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getDiscount() {
        return this.discount;
    }

    public void setDiscount(Currency discount) {
        this.discount = discount;
    }

    public OrderItem discountQuantity(BigDecimal discountQuantity) {
        this.discountQuantity = discountQuantity;
        return this;
    }

    @ApiModelProperty(value="Discount quantity")
    public BigDecimal getDiscountQuantity() {
        return this.discountQuantity;
    }

    public void setDiscountQuantity(BigDecimal discountQuantity) {
        this.discountQuantity = discountQuantity;
    }

    public OrderItem discountShippingWeight(Weight discountShippingWeight) {
        this.discountShippingWeight = discountShippingWeight;
        return this;
    }

    @ApiModelProperty(value="")
    public Weight getDiscountShippingWeight() {
        return this.discountShippingWeight;
    }

    public void setDiscountShippingWeight(Weight discountShippingWeight) {
        this.discountShippingWeight = discountShippingWeight;
    }

    public OrderItem distributionCenterCode(String distributionCenterCode) {
        this.distributionCenterCode = distributionCenterCode;
        return this;
    }

    @ApiModelProperty(value="Distribution center code responsible for shipping this item")
    public String getDistributionCenterCode() {
        return this.distributionCenterCode;
    }

    public void setDistributionCenterCode(String distributionCenterCode) {
        this.distributionCenterCode = distributionCenterCode;
    }

    public OrderItem edi(OrderItemEdi edi) {
        this.edi = edi;
        return this;
    }

    @ApiModelProperty(value="")
    public OrderItemEdi getEdi() {
        return this.edi;
    }

    public void setEdi(OrderItemEdi edi) {
        this.edi = edi;
    }

    public OrderItem excludeCoupon(Boolean excludeCoupon) {
        this.excludeCoupon = excludeCoupon;
        return this;
    }

    @ApiModelProperty(value="True if this item is excluded from coupons")
    public Boolean isExcludeCoupon() {
        return this.excludeCoupon;
    }

    public void setExcludeCoupon(Boolean excludeCoupon) {
        this.excludeCoupon = excludeCoupon;
    }

    public OrderItem freeShipping(Boolean freeShipping) {
        this.freeShipping = freeShipping;
        return this;
    }

    @ApiModelProperty(value="True if the item receives free shipping")
    public Boolean isFreeShipping() {
        return this.freeShipping;
    }

    public void setFreeShipping(Boolean freeShipping) {
        this.freeShipping = freeShipping;
    }

    public OrderItem hazmat(Boolean hazmat) {
        this.hazmat = hazmat;
        return this;
    }

    @ApiModelProperty(value="Hazardous materials indicator")
    public Boolean isHazmat() {
        return this.hazmat;
    }

    public void setHazmat(Boolean hazmat) {
        this.hazmat = hazmat;
    }

    public OrderItem height(Distance height) {
        this.height = height;
        return this;
    }

    @ApiModelProperty(value="")
    public Distance getHeight() {
        return this.height;
    }

    public void setHeight(Distance height) {
        this.height = height;
    }

    public OrderItem itemReferenceOid(Integer itemReferenceOid) {
        this.itemReferenceOid = itemReferenceOid;
        return this;
    }

    @ApiModelProperty(value="Item reference object identifier used to linked to auto order item record")
    public Integer getItemReferenceOid() {
        return this.itemReferenceOid;
    }

    public void setItemReferenceOid(Integer itemReferenceOid) {
        this.itemReferenceOid = itemReferenceOid;
    }

    public OrderItem kit(Boolean kit) {
        this.kit = kit;
        return this;
    }

    @ApiModelProperty(value="True if this item is a kit")
    public Boolean isKit() {
        return this.kit;
    }

    public void setKit(Boolean kit) {
        this.kit = kit;
    }

    public OrderItem kitComponent(Boolean kitComponent) {
        this.kitComponent = kitComponent;
        return this;
    }

    @ApiModelProperty(value="True if this item is a kit component")
    public Boolean isKitComponent() {
        return this.kitComponent;
    }

    public void setKitComponent(Boolean kitComponent) {
        this.kitComponent = kitComponent;
    }

    public OrderItem length(Distance length) {
        this.length = length;
        return this;
    }

    @ApiModelProperty(value="")
    public Distance getLength() {
        return this.length;
    }

    public void setLength(Distance length) {
        this.length = length;
    }

    public OrderItem manufacturerSku(String manufacturerSku) {
        this.manufacturerSku = manufacturerSku;
        return this;
    }

    @ApiModelProperty(value="Manufacturer SKU")
    public String getManufacturerSku() {
        return this.manufacturerSku;
    }

    public void setManufacturerSku(String manufacturerSku) {
        this.manufacturerSku = manufacturerSku;
    }

    public OrderItem maxDaysTimeInTransit(Integer maxDaysTimeInTransit) {
        this.maxDaysTimeInTransit = maxDaysTimeInTransit;
        return this;
    }

    @ApiModelProperty(value="Maximum days that the item can be in transit before spoilage (perishable products)")
    public Integer getMaxDaysTimeInTransit() {
        return this.maxDaysTimeInTransit;
    }

    public void setMaxDaysTimeInTransit(Integer maxDaysTimeInTransit) {
        this.maxDaysTimeInTransit = maxDaysTimeInTransit;
    }

    public OrderItem merchantItemId(String merchantItemId) {
        this.merchantItemId = merchantItemId;
        return this;
    }

    @ApiModelProperty(value="Item ID")
    public String getMerchantItemId() {
        return this.merchantItemId;
    }

    public void setMerchantItemId(String merchantItemId) {
        this.merchantItemId = merchantItemId;
    }

    public OrderItem mixAndMatchGroupName(String mixAndMatchGroupName) {
        this.mixAndMatchGroupName = mixAndMatchGroupName;
        return this;
    }

    @ApiModelProperty(value="Mix and match group name")
    public String getMixAndMatchGroupName() {
        return this.mixAndMatchGroupName;
    }

    public void setMixAndMatchGroupName(String mixAndMatchGroupName) {
        this.mixAndMatchGroupName = mixAndMatchGroupName;
    }

    public OrderItem mixAndMatchGroupOid(Integer mixAndMatchGroupOid) {
        this.mixAndMatchGroupOid = mixAndMatchGroupOid;
        return this;
    }

    @ApiModelProperty(value="Mix and match group object identifier")
    public Integer getMixAndMatchGroupOid() {
        return this.mixAndMatchGroupOid;
    }

    public void setMixAndMatchGroupOid(Integer mixAndMatchGroupOid) {
        this.mixAndMatchGroupOid = mixAndMatchGroupOid;
    }

    public OrderItem noShippingDiscount(Boolean noShippingDiscount) {
        this.noShippingDiscount = noShippingDiscount;
        return this;
    }

    @ApiModelProperty(value="True if this item is excluded from shipping discounts")
    public Boolean isNoShippingDiscount() {
        return this.noShippingDiscount;
    }

    public void setNoShippingDiscount(Boolean noShippingDiscount) {
        this.noShippingDiscount = noShippingDiscount;
    }

    public OrderItem options(List<OrderItemOption> options) {
        this.options = options;
        return this;
    }

    public OrderItem addOptionsItem(OrderItemOption optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<OrderItemOption>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="Options")
    public List<OrderItemOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<OrderItemOption> options) {
        this.options = options;
    }

    public OrderItem packedByUser(String packedByUser) {
        this.packedByUser = packedByUser;
        return this;
    }

    @ApiModelProperty(value="Packed by user")
    public String getPackedByUser() {
        return this.packedByUser;
    }

    public void setPackedByUser(String packedByUser) {
        this.packedByUser = packedByUser;
    }

    public OrderItem perishableClass(String perishableClass) {
        this.perishableClass = perishableClass;
        return this;
    }

    @ApiModelProperty(value="Perishable class of the item")
    public String getPerishableClass() {
        return this.perishableClass;
    }

    public void setPerishableClass(String perishableClass) {
        this.perishableClass = perishableClass;
    }

    public OrderItem pricingTierName(String pricingTierName) {
        this.pricingTierName = pricingTierName;
        return this;
    }

    @ApiModelProperty(value="Pricing tier that granted the particular price for this item if the customer profile had pricing tiers assigned")
    public String getPricingTierName() {
        return this.pricingTierName;
    }

    public void setPricingTierName(String pricingTierName) {
        this.pricingTierName = pricingTierName;
    }

    public OrderItem properties(List<OrderItemProperty> properties) {
        this.properties = properties;
        return this;
    }

    public OrderItem addPropertiesItem(OrderItemProperty propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<OrderItemProperty>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Properties")
    public List<OrderItemProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<OrderItemProperty> properties) {
        this.properties = properties;
    }

    public OrderItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="Quantity")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public OrderItem quantityRefunded(BigDecimal quantityRefunded) {
        this.quantityRefunded = quantityRefunded;
        return this;
    }

    @ApiModelProperty(value="Quantity refunded on this item (read only except refund operation)")
    public BigDecimal getQuantityRefunded() {
        return this.quantityRefunded;
    }

    public void setQuantityRefunded(BigDecimal quantityRefunded) {
        this.quantityRefunded = quantityRefunded;
    }

    public OrderItem quickbooksClass(String quickbooksClass) {
        this.quickbooksClass = quickbooksClass;
        return this;
    }

    @ApiModelProperty(value="QuickBooks class")
    public String getQuickbooksClass() {
        return this.quickbooksClass;
    }

    public void setQuickbooksClass(String quickbooksClass) {
        this.quickbooksClass = quickbooksClass;
    }

    public OrderItem shipSeparately(Boolean shipSeparately) {
        this.shipSeparately = shipSeparately;
        return this;
    }

    @ApiModelProperty(value="True if this item ships in a separate box")
    public Boolean isShipSeparately() {
        return this.shipSeparately;
    }

    public void setShipSeparately(Boolean shipSeparately) {
        this.shipSeparately = shipSeparately;
    }

    public OrderItem shippedByUser(String shippedByUser) {
        this.shippedByUser = shippedByUser;
        return this;
    }

    @ApiModelProperty(value="Shipped by user")
    public String getShippedByUser() {
        return this.shippedByUser;
    }

    public void setShippedByUser(String shippedByUser) {
        this.shippedByUser = shippedByUser;
    }

    public OrderItem shippedDts(String shippedDts) {
        this.shippedDts = shippedDts;
        return this;
    }

    @ApiModelProperty(value="Date/time that this item was marked shipped")
    public String getShippedDts() {
        return this.shippedDts;
    }

    public void setShippedDts(String shippedDts) {
        this.shippedDts = shippedDts;
    }

    public OrderItem shippingStatus(String shippingStatus) {
        this.shippingStatus = shippingStatus;
        return this;
    }

    @ApiModelProperty(value="Shipping status for this item.  This is the replacement for the old order level shipping status.")
    public String getShippingStatus() {
        return this.shippingStatus;
    }

    public void setShippingStatus(String shippingStatus) {
        this.shippingStatus = shippingStatus;
    }

    public OrderItem specialProductType(String specialProductType) {
        this.specialProductType = specialProductType;
        return this;
    }

    @ApiModelProperty(value="Special product type (USPS Media Mail)")
    public String getSpecialProductType() {
        return this.specialProductType;
    }

    public void setSpecialProductType(String specialProductType) {
        this.specialProductType = specialProductType;
    }

    public OrderItem tags(List<OrderItemTag> tags) {
        this.tags = tags;
        return this;
    }

    public OrderItem addTagsItem(OrderItemTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<OrderItemTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tags")
    public List<OrderItemTag> getTags() {
        return this.tags;
    }

    public void setTags(List<OrderItemTag> tags) {
        this.tags = tags;
    }

    public OrderItem taxFree(Boolean taxFree) {
        this.taxFree = taxFree;
        return this;
    }

    @ApiModelProperty(value="True if the item is tax free")
    public Boolean isTaxFree() {
        return this.taxFree;
    }

    public void setTaxFree(Boolean taxFree) {
        this.taxFree = taxFree;
    }

    public OrderItem taxProductType(TaxProductTypeEnum taxProductType) {
        this.taxProductType = taxProductType;
        return this;
    }

    @ApiModelProperty(value="Type of product for tax purposes (self or UltraCart Managed taxes)")
    public TaxProductTypeEnum getTaxProductType() {
        return this.taxProductType;
    }

    public void setTaxProductType(TaxProductTypeEnum taxProductType) {
        this.taxProductType = taxProductType;
    }

    public OrderItem taxableCost(Currency taxableCost) {
        this.taxableCost = taxableCost;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getTaxableCost() {
        return this.taxableCost;
    }

    public void setTaxableCost(Currency taxableCost) {
        this.taxableCost = taxableCost;
    }

    public OrderItem totalCostWithDiscount(Currency totalCostWithDiscount) {
        this.totalCostWithDiscount = totalCostWithDiscount;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getTotalCostWithDiscount() {
        return this.totalCostWithDiscount;
    }

    public void setTotalCostWithDiscount(Currency totalCostWithDiscount) {
        this.totalCostWithDiscount = totalCostWithDiscount;
    }

    public OrderItem totalRefunded(Currency totalRefunded) {
        this.totalRefunded = totalRefunded;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getTotalRefunded() {
        return this.totalRefunded;
    }

    public void setTotalRefunded(Currency totalRefunded) {
        this.totalRefunded = totalRefunded;
    }

    public OrderItem transmittedToDistributionCenterDts(String transmittedToDistributionCenterDts) {
        this.transmittedToDistributionCenterDts = transmittedToDistributionCenterDts;
        return this;
    }

    @ApiModelProperty(value="Date/time that this item was transmitted to the distribution center")
    public String getTransmittedToDistributionCenterDts() {
        return this.transmittedToDistributionCenterDts;
    }

    public void setTransmittedToDistributionCenterDts(String transmittedToDistributionCenterDts) {
        this.transmittedToDistributionCenterDts = transmittedToDistributionCenterDts;
    }

    public OrderItem unitCostWithDiscount(Currency unitCostWithDiscount) {
        this.unitCostWithDiscount = unitCostWithDiscount;
        return this;
    }

    @ApiModelProperty(value="")
    public Currency getUnitCostWithDiscount() {
        return this.unitCostWithDiscount;
    }

    public void setUnitCostWithDiscount(Currency unitCostWithDiscount) {
        this.unitCostWithDiscount = unitCostWithDiscount;
    }

    public OrderItem upsell(Boolean upsell) {
        this.upsell = upsell;
        return this;
    }

    @ApiModelProperty(value="True if this item was added to the order as part of an upsell")
    public Boolean isUpsell() {
        return this.upsell;
    }

    public void setUpsell(Boolean upsell) {
        this.upsell = upsell;
    }

    public OrderItem weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @ApiModelProperty(value="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public OrderItem width(Distance width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="")
    public Distance getWidth() {
        return this.width;
    }

    public void setWidth(Distance width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItem orderItem = (OrderItem)o;
        return Objects.equals(this.accountingCode, orderItem.accountingCode) && Objects.equals(this.activationCodes, orderItem.activationCodes) && Objects.equals(this.arbitraryUnitCost, orderItem.arbitraryUnitCost) && Objects.equals(this.autoOrderLastRebillDts, orderItem.autoOrderLastRebillDts) && Objects.equals(this.autoOrderSchedule, orderItem.autoOrderSchedule) && Objects.equals(this.barcode, orderItem.barcode) && Objects.equals(this.channelPartnerItemId, orderItem.channelPartnerItemId) && Objects.equals(this.cogs, orderItem.cogs) && Objects.equals(this.componentUnitValue, orderItem.componentUnitValue) && Objects.equals(this.cost, orderItem.cost) && Objects.equals(this.countryCodeOfOrigin, orderItem.countryCodeOfOrigin) && Objects.equals(this.customsDescription, orderItem.customsDescription) && Objects.equals(this.description, orderItem.description) && Objects.equals(this.discount, orderItem.discount) && Objects.equals(this.discountQuantity, orderItem.discountQuantity) && Objects.equals(this.discountShippingWeight, orderItem.discountShippingWeight) && Objects.equals(this.distributionCenterCode, orderItem.distributionCenterCode) && Objects.equals(this.edi, orderItem.edi) && Objects.equals(this.excludeCoupon, orderItem.excludeCoupon) && Objects.equals(this.freeShipping, orderItem.freeShipping) && Objects.equals(this.hazmat, orderItem.hazmat) && Objects.equals(this.height, orderItem.height) && Objects.equals(this.itemReferenceOid, orderItem.itemReferenceOid) && Objects.equals(this.kit, orderItem.kit) && Objects.equals(this.kitComponent, orderItem.kitComponent) && Objects.equals(this.length, orderItem.length) && Objects.equals(this.manufacturerSku, orderItem.manufacturerSku) && Objects.equals(this.maxDaysTimeInTransit, orderItem.maxDaysTimeInTransit) && Objects.equals(this.merchantItemId, orderItem.merchantItemId) && Objects.equals(this.mixAndMatchGroupName, orderItem.mixAndMatchGroupName) && Objects.equals(this.mixAndMatchGroupOid, orderItem.mixAndMatchGroupOid) && Objects.equals(this.noShippingDiscount, orderItem.noShippingDiscount) && Objects.equals(this.options, orderItem.options) && Objects.equals(this.packedByUser, orderItem.packedByUser) && Objects.equals(this.perishableClass, orderItem.perishableClass) && Objects.equals(this.pricingTierName, orderItem.pricingTierName) && Objects.equals(this.properties, orderItem.properties) && Objects.equals(this.quantity, orderItem.quantity) && Objects.equals(this.quantityRefunded, orderItem.quantityRefunded) && Objects.equals(this.quickbooksClass, orderItem.quickbooksClass) && Objects.equals(this.shipSeparately, orderItem.shipSeparately) && Objects.equals(this.shippedByUser, orderItem.shippedByUser) && Objects.equals(this.shippedDts, orderItem.shippedDts) && Objects.equals(this.shippingStatus, orderItem.shippingStatus) && Objects.equals(this.specialProductType, orderItem.specialProductType) && Objects.equals(this.tags, orderItem.tags) && Objects.equals(this.taxFree, orderItem.taxFree) && Objects.equals((Object)this.taxProductType, (Object)orderItem.taxProductType) && Objects.equals(this.taxableCost, orderItem.taxableCost) && Objects.equals(this.totalCostWithDiscount, orderItem.totalCostWithDiscount) && Objects.equals(this.totalRefunded, orderItem.totalRefunded) && Objects.equals(this.transmittedToDistributionCenterDts, orderItem.transmittedToDistributionCenterDts) && Objects.equals(this.unitCostWithDiscount, orderItem.unitCostWithDiscount) && Objects.equals(this.upsell, orderItem.upsell) && Objects.equals(this.weight, orderItem.weight) && Objects.equals(this.width, orderItem.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountingCode, this.activationCodes, this.arbitraryUnitCost, this.autoOrderLastRebillDts, this.autoOrderSchedule, this.barcode, this.channelPartnerItemId, this.cogs, this.componentUnitValue, this.cost, this.countryCodeOfOrigin, this.customsDescription, this.description, this.discount, this.discountQuantity, this.discountShippingWeight, this.distributionCenterCode, this.edi, this.excludeCoupon, this.freeShipping, this.hazmat, this.height, this.itemReferenceOid, this.kit, this.kitComponent, this.length, this.manufacturerSku, this.maxDaysTimeInTransit, this.merchantItemId, this.mixAndMatchGroupName, this.mixAndMatchGroupOid, this.noShippingDiscount, this.options, this.packedByUser, this.perishableClass, this.pricingTierName, this.properties, this.quantity, this.quantityRefunded, this.quickbooksClass, this.shipSeparately, this.shippedByUser, this.shippedDts, this.shippingStatus, this.specialProductType, this.tags, this.taxFree, this.taxProductType, this.taxableCost, this.totalCostWithDiscount, this.totalRefunded, this.transmittedToDistributionCenterDts, this.unitCostWithDiscount, this.upsell, this.weight, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItem {\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    activationCodes: ").append(this.toIndentedString(this.activationCodes)).append("\n");
        sb.append("    arbitraryUnitCost: ").append(this.toIndentedString(this.arbitraryUnitCost)).append("\n");
        sb.append("    autoOrderLastRebillDts: ").append(this.toIndentedString(this.autoOrderLastRebillDts)).append("\n");
        sb.append("    autoOrderSchedule: ").append(this.toIndentedString(this.autoOrderSchedule)).append("\n");
        sb.append("    barcode: ").append(this.toIndentedString(this.barcode)).append("\n");
        sb.append("    channelPartnerItemId: ").append(this.toIndentedString(this.channelPartnerItemId)).append("\n");
        sb.append("    cogs: ").append(this.toIndentedString(this.cogs)).append("\n");
        sb.append("    componentUnitValue: ").append(this.toIndentedString(this.componentUnitValue)).append("\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    countryCodeOfOrigin: ").append(this.toIndentedString(this.countryCodeOfOrigin)).append("\n");
        sb.append("    customsDescription: ").append(this.toIndentedString(this.customsDescription)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    discount: ").append(this.toIndentedString(this.discount)).append("\n");
        sb.append("    discountQuantity: ").append(this.toIndentedString(this.discountQuantity)).append("\n");
        sb.append("    discountShippingWeight: ").append(this.toIndentedString(this.discountShippingWeight)).append("\n");
        sb.append("    distributionCenterCode: ").append(this.toIndentedString(this.distributionCenterCode)).append("\n");
        sb.append("    edi: ").append(this.toIndentedString(this.edi)).append("\n");
        sb.append("    excludeCoupon: ").append(this.toIndentedString(this.excludeCoupon)).append("\n");
        sb.append("    freeShipping: ").append(this.toIndentedString(this.freeShipping)).append("\n");
        sb.append("    hazmat: ").append(this.toIndentedString(this.hazmat)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    itemReferenceOid: ").append(this.toIndentedString(this.itemReferenceOid)).append("\n");
        sb.append("    kit: ").append(this.toIndentedString(this.kit)).append("\n");
        sb.append("    kitComponent: ").append(this.toIndentedString(this.kitComponent)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    manufacturerSku: ").append(this.toIndentedString(this.manufacturerSku)).append("\n");
        sb.append("    maxDaysTimeInTransit: ").append(this.toIndentedString(this.maxDaysTimeInTransit)).append("\n");
        sb.append("    merchantItemId: ").append(this.toIndentedString(this.merchantItemId)).append("\n");
        sb.append("    mixAndMatchGroupName: ").append(this.toIndentedString(this.mixAndMatchGroupName)).append("\n");
        sb.append("    mixAndMatchGroupOid: ").append(this.toIndentedString(this.mixAndMatchGroupOid)).append("\n");
        sb.append("    noShippingDiscount: ").append(this.toIndentedString(this.noShippingDiscount)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    packedByUser: ").append(this.toIndentedString(this.packedByUser)).append("\n");
        sb.append("    perishableClass: ").append(this.toIndentedString(this.perishableClass)).append("\n");
        sb.append("    pricingTierName: ").append(this.toIndentedString(this.pricingTierName)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    quantityRefunded: ").append(this.toIndentedString(this.quantityRefunded)).append("\n");
        sb.append("    quickbooksClass: ").append(this.toIndentedString(this.quickbooksClass)).append("\n");
        sb.append("    shipSeparately: ").append(this.toIndentedString(this.shipSeparately)).append("\n");
        sb.append("    shippedByUser: ").append(this.toIndentedString(this.shippedByUser)).append("\n");
        sb.append("    shippedDts: ").append(this.toIndentedString(this.shippedDts)).append("\n");
        sb.append("    shippingStatus: ").append(this.toIndentedString(this.shippingStatus)).append("\n");
        sb.append("    specialProductType: ").append(this.toIndentedString(this.specialProductType)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    taxFree: ").append(this.toIndentedString(this.taxFree)).append("\n");
        sb.append("    taxProductType: ").append(this.toIndentedString((Object)this.taxProductType)).append("\n");
        sb.append("    taxableCost: ").append(this.toIndentedString(this.taxableCost)).append("\n");
        sb.append("    totalCostWithDiscount: ").append(this.toIndentedString(this.totalCostWithDiscount)).append("\n");
        sb.append("    totalRefunded: ").append(this.toIndentedString(this.totalRefunded)).append("\n");
        sb.append("    transmittedToDistributionCenterDts: ").append(this.toIndentedString(this.transmittedToDistributionCenterDts)).append("\n");
        sb.append("    unitCostWithDiscount: ").append(this.toIndentedString(this.unitCostWithDiscount)).append("\n");
        sb.append("    upsell: ").append(this.toIndentedString(this.upsell)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxProductTypeEnum {
        EMPTY(""),
        DIGITAL("digital"),
        PHYSICAL("physical"),
        SERVICE("service");

        private String value;

        private TaxProductTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxProductTypeEnum fromValue(String text) {
            for (TaxProductTypeEnum b : TaxProductTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TaxProductTypeEnum> {
            public void write(JsonWriter jsonWriter, TaxProductTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TaxProductTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxProductTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

