/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OrderInternal {
    @SerializedName(value="exported_to_accounting")
    private Boolean exportedToAccounting = null;
    @SerializedName(value="merchant_notes")
    private String merchantNotes = null;
    @SerializedName(value="placed_by_user")
    private String placedByUser = null;
    @SerializedName(value="refund_by_user")
    private String refundByUser = null;
    @SerializedName(value="sales_rep_code")
    private String salesRepCode = null;

    public OrderInternal exportedToAccounting(Boolean exportedToAccounting) {
        this.exportedToAccounting = exportedToAccounting;
        return this;
    }

    @ApiModelProperty(value="True if the order has been exported to QuickBooks. If QuickBooks is not configured, then this will already be true")
    public Boolean isExportedToAccounting() {
        return this.exportedToAccounting;
    }

    public void setExportedToAccounting(Boolean exportedToAccounting) {
        this.exportedToAccounting = exportedToAccounting;
    }

    public OrderInternal merchantNotes(String merchantNotes) {
        this.merchantNotes = merchantNotes;
        return this;
    }

    @ApiModelProperty(value="Merchant notes")
    public String getMerchantNotes() {
        return this.merchantNotes;
    }

    public void setMerchantNotes(String merchantNotes) {
        this.merchantNotes = merchantNotes;
    }

    public OrderInternal placedByUser(String placedByUser) {
        this.placedByUser = placedByUser;
        return this;
    }

    @ApiModelProperty(value="If placed via the BEOE, this is the user that placed the order")
    public String getPlacedByUser() {
        return this.placedByUser;
    }

    public void setPlacedByUser(String placedByUser) {
        this.placedByUser = placedByUser;
    }

    public OrderInternal refundByUser(String refundByUser) {
        this.refundByUser = refundByUser;
        return this;
    }

    @ApiModelProperty(value="User that issued the refund")
    public String getRefundByUser() {
        return this.refundByUser;
    }

    public void setRefundByUser(String refundByUser) {
        this.refundByUser = refundByUser;
    }

    public OrderInternal salesRepCode(String salesRepCode) {
        this.salesRepCode = salesRepCode;
        return this;
    }

    @ApiModelProperty(value="Sales rep code associated with the order")
    public String getSalesRepCode() {
        return this.salesRepCode;
    }

    public void setSalesRepCode(String salesRepCode) {
        this.salesRepCode = salesRepCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderInternal orderInternal = (OrderInternal)o;
        return Objects.equals(this.exportedToAccounting, orderInternal.exportedToAccounting) && Objects.equals(this.merchantNotes, orderInternal.merchantNotes) && Objects.equals(this.placedByUser, orderInternal.placedByUser) && Objects.equals(this.refundByUser, orderInternal.refundByUser) && Objects.equals(this.salesRepCode, orderInternal.salesRepCode);
    }

    public int hashCode() {
        return Objects.hash(this.exportedToAccounting, this.merchantNotes, this.placedByUser, this.refundByUser, this.salesRepCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderInternal {\n");
        sb.append("    exportedToAccounting: ").append(this.toIndentedString(this.exportedToAccounting)).append("\n");
        sb.append("    merchantNotes: ").append(this.toIndentedString(this.merchantNotes)).append("\n");
        sb.append("    placedByUser: ").append(this.toIndentedString(this.placedByUser)).append("\n");
        sb.append("    refundByUser: ").append(this.toIndentedString(this.refundByUser)).append("\n");
        sb.append("    salesRepCode: ").append(this.toIndentedString(this.salesRepCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

