/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

public class OrderFraudScore {
    @SerializedName(value="anonymous_proxy")
    private Boolean anonymousProxy = null;
    @SerializedName(value="bin_match")
    private BinMatchEnum binMatch = null;
    @SerializedName(value="carder_email")
    private Boolean carderEmail = null;
    @SerializedName(value="country_code")
    private String countryCode = null;
    @SerializedName(value="country_match")
    private Boolean countryMatch = null;
    @SerializedName(value="customer_phone_in_billing_location")
    private String customerPhoneInBillingLocation = null;
    @SerializedName(value="distance_km")
    private Integer distanceKm = null;
    @SerializedName(value="free_email")
    private Boolean freeEmail = null;
    @SerializedName(value="high_risk_country")
    private Boolean highRiskCountry = null;
    @SerializedName(value="ip_city")
    private String ipCity = null;
    @SerializedName(value="ip_isp")
    private String ipIsp = null;
    @SerializedName(value="ip_latitude")
    private String ipLatitude = null;
    @SerializedName(value="ip_longitude")
    private String ipLongitude = null;
    @SerializedName(value="ip_org")
    private String ipOrg = null;
    @SerializedName(value="ip_region")
    private String ipRegion = null;
    @SerializedName(value="proxy_score")
    private BigDecimal proxyScore = null;
    @SerializedName(value="score")
    private BigDecimal score = null;
    @SerializedName(value="ship_forwarder")
    private Boolean shipForwarder = null;
    @SerializedName(value="spam_score")
    private BigDecimal spamScore = null;
    @SerializedName(value="transparent_proxy")
    private Boolean transparentProxy = null;

    public OrderFraudScore anonymousProxy(Boolean anonymousProxy) {
        this.anonymousProxy = anonymousProxy;
        return this;
    }

    @ApiModelProperty(value="True if the IP address is a known anonymous proxy server")
    public Boolean isAnonymousProxy() {
        return this.anonymousProxy;
    }

    public void setAnonymousProxy(Boolean anonymousProxy) {
        this.anonymousProxy = anonymousProxy;
    }

    public OrderFraudScore binMatch(BinMatchEnum binMatch) {
        this.binMatch = binMatch;
        return this;
    }

    @ApiModelProperty(value="Whether the BIN (first six digits) matched the country")
    public BinMatchEnum getBinMatch() {
        return this.binMatch;
    }

    public void setBinMatch(BinMatchEnum binMatch) {
        this.binMatch = binMatch;
    }

    public OrderFraudScore carderEmail(Boolean carderEmail) {
        this.carderEmail = carderEmail;
        return this;
    }

    @ApiModelProperty(value="True if the email address belongs to a known credit card fraudster")
    public Boolean isCarderEmail() {
        return this.carderEmail;
    }

    public void setCarderEmail(Boolean carderEmail) {
        this.carderEmail = carderEmail;
    }

    public OrderFraudScore countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="Country code")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public OrderFraudScore countryMatch(Boolean countryMatch) {
        this.countryMatch = countryMatch;
        return this;
    }

    @ApiModelProperty(value="Country code matches BIN country")
    public Boolean isCountryMatch() {
        return this.countryMatch;
    }

    public void setCountryMatch(Boolean countryMatch) {
        this.countryMatch = countryMatch;
    }

    public OrderFraudScore customerPhoneInBillingLocation(String customerPhoneInBillingLocation) {
        this.customerPhoneInBillingLocation = customerPhoneInBillingLocation;
        return this;
    }

    @ApiModelProperty(value="Whether the customer's phone number is located in the area of the billing address")
    public String getCustomerPhoneInBillingLocation() {
        return this.customerPhoneInBillingLocation;
    }

    public void setCustomerPhoneInBillingLocation(String customerPhoneInBillingLocation) {
        this.customerPhoneInBillingLocation = customerPhoneInBillingLocation;
    }

    public OrderFraudScore distanceKm(Integer distanceKm) {
        this.distanceKm = distanceKm;
        return this;
    }

    @ApiModelProperty(value="Distance in kilometers between the IP address and the BIN")
    public Integer getDistanceKm() {
        return this.distanceKm;
    }

    public void setDistanceKm(Integer distanceKm) {
        this.distanceKm = distanceKm;
    }

    public OrderFraudScore freeEmail(Boolean freeEmail) {
        this.freeEmail = freeEmail;
        return this;
    }

    @ApiModelProperty(value="True if the email address is for a free service like gmail.com")
    public Boolean isFreeEmail() {
        return this.freeEmail;
    }

    public void setFreeEmail(Boolean freeEmail) {
        this.freeEmail = freeEmail;
    }

    public OrderFraudScore highRiskCountry(Boolean highRiskCountry) {
        this.highRiskCountry = highRiskCountry;
        return this;
    }

    @ApiModelProperty(value="True if the customer is in a high risk country known for internet fraud")
    public Boolean isHighRiskCountry() {
        return this.highRiskCountry;
    }

    public void setHighRiskCountry(Boolean highRiskCountry) {
        this.highRiskCountry = highRiskCountry;
    }

    public OrderFraudScore ipCity(String ipCity) {
        this.ipCity = ipCity;
        return this;
    }

    @ApiModelProperty(value="City associated with the IP address")
    public String getIpCity() {
        return this.ipCity;
    }

    public void setIpCity(String ipCity) {
        this.ipCity = ipCity;
    }

    public OrderFraudScore ipIsp(String ipIsp) {
        this.ipIsp = ipIsp;
        return this;
    }

    @ApiModelProperty(value="ISP that owns the IP address")
    public String getIpIsp() {
        return this.ipIsp;
    }

    public void setIpIsp(String ipIsp) {
        this.ipIsp = ipIsp;
    }

    public OrderFraudScore ipLatitude(String ipLatitude) {
        this.ipLatitude = ipLatitude;
        return this;
    }

    @ApiModelProperty(value="Approximate latitude associated with the IP address")
    public String getIpLatitude() {
        return this.ipLatitude;
    }

    public void setIpLatitude(String ipLatitude) {
        this.ipLatitude = ipLatitude;
    }

    public OrderFraudScore ipLongitude(String ipLongitude) {
        this.ipLongitude = ipLongitude;
        return this;
    }

    @ApiModelProperty(value="Approximate longitude associated with the IP address")
    public String getIpLongitude() {
        return this.ipLongitude;
    }

    public void setIpLongitude(String ipLongitude) {
        this.ipLongitude = ipLongitude;
    }

    public OrderFraudScore ipOrg(String ipOrg) {
        this.ipOrg = ipOrg;
        return this;
    }

    @ApiModelProperty(value="Organization that owns the IP address")
    public String getIpOrg() {
        return this.ipOrg;
    }

    public void setIpOrg(String ipOrg) {
        this.ipOrg = ipOrg;
    }

    public OrderFraudScore ipRegion(String ipRegion) {
        this.ipRegion = ipRegion;
        return this;
    }

    @ApiModelProperty(value="State/region associated with the IP address")
    public String getIpRegion() {
        return this.ipRegion;
    }

    public void setIpRegion(String ipRegion) {
        this.ipRegion = ipRegion;
    }

    public OrderFraudScore proxyScore(BigDecimal proxyScore) {
        this.proxyScore = proxyScore;
        return this;
    }

    @ApiModelProperty(value="Likelihood of the IP address being a proxy server")
    public BigDecimal getProxyScore() {
        return this.proxyScore;
    }

    public void setProxyScore(BigDecimal proxyScore) {
        this.proxyScore = proxyScore;
    }

    public OrderFraudScore score(BigDecimal score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(value="Overall score.  This is the score that is compared to see if the order is rejected or held for review by the fraud filter rules.")
    public BigDecimal getScore() {
        return this.score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public OrderFraudScore shipForwarder(Boolean shipForwarder) {
        this.shipForwarder = shipForwarder;
        return this;
    }

    @ApiModelProperty(value="True if the address is a known ship forwarding company")
    public Boolean isShipForwarder() {
        return this.shipForwarder;
    }

    public void setShipForwarder(Boolean shipForwarder) {
        this.shipForwarder = shipForwarder;
    }

    public OrderFraudScore spamScore(BigDecimal spamScore) {
        this.spamScore = spamScore;
        return this;
    }

    @ApiModelProperty(value="Likelihood of the email address being associated with a spammer")
    public BigDecimal getSpamScore() {
        return this.spamScore;
    }

    public void setSpamScore(BigDecimal spamScore) {
        this.spamScore = spamScore;
    }

    public OrderFraudScore transparentProxy(Boolean transparentProxy) {
        this.transparentProxy = transparentProxy;
        return this;
    }

    @ApiModelProperty(value="True if the IP address that placed the order is a transparent proxy server")
    public Boolean isTransparentProxy() {
        return this.transparentProxy;
    }

    public void setTransparentProxy(Boolean transparentProxy) {
        this.transparentProxy = transparentProxy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderFraudScore orderFraudScore = (OrderFraudScore)o;
        return Objects.equals(this.anonymousProxy, orderFraudScore.anonymousProxy) && Objects.equals((Object)this.binMatch, (Object)orderFraudScore.binMatch) && Objects.equals(this.carderEmail, orderFraudScore.carderEmail) && Objects.equals(this.countryCode, orderFraudScore.countryCode) && Objects.equals(this.countryMatch, orderFraudScore.countryMatch) && Objects.equals(this.customerPhoneInBillingLocation, orderFraudScore.customerPhoneInBillingLocation) && Objects.equals(this.distanceKm, orderFraudScore.distanceKm) && Objects.equals(this.freeEmail, orderFraudScore.freeEmail) && Objects.equals(this.highRiskCountry, orderFraudScore.highRiskCountry) && Objects.equals(this.ipCity, orderFraudScore.ipCity) && Objects.equals(this.ipIsp, orderFraudScore.ipIsp) && Objects.equals(this.ipLatitude, orderFraudScore.ipLatitude) && Objects.equals(this.ipLongitude, orderFraudScore.ipLongitude) && Objects.equals(this.ipOrg, orderFraudScore.ipOrg) && Objects.equals(this.ipRegion, orderFraudScore.ipRegion) && Objects.equals(this.proxyScore, orderFraudScore.proxyScore) && Objects.equals(this.score, orderFraudScore.score) && Objects.equals(this.shipForwarder, orderFraudScore.shipForwarder) && Objects.equals(this.spamScore, orderFraudScore.spamScore) && Objects.equals(this.transparentProxy, orderFraudScore.transparentProxy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.anonymousProxy, this.binMatch, this.carderEmail, this.countryCode, this.countryMatch, this.customerPhoneInBillingLocation, this.distanceKm, this.freeEmail, this.highRiskCountry, this.ipCity, this.ipIsp, this.ipLatitude, this.ipLongitude, this.ipOrg, this.ipRegion, this.proxyScore, this.score, this.shipForwarder, this.spamScore, this.transparentProxy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderFraudScore {\n");
        sb.append("    anonymousProxy: ").append(this.toIndentedString(this.anonymousProxy)).append("\n");
        sb.append("    binMatch: ").append(this.toIndentedString((Object)this.binMatch)).append("\n");
        sb.append("    carderEmail: ").append(this.toIndentedString(this.carderEmail)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    countryMatch: ").append(this.toIndentedString(this.countryMatch)).append("\n");
        sb.append("    customerPhoneInBillingLocation: ").append(this.toIndentedString(this.customerPhoneInBillingLocation)).append("\n");
        sb.append("    distanceKm: ").append(this.toIndentedString(this.distanceKm)).append("\n");
        sb.append("    freeEmail: ").append(this.toIndentedString(this.freeEmail)).append("\n");
        sb.append("    highRiskCountry: ").append(this.toIndentedString(this.highRiskCountry)).append("\n");
        sb.append("    ipCity: ").append(this.toIndentedString(this.ipCity)).append("\n");
        sb.append("    ipIsp: ").append(this.toIndentedString(this.ipIsp)).append("\n");
        sb.append("    ipLatitude: ").append(this.toIndentedString(this.ipLatitude)).append("\n");
        sb.append("    ipLongitude: ").append(this.toIndentedString(this.ipLongitude)).append("\n");
        sb.append("    ipOrg: ").append(this.toIndentedString(this.ipOrg)).append("\n");
        sb.append("    ipRegion: ").append(this.toIndentedString(this.ipRegion)).append("\n");
        sb.append("    proxyScore: ").append(this.toIndentedString(this.proxyScore)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    shipForwarder: ").append(this.toIndentedString(this.shipForwarder)).append("\n");
        sb.append("    spamScore: ").append(this.toIndentedString(this.spamScore)).append("\n");
        sb.append("    transparentProxy: ").append(this.toIndentedString(this.transparentProxy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BinMatchEnum {
        NA("NA"),
        NO("No"),
        NOTFOUND("NotFound"),
        YES("Yes");

        private String value;

        private BinMatchEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BinMatchEnum fromValue(String text) {
            for (BinMatchEnum b : BinMatchEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BinMatchEnum> {
            public void write(JsonWriter jsonWriter, BinMatchEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BinMatchEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BinMatchEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

