/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.OrderDigitalItem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrderDigitalOrder {
    @SerializedName(value="creation_dts")
    private String creationDts = null;
    @SerializedName(value="expiration_dts")
    private String expirationDts = null;
    @SerializedName(value="items")
    private List<OrderDigitalItem> items = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="url_id")
    private String urlId = null;

    public OrderDigitalOrder creationDts(String creationDts) {
        this.creationDts = creationDts;
        return this;
    }

    @ApiModelProperty(value="Date/time that the digital order was created")
    public String getCreationDts() {
        return this.creationDts;
    }

    public void setCreationDts(String creationDts) {
        this.creationDts = creationDts;
    }

    public OrderDigitalOrder expirationDts(String expirationDts) {
        this.expirationDts = expirationDts;
        return this;
    }

    @ApiModelProperty(value="Expiration date/time of the digital order")
    public String getExpirationDts() {
        return this.expirationDts;
    }

    public void setExpirationDts(String expirationDts) {
        this.expirationDts = expirationDts;
    }

    public OrderDigitalOrder items(List<OrderDigitalItem> items) {
        this.items = items;
        return this;
    }

    public OrderDigitalOrder addItemsItem(OrderDigitalItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<OrderDigitalItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="Digital items associated with the digital order")
    public List<OrderDigitalItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderDigitalItem> items) {
        this.items = items;
    }

    public OrderDigitalOrder url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL where the customer can go to and download their digital order content")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public OrderDigitalOrder urlId(String urlId) {
        this.urlId = urlId;
        return this;
    }

    @ApiModelProperty(value="URL ID is a unique code that is part of the URLs")
    public String getUrlId() {
        return this.urlId;
    }

    public void setUrlId(String urlId) {
        this.urlId = urlId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderDigitalOrder orderDigitalOrder = (OrderDigitalOrder)o;
        return Objects.equals(this.creationDts, orderDigitalOrder.creationDts) && Objects.equals(this.expirationDts, orderDigitalOrder.expirationDts) && Objects.equals(this.items, orderDigitalOrder.items) && Objects.equals(this.url, orderDigitalOrder.url) && Objects.equals(this.urlId, orderDigitalOrder.urlId);
    }

    public int hashCode() {
        return Objects.hash(this.creationDts, this.expirationDts, this.items, this.url, this.urlId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderDigitalOrder {\n");
        sb.append("    creationDts: ").append(this.toIndentedString(this.creationDts)).append("\n");
        sb.append("    expirationDts: ").append(this.toIndentedString(this.expirationDts)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    urlId: ").append(this.toIndentedString(this.urlId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

