/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class OrderCoupon {
    @SerializedName(value="accounting_code")
    private String accountingCode = null;
    @SerializedName(value="automatically_applied")
    private Boolean automaticallyApplied = null;
    @SerializedName(value="base_coupon_code")
    private String baseCouponCode = null;
    @SerializedName(value="coupon_code")
    private String couponCode = null;
    @SerializedName(value="hdie_from_customer")
    private Boolean hdieFromCustomer = null;

    public OrderCoupon accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @ApiModelProperty(value="QuickBooks accounting code for this coupon")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public OrderCoupon automaticallyApplied(Boolean automaticallyApplied) {
        this.automaticallyApplied = automaticallyApplied;
        return this;
    }

    @ApiModelProperty(value="Whether or not the coupon was automatically applied to the order")
    public Boolean isAutomaticallyApplied() {
        return this.automaticallyApplied;
    }

    public void setAutomaticallyApplied(Boolean automaticallyApplied) {
        this.automaticallyApplied = automaticallyApplied;
    }

    public OrderCoupon baseCouponCode(String baseCouponCode) {
        this.baseCouponCode = baseCouponCode;
        return this;
    }

    @ApiModelProperty(value="Coupon code configured by the merchant.  Will differ if the customer used a one time coupon code generated off this base coupon")
    public String getBaseCouponCode() {
        return this.baseCouponCode;
    }

    public void setBaseCouponCode(String baseCouponCode) {
        this.baseCouponCode = baseCouponCode;
    }

    public OrderCoupon couponCode(String couponCode) {
        this.couponCode = couponCode;
        return this;
    }

    @ApiModelProperty(value="Coupon code entered by the customer")
    public String getCouponCode() {
        return this.couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public OrderCoupon hdieFromCustomer(Boolean hdieFromCustomer) {
        this.hdieFromCustomer = hdieFromCustomer;
        return this;
    }

    @ApiModelProperty(value="True if this coupon is hidde from the customer")
    public Boolean isHdieFromCustomer() {
        return this.hdieFromCustomer;
    }

    public void setHdieFromCustomer(Boolean hdieFromCustomer) {
        this.hdieFromCustomer = hdieFromCustomer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderCoupon orderCoupon = (OrderCoupon)o;
        return Objects.equals(this.accountingCode, orderCoupon.accountingCode) && Objects.equals(this.automaticallyApplied, orderCoupon.automaticallyApplied) && Objects.equals(this.baseCouponCode, orderCoupon.baseCouponCode) && Objects.equals(this.couponCode, orderCoupon.couponCode) && Objects.equals(this.hdieFromCustomer, orderCoupon.hdieFromCustomer);
    }

    public int hashCode() {
        return Objects.hash(this.accountingCode, this.automaticallyApplied, this.baseCouponCode, this.couponCode, this.hdieFromCustomer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderCoupon {\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    automaticallyApplied: ").append(this.toIndentedString(this.automaticallyApplied)).append("\n");
        sb.append("    baseCouponCode: ").append(this.toIndentedString(this.baseCouponCode)).append("\n");
        sb.append("    couponCode: ").append(this.toIndentedString(this.couponCode)).append("\n");
        sb.append("    hdieFromCustomer: ").append(this.toIndentedString(this.hdieFromCustomer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

