/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.AutoOrderItem;
import com.ultracart.admin.v2.models.Order;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrderAutoOrder {
    @SerializedName(value="auto_order_code")
    private String autoOrderCode = null;
    @SerializedName(value="auto_order_oid")
    private Integer autoOrderOid = null;
    @SerializedName(value="cancel_after_next_x_orders")
    private Integer cancelAfterNextXOrders = null;
    @SerializedName(value="cancel_downgrade")
    private Boolean cancelDowngrade = null;
    @SerializedName(value="cancel_reason")
    private String cancelReason = null;
    @SerializedName(value="cancel_upgrade")
    private Boolean cancelUpgrade = null;
    @SerializedName(value="canceled_by_user")
    private String canceledByUser = null;
    @SerializedName(value="canceled_dts")
    private String canceledDts = null;
    @SerializedName(value="completed")
    private Boolean completed = null;
    @SerializedName(value="credit_card_attempt")
    private Integer creditCardAttempt = null;
    @SerializedName(value="disabled_dts")
    private String disabledDts = null;
    @SerializedName(value="enabled")
    private Boolean enabled = null;
    @SerializedName(value="failure_reason")
    private String failureReason = null;
    @SerializedName(value="items")
    private List<AutoOrderItem> items = null;
    @SerializedName(value="next_attempt")
    private String nextAttempt = null;
    @SerializedName(value="original_order_id")
    private String originalOrderId = null;
    @SerializedName(value="override_affiliate_id")
    private Integer overrideAffiliateId = null;
    @SerializedName(value="rebill_orders")
    private List<Order> rebillOrders = null;
    @SerializedName(value="rotating_transaction_gateway_code")
    private String rotatingTransactionGatewayCode = null;
    @SerializedName(value="status")
    private StatusEnum status = null;

    public OrderAutoOrder autoOrderCode(String autoOrderCode) {
        this.autoOrderCode = autoOrderCode;
        return this;
    }

    @ApiModelProperty(value="Unique code assigned to this auto order")
    public String getAutoOrderCode() {
        return this.autoOrderCode;
    }

    public void setAutoOrderCode(String autoOrderCode) {
        this.autoOrderCode = autoOrderCode;
    }

    public OrderAutoOrder autoOrderOid(Integer autoOrderOid) {
        this.autoOrderOid = autoOrderOid;
        return this;
    }

    @ApiModelProperty(value="Auto order object identifier")
    public Integer getAutoOrderOid() {
        return this.autoOrderOid;
    }

    public void setAutoOrderOid(Integer autoOrderOid) {
        this.autoOrderOid = autoOrderOid;
    }

    public OrderAutoOrder cancelAfterNextXOrders(Integer cancelAfterNextXOrders) {
        this.cancelAfterNextXOrders = cancelAfterNextXOrders;
        return this;
    }

    @ApiModelProperty(value="Cancel this auto order after X additional rebills")
    public Integer getCancelAfterNextXOrders() {
        return this.cancelAfterNextXOrders;
    }

    public void setCancelAfterNextXOrders(Integer cancelAfterNextXOrders) {
        this.cancelAfterNextXOrders = cancelAfterNextXOrders;
    }

    public OrderAutoOrder cancelDowngrade(Boolean cancelDowngrade) {
        this.cancelDowngrade = cancelDowngrade;
        return this;
    }

    @ApiModelProperty(value="True if the auto order was canceled because the customer purchased a downgrade item")
    public Boolean isCancelDowngrade() {
        return this.cancelDowngrade;
    }

    public void setCancelDowngrade(Boolean cancelDowngrade) {
        this.cancelDowngrade = cancelDowngrade;
    }

    public OrderAutoOrder cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @ApiModelProperty(value="The reason this auto order was canceled by either merchant or customer")
    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public OrderAutoOrder cancelUpgrade(Boolean cancelUpgrade) {
        this.cancelUpgrade = cancelUpgrade;
        return this;
    }

    @ApiModelProperty(value="True if the auto order was canceled because the customer purchased an upgrade item")
    public Boolean isCancelUpgrade() {
        return this.cancelUpgrade;
    }

    public void setCancelUpgrade(Boolean cancelUpgrade) {
        this.cancelUpgrade = cancelUpgrade;
    }

    public OrderAutoOrder canceledByUser(String canceledByUser) {
        this.canceledByUser = canceledByUser;
        return this;
    }

    @ApiModelProperty(value="The user that canceled the auto order")
    public String getCanceledByUser() {
        return this.canceledByUser;
    }

    public void setCanceledByUser(String canceledByUser) {
        this.canceledByUser = canceledByUser;
    }

    public OrderAutoOrder canceledDts(String canceledDts) {
        this.canceledDts = canceledDts;
        return this;
    }

    @ApiModelProperty(value="The date/time that the auto order was canceled")
    public String getCanceledDts() {
        return this.canceledDts;
    }

    public void setCanceledDts(String canceledDts) {
        this.canceledDts = canceledDts;
    }

    public OrderAutoOrder completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @ApiModelProperty(value="True if the auto order ran successfully to completion")
    public Boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public OrderAutoOrder creditCardAttempt(Integer creditCardAttempt) {
        this.creditCardAttempt = creditCardAttempt;
        return this;
    }

    @ApiModelProperty(value="The number of credit card attempts that have taken place")
    public Integer getCreditCardAttempt() {
        return this.creditCardAttempt;
    }

    public void setCreditCardAttempt(Integer creditCardAttempt) {
        this.creditCardAttempt = creditCardAttempt;
    }

    public OrderAutoOrder disabledDts(String disabledDts) {
        this.disabledDts = disabledDts;
        return this;
    }

    @ApiModelProperty(value="The date/time the auto order was disabled due to failed rebills")
    public String getDisabledDts() {
        return this.disabledDts;
    }

    public void setDisabledDts(String disabledDts) {
        this.disabledDts = disabledDts;
    }

    public OrderAutoOrder enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="True if this auto order is enabled")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public OrderAutoOrder failureReason(String failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @ApiModelProperty(value="The reason this auto order failed during the last rebill attempt")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public OrderAutoOrder items(List<AutoOrderItem> items) {
        this.items = items;
        return this;
    }

    public OrderAutoOrder addItemsItem(AutoOrderItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<AutoOrderItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="The items that are setup to rebill")
    public List<AutoOrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<AutoOrderItem> items) {
        this.items = items;
    }

    public OrderAutoOrder nextAttempt(String nextAttempt) {
        this.nextAttempt = nextAttempt;
        return this;
    }

    @ApiModelProperty(value="The next time that the auto order will be attempted for processing")
    public String getNextAttempt() {
        return this.nextAttempt;
    }

    public void setNextAttempt(String nextAttempt) {
        this.nextAttempt = nextAttempt;
    }

    public OrderAutoOrder originalOrderId(String originalOrderId) {
        this.originalOrderId = originalOrderId;
        return this;
    }

    @ApiModelProperty(value="The original order id that this auto order is associated with.")
    public String getOriginalOrderId() {
        return this.originalOrderId;
    }

    public void setOriginalOrderId(String originalOrderId) {
        this.originalOrderId = originalOrderId;
    }

    public OrderAutoOrder overrideAffiliateId(Integer overrideAffiliateId) {
        this.overrideAffiliateId = overrideAffiliateId;
        return this;
    }

    @ApiModelProperty(value="Override the affiliate id given credit for rebills of this auto order")
    public Integer getOverrideAffiliateId() {
        return this.overrideAffiliateId;
    }

    public void setOverrideAffiliateId(Integer overrideAffiliateId) {
        this.overrideAffiliateId = overrideAffiliateId;
    }

    public OrderAutoOrder rebillOrders(List<Order> rebillOrders) {
        this.rebillOrders = rebillOrders;
        return this;
    }

    public OrderAutoOrder addRebillOrdersItem(Order rebillOrdersItem) {
        if (this.rebillOrders == null) {
            this.rebillOrders = new ArrayList<Order>();
        }
        this.rebillOrders.add(rebillOrdersItem);
        return this;
    }

    @ApiModelProperty(value="Rebill orders that have taken place on this auto order")
    public List<Order> getRebillOrders() {
        return this.rebillOrders;
    }

    public void setRebillOrders(List<Order> rebillOrders) {
        this.rebillOrders = rebillOrders;
    }

    public OrderAutoOrder rotatingTransactionGatewayCode(String rotatingTransactionGatewayCode) {
        this.rotatingTransactionGatewayCode = rotatingTransactionGatewayCode;
        return this;
    }

    @ApiModelProperty(value="The RTG code associated with this order for future rebills")
    public String getRotatingTransactionGatewayCode() {
        return this.rotatingTransactionGatewayCode;
    }

    public void setRotatingTransactionGatewayCode(String rotatingTransactionGatewayCode) {
        this.rotatingTransactionGatewayCode = rotatingTransactionGatewayCode;
    }

    public OrderAutoOrder status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the auto order")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderAutoOrder orderAutoOrder = (OrderAutoOrder)o;
        return Objects.equals(this.autoOrderCode, orderAutoOrder.autoOrderCode) && Objects.equals(this.autoOrderOid, orderAutoOrder.autoOrderOid) && Objects.equals(this.cancelAfterNextXOrders, orderAutoOrder.cancelAfterNextXOrders) && Objects.equals(this.cancelDowngrade, orderAutoOrder.cancelDowngrade) && Objects.equals(this.cancelReason, orderAutoOrder.cancelReason) && Objects.equals(this.cancelUpgrade, orderAutoOrder.cancelUpgrade) && Objects.equals(this.canceledByUser, orderAutoOrder.canceledByUser) && Objects.equals(this.canceledDts, orderAutoOrder.canceledDts) && Objects.equals(this.completed, orderAutoOrder.completed) && Objects.equals(this.creditCardAttempt, orderAutoOrder.creditCardAttempt) && Objects.equals(this.disabledDts, orderAutoOrder.disabledDts) && Objects.equals(this.enabled, orderAutoOrder.enabled) && Objects.equals(this.failureReason, orderAutoOrder.failureReason) && Objects.equals(this.items, orderAutoOrder.items) && Objects.equals(this.nextAttempt, orderAutoOrder.nextAttempt) && Objects.equals(this.originalOrderId, orderAutoOrder.originalOrderId) && Objects.equals(this.overrideAffiliateId, orderAutoOrder.overrideAffiliateId) && Objects.equals(this.rebillOrders, orderAutoOrder.rebillOrders) && Objects.equals(this.rotatingTransactionGatewayCode, orderAutoOrder.rotatingTransactionGatewayCode) && Objects.equals((Object)this.status, (Object)orderAutoOrder.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoOrderCode, this.autoOrderOid, this.cancelAfterNextXOrders, this.cancelDowngrade, this.cancelReason, this.cancelUpgrade, this.canceledByUser, this.canceledDts, this.completed, this.creditCardAttempt, this.disabledDts, this.enabled, this.failureReason, this.items, this.nextAttempt, this.originalOrderId, this.overrideAffiliateId, this.rebillOrders, this.rotatingTransactionGatewayCode, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderAutoOrder {\n");
        sb.append("    autoOrderCode: ").append(this.toIndentedString(this.autoOrderCode)).append("\n");
        sb.append("    autoOrderOid: ").append(this.toIndentedString(this.autoOrderOid)).append("\n");
        sb.append("    cancelAfterNextXOrders: ").append(this.toIndentedString(this.cancelAfterNextXOrders)).append("\n");
        sb.append("    cancelDowngrade: ").append(this.toIndentedString(this.cancelDowngrade)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    cancelUpgrade: ").append(this.toIndentedString(this.cancelUpgrade)).append("\n");
        sb.append("    canceledByUser: ").append(this.toIndentedString(this.canceledByUser)).append("\n");
        sb.append("    canceledDts: ").append(this.toIndentedString(this.canceledDts)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    creditCardAttempt: ").append(this.toIndentedString(this.creditCardAttempt)).append("\n");
        sb.append("    disabledDts: ").append(this.toIndentedString(this.disabledDts)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    nextAttempt: ").append(this.toIndentedString(this.nextAttempt)).append("\n");
        sb.append("    originalOrderId: ").append(this.toIndentedString(this.originalOrderId)).append("\n");
        sb.append("    overrideAffiliateId: ").append(this.toIndentedString(this.overrideAffiliateId)).append("\n");
        sb.append("    rebillOrders: ").append(this.toIndentedString(this.rebillOrders)).append("\n");
        sb.append("    rotatingTransactionGatewayCode: ").append(this.toIndentedString(this.rotatingTransactionGatewayCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        CANCELED("canceled"),
        DISABLED("disabled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

