/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

public class OrderAffiliateLedger {
    @SerializedName(value="assigned_by_user")
    private String assignedByUser = null;
    @SerializedName(value="item_id")
    private String itemId = null;
    @SerializedName(value="tier_number")
    private Integer tierNumber = null;
    @SerializedName(value="transaction_amount")
    private BigDecimal transactionAmount = null;
    @SerializedName(value="transaction_amount_paid")
    private BigDecimal transactionAmountPaid = null;
    @SerializedName(value="transaction_dts")
    private String transactionDts = null;
    @SerializedName(value="transaction_memo")
    private String transactionMemo = null;
    @SerializedName(value="transaction_percentage")
    private BigDecimal transactionPercentage = null;
    @SerializedName(value="transaction_state")
    private TransactionStateEnum transactionState = null;

    public OrderAffiliateLedger assignedByUser(String assignedByUser) {
        this.assignedByUser = assignedByUser;
        return this;
    }

    @ApiModelProperty(value="UltraCart user name that assigned this commission if manually assigned")
    public String getAssignedByUser() {
        return this.assignedByUser;
    }

    public void setAssignedByUser(String assignedByUser) {
        this.assignedByUser = assignedByUser;
    }

    public OrderAffiliateLedger itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(value="Item ID that this ledger record is associated with")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public OrderAffiliateLedger tierNumber(Integer tierNumber) {
        this.tierNumber = tierNumber;
        return this;
    }

    @ApiModelProperty(value="Tier number of this affiliate in the commission calculation")
    public Integer getTierNumber() {
        return this.tierNumber;
    }

    public void setTierNumber(Integer tierNumber) {
        this.tierNumber = tierNumber;
    }

    public OrderAffiliateLedger transactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @ApiModelProperty(value="Amount of the transaction")
    public BigDecimal getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public OrderAffiliateLedger transactionAmountPaid(BigDecimal transactionAmountPaid) {
        this.transactionAmountPaid = transactionAmountPaid;
        return this;
    }

    @ApiModelProperty(value="The amount that has been paid so far on the transaction")
    public BigDecimal getTransactionAmountPaid() {
        return this.transactionAmountPaid;
    }

    public void setTransactionAmountPaid(BigDecimal transactionAmountPaid) {
        this.transactionAmountPaid = transactionAmountPaid;
    }

    public OrderAffiliateLedger transactionDts(String transactionDts) {
        this.transactionDts = transactionDts;
        return this;
    }

    @ApiModelProperty(value="The date/time that the affiliate ledger was generated for the transaction")
    public String getTransactionDts() {
        return this.transactionDts;
    }

    public void setTransactionDts(String transactionDts) {
        this.transactionDts = transactionDts;
    }

    public OrderAffiliateLedger transactionMemo(String transactionMemo) {
        this.transactionMemo = transactionMemo;
        return this;
    }

    @ApiModelProperty(value="Details of the transaction suitable for display to the affiliate")
    public String getTransactionMemo() {
        return this.transactionMemo;
    }

    public void setTransactionMemo(String transactionMemo) {
        this.transactionMemo = transactionMemo;
    }

    public OrderAffiliateLedger transactionPercentage(BigDecimal transactionPercentage) {
        this.transactionPercentage = transactionPercentage;
        return this;
    }

    @ApiModelProperty(value="The percentage earned on the transaction")
    public BigDecimal getTransactionPercentage() {
        return this.transactionPercentage;
    }

    public void setTransactionPercentage(BigDecimal transactionPercentage) {
        this.transactionPercentage = transactionPercentage;
    }

    public OrderAffiliateLedger transactionState(TransactionStateEnum transactionState) {
        this.transactionState = transactionState;
        return this;
    }

    @ApiModelProperty(value="The state of the transaction")
    public TransactionStateEnum getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionStateEnum transactionState) {
        this.transactionState = transactionState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderAffiliateLedger orderAffiliateLedger = (OrderAffiliateLedger)o;
        return Objects.equals(this.assignedByUser, orderAffiliateLedger.assignedByUser) && Objects.equals(this.itemId, orderAffiliateLedger.itemId) && Objects.equals(this.tierNumber, orderAffiliateLedger.tierNumber) && Objects.equals(this.transactionAmount, orderAffiliateLedger.transactionAmount) && Objects.equals(this.transactionAmountPaid, orderAffiliateLedger.transactionAmountPaid) && Objects.equals(this.transactionDts, orderAffiliateLedger.transactionDts) && Objects.equals(this.transactionMemo, orderAffiliateLedger.transactionMemo) && Objects.equals(this.transactionPercentage, orderAffiliateLedger.transactionPercentage) && Objects.equals((Object)this.transactionState, (Object)orderAffiliateLedger.transactionState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assignedByUser, this.itemId, this.tierNumber, this.transactionAmount, this.transactionAmountPaid, this.transactionDts, this.transactionMemo, this.transactionPercentage, this.transactionState});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderAffiliateLedger {\n");
        sb.append("    assignedByUser: ").append(this.toIndentedString(this.assignedByUser)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    tierNumber: ").append(this.toIndentedString(this.tierNumber)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("    transactionAmountPaid: ").append(this.toIndentedString(this.transactionAmountPaid)).append("\n");
        sb.append("    transactionDts: ").append(this.toIndentedString(this.transactionDts)).append("\n");
        sb.append("    transactionMemo: ").append(this.toIndentedString(this.transactionMemo)).append("\n");
        sb.append("    transactionPercentage: ").append(this.toIndentedString(this.transactionPercentage)).append("\n");
        sb.append("    transactionState: ").append(this.toIndentedString((Object)this.transactionState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TransactionStateEnum {
        PENDING("Pending"),
        POSTED("Posted"),
        APPROVED("Approved"),
        PAID("Paid"),
        REJECTED("Rejected"),
        PARTIALLY_PAID("Partially Paid");

        private String value;

        private TransactionStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TransactionStateEnum fromValue(String text) {
            for (TransactionStateEnum b : TransactionStateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TransactionStateEnum> {
            public void write(JsonWriter jsonWriter, TransactionStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TransactionStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TransactionStateEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

