/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class OauthTokenResponse {
    @SerializedName(value="access_token")
    private String accessToken = null;
    @SerializedName(value="error")
    private String error = null;
    @SerializedName(value="error_description")
    private String errorDescription = null;
    @SerializedName(value="error_uri")
    private String errorUri = null;
    @SerializedName(value="expires_in")
    private String expiresIn = null;
    @SerializedName(value="refresh_token")
    private String refreshToken = null;
    @SerializedName(value="scope")
    private String scope = null;
    @SerializedName(value="token_type")
    private TokenTypeEnum tokenType = null;

    public OauthTokenResponse accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(value="Access token to use in OAuth authenticated API call")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OauthTokenResponse error(String error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(value="")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public OauthTokenResponse errorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    @ApiModelProperty(value="")
    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public OauthTokenResponse errorUri(String errorUri) {
        this.errorUri = errorUri;
        return this;
    }

    @ApiModelProperty(value="")
    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public OauthTokenResponse expiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @ApiModelProperty(value="The number of seconds since issuance when the access token will expire and need to be refreshed using the refresh token")
    public String getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(String expiresIn) {
        this.expiresIn = expiresIn;
    }

    public OauthTokenResponse refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @ApiModelProperty(value="The refresh token that should be used to fetch a new access token when the expiration occurs")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OauthTokenResponse scope(String scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="The scope of permissions associated with teh access token")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public OauthTokenResponse tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @ApiModelProperty(value="Type of token")
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OauthTokenResponse oauthTokenResponse = (OauthTokenResponse)o;
        return Objects.equals(this.accessToken, oauthTokenResponse.accessToken) && Objects.equals(this.error, oauthTokenResponse.error) && Objects.equals(this.errorDescription, oauthTokenResponse.errorDescription) && Objects.equals(this.errorUri, oauthTokenResponse.errorUri) && Objects.equals(this.expiresIn, oauthTokenResponse.expiresIn) && Objects.equals(this.refreshToken, oauthTokenResponse.refreshToken) && Objects.equals(this.scope, oauthTokenResponse.scope) && Objects.equals((Object)this.tokenType, (Object)oauthTokenResponse.tokenType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessToken, this.error, this.errorDescription, this.errorUri, this.expiresIn, this.refreshToken, this.scope, this.tokenType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OauthTokenResponse {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    errorDescription: ").append(this.toIndentedString(this.errorDescription)).append("\n");
        sb.append("    errorUri: ").append(this.toIndentedString(this.errorUri)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenTypeEnum {
        BEARER("bearer");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenTypeEnum fromValue(String text) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TokenTypeEnum> {
            public void write(JsonWriter jsonWriter, TokenTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

