/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

public class LibraryItemQuery {
    @SerializedName(value="category")
    private String category = null;
    @SerializedName(value="content_type")
    private String contentType = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="industry")
    private String industry = null;
    @SerializedName(value="price_high")
    private BigDecimal priceHigh = null;
    @SerializedName(value="price_low")
    private BigDecimal priceLow = null;
    @SerializedName(value="published_dts_begin")
    private String publishedDtsBegin = null;
    @SerializedName(value="published_dts_end")
    private String publishedDtsEnd = null;
    @SerializedName(value="source_of_published")
    private Boolean sourceOfPublished = null;
    @SerializedName(value="style")
    private String style = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="type")
    private String type = null;

    public LibraryItemQuery category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="Category")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public LibraryItemQuery contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(value="Library item content type such as flow, campaign, cjson, email, or transactional_email")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public LibraryItemQuery description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of library item")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LibraryItemQuery industry(String industry) {
        this.industry = industry;
        return this;
    }

    @ApiModelProperty(value="Industry")
    public String getIndustry() {
        return this.industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public LibraryItemQuery priceHigh(BigDecimal priceHigh) {
        this.priceHigh = priceHigh;
        return this;
    }

    @ApiModelProperty(value="Maximum price")
    public BigDecimal getPriceHigh() {
        return this.priceHigh;
    }

    public void setPriceHigh(BigDecimal priceHigh) {
        this.priceHigh = priceHigh;
    }

    public LibraryItemQuery priceLow(BigDecimal priceLow) {
        this.priceLow = priceLow;
        return this;
    }

    @ApiModelProperty(value="Minimum price")
    public BigDecimal getPriceLow() {
        return this.priceLow;
    }

    public void setPriceLow(BigDecimal priceLow) {
        this.priceLow = priceLow;
    }

    public LibraryItemQuery publishedDtsBegin(String publishedDtsBegin) {
        this.publishedDtsBegin = publishedDtsBegin;
        return this;
    }

    @ApiModelProperty(value="Minimum published date/time")
    public String getPublishedDtsBegin() {
        return this.publishedDtsBegin;
    }

    public void setPublishedDtsBegin(String publishedDtsBegin) {
        this.publishedDtsBegin = publishedDtsBegin;
    }

    public LibraryItemQuery publishedDtsEnd(String publishedDtsEnd) {
        this.publishedDtsEnd = publishedDtsEnd;
        return this;
    }

    @ApiModelProperty(value="Maximum published date/time")
    public String getPublishedDtsEnd() {
        return this.publishedDtsEnd;
    }

    public void setPublishedDtsEnd(String publishedDtsEnd) {
        this.publishedDtsEnd = publishedDtsEnd;
    }

    public LibraryItemQuery sourceOfPublished(Boolean sourceOfPublished) {
        this.sourceOfPublished = sourceOfPublished;
        return this;
    }

    @ApiModelProperty(value="Boolean, true if this library item has been published and is the master copy of that published work")
    public Boolean isSourceOfPublished() {
        return this.sourceOfPublished;
    }

    public void setSourceOfPublished(Boolean sourceOfPublished) {
        this.sourceOfPublished = sourceOfPublished;
    }

    public LibraryItemQuery style(String style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(value="Library item style")
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public LibraryItemQuery title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Title of the library item")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LibraryItemQuery type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Library item type such as header, footer, shipping block, etc")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryItemQuery libraryItemQuery = (LibraryItemQuery)o;
        return Objects.equals(this.category, libraryItemQuery.category) && Objects.equals(this.contentType, libraryItemQuery.contentType) && Objects.equals(this.description, libraryItemQuery.description) && Objects.equals(this.industry, libraryItemQuery.industry) && Objects.equals(this.priceHigh, libraryItemQuery.priceHigh) && Objects.equals(this.priceLow, libraryItemQuery.priceLow) && Objects.equals(this.publishedDtsBegin, libraryItemQuery.publishedDtsBegin) && Objects.equals(this.publishedDtsEnd, libraryItemQuery.publishedDtsEnd) && Objects.equals(this.sourceOfPublished, libraryItemQuery.sourceOfPublished) && Objects.equals(this.style, libraryItemQuery.style) && Objects.equals(this.title, libraryItemQuery.title) && Objects.equals(this.type, libraryItemQuery.type);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.contentType, this.description, this.industry, this.priceHigh, this.priceLow, this.publishedDtsBegin, this.publishedDtsEnd, this.sourceOfPublished, this.style, this.title, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LibraryItemQuery {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    industry: ").append(this.toIndentedString(this.industry)).append("\n");
        sb.append("    priceHigh: ").append(this.toIndentedString(this.priceHigh)).append("\n");
        sb.append("    priceLow: ").append(this.toIndentedString(this.priceLow)).append("\n");
        sb.append("    publishedDtsBegin: ").append(this.toIndentedString(this.publishedDtsBegin)).append("\n");
        sb.append("    publishedDtsEnd: ").append(this.toIndentedString(this.publishedDtsEnd)).append("\n");
        sb.append("    sourceOfPublished: ").append(this.toIndentedString(this.sourceOfPublished)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

