/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.LibraryItemAccount;
import com.ultracart.admin.v2.models.LibraryItemAsset;
import com.ultracart.admin.v2.models.LibraryItemAttribute;
import com.ultracart.admin.v2.models.LibraryItemEmail;
import com.ultracart.admin.v2.models.LibraryItemPublishedMeta;
import com.ultracart.admin.v2.models.LibraryItemPurchasedMeta;
import com.ultracart.admin.v2.models.LibraryItemScreenshot;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LibraryItem {
    @SerializedName(value="assets")
    private List<LibraryItemAsset> assets = null;
    @SerializedName(value="attributes")
    private List<LibraryItemAttribute> attributes = null;
    @SerializedName(value="categories")
    private List<String> categories = null;
    @SerializedName(value="content")
    private String content = null;
    @SerializedName(value="content_type")
    private String contentType = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="industries")
    private List<String> industries = null;
    @SerializedName(value="library_item_oid")
    private Integer libraryItemOid = null;
    @SerializedName(value="merchant_id")
    private String merchantId = null;
    @SerializedName(value="my_purchased_version")
    private Integer myPurchasedVersion = null;
    @SerializedName(value="original_object_id")
    private String originalObjectId = null;
    @SerializedName(value="price")
    private BigDecimal price = null;
    @SerializedName(value="price_formatted")
    private String priceFormatted = null;
    @SerializedName(value="published")
    private Boolean published = null;
    @SerializedName(value="published_dts")
    private Object publishedDts = null;
    @SerializedName(value="published_from_library_item_oid")
    private Integer publishedFromLibraryItemOid = null;
    @SerializedName(value="published_meta")
    private LibraryItemPublishedMeta publishedMeta = null;
    @SerializedName(value="published_version")
    private Integer publishedVersion = null;
    @SerializedName(value="purchased")
    private Boolean purchased = null;
    @SerializedName(value="purchased_from_library_item_oid")
    private Integer purchasedFromLibraryItemOid = null;
    @SerializedName(value="purchased_meta")
    private LibraryItemPurchasedMeta purchasedMeta = null;
    @SerializedName(value="purchased_version")
    private Integer purchasedVersion = null;
    @SerializedName(value="rejected")
    private Boolean rejected = null;
    @SerializedName(value="rejected_reason")
    private String rejectedReason = null;
    @SerializedName(value="release_notes")
    private String releaseNotes = null;
    @SerializedName(value="release_version")
    private Integer releaseVersion = null;
    @SerializedName(value="reviewed")
    private Boolean reviewed = null;
    @SerializedName(value="reviewed_dts")
    private Object reviewedDts = null;
    @SerializedName(value="screenshots")
    private List<LibraryItemScreenshot> screenshots = null;
    @SerializedName(value="share_with_accounts")
    private List<LibraryItemAccount> shareWithAccounts = null;
    @SerializedName(value="share_with_other_emails")
    private List<LibraryItemEmail> shareWithOtherEmails = null;
    @SerializedName(value="shared")
    private Boolean shared = null;
    @SerializedName(value="source")
    private Boolean source = null;
    @SerializedName(value="source_to_library_item_oid")
    private Integer sourceToLibraryItemOid = null;
    @SerializedName(value="source_version")
    private Integer sourceVersion = null;
    @SerializedName(value="style")
    private String style = null;
    @SerializedName(value="times_purchased")
    private Integer timesPurchased = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="under_review")
    private Boolean underReview = null;

    public LibraryItem assets(List<LibraryItemAsset> assets) {
        this.assets = assets;
        return this;
    }

    public LibraryItem addAssetsItem(LibraryItemAsset assetsItem) {
        if (this.assets == null) {
            this.assets = new ArrayList<LibraryItemAsset>();
        }
        this.assets.add(assetsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LibraryItemAsset> getAssets() {
        return this.assets;
    }

    public void setAssets(List<LibraryItemAsset> assets) {
        this.assets = assets;
    }

    public LibraryItem attributes(List<LibraryItemAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public LibraryItem addAttributesItem(LibraryItemAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<LibraryItemAttribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LibraryItemAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<LibraryItemAttribute> attributes) {
        this.attributes = attributes;
    }

    public LibraryItem categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public LibraryItem addCategoriesItem(String categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public LibraryItem content(String content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LibraryItem contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(value="")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public LibraryItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LibraryItem industries(List<String> industries) {
        this.industries = industries;
        return this;
    }

    public LibraryItem addIndustriesItem(String industriesItem) {
        if (this.industries == null) {
            this.industries = new ArrayList<String>();
        }
        this.industries.add(industriesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getIndustries() {
        return this.industries;
    }

    public void setIndustries(List<String> industries) {
        this.industries = industries;
    }

    public LibraryItem libraryItemOid(Integer libraryItemOid) {
        this.libraryItemOid = libraryItemOid;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getLibraryItemOid() {
        return this.libraryItemOid;
    }

    public void setLibraryItemOid(Integer libraryItemOid) {
        this.libraryItemOid = libraryItemOid;
    }

    public LibraryItem merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public LibraryItem myPurchasedVersion(Integer myPurchasedVersion) {
        this.myPurchasedVersion = myPurchasedVersion;
        return this;
    }

    @ApiModelProperty(value="If this is a public item and the merchant has already purchased it, this is their version.  If not yet purchased, this will be zero.  This value will only be populated during a searchPublicItems() call.")
    public Integer getMyPurchasedVersion() {
        return this.myPurchasedVersion;
    }

    public void setMyPurchasedVersion(Integer myPurchasedVersion) {
        this.myPurchasedVersion = myPurchasedVersion;
    }

    public LibraryItem originalObjectId(String originalObjectId) {
        this.originalObjectId = originalObjectId;
        return this;
    }

    @ApiModelProperty(value="This id points to the original object that was added to the library. For flows and campaigns, this is a uuid string.  For upsells, it is an oid integer.  For transactional_emails, it is an email name.")
    public String getOriginalObjectId() {
        return this.originalObjectId;
    }

    public void setOriginalObjectId(String originalObjectId) {
        this.originalObjectId = originalObjectId;
    }

    public LibraryItem price(BigDecimal price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(value="The price of the published item.  Null for any private library items.")
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public LibraryItem priceFormatted(String priceFormatted) {
        this.priceFormatted = priceFormatted;
        return this;
    }

    @ApiModelProperty(value="The formatted price of the published item.  Null for any private library items.")
    public String getPriceFormatted() {
        return this.priceFormatted;
    }

    public void setPriceFormatted(String priceFormatted) {
        this.priceFormatted = priceFormatted;
    }

    public LibraryItem published(Boolean published) {
        this.published = published;
        return this;
    }

    @ApiModelProperty(value="True if this library item is a published item (not source)")
    public Boolean isPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public LibraryItem publishedDts(Object publishedDts) {
        this.publishedDts = publishedDts;
        return this;
    }

    @ApiModelProperty(value="The timestamp of the last published version")
    public Object getPublishedDts() {
        return this.publishedDts;
    }

    public void setPublishedDts(Object publishedDts) {
        this.publishedDts = publishedDts;
    }

    public LibraryItem publishedFromLibraryItemOid(Integer publishedFromLibraryItemOid) {
        this.publishedFromLibraryItemOid = publishedFromLibraryItemOid;
        return this;
    }

    @ApiModelProperty(value="The source item used to publish this item.  This allows for comparisons between source and published")
    public Integer getPublishedFromLibraryItemOid() {
        return this.publishedFromLibraryItemOid;
    }

    public void setPublishedFromLibraryItemOid(Integer publishedFromLibraryItemOid) {
        this.publishedFromLibraryItemOid = publishedFromLibraryItemOid;
    }

    public LibraryItem publishedMeta(LibraryItemPublishedMeta publishedMeta) {
        this.publishedMeta = publishedMeta;
        return this;
    }

    @ApiModelProperty(value="")
    public LibraryItemPublishedMeta getPublishedMeta() {
        return this.publishedMeta;
    }

    public void setPublishedMeta(LibraryItemPublishedMeta publishedMeta) {
        this.publishedMeta = publishedMeta;
    }

    public LibraryItem publishedVersion(Integer publishedVersion) {
        this.publishedVersion = publishedVersion;
        return this;
    }

    @ApiModelProperty(value="The source version when this item was published.  This allows for out-of-date alerts to be shown when there is a difference between source and published")
    public Integer getPublishedVersion() {
        return this.publishedVersion;
    }

    public void setPublishedVersion(Integer publishedVersion) {
        this.publishedVersion = publishedVersion;
    }

    public LibraryItem purchased(Boolean purchased) {
        this.purchased = purchased;
        return this;
    }

    @ApiModelProperty(value="True if this library item has been purchased")
    public Boolean isPurchased() {
        return this.purchased;
    }

    public void setPurchased(Boolean purchased) {
        this.purchased = purchased;
    }

    public LibraryItem purchasedFromLibraryItemOid(Integer purchasedFromLibraryItemOid) {
        this.purchasedFromLibraryItemOid = purchasedFromLibraryItemOid;
        return this;
    }

    @ApiModelProperty(value="The published item that was purchased to make this item.  This allows for comparisons between published and purchased")
    public Integer getPurchasedFromLibraryItemOid() {
        return this.purchasedFromLibraryItemOid;
    }

    public void setPurchasedFromLibraryItemOid(Integer purchasedFromLibraryItemOid) {
        this.purchasedFromLibraryItemOid = purchasedFromLibraryItemOid;
    }

    public LibraryItem purchasedMeta(LibraryItemPurchasedMeta purchasedMeta) {
        this.purchasedMeta = purchasedMeta;
        return this;
    }

    @ApiModelProperty(value="")
    public LibraryItemPurchasedMeta getPurchasedMeta() {
        return this.purchasedMeta;
    }

    public void setPurchasedMeta(LibraryItemPurchasedMeta purchasedMeta) {
        this.purchasedMeta = purchasedMeta;
    }

    public LibraryItem purchasedVersion(Integer purchasedVersion) {
        this.purchasedVersion = purchasedVersion;
        return this;
    }

    @ApiModelProperty(value="The published version when this item was purchased.  This allows for out-of-date alerts to be shown when there is a difference between published and purchased")
    public Integer getPurchasedVersion() {
        return this.purchasedVersion;
    }

    public void setPurchasedVersion(Integer purchasedVersion) {
        this.purchasedVersion = purchasedVersion;
    }

    public LibraryItem rejected(Boolean rejected) {
        this.rejected = rejected;
        return this;
    }

    @ApiModelProperty(value="Any published library reviewed by UltraCart staff for malicious or inappropriate content will have this flag set to true.  This is always false for non-published items")
    public Boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(Boolean rejected) {
        this.rejected = rejected;
    }

    public LibraryItem rejectedReason(String rejectedReason) {
        this.rejectedReason = rejectedReason;
        return this;
    }

    @ApiModelProperty(value="Any rejected published item will have this field populated with the reason.")
    public String getRejectedReason() {
        return this.rejectedReason;
    }

    public void setRejectedReason(String rejectedReason) {
        this.rejectedReason = rejectedReason;
    }

    public LibraryItem releaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
        return this;
    }

    @ApiModelProperty(value="Release notes specific to each published version and only appearing on public items.")
    public String getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public LibraryItem releaseVersion(Integer releaseVersion) {
        this.releaseVersion = releaseVersion;
        return this;
    }

    @ApiModelProperty(value="This counter records how many times a library item has been published.  This is used to show version history.")
    public Integer getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(Integer releaseVersion) {
        this.releaseVersion = releaseVersion;
    }

    public LibraryItem reviewed(Boolean reviewed) {
        this.reviewed = reviewed;
        return this;
    }

    @ApiModelProperty(value="Any published library items must be reviewed by UltraCart staff for malicious content.  This flag shows the status of that review.  This is always false for non-published items")
    public Boolean isReviewed() {
        return this.reviewed;
    }

    public void setReviewed(Boolean reviewed) {
        this.reviewed = reviewed;
    }

    public LibraryItem reviewedDts(Object reviewedDts) {
        this.reviewedDts = reviewedDts;
        return this;
    }

    @ApiModelProperty(value="This is the timestamp for a published items formal review by UltraCart staff for malicious content.")
    public Object getReviewedDts() {
        return this.reviewedDts;
    }

    public void setReviewedDts(Object reviewedDts) {
        this.reviewedDts = reviewedDts;
    }

    public LibraryItem screenshots(List<LibraryItemScreenshot> screenshots) {
        this.screenshots = screenshots;
        return this;
    }

    public LibraryItem addScreenshotsItem(LibraryItemScreenshot screenshotsItem) {
        if (this.screenshots == null) {
            this.screenshots = new ArrayList<LibraryItemScreenshot>();
        }
        this.screenshots.add(screenshotsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LibraryItemScreenshot> getScreenshots() {
        return this.screenshots;
    }

    public void setScreenshots(List<LibraryItemScreenshot> screenshots) {
        this.screenshots = screenshots;
    }

    public LibraryItem shareWithAccounts(List<LibraryItemAccount> shareWithAccounts) {
        this.shareWithAccounts = shareWithAccounts;
        return this;
    }

    public LibraryItem addShareWithAccountsItem(LibraryItemAccount shareWithAccountsItem) {
        if (this.shareWithAccounts == null) {
            this.shareWithAccounts = new ArrayList<LibraryItemAccount>();
        }
        this.shareWithAccounts.add(shareWithAccountsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LibraryItemAccount> getShareWithAccounts() {
        return this.shareWithAccounts;
    }

    public void setShareWithAccounts(List<LibraryItemAccount> shareWithAccounts) {
        this.shareWithAccounts = shareWithAccounts;
    }

    public LibraryItem shareWithOtherEmails(List<LibraryItemEmail> shareWithOtherEmails) {
        this.shareWithOtherEmails = shareWithOtherEmails;
        return this;
    }

    public LibraryItem addShareWithOtherEmailsItem(LibraryItemEmail shareWithOtherEmailsItem) {
        if (this.shareWithOtherEmails == null) {
            this.shareWithOtherEmails = new ArrayList<LibraryItemEmail>();
        }
        this.shareWithOtherEmails.add(shareWithOtherEmailsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LibraryItemEmail> getShareWithOtherEmails() {
        return this.shareWithOtherEmails;
    }

    public void setShareWithOtherEmails(List<LibraryItemEmail> shareWithOtherEmails) {
        this.shareWithOtherEmails = shareWithOtherEmails;
    }

    public LibraryItem shared(Boolean shared) {
        this.shared = shared;
        return this;
    }

    @ApiModelProperty(value="True if this item is shared from another merchant account")
    public Boolean isShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public LibraryItem source(Boolean source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="True if this library item has been published")
    public Boolean isSource() {
        return this.source;
    }

    public void setSource(Boolean source) {
        this.source = source;
    }

    public LibraryItem sourceToLibraryItemOid(Integer sourceToLibraryItemOid) {
        this.sourceToLibraryItemOid = sourceToLibraryItemOid;
        return this;
    }

    @ApiModelProperty(value="This oid points to the published library item, if there is one.")
    public Integer getSourceToLibraryItemOid() {
        return this.sourceToLibraryItemOid;
    }

    public void setSourceToLibraryItemOid(Integer sourceToLibraryItemOid) {
        this.sourceToLibraryItemOid = sourceToLibraryItemOid;
    }

    public LibraryItem sourceVersion(Integer sourceVersion) {
        this.sourceVersion = sourceVersion;
        return this;
    }

    @ApiModelProperty(value="The version of this item.  Increment every time the item is saved.")
    public Integer getSourceVersion() {
        return this.sourceVersion;
    }

    public void setSourceVersion(Integer sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public LibraryItem style(String style) {
        this.style = style;
        return this;
    }

    @ApiModelProperty(value="")
    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public LibraryItem timesPurchased(Integer timesPurchased) {
        this.timesPurchased = timesPurchased;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getTimesPurchased() {
        return this.timesPurchased;
    }

    public void setTimesPurchased(Integer timesPurchased) {
        this.timesPurchased = timesPurchased;
    }

    public LibraryItem title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LibraryItem type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LibraryItem underReview(Boolean underReview) {
        this.underReview = underReview;
        return this;
    }

    @ApiModelProperty(value="True if this library item was published but is awaiting review from UltraCart staff.")
    public Boolean isUnderReview() {
        return this.underReview;
    }

    public void setUnderReview(Boolean underReview) {
        this.underReview = underReview;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryItem libraryItem = (LibraryItem)o;
        return Objects.equals(this.assets, libraryItem.assets) && Objects.equals(this.attributes, libraryItem.attributes) && Objects.equals(this.categories, libraryItem.categories) && Objects.equals(this.content, libraryItem.content) && Objects.equals(this.contentType, libraryItem.contentType) && Objects.equals(this.description, libraryItem.description) && Objects.equals(this.industries, libraryItem.industries) && Objects.equals(this.libraryItemOid, libraryItem.libraryItemOid) && Objects.equals(this.merchantId, libraryItem.merchantId) && Objects.equals(this.myPurchasedVersion, libraryItem.myPurchasedVersion) && Objects.equals(this.originalObjectId, libraryItem.originalObjectId) && Objects.equals(this.price, libraryItem.price) && Objects.equals(this.priceFormatted, libraryItem.priceFormatted) && Objects.equals(this.published, libraryItem.published) && Objects.equals(this.publishedDts, libraryItem.publishedDts) && Objects.equals(this.publishedFromLibraryItemOid, libraryItem.publishedFromLibraryItemOid) && Objects.equals(this.publishedMeta, libraryItem.publishedMeta) && Objects.equals(this.publishedVersion, libraryItem.publishedVersion) && Objects.equals(this.purchased, libraryItem.purchased) && Objects.equals(this.purchasedFromLibraryItemOid, libraryItem.purchasedFromLibraryItemOid) && Objects.equals(this.purchasedMeta, libraryItem.purchasedMeta) && Objects.equals(this.purchasedVersion, libraryItem.purchasedVersion) && Objects.equals(this.rejected, libraryItem.rejected) && Objects.equals(this.rejectedReason, libraryItem.rejectedReason) && Objects.equals(this.releaseNotes, libraryItem.releaseNotes) && Objects.equals(this.releaseVersion, libraryItem.releaseVersion) && Objects.equals(this.reviewed, libraryItem.reviewed) && Objects.equals(this.reviewedDts, libraryItem.reviewedDts) && Objects.equals(this.screenshots, libraryItem.screenshots) && Objects.equals(this.shareWithAccounts, libraryItem.shareWithAccounts) && Objects.equals(this.shareWithOtherEmails, libraryItem.shareWithOtherEmails) && Objects.equals(this.shared, libraryItem.shared) && Objects.equals(this.source, libraryItem.source) && Objects.equals(this.sourceToLibraryItemOid, libraryItem.sourceToLibraryItemOid) && Objects.equals(this.sourceVersion, libraryItem.sourceVersion) && Objects.equals(this.style, libraryItem.style) && Objects.equals(this.timesPurchased, libraryItem.timesPurchased) && Objects.equals(this.title, libraryItem.title) && Objects.equals(this.type, libraryItem.type) && Objects.equals(this.underReview, libraryItem.underReview);
    }

    public int hashCode() {
        return Objects.hash(this.assets, this.attributes, this.categories, this.content, this.contentType, this.description, this.industries, this.libraryItemOid, this.merchantId, this.myPurchasedVersion, this.originalObjectId, this.price, this.priceFormatted, this.published, this.publishedDts, this.publishedFromLibraryItemOid, this.publishedMeta, this.publishedVersion, this.purchased, this.purchasedFromLibraryItemOid, this.purchasedMeta, this.purchasedVersion, this.rejected, this.rejectedReason, this.releaseNotes, this.releaseVersion, this.reviewed, this.reviewedDts, this.screenshots, this.shareWithAccounts, this.shareWithOtherEmails, this.shared, this.source, this.sourceToLibraryItemOid, this.sourceVersion, this.style, this.timesPurchased, this.title, this.type, this.underReview);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LibraryItem {\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    industries: ").append(this.toIndentedString(this.industries)).append("\n");
        sb.append("    libraryItemOid: ").append(this.toIndentedString(this.libraryItemOid)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    myPurchasedVersion: ").append(this.toIndentedString(this.myPurchasedVersion)).append("\n");
        sb.append("    originalObjectId: ").append(this.toIndentedString(this.originalObjectId)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    priceFormatted: ").append(this.toIndentedString(this.priceFormatted)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    publishedDts: ").append(this.toIndentedString(this.publishedDts)).append("\n");
        sb.append("    publishedFromLibraryItemOid: ").append(this.toIndentedString(this.publishedFromLibraryItemOid)).append("\n");
        sb.append("    publishedMeta: ").append(this.toIndentedString(this.publishedMeta)).append("\n");
        sb.append("    publishedVersion: ").append(this.toIndentedString(this.publishedVersion)).append("\n");
        sb.append("    purchased: ").append(this.toIndentedString(this.purchased)).append("\n");
        sb.append("    purchasedFromLibraryItemOid: ").append(this.toIndentedString(this.purchasedFromLibraryItemOid)).append("\n");
        sb.append("    purchasedMeta: ").append(this.toIndentedString(this.purchasedMeta)).append("\n");
        sb.append("    purchasedVersion: ").append(this.toIndentedString(this.purchasedVersion)).append("\n");
        sb.append("    rejected: ").append(this.toIndentedString(this.rejected)).append("\n");
        sb.append("    rejectedReason: ").append(this.toIndentedString(this.rejectedReason)).append("\n");
        sb.append("    releaseNotes: ").append(this.toIndentedString(this.releaseNotes)).append("\n");
        sb.append("    releaseVersion: ").append(this.toIndentedString(this.releaseVersion)).append("\n");
        sb.append("    reviewed: ").append(this.toIndentedString(this.reviewed)).append("\n");
        sb.append("    reviewedDts: ").append(this.toIndentedString(this.reviewedDts)).append("\n");
        sb.append("    screenshots: ").append(this.toIndentedString(this.screenshots)).append("\n");
        sb.append("    shareWithAccounts: ").append(this.toIndentedString(this.shareWithAccounts)).append("\n");
        sb.append("    shareWithOtherEmails: ").append(this.toIndentedString(this.shareWithOtherEmails)).append("\n");
        sb.append("    shared: ").append(this.toIndentedString(this.shared)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    sourceToLibraryItemOid: ").append(this.toIndentedString(this.sourceToLibraryItemOid)).append("\n");
        sb.append("    sourceVersion: ").append(this.toIndentedString(this.sourceVersion)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    timesPurchased: ").append(this.toIndentedString(this.timesPurchased)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    underReview: ").append(this.toIndentedString(this.underReview)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

