/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.ItemTaxExemption;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ItemTax {
    @SerializedName(value="exemptions")
    private List<ItemTaxExemption> exemptions = null;
    @SerializedName(value="tax_free")
    private Boolean taxFree = null;
    @SerializedName(value="tax_product_type")
    private TaxProductTypeEnum taxProductType = null;
    @SerializedName(value="taxable_cost")
    private BigDecimal taxableCost = null;

    public ItemTax exemptions(List<ItemTaxExemption> exemptions) {
        this.exemptions = exemptions;
        return this;
    }

    public ItemTax addExemptionsItem(ItemTaxExemption exemptionsItem) {
        if (this.exemptions == null) {
            this.exemptions = new ArrayList<ItemTaxExemption>();
        }
        this.exemptions.add(exemptionsItem);
        return this;
    }

    @ApiModelProperty(value="Exemptions")
    public List<ItemTaxExemption> getExemptions() {
        return this.exemptions;
    }

    public void setExemptions(List<ItemTaxExemption> exemptions) {
        this.exemptions = exemptions;
    }

    public ItemTax taxFree(Boolean taxFree) {
        this.taxFree = taxFree;
        return this;
    }

    @ApiModelProperty(value="True if tax free")
    public Boolean isTaxFree() {
        return this.taxFree;
    }

    public void setTaxFree(Boolean taxFree) {
        this.taxFree = taxFree;
    }

    public ItemTax taxProductType(TaxProductTypeEnum taxProductType) {
        this.taxProductType = taxProductType;
        return this;
    }

    @ApiModelProperty(value="Tax product type")
    public TaxProductTypeEnum getTaxProductType() {
        return this.taxProductType;
    }

    public void setTaxProductType(TaxProductTypeEnum taxProductType) {
        this.taxProductType = taxProductType;
    }

    public ItemTax taxableCost(BigDecimal taxableCost) {
        this.taxableCost = taxableCost;
        return this;
    }

    @ApiModelProperty(value="Taxable cost if different than regular cost")
    public BigDecimal getTaxableCost() {
        return this.taxableCost;
    }

    public void setTaxableCost(BigDecimal taxableCost) {
        this.taxableCost = taxableCost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemTax itemTax = (ItemTax)o;
        return Objects.equals(this.exemptions, itemTax.exemptions) && Objects.equals(this.taxFree, itemTax.taxFree) && Objects.equals((Object)this.taxProductType, (Object)itemTax.taxProductType) && Objects.equals(this.taxableCost, itemTax.taxableCost);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exemptions, this.taxFree, this.taxProductType, this.taxableCost});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemTax {\n");
        sb.append("    exemptions: ").append(this.toIndentedString(this.exemptions)).append("\n");
        sb.append("    taxFree: ").append(this.toIndentedString(this.taxFree)).append("\n");
        sb.append("    taxProductType: ").append(this.toIndentedString((Object)this.taxProductType)).append("\n");
        sb.append("    taxableCost: ").append(this.toIndentedString(this.taxableCost)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxProductTypeEnum {
        EMPTY(""),
        DIGITAL("digital"),
        PHYSICAL("physical"),
        SERVICE("service");

        private String value;

        private TaxProductTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxProductTypeEnum fromValue(String text) {
            for (TaxProductTypeEnum b : TaxProductTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TaxProductTypeEnum> {
            public void write(JsonWriter jsonWriter, TaxProductTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TaxProductTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxProductTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

