/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.ItemAutoOrderStepArbitraryUnitCostSchedule;
import com.ultracart.admin.v2.models.ItemAutoOrderStepGrandfatherPricing;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ItemAutoOrderStep {
    @SerializedName(value="arbitrary_schedule_days")
    private Integer arbitraryScheduleDays = null;
    @SerializedName(value="arbitrary_unit_cost")
    private BigDecimal arbitraryUnitCost = null;
    @SerializedName(value="arbitrary_unit_cost_schedules")
    private List<ItemAutoOrderStepArbitraryUnitCostSchedule> arbitraryUnitCostSchedules = null;
    @SerializedName(value="grandfather_pricing")
    private List<ItemAutoOrderStepGrandfatherPricing> grandfatherPricing = null;
    @SerializedName(value="managed_by")
    private String managedBy = null;
    @SerializedName(value="pause_days")
    private Integer pauseDays = null;
    @SerializedName(value="pause_until_date")
    private String pauseUntilDate = null;
    @SerializedName(value="preshipment_notice_days")
    private Integer preshipmentNoticeDays = null;
    @SerializedName(value="recurring_merchant_item_id")
    private String recurringMerchantItemId = null;
    @SerializedName(value="recurring_merchant_item_oid")
    private Integer recurringMerchantItemOid = null;
    @SerializedName(value="repeat_count")
    private Integer repeatCount = null;
    @SerializedName(value="schedule")
    private String schedule = null;
    @SerializedName(value="subscribe_email_list_name")
    private String subscribeEmailListName = null;
    @SerializedName(value="subscribe_email_list_oid")
    private Integer subscribeEmailListOid = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public ItemAutoOrderStep arbitraryScheduleDays(Integer arbitraryScheduleDays) {
        this.arbitraryScheduleDays = arbitraryScheduleDays;
        return this;
    }

    @ApiModelProperty(value="If the schedule is arbitrary, then this is the number of days")
    public Integer getArbitraryScheduleDays() {
        return this.arbitraryScheduleDays;
    }

    public void setArbitraryScheduleDays(Integer arbitraryScheduleDays) {
        this.arbitraryScheduleDays = arbitraryScheduleDays;
    }

    public ItemAutoOrderStep arbitraryUnitCost(BigDecimal arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
        return this;
    }

    @ApiModelProperty(value="Arbitrary unit cost used to override the regular item cost")
    public BigDecimal getArbitraryUnitCost() {
        return this.arbitraryUnitCost;
    }

    public void setArbitraryUnitCost(BigDecimal arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
    }

    public ItemAutoOrderStep arbitraryUnitCostSchedules(List<ItemAutoOrderStepArbitraryUnitCostSchedule> arbitraryUnitCostSchedules) {
        this.arbitraryUnitCostSchedules = arbitraryUnitCostSchedules;
        return this;
    }

    public ItemAutoOrderStep addArbitraryUnitCostSchedulesItem(ItemAutoOrderStepArbitraryUnitCostSchedule arbitraryUnitCostSchedulesItem) {
        if (this.arbitraryUnitCostSchedules == null) {
            this.arbitraryUnitCostSchedules = new ArrayList<ItemAutoOrderStepArbitraryUnitCostSchedule>();
        }
        this.arbitraryUnitCostSchedules.add(arbitraryUnitCostSchedulesItem);
        return this;
    }

    @ApiModelProperty(value="Arbitrary unit costs schedules for more advanced discounting by rebill attempt")
    public List<ItemAutoOrderStepArbitraryUnitCostSchedule> getArbitraryUnitCostSchedules() {
        return this.arbitraryUnitCostSchedules;
    }

    public void setArbitraryUnitCostSchedules(List<ItemAutoOrderStepArbitraryUnitCostSchedule> arbitraryUnitCostSchedules) {
        this.arbitraryUnitCostSchedules = arbitraryUnitCostSchedules;
    }

    public ItemAutoOrderStep grandfatherPricing(List<ItemAutoOrderStepGrandfatherPricing> grandfatherPricing) {
        this.grandfatherPricing = grandfatherPricing;
        return this;
    }

    public ItemAutoOrderStep addGrandfatherPricingItem(ItemAutoOrderStepGrandfatherPricing grandfatherPricingItem) {
        if (this.grandfatherPricing == null) {
            this.grandfatherPricing = new ArrayList<ItemAutoOrderStepGrandfatherPricing>();
        }
        this.grandfatherPricing.add(grandfatherPricingItem);
        return this;
    }

    @ApiModelProperty(value="Grand-father pricing configuration if the rebill schedule has changed over time")
    public List<ItemAutoOrderStepGrandfatherPricing> getGrandfatherPricing() {
        return this.grandfatherPricing;
    }

    public void setGrandfatherPricing(List<ItemAutoOrderStepGrandfatherPricing> grandfatherPricing) {
        this.grandfatherPricing = grandfatherPricing;
    }

    public ItemAutoOrderStep managedBy(String managedBy) {
        this.managedBy = managedBy;
        return this;
    }

    @ApiModelProperty(value="Managed by (defaults to UltraCart)")
    public String getManagedBy() {
        return this.managedBy;
    }

    public void setManagedBy(String managedBy) {
        this.managedBy = managedBy;
    }

    public ItemAutoOrderStep pauseDays(Integer pauseDays) {
        this.pauseDays = pauseDays;
        return this;
    }

    @ApiModelProperty(value="Number of days to pause")
    public Integer getPauseDays() {
        return this.pauseDays;
    }

    public void setPauseDays(Integer pauseDays) {
        this.pauseDays = pauseDays;
    }

    public ItemAutoOrderStep pauseUntilDate(String pauseUntilDate) {
        this.pauseUntilDate = pauseUntilDate;
        return this;
    }

    @ApiModelProperty(value="Wait for this step to happen until the specified date")
    public String getPauseUntilDate() {
        return this.pauseUntilDate;
    }

    public void setPauseUntilDate(String pauseUntilDate) {
        this.pauseUntilDate = pauseUntilDate;
    }

    public ItemAutoOrderStep preshipmentNoticeDays(Integer preshipmentNoticeDays) {
        this.preshipmentNoticeDays = preshipmentNoticeDays;
        return this;
    }

    @ApiModelProperty(value="If set, a pre-shipment notice is sent to the customer this many days in advance")
    public Integer getPreshipmentNoticeDays() {
        return this.preshipmentNoticeDays;
    }

    public void setPreshipmentNoticeDays(Integer preshipmentNoticeDays) {
        this.preshipmentNoticeDays = preshipmentNoticeDays;
    }

    public ItemAutoOrderStep recurringMerchantItemId(String recurringMerchantItemId) {
        this.recurringMerchantItemId = recurringMerchantItemId;
        return this;
    }

    @ApiModelProperty(value="Item id to rebill")
    public String getRecurringMerchantItemId() {
        return this.recurringMerchantItemId;
    }

    public void setRecurringMerchantItemId(String recurringMerchantItemId) {
        this.recurringMerchantItemId = recurringMerchantItemId;
    }

    public ItemAutoOrderStep recurringMerchantItemOid(Integer recurringMerchantItemOid) {
        this.recurringMerchantItemOid = recurringMerchantItemOid;
        return this;
    }

    @ApiModelProperty(value="Item object identifier to rebill")
    public Integer getRecurringMerchantItemOid() {
        return this.recurringMerchantItemOid;
    }

    public void setRecurringMerchantItemOid(Integer recurringMerchantItemOid) {
        this.recurringMerchantItemOid = recurringMerchantItemOid;
    }

    public ItemAutoOrderStep repeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
        return this;
    }

    @ApiModelProperty(value="Number of times to rebill.  Last step can be null for infinite")
    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public ItemAutoOrderStep schedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(value="Frequency of the rebill")
    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public ItemAutoOrderStep subscribeEmailListName(String subscribeEmailListName) {
        this.subscribeEmailListName = subscribeEmailListName;
        return this;
    }

    @ApiModelProperty(value="Email list name to subscribe the customer to when the rebill occurs")
    public String getSubscribeEmailListName() {
        return this.subscribeEmailListName;
    }

    public void setSubscribeEmailListName(String subscribeEmailListName) {
        this.subscribeEmailListName = subscribeEmailListName;
    }

    public ItemAutoOrderStep subscribeEmailListOid(Integer subscribeEmailListOid) {
        this.subscribeEmailListOid = subscribeEmailListOid;
        return this;
    }

    @ApiModelProperty(value="Email list identifier to subscribe the customer to when this rebill occurs")
    public Integer getSubscribeEmailListOid() {
        return this.subscribeEmailListOid;
    }

    public void setSubscribeEmailListOid(Integer subscribeEmailListOid) {
        this.subscribeEmailListOid = subscribeEmailListOid;
    }

    public ItemAutoOrderStep type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of step (item, kit only, loop or pause)")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemAutoOrderStep itemAutoOrderStep = (ItemAutoOrderStep)o;
        return Objects.equals(this.arbitraryScheduleDays, itemAutoOrderStep.arbitraryScheduleDays) && Objects.equals(this.arbitraryUnitCost, itemAutoOrderStep.arbitraryUnitCost) && Objects.equals(this.arbitraryUnitCostSchedules, itemAutoOrderStep.arbitraryUnitCostSchedules) && Objects.equals(this.grandfatherPricing, itemAutoOrderStep.grandfatherPricing) && Objects.equals(this.managedBy, itemAutoOrderStep.managedBy) && Objects.equals(this.pauseDays, itemAutoOrderStep.pauseDays) && Objects.equals(this.pauseUntilDate, itemAutoOrderStep.pauseUntilDate) && Objects.equals(this.preshipmentNoticeDays, itemAutoOrderStep.preshipmentNoticeDays) && Objects.equals(this.recurringMerchantItemId, itemAutoOrderStep.recurringMerchantItemId) && Objects.equals(this.recurringMerchantItemOid, itemAutoOrderStep.recurringMerchantItemOid) && Objects.equals(this.repeatCount, itemAutoOrderStep.repeatCount) && Objects.equals(this.schedule, itemAutoOrderStep.schedule) && Objects.equals(this.subscribeEmailListName, itemAutoOrderStep.subscribeEmailListName) && Objects.equals(this.subscribeEmailListOid, itemAutoOrderStep.subscribeEmailListOid) && Objects.equals((Object)this.type, (Object)itemAutoOrderStep.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arbitraryScheduleDays, this.arbitraryUnitCost, this.arbitraryUnitCostSchedules, this.grandfatherPricing, this.managedBy, this.pauseDays, this.pauseUntilDate, this.preshipmentNoticeDays, this.recurringMerchantItemId, this.recurringMerchantItemOid, this.repeatCount, this.schedule, this.subscribeEmailListName, this.subscribeEmailListOid, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemAutoOrderStep {\n");
        sb.append("    arbitraryScheduleDays: ").append(this.toIndentedString(this.arbitraryScheduleDays)).append("\n");
        sb.append("    arbitraryUnitCost: ").append(this.toIndentedString(this.arbitraryUnitCost)).append("\n");
        sb.append("    arbitraryUnitCostSchedules: ").append(this.toIndentedString(this.arbitraryUnitCostSchedules)).append("\n");
        sb.append("    grandfatherPricing: ").append(this.toIndentedString(this.grandfatherPricing)).append("\n");
        sb.append("    managedBy: ").append(this.toIndentedString(this.managedBy)).append("\n");
        sb.append("    pauseDays: ").append(this.toIndentedString(this.pauseDays)).append("\n");
        sb.append("    pauseUntilDate: ").append(this.toIndentedString(this.pauseUntilDate)).append("\n");
        sb.append("    preshipmentNoticeDays: ").append(this.toIndentedString(this.preshipmentNoticeDays)).append("\n");
        sb.append("    recurringMerchantItemId: ").append(this.toIndentedString(this.recurringMerchantItemId)).append("\n");
        sb.append("    recurringMerchantItemOid: ").append(this.toIndentedString(this.recurringMerchantItemOid)).append("\n");
        sb.append("    repeatCount: ").append(this.toIndentedString(this.repeatCount)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    subscribeEmailListName: ").append(this.toIndentedString(this.subscribeEmailListName)).append("\n");
        sb.append("    subscribeEmailListOid: ").append(this.toIndentedString(this.subscribeEmailListOid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ITEM("item"),
        PAUSE("pause"),
        LOOP("loop"),
        KIT_ONLY("kit only");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

