/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.GroupUserMembership;
import com.ultracart.admin.v2.models.Notification;
import com.ultracart.admin.v2.models.Permission;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Group {
    @SerializedName(value="group_oid")
    private Integer groupOid = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="notifications")
    private List<Notification> notifications = null;
    @SerializedName(value="permissions")
    private List<Permission> permissions = null;
    @SerializedName(value="users")
    private List<GroupUserMembership> users = null;

    public Group groupOid(Integer groupOid) {
        this.groupOid = groupOid;
        return this;
    }

    @ApiModelProperty(value="The unique object identifier (oid for short) for this group")
    public Integer getGroupOid() {
        return this.groupOid;
    }

    public void setGroupOid(Integer groupOid) {
        this.groupOid = groupOid;
    }

    public Group name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of this group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Group notifications(List<Notification> notifications) {
        this.notifications = notifications;
        return this;
    }

    public Group addNotificationsItem(Notification notificationsItem) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<Notification>();
        }
        this.notifications.add(notificationsItem);
        return this;
    }

    @ApiModelProperty(value="A list of notifications the user receives.")
    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<Notification> notifications) {
        this.notifications = notifications;
    }

    public Group permissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Group addPermissionsItem(Permission permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<Permission>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(value="A list of permissions the user enjoys for accessing the backend of UltraCart.")
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public Group users(List<GroupUserMembership> users) {
        this.users = users;
        return this;
    }

    public Group addUsersItem(GroupUserMembership usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<GroupUserMembership>();
        }
        this.users.add(usersItem);
        return this;
    }

    @ApiModelProperty(value="A list of users that belong to this group.")
    public List<GroupUserMembership> getUsers() {
        return this.users;
    }

    public void setUsers(List<GroupUserMembership> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        return Objects.equals(this.groupOid, group.groupOid) && Objects.equals(this.name, group.name) && Objects.equals(this.notifications, group.notifications) && Objects.equals(this.permissions, group.permissions) && Objects.equals(this.users, group.users);
    }

    public int hashCode() {
        return Objects.hash(this.groupOid, this.name, this.notifications, this.permissions, this.users);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Group {\n");
        sb.append("    groupOid: ").append(this.toIndentedString(this.groupOid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

