/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.GiftCertificateLedgerEntry;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GiftCertificate {
    @SerializedName(value="activated")
    private Boolean activated = null;
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="customer_profile_oid")
    private Integer customerProfileOid = null;
    @SerializedName(value="deleted")
    private Boolean deleted = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="expiration_dts")
    private String expirationDts = null;
    @SerializedName(value="gift_certificate_oid")
    private Integer giftCertificateOid = null;
    @SerializedName(value="internal")
    private Boolean internal = null;
    @SerializedName(value="ledger_entries")
    private List<GiftCertificateLedgerEntry> ledgerEntries = null;
    @SerializedName(value="merchant_id")
    private String merchantId = null;
    @SerializedName(value="merchant_note")
    private String merchantNote = null;
    @SerializedName(value="original_balance")
    private BigDecimal originalBalance = null;
    @SerializedName(value="reference_order_id")
    private String referenceOrderId = null;
    @SerializedName(value="remaining_balance")
    private BigDecimal remainingBalance = null;

    public GiftCertificate activated(Boolean activated) {
        this.activated = activated;
        return this;
    }

    @ApiModelProperty(value="True if this gift certificate is activated and ready to apply to purchases.")
    public Boolean isActivated() {
        return this.activated;
    }

    public void setActivated(Boolean activated) {
        this.activated = activated;
    }

    public GiftCertificate code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="The code used by the customer to purchase against this gift certificate.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public GiftCertificate customerProfileOid(Integer customerProfileOid) {
        this.customerProfileOid = customerProfileOid;
        return this;
    }

    @ApiModelProperty(value="This is the customer profile oid associated with this internally managed gift certificate.")
    public Integer getCustomerProfileOid() {
        return this.customerProfileOid;
    }

    public void setCustomerProfileOid(Integer customerProfileOid) {
        this.customerProfileOid = customerProfileOid;
    }

    public GiftCertificate deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @ApiModelProperty(value="True if this gift certificate was deleted.")
    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public GiftCertificate email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Email of the customer associated with this gift certificate.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public GiftCertificate expirationDts(String expirationDts) {
        this.expirationDts = expirationDts;
        return this;
    }

    @ApiModelProperty(value="Expiration date time.")
    public String getExpirationDts() {
        return this.expirationDts;
    }

    public void setExpirationDts(String expirationDts) {
        this.expirationDts = expirationDts;
    }

    public GiftCertificate giftCertificateOid(Integer giftCertificateOid) {
        this.giftCertificateOid = giftCertificateOid;
        return this;
    }

    @ApiModelProperty(value="Gift certificate oid.")
    public Integer getGiftCertificateOid() {
        return this.giftCertificateOid;
    }

    public void setGiftCertificateOid(Integer giftCertificateOid) {
        this.giftCertificateOid = giftCertificateOid;
    }

    public GiftCertificate internal(Boolean internal) {
        this.internal = internal;
        return this;
    }

    @ApiModelProperty(value="This is an internally managed gift certificate associated with the loyalty cash rewards program.")
    public Boolean isInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public GiftCertificate ledgerEntries(List<GiftCertificateLedgerEntry> ledgerEntries) {
        this.ledgerEntries = ledgerEntries;
        return this;
    }

    public GiftCertificate addLedgerEntriesItem(GiftCertificateLedgerEntry ledgerEntriesItem) {
        if (this.ledgerEntries == null) {
            this.ledgerEntries = new ArrayList<GiftCertificateLedgerEntry>();
        }
        this.ledgerEntries.add(ledgerEntriesItem);
        return this;
    }

    @ApiModelProperty(value="A list of all ledger activity for this gift certificate.")
    public List<GiftCertificateLedgerEntry> getLedgerEntries() {
        return this.ledgerEntries;
    }

    public void setLedgerEntries(List<GiftCertificateLedgerEntry> ledgerEntries) {
        this.ledgerEntries = ledgerEntries;
    }

    public GiftCertificate merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="Merchant Id")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public GiftCertificate merchantNote(String merchantNote) {
        this.merchantNote = merchantNote;
        return this;
    }

    @ApiModelProperty(value="A list of all ledger activity for this gift certificate.")
    public String getMerchantNote() {
        return this.merchantNote;
    }

    public void setMerchantNote(String merchantNote) {
        this.merchantNote = merchantNote;
    }

    public GiftCertificate originalBalance(BigDecimal originalBalance) {
        this.originalBalance = originalBalance;
        return this;
    }

    @ApiModelProperty(value="Original balance of the gift certificate.")
    public BigDecimal getOriginalBalance() {
        return this.originalBalance;
    }

    public void setOriginalBalance(BigDecimal originalBalance) {
        this.originalBalance = originalBalance;
    }

    public GiftCertificate referenceOrderId(String referenceOrderId) {
        this.referenceOrderId = referenceOrderId;
        return this;
    }

    @ApiModelProperty(value="The order used to purchase this gift certificate.  This value is ONLY set during checkout when a certificate is purchased, not when it is used.  Any usage is recorded in the ledger")
    public String getReferenceOrderId() {
        return this.referenceOrderId;
    }

    public void setReferenceOrderId(String referenceOrderId) {
        this.referenceOrderId = referenceOrderId;
    }

    public GiftCertificate remainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
        return this;
    }

    @ApiModelProperty(value="The remaining balance on the gift certificate.  This is never set directly, but calculated from the ledger.  To change the remaining balance, add a ledger entry.")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    public void setRemainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GiftCertificate giftCertificate = (GiftCertificate)o;
        return Objects.equals(this.activated, giftCertificate.activated) && Objects.equals(this.code, giftCertificate.code) && Objects.equals(this.customerProfileOid, giftCertificate.customerProfileOid) && Objects.equals(this.deleted, giftCertificate.deleted) && Objects.equals(this.email, giftCertificate.email) && Objects.equals(this.expirationDts, giftCertificate.expirationDts) && Objects.equals(this.giftCertificateOid, giftCertificate.giftCertificateOid) && Objects.equals(this.internal, giftCertificate.internal) && Objects.equals(this.ledgerEntries, giftCertificate.ledgerEntries) && Objects.equals(this.merchantId, giftCertificate.merchantId) && Objects.equals(this.merchantNote, giftCertificate.merchantNote) && Objects.equals(this.originalBalance, giftCertificate.originalBalance) && Objects.equals(this.referenceOrderId, giftCertificate.referenceOrderId) && Objects.equals(this.remainingBalance, giftCertificate.remainingBalance);
    }

    public int hashCode() {
        return Objects.hash(this.activated, this.code, this.customerProfileOid, this.deleted, this.email, this.expirationDts, this.giftCertificateOid, this.internal, this.ledgerEntries, this.merchantId, this.merchantNote, this.originalBalance, this.referenceOrderId, this.remainingBalance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GiftCertificate {\n");
        sb.append("    activated: ").append(this.toIndentedString(this.activated)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    customerProfileOid: ").append(this.toIndentedString(this.customerProfileOid)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    expirationDts: ").append(this.toIndentedString(this.expirationDts)).append("\n");
        sb.append("    giftCertificateOid: ").append(this.toIndentedString(this.giftCertificateOid)).append("\n");
        sb.append("    internal: ").append(this.toIndentedString(this.internal)).append("\n");
        sb.append("    ledgerEntries: ").append(this.toIndentedString(this.ledgerEntries)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    merchantNote: ").append(this.toIndentedString(this.merchantNote)).append("\n");
        sb.append("    originalBalance: ").append(this.toIndentedString(this.originalBalance)).append("\n");
        sb.append("    referenceOrderId: ").append(this.toIndentedString(this.referenceOrderId)).append("\n");
        sb.append("    remainingBalance: ").append(this.toIndentedString(this.remainingBalance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

