/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FulfillmentShipment {
    @SerializedName(value="fulfillment_fee")
    private BigDecimal fulfillmentFee = null;
    @SerializedName(value="order_id")
    private String orderId = null;
    @SerializedName(value="package_cost")
    private BigDecimal packageCost = null;
    @SerializedName(value="shipping_cost")
    private BigDecimal shippingCost = null;
    @SerializedName(value="tracking_numbers")
    private List<String> trackingNumbers = null;

    public FulfillmentShipment fulfillmentFee(BigDecimal fulfillmentFee) {
        this.fulfillmentFee = fulfillmentFee;
        return this;
    }

    @ApiModelProperty(value="Fees charged by the fulfillment company other than the shipping cost to process the order.")
    public BigDecimal getFulfillmentFee() {
        return this.fulfillmentFee;
    }

    public void setFulfillmentFee(BigDecimal fulfillmentFee) {
        this.fulfillmentFee = fulfillmentFee;
    }

    public FulfillmentShipment orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(value="Order ID that was shipped")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public FulfillmentShipment packageCost(BigDecimal packageCost) {
        this.packageCost = packageCost;
        return this;
    }

    @ApiModelProperty(value="The cost of the packaging used to sent this shipment")
    public BigDecimal getPackageCost() {
        return this.packageCost;
    }

    public void setPackageCost(BigDecimal packageCost) {
        this.packageCost = packageCost;
    }

    public FulfillmentShipment shippingCost(BigDecimal shippingCost) {
        this.shippingCost = shippingCost;
        return this;
    }

    @ApiModelProperty(value="The actual total cost of shipping this order")
    public BigDecimal getShippingCost() {
        return this.shippingCost;
    }

    public void setShippingCost(BigDecimal shippingCost) {
        this.shippingCost = shippingCost;
    }

    public FulfillmentShipment trackingNumbers(List<String> trackingNumbers) {
        this.trackingNumbers = trackingNumbers;
        return this;
    }

    public FulfillmentShipment addTrackingNumbersItem(String trackingNumbersItem) {
        if (this.trackingNumbers == null) {
            this.trackingNumbers = new ArrayList<String>();
        }
        this.trackingNumbers.add(trackingNumbersItem);
        return this;
    }

    @ApiModelProperty(value="Tracking numbers associated with the shipment")
    public List<String> getTrackingNumbers() {
        return this.trackingNumbers;
    }

    public void setTrackingNumbers(List<String> trackingNumbers) {
        this.trackingNumbers = trackingNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentShipment fulfillmentShipment = (FulfillmentShipment)o;
        return Objects.equals(this.fulfillmentFee, fulfillmentShipment.fulfillmentFee) && Objects.equals(this.orderId, fulfillmentShipment.orderId) && Objects.equals(this.packageCost, fulfillmentShipment.packageCost) && Objects.equals(this.shippingCost, fulfillmentShipment.shippingCost) && Objects.equals(this.trackingNumbers, fulfillmentShipment.trackingNumbers);
    }

    public int hashCode() {
        return Objects.hash(this.fulfillmentFee, this.orderId, this.packageCost, this.shippingCost, this.trackingNumbers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentShipment {\n");
        sb.append("    fulfillmentFee: ").append(this.toIndentedString(this.fulfillmentFee)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    packageCost: ").append(this.toIndentedString(this.packageCost)).append("\n");
        sb.append("    shippingCost: ").append(this.toIndentedString(this.shippingCost)).append("\n");
        sb.append("    trackingNumbers: ").append(this.toIndentedString(this.trackingNumbers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

