/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.ExperimentVariation;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Experiment {
    @SerializedName(value="container_id")
    private String containerId = null;
    @SerializedName(value="duration_days")
    private Integer durationDays = null;
    @SerializedName(value="end_dts")
    private String endDts = null;
    @SerializedName(value="equal_weighting")
    private Boolean equalWeighting = null;
    @SerializedName(value="experiment_type")
    private String experimentType = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="notes")
    private String notes = null;
    @SerializedName(value="objective")
    private String objective = null;
    @SerializedName(value="objective_parameter")
    private String objectiveParameter = null;
    @SerializedName(value="optimization_type")
    private String optimizationType = null;
    @SerializedName(value="session_count")
    private Integer sessionCount = null;
    @SerializedName(value="start_dts")
    private String startDts = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="storefront_experiment_oid")
    private Integer storefrontExperimentOid = null;
    @SerializedName(value="storefront_oid")
    private Integer storefrontOid = null;
    @SerializedName(value="uri")
    private String uri = null;
    @SerializedName(value="variations")
    private List<ExperimentVariation> variations = null;

    public Experiment containerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    @ApiModelProperty(value="Contained ID where the experiment element was located")
    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public Experiment durationDays(Integer durationDays) {
        this.durationDays = durationDays;
        return this;
    }

    @ApiModelProperty(value="Duration in days")
    public Integer getDurationDays() {
        return this.durationDays;
    }

    public void setDurationDays(Integer durationDays) {
        this.durationDays = durationDays;
    }

    public Experiment endDts(String endDts) {
        this.endDts = endDts;
        return this;
    }

    @ApiModelProperty(value="End date/time")
    public String getEndDts() {
        return this.endDts;
    }

    public void setEndDts(String endDts) {
        this.endDts = endDts;
    }

    public Experiment equalWeighting(Boolean equalWeighting) {
        this.equalWeighting = equalWeighting;
        return this;
    }

    @ApiModelProperty(value="Whether or not traffic is equally weighted or shifts over time during the experiment")
    public Boolean isEqualWeighting() {
        return this.equalWeighting;
    }

    public void setEqualWeighting(Boolean equalWeighting) {
        this.equalWeighting = equalWeighting;
    }

    public Experiment experimentType(String experimentType) {
        this.experimentType = experimentType;
        return this;
    }

    @ApiModelProperty(value="The type of experiment")
    public String getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(String experimentType) {
        this.experimentType = experimentType;
    }

    public Experiment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Experiment id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Experiment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Experiment name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Experiment notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="Notes about the experiment")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Experiment objective(String objective) {
        this.objective = objective;
        return this;
    }

    @ApiModelProperty(value="Objective that is being optimized")
    public String getObjective() {
        return this.objective;
    }

    public void setObjective(String objective) {
        this.objective = objective;
    }

    public Experiment objectiveParameter(String objectiveParameter) {
        this.objectiveParameter = objectiveParameter;
        return this;
    }

    @ApiModelProperty(value="Objective parameter (such as event name) that is being optimized")
    public String getObjectiveParameter() {
        return this.objectiveParameter;
    }

    public void setObjectiveParameter(String objectiveParameter) {
        this.objectiveParameter = objectiveParameter;
    }

    public Experiment optimizationType(String optimizationType) {
        this.optimizationType = optimizationType;
        return this;
    }

    @ApiModelProperty(value="Type of optimization")
    public String getOptimizationType() {
        return this.optimizationType;
    }

    public void setOptimizationType(String optimizationType) {
        this.optimizationType = optimizationType;
    }

    public Experiment sessionCount(Integer sessionCount) {
        this.sessionCount = sessionCount;
        return this;
    }

    @ApiModelProperty(value="Total number of sessions in the experiment")
    public Integer getSessionCount() {
        return this.sessionCount;
    }

    public void setSessionCount(Integer sessionCount) {
        this.sessionCount = sessionCount;
    }

    public Experiment startDts(String startDts) {
        this.startDts = startDts;
        return this;
    }

    @ApiModelProperty(value="Start date/time")
    public String getStartDts() {
        return this.startDts;
    }

    public void setStartDts(String startDts) {
        this.startDts = startDts;
    }

    public Experiment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status of the experiment")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Experiment storefrontExperimentOid(Integer storefrontExperimentOid) {
        this.storefrontExperimentOid = storefrontExperimentOid;
        return this;
    }

    @ApiModelProperty(value="Storefront Experiment Oid")
    public Integer getStorefrontExperimentOid() {
        return this.storefrontExperimentOid;
    }

    public void setStorefrontExperimentOid(Integer storefrontExperimentOid) {
        this.storefrontExperimentOid = storefrontExperimentOid;
    }

    public Experiment storefrontOid(Integer storefrontOid) {
        this.storefrontOid = storefrontOid;
        return this;
    }

    @ApiModelProperty(value="Storefront oid")
    public Integer getStorefrontOid() {
        return this.storefrontOid;
    }

    public void setStorefrontOid(Integer storefrontOid) {
        this.storefrontOid = storefrontOid;
    }

    public Experiment uri(String uri) {
        this.uri = uri;
        return this;
    }

    @ApiModelProperty(value="URI the experiment was started on")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Experiment variations(List<ExperimentVariation> variations) {
        this.variations = variations;
        return this;
    }

    public Experiment addVariationsItem(ExperimentVariation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<ExperimentVariation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    @ApiModelProperty(value="Variations being tested in the experiment")
    public List<ExperimentVariation> getVariations() {
        return this.variations;
    }

    public void setVariations(List<ExperimentVariation> variations) {
        this.variations = variations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Experiment experiment = (Experiment)o;
        return Objects.equals(this.containerId, experiment.containerId) && Objects.equals(this.durationDays, experiment.durationDays) && Objects.equals(this.endDts, experiment.endDts) && Objects.equals(this.equalWeighting, experiment.equalWeighting) && Objects.equals(this.experimentType, experiment.experimentType) && Objects.equals(this.id, experiment.id) && Objects.equals(this.name, experiment.name) && Objects.equals(this.notes, experiment.notes) && Objects.equals(this.objective, experiment.objective) && Objects.equals(this.objectiveParameter, experiment.objectiveParameter) && Objects.equals(this.optimizationType, experiment.optimizationType) && Objects.equals(this.sessionCount, experiment.sessionCount) && Objects.equals(this.startDts, experiment.startDts) && Objects.equals((Object)this.status, (Object)experiment.status) && Objects.equals(this.storefrontExperimentOid, experiment.storefrontExperimentOid) && Objects.equals(this.storefrontOid, experiment.storefrontOid) && Objects.equals(this.uri, experiment.uri) && Objects.equals(this.variations, experiment.variations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerId, this.durationDays, this.endDts, this.equalWeighting, this.experimentType, this.id, this.name, this.notes, this.objective, this.objectiveParameter, this.optimizationType, this.sessionCount, this.startDts, this.status, this.storefrontExperimentOid, this.storefrontOid, this.uri, this.variations});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Experiment {\n");
        sb.append("    containerId: ").append(this.toIndentedString(this.containerId)).append("\n");
        sb.append("    durationDays: ").append(this.toIndentedString(this.durationDays)).append("\n");
        sb.append("    endDts: ").append(this.toIndentedString(this.endDts)).append("\n");
        sb.append("    equalWeighting: ").append(this.toIndentedString(this.equalWeighting)).append("\n");
        sb.append("    experimentType: ").append(this.toIndentedString(this.experimentType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    objectiveParameter: ").append(this.toIndentedString(this.objectiveParameter)).append("\n");
        sb.append("    optimizationType: ").append(this.toIndentedString(this.optimizationType)).append("\n");
        sb.append("    sessionCount: ").append(this.toIndentedString(this.sessionCount)).append("\n");
        sb.append("    startDts: ").append(this.toIndentedString(this.startDts)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    storefrontExperimentOid: ").append(this.toIndentedString(this.storefrontExperimentOid)).append("\n");
        sb.append("    storefrontOid: ").append(this.toIndentedString(this.storefrontOid)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        RUNNING("Running"),
        ENDED("Ended"),
        DELETED("Deleted");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

