/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

public class CustomerStoreCreditLedgerEntry {
    @SerializedName(value="action")
    private String action = null;
    @SerializedName(value="amount")
    private BigDecimal amount = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="entry_dts")
    private String entryDts = null;
    @SerializedName(value="gift_certificate_ledger_oid")
    private Integer giftCertificateLedgerOid = null;
    @SerializedName(value="gift_certificate_oid")
    private Integer giftCertificateOid = null;
    @SerializedName(value="reference_order_id")
    private String referenceOrderId = null;

    public CustomerStoreCreditLedgerEntry action(String action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(value="Identifies the state of this ledger entry whether the entry is Vesting or Expiring")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public CustomerStoreCreditLedgerEntry amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount of the activity.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public CustomerStoreCreditLedgerEntry description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of what this ledger entry is used.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CustomerStoreCreditLedgerEntry entryDts(String entryDts) {
        this.entryDts = entryDts;
        return this;
    }

    @ApiModelProperty(value="Date time of this ledger activity.")
    public String getEntryDts() {
        return this.entryDts;
    }

    public void setEntryDts(String entryDts) {
        this.entryDts = entryDts;
    }

    public CustomerStoreCreditLedgerEntry giftCertificateLedgerOid(Integer giftCertificateLedgerOid) {
        this.giftCertificateLedgerOid = giftCertificateLedgerOid;
        return this;
    }

    @ApiModelProperty(value="Gift certificate ledger oid is a primary key for this object, used internally.")
    public Integer getGiftCertificateLedgerOid() {
        return this.giftCertificateLedgerOid;
    }

    public void setGiftCertificateLedgerOid(Integer giftCertificateLedgerOid) {
        this.giftCertificateLedgerOid = giftCertificateLedgerOid;
    }

    public CustomerStoreCreditLedgerEntry giftCertificateOid(Integer giftCertificateOid) {
        this.giftCertificateOid = giftCertificateOid;
        return this;
    }

    @ApiModelProperty(value="Gift certificate oid.")
    public Integer getGiftCertificateOid() {
        return this.giftCertificateOid;
    }

    public void setGiftCertificateOid(Integer giftCertificateOid) {
        this.giftCertificateOid = giftCertificateOid;
    }

    public CustomerStoreCreditLedgerEntry referenceOrderId(String referenceOrderId) {
        this.referenceOrderId = referenceOrderId;
        return this;
    }

    @ApiModelProperty(value="The order id if this gift certificate was used as part of the payment.")
    public String getReferenceOrderId() {
        return this.referenceOrderId;
    }

    public void setReferenceOrderId(String referenceOrderId) {
        this.referenceOrderId = referenceOrderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerStoreCreditLedgerEntry customerStoreCreditLedgerEntry = (CustomerStoreCreditLedgerEntry)o;
        return Objects.equals(this.action, customerStoreCreditLedgerEntry.action) && Objects.equals(this.amount, customerStoreCreditLedgerEntry.amount) && Objects.equals(this.description, customerStoreCreditLedgerEntry.description) && Objects.equals(this.entryDts, customerStoreCreditLedgerEntry.entryDts) && Objects.equals(this.giftCertificateLedgerOid, customerStoreCreditLedgerEntry.giftCertificateLedgerOid) && Objects.equals(this.giftCertificateOid, customerStoreCreditLedgerEntry.giftCertificateOid) && Objects.equals(this.referenceOrderId, customerStoreCreditLedgerEntry.referenceOrderId);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.amount, this.description, this.entryDts, this.giftCertificateLedgerOid, this.giftCertificateOid, this.referenceOrderId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerStoreCreditLedgerEntry {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    entryDts: ").append(this.toIndentedString(this.entryDts)).append("\n");
        sb.append("    giftCertificateLedgerOid: ").append(this.toIndentedString(this.giftCertificateLedgerOid)).append("\n");
        sb.append("    giftCertificateOid: ").append(this.toIndentedString(this.giftCertificateOid)).append("\n");
        sb.append("    referenceOrderId: ").append(this.toIndentedString(this.referenceOrderId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

