/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.CustomerStoreCreditLedgerEntry;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CustomerStoreCredit {
    @SerializedName(value="available")
    private BigDecimal available = null;
    @SerializedName(value="expiring")
    private BigDecimal expiring = null;
    @SerializedName(value="future_ledgers")
    private List<CustomerStoreCreditLedgerEntry> futureLedgers = null;
    @SerializedName(value="past_ledgers")
    private List<CustomerStoreCreditLedgerEntry> pastLedgers = null;
    @SerializedName(value="total")
    private BigDecimal total = null;
    @SerializedName(value="vesting")
    private BigDecimal vesting = null;

    public CustomerStoreCredit available(BigDecimal available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(value="Available store credit which is defined as unused and vested")
    public BigDecimal getAvailable() {
        return this.available;
    }

    public void setAvailable(BigDecimal available) {
        this.available = available;
    }

    public CustomerStoreCredit expiring(BigDecimal expiring) {
        this.expiring = expiring;
        return this;
    }

    @ApiModelProperty(value="Amount of store credit expiring within 30 days")
    public BigDecimal getExpiring() {
        return this.expiring;
    }

    public void setExpiring(BigDecimal expiring) {
        this.expiring = expiring;
    }

    public CustomerStoreCredit futureLedgers(List<CustomerStoreCreditLedgerEntry> futureLedgers) {
        this.futureLedgers = futureLedgers;
        return this;
    }

    public CustomerStoreCredit addFutureLedgersItem(CustomerStoreCreditLedgerEntry futureLedgersItem) {
        if (this.futureLedgers == null) {
            this.futureLedgers = new ArrayList<CustomerStoreCreditLedgerEntry>();
        }
        this.futureLedgers.add(futureLedgersItem);
        return this;
    }

    @ApiModelProperty(value="Array of future ledger entries including expiring entries")
    public List<CustomerStoreCreditLedgerEntry> getFutureLedgers() {
        return this.futureLedgers;
    }

    public void setFutureLedgers(List<CustomerStoreCreditLedgerEntry> futureLedgers) {
        this.futureLedgers = futureLedgers;
    }

    public CustomerStoreCredit pastLedgers(List<CustomerStoreCreditLedgerEntry> pastLedgers) {
        this.pastLedgers = pastLedgers;
        return this;
    }

    public CustomerStoreCredit addPastLedgersItem(CustomerStoreCreditLedgerEntry pastLedgersItem) {
        if (this.pastLedgers == null) {
            this.pastLedgers = new ArrayList<CustomerStoreCreditLedgerEntry>();
        }
        this.pastLedgers.add(pastLedgersItem);
        return this;
    }

    @ApiModelProperty(value="Array of past ledger entries including accrual, usage, and expiring entries")
    public List<CustomerStoreCreditLedgerEntry> getPastLedgers() {
        return this.pastLedgers;
    }

    public void setPastLedgers(List<CustomerStoreCreditLedgerEntry> pastLedgers) {
        this.pastLedgers = pastLedgers;
    }

    public CustomerStoreCredit total(BigDecimal total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total lifetime store credit for this customer.")
    public BigDecimal getTotal() {
        return this.total;
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public CustomerStoreCredit vesting(BigDecimal vesting) {
        this.vesting = vesting;
        return this;
    }

    @ApiModelProperty(value="Amount of store credit vesting")
    public BigDecimal getVesting() {
        return this.vesting;
    }

    public void setVesting(BigDecimal vesting) {
        this.vesting = vesting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerStoreCredit customerStoreCredit = (CustomerStoreCredit)o;
        return Objects.equals(this.available, customerStoreCredit.available) && Objects.equals(this.expiring, customerStoreCredit.expiring) && Objects.equals(this.futureLedgers, customerStoreCredit.futureLedgers) && Objects.equals(this.pastLedgers, customerStoreCredit.pastLedgers) && Objects.equals(this.total, customerStoreCredit.total) && Objects.equals(this.vesting, customerStoreCredit.vesting);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.expiring, this.futureLedgers, this.pastLedgers, this.total, this.vesting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerStoreCredit {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    expiring: ").append(this.toIndentedString(this.expiring)).append("\n");
        sb.append("    futureLedgers: ").append(this.toIndentedString(this.futureLedgers)).append("\n");
        sb.append("    pastLedgers: ").append(this.toIndentedString(this.pastLedgers)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    vesting: ").append(this.toIndentedString(this.vesting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

