/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.CustomerLoyaltyLedger;
import com.ultracart.admin.v2.models.CustomerLoyaltyRedemption;
import com.ultracart.admin.v2.models.GiftCertificate;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CustomerLoyalty {
    @SerializedName(value="current_points")
    private Integer currentPoints = null;
    @SerializedName(value="internal_gift_certificate")
    private GiftCertificate internalGiftCertificate = null;
    @SerializedName(value="internal_gift_certificate_balance")
    private String internalGiftCertificateBalance = null;
    @SerializedName(value="internal_gift_certificate_oid")
    private Integer internalGiftCertificateOid = null;
    @SerializedName(value="ledger_entries")
    private List<CustomerLoyaltyLedger> ledgerEntries = null;
    @SerializedName(value="pending_points")
    private Integer pendingPoints = null;
    @SerializedName(value="redemptions")
    private List<CustomerLoyaltyRedemption> redemptions = null;

    public CustomerLoyalty currentPoints(Integer currentPoints) {
        this.currentPoints = currentPoints;
        return this;
    }

    @ApiModelProperty(value="Current points")
    public Integer getCurrentPoints() {
        return this.currentPoints;
    }

    public void setCurrentPoints(Integer currentPoints) {
        this.currentPoints = currentPoints;
    }

    public CustomerLoyalty internalGiftCertificate(GiftCertificate internalGiftCertificate) {
        this.internalGiftCertificate = internalGiftCertificate;
        return this;
    }

    @ApiModelProperty(value="")
    public GiftCertificate getInternalGiftCertificate() {
        return this.internalGiftCertificate;
    }

    public void setInternalGiftCertificate(GiftCertificate internalGiftCertificate) {
        this.internalGiftCertificate = internalGiftCertificate;
    }

    public CustomerLoyalty internalGiftCertificateBalance(String internalGiftCertificateBalance) {
        this.internalGiftCertificateBalance = internalGiftCertificateBalance;
        return this;
    }

    @ApiModelProperty(value="Loyalty Cashback / Store credit balance (internal gift certificate balance)")
    public String getInternalGiftCertificateBalance() {
        return this.internalGiftCertificateBalance;
    }

    public void setInternalGiftCertificateBalance(String internalGiftCertificateBalance) {
        this.internalGiftCertificateBalance = internalGiftCertificateBalance;
    }

    public CustomerLoyalty internalGiftCertificateOid(Integer internalGiftCertificateOid) {
        this.internalGiftCertificateOid = internalGiftCertificateOid;
        return this;
    }

    @ApiModelProperty(value="Internal gift certificate oid used to tracking loyalty cashback / store credit.")
    public Integer getInternalGiftCertificateOid() {
        return this.internalGiftCertificateOid;
    }

    public void setInternalGiftCertificateOid(Integer internalGiftCertificateOid) {
        this.internalGiftCertificateOid = internalGiftCertificateOid;
    }

    public CustomerLoyalty ledgerEntries(List<CustomerLoyaltyLedger> ledgerEntries) {
        this.ledgerEntries = ledgerEntries;
        return this;
    }

    public CustomerLoyalty addLedgerEntriesItem(CustomerLoyaltyLedger ledgerEntriesItem) {
        if (this.ledgerEntries == null) {
            this.ledgerEntries = new ArrayList<CustomerLoyaltyLedger>();
        }
        this.ledgerEntries.add(ledgerEntriesItem);
        return this;
    }

    @ApiModelProperty(value="Ledger entries")
    public List<CustomerLoyaltyLedger> getLedgerEntries() {
        return this.ledgerEntries;
    }

    public void setLedgerEntries(List<CustomerLoyaltyLedger> ledgerEntries) {
        this.ledgerEntries = ledgerEntries;
    }

    public CustomerLoyalty pendingPoints(Integer pendingPoints) {
        this.pendingPoints = pendingPoints;
        return this;
    }

    @ApiModelProperty(value="Pending Points")
    public Integer getPendingPoints() {
        return this.pendingPoints;
    }

    public void setPendingPoints(Integer pendingPoints) {
        this.pendingPoints = pendingPoints;
    }

    public CustomerLoyalty redemptions(List<CustomerLoyaltyRedemption> redemptions) {
        this.redemptions = redemptions;
        return this;
    }

    public CustomerLoyalty addRedemptionsItem(CustomerLoyaltyRedemption redemptionsItem) {
        if (this.redemptions == null) {
            this.redemptions = new ArrayList<CustomerLoyaltyRedemption>();
        }
        this.redemptions.add(redemptionsItem);
        return this;
    }

    @ApiModelProperty(value="Redemptions")
    public List<CustomerLoyaltyRedemption> getRedemptions() {
        return this.redemptions;
    }

    public void setRedemptions(List<CustomerLoyaltyRedemption> redemptions) {
        this.redemptions = redemptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerLoyalty customerLoyalty = (CustomerLoyalty)o;
        return Objects.equals(this.currentPoints, customerLoyalty.currentPoints) && Objects.equals(this.internalGiftCertificate, customerLoyalty.internalGiftCertificate) && Objects.equals(this.internalGiftCertificateBalance, customerLoyalty.internalGiftCertificateBalance) && Objects.equals(this.internalGiftCertificateOid, customerLoyalty.internalGiftCertificateOid) && Objects.equals(this.ledgerEntries, customerLoyalty.ledgerEntries) && Objects.equals(this.pendingPoints, customerLoyalty.pendingPoints) && Objects.equals(this.redemptions, customerLoyalty.redemptions);
    }

    public int hashCode() {
        return Objects.hash(this.currentPoints, this.internalGiftCertificate, this.internalGiftCertificateBalance, this.internalGiftCertificateOid, this.ledgerEntries, this.pendingPoints, this.redemptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerLoyalty {\n");
        sb.append("    currentPoints: ").append(this.toIndentedString(this.currentPoints)).append("\n");
        sb.append("    internalGiftCertificate: ").append(this.toIndentedString(this.internalGiftCertificate)).append("\n");
        sb.append("    internalGiftCertificateBalance: ").append(this.toIndentedString(this.internalGiftCertificateBalance)).append("\n");
        sb.append("    internalGiftCertificateOid: ").append(this.toIndentedString(this.internalGiftCertificateOid)).append("\n");
        sb.append("    ledgerEntries: ").append(this.toIndentedString(this.ledgerEntries)).append("\n");
        sb.append("    pendingPoints: ").append(this.toIndentedString(this.pendingPoints)).append("\n");
        sb.append("    redemptions: ").append(this.toIndentedString(this.redemptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

