/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

public class Currency {
    @SerializedName(value="currency_code")
    private String currencyCode = null;
    @SerializedName(value="exchange_rate")
    private BigDecimal exchangeRate = null;
    @SerializedName(value="localized")
    private BigDecimal localized = null;
    @SerializedName(value="localized_formatted")
    private String localizedFormatted = null;
    @SerializedName(value="value")
    private BigDecimal value = null;

    public Currency currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="Currency code of the localized value")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Currency exchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @ApiModelProperty(value="Exchange rate used to localize")
    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public Currency localized(BigDecimal localized) {
        this.localized = localized;
        return this;
    }

    @ApiModelProperty(value="Value localized to the customer")
    public BigDecimal getLocalized() {
        return this.localized;
    }

    public void setLocalized(BigDecimal localized) {
        this.localized = localized;
    }

    public Currency localizedFormatted(String localizedFormatted) {
        this.localizedFormatted = localizedFormatted;
        return this;
    }

    @ApiModelProperty(value="Value localized and formatted for the customer")
    public String getLocalizedFormatted() {
        return this.localizedFormatted;
    }

    public void setLocalizedFormatted(String localizedFormatted) {
        this.localizedFormatted = localizedFormatted;
    }

    public Currency value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Value in base currency")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Currency currency = (Currency)o;
        return Objects.equals(this.currencyCode, currency.currencyCode) && Objects.equals(this.exchangeRate, currency.exchangeRate) && Objects.equals(this.localized, currency.localized) && Objects.equals(this.localizedFormatted, currency.localizedFormatted) && Objects.equals(this.value, currency.value);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.exchangeRate, this.localized, this.localizedFormatted, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Currency {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    exchangeRate: ").append(this.toIndentedString(this.exchangeRate)).append("\n");
        sb.append("    localized: ").append(this.toIndentedString(this.localized)).append("\n");
        sb.append("    localizedFormatted: ").append(this.toIndentedString(this.localizedFormatted)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

