/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CouponDiscountItems {
    @SerializedName(value="currency_code")
    private String currencyCode = null;
    @SerializedName(value="discount_price")
    private BigDecimal discountPrice = null;
    @SerializedName(value="items")
    private List<String> items = null;
    @SerializedName(value="limit")
    private Integer limit = null;

    public CouponDiscountItems currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The ISO-4217 three letter currency code the customer is viewing prices in")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CouponDiscountItems discountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
        return this;
    }

    @ApiModelProperty(value="The price (unit cost) of the discounted item")
    public BigDecimal getDiscountPrice() {
        return this.discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public CouponDiscountItems items(List<String> items) {
        this.items = items;
        return this;
    }

    public CouponDiscountItems addItemsItem(String itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<String>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(value="A list of items that are eligible for this discount_price.")
    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public CouponDiscountItems limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(value="The (optional) maximum quantity of discounted items.")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouponDiscountItems couponDiscountItems = (CouponDiscountItems)o;
        return Objects.equals(this.currencyCode, couponDiscountItems.currencyCode) && Objects.equals(this.discountPrice, couponDiscountItems.discountPrice) && Objects.equals(this.items, couponDiscountItems.items) && Objects.equals(this.limit, couponDiscountItems.limit);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.discountPrice, this.items, this.limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CouponDiscountItems {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    discountPrice: ").append(this.toIndentedString(this.discountPrice)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

