/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CouponAmountShippingWithSubtotal {
    @SerializedName(value="currency_code")
    private String currencyCode = null;
    @SerializedName(value="purchase_amount")
    private BigDecimal purchaseAmount = null;
    @SerializedName(value="shipping_amount")
    private BigDecimal shippingAmount = null;
    @SerializedName(value="shipping_methods")
    private List<String> shippingMethods = null;

    public CouponAmountShippingWithSubtotal currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The ISO-4217 three letter currency code the customer is viewing prices in")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CouponAmountShippingWithSubtotal purchaseAmount(BigDecimal purchaseAmount) {
        this.purchaseAmount = purchaseAmount;
        return this;
    }

    @ApiModelProperty(value="The purchase amount to qualify for subtotal discount and free shipping")
    public BigDecimal getPurchaseAmount() {
        return this.purchaseAmount;
    }

    public void setPurchaseAmount(BigDecimal purchaseAmount) {
        this.purchaseAmount = purchaseAmount;
    }

    public CouponAmountShippingWithSubtotal shippingAmount(BigDecimal shippingAmount) {
        this.shippingAmount = shippingAmount;
        return this;
    }

    @ApiModelProperty(value="The amount of the shipping cost (this is not a discount, this is the actual cost of shipping)")
    public BigDecimal getShippingAmount() {
        return this.shippingAmount;
    }

    public void setShippingAmount(BigDecimal shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    public CouponAmountShippingWithSubtotal shippingMethods(List<String> shippingMethods) {
        this.shippingMethods = shippingMethods;
        return this;
    }

    public CouponAmountShippingWithSubtotal addShippingMethodsItem(String shippingMethodsItem) {
        if (this.shippingMethods == null) {
            this.shippingMethods = new ArrayList<String>();
        }
        this.shippingMethods.add(shippingMethodsItem);
        return this;
    }

    @ApiModelProperty(value="One or more shipping methods that may be used with this coupon")
    public List<String> getShippingMethods() {
        return this.shippingMethods;
    }

    public void setShippingMethods(List<String> shippingMethods) {
        this.shippingMethods = shippingMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouponAmountShippingWithSubtotal couponAmountShippingWithSubtotal = (CouponAmountShippingWithSubtotal)o;
        return Objects.equals(this.currencyCode, couponAmountShippingWithSubtotal.currencyCode) && Objects.equals(this.purchaseAmount, couponAmountShippingWithSubtotal.purchaseAmount) && Objects.equals(this.shippingAmount, couponAmountShippingWithSubtotal.shippingAmount) && Objects.equals(this.shippingMethods, couponAmountShippingWithSubtotal.shippingMethods);
    }

    public int hashCode() {
        return Objects.hash(this.currencyCode, this.purchaseAmount, this.shippingAmount, this.shippingMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CouponAmountShippingWithSubtotal {\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    purchaseAmount: ").append(this.toIndentedString(this.purchaseAmount)).append("\n");
        sb.append("    shippingAmount: ").append(this.toIndentedString(this.shippingAmount)).append("\n");
        sb.append("    shippingMethods: ").append(this.toIndentedString(this.shippingMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

