/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.Cart;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;

public class CheckoutHandoffRequest {
    @SerializedName(value="cart")
    private Cart cart = null;
    @SerializedName(value="error_parameter_name")
    private String errorParameterName = null;
    @SerializedName(value="error_return_url")
    private String errorReturnUrl = null;
    @SerializedName(value="operation")
    private OperationEnum operation = null;
    @SerializedName(value="paypal_maximum_upsell_revenue")
    private BigDecimal paypalMaximumUpsellRevenue = null;
    @SerializedName(value="paypal_return_url")
    private String paypalReturnUrl = null;
    @SerializedName(value="secure_host_name")
    private String secureHostName = null;
    @SerializedName(value="ucacid")
    private String ucacid = null;

    public CheckoutHandoffRequest cart(Cart cart) {
        this.cart = cart;
        return this;
    }

    @ApiModelProperty(value="")
    public Cart getCart() {
        return this.cart;
    }

    public void setCart(Cart cart) {
        this.cart = cart;
    }

    public CheckoutHandoffRequest errorParameterName(String errorParameterName) {
        this.errorParameterName = errorParameterName;
        return this;
    }

    @ApiModelProperty(value="If any error happen during the processing on the UltraCart side, the browser will be redirected to your error_return_url with the error passed in this parameter name.")
    public String getErrorParameterName() {
        return this.errorParameterName;
    }

    public void setErrorParameterName(String errorParameterName) {
        this.errorParameterName = errorParameterName;
    }

    public CheckoutHandoffRequest errorReturnUrl(String errorReturnUrl) {
        this.errorReturnUrl = errorReturnUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to return the browser to if there are processing errors on the UltraCart side.")
    public String getErrorReturnUrl() {
        return this.errorReturnUrl;
    }

    public void setErrorReturnUrl(String errorReturnUrl) {
        this.errorReturnUrl = errorReturnUrl;
    }

    public CheckoutHandoffRequest operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(value="The type of handoff operation to perform")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public CheckoutHandoffRequest paypalMaximumUpsellRevenue(BigDecimal paypalMaximumUpsellRevenue) {
        this.paypalMaximumUpsellRevenue = paypalMaximumUpsellRevenue;
        return this;
    }

    @ApiModelProperty(value="The maximum amount of revenue that you think the customer could add during a custom upsell after sequence on your checkout.")
    public BigDecimal getPaypalMaximumUpsellRevenue() {
        return this.paypalMaximumUpsellRevenue;
    }

    public void setPaypalMaximumUpsellRevenue(BigDecimal paypalMaximumUpsellRevenue) {
        this.paypalMaximumUpsellRevenue = paypalMaximumUpsellRevenue;
    }

    public CheckoutHandoffRequest paypalReturnUrl(String paypalReturnUrl) {
        this.paypalReturnUrl = paypalReturnUrl;
        return this;
    }

    @ApiModelProperty(value="The URl to return the customers browser to after they have completed the PayPal process.")
    public String getPaypalReturnUrl() {
        return this.paypalReturnUrl;
    }

    public void setPaypalReturnUrl(String paypalReturnUrl) {
        this.paypalReturnUrl = paypalReturnUrl;
    }

    public CheckoutHandoffRequest secureHostName(String secureHostName) {
        this.secureHostName = secureHostName;
        return this;
    }

    @ApiModelProperty(value="The desired secure host name to perform the handoff on.  This should match the desired StoreFront.")
    public String getSecureHostName() {
        return this.secureHostName;
    }

    public void setSecureHostName(String secureHostName) {
        this.secureHostName = secureHostName;
    }

    public CheckoutHandoffRequest ucacid(String ucacid) {
        this.ucacid = ucacid;
        return this;
    }

    @ApiModelProperty(value="The UltraCart Analytics cookie value.  Populate this if you're handing off from a different domain than the checkout.")
    public String getUcacid() {
        return this.ucacid;
    }

    public void setUcacid(String ucacid) {
        this.ucacid = ucacid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutHandoffRequest checkoutHandoffRequest = (CheckoutHandoffRequest)o;
        return Objects.equals(this.cart, checkoutHandoffRequest.cart) && Objects.equals(this.errorParameterName, checkoutHandoffRequest.errorParameterName) && Objects.equals(this.errorReturnUrl, checkoutHandoffRequest.errorReturnUrl) && Objects.equals((Object)this.operation, (Object)checkoutHandoffRequest.operation) && Objects.equals(this.paypalMaximumUpsellRevenue, checkoutHandoffRequest.paypalMaximumUpsellRevenue) && Objects.equals(this.paypalReturnUrl, checkoutHandoffRequest.paypalReturnUrl) && Objects.equals(this.secureHostName, checkoutHandoffRequest.secureHostName) && Objects.equals(this.ucacid, checkoutHandoffRequest.ucacid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cart, this.errorParameterName, this.errorReturnUrl, this.operation, this.paypalMaximumUpsellRevenue, this.paypalReturnUrl, this.secureHostName, this.ucacid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutHandoffRequest {\n");
        sb.append("    cart: ").append(this.toIndentedString(this.cart)).append("\n");
        sb.append("    errorParameterName: ").append(this.toIndentedString(this.errorParameterName)).append("\n");
        sb.append("    errorReturnUrl: ").append(this.toIndentedString(this.errorReturnUrl)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    paypalMaximumUpsellRevenue: ").append(this.toIndentedString(this.paypalMaximumUpsellRevenue)).append("\n");
        sb.append("    paypalReturnUrl: ").append(this.toIndentedString(this.paypalReturnUrl)).append("\n");
        sb.append("    secureHostName: ").append(this.toIndentedString(this.secureHostName)).append("\n");
        sb.append("    ucacid: ").append(this.toIndentedString(this.ucacid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperationEnum {
        CHECKOUT("checkout"),
        PAYPAL("payPal"),
        PAYPALCREDIT("payPalCredit"),
        VIEW("view"),
        AFFIRM("affirm"),
        SEZZLE("sezzle");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperationEnum fromValue(String text) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OperationEnum> {
            public void write(JsonWriter jsonWriter, OperationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperationEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

