/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.ChannelPartnerOrderItemOption;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ChannelPartnerOrderItem {
    @SerializedName(value="arbitrary_unit_cost")
    private BigDecimal arbitraryUnitCost = null;
    @SerializedName(value="auto_order_last_rebill_dts")
    private String autoOrderLastRebillDts = null;
    @SerializedName(value="auto_order_schedule")
    private AutoOrderScheduleEnum autoOrderSchedule = null;
    @SerializedName(value="merchant_item_id")
    private String merchantItemId = null;
    @SerializedName(value="options")
    private List<ChannelPartnerOrderItemOption> options = null;
    @SerializedName(value="quantity")
    private BigDecimal quantity = null;
    @SerializedName(value="upsell")
    private Boolean upsell = null;

    public ChannelPartnerOrderItem arbitraryUnitCost(BigDecimal arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
        return this;
    }

    @ApiModelProperty(value="Arbitrary unit cost for this item that differs from the listed price")
    public BigDecimal getArbitraryUnitCost() {
        return this.arbitraryUnitCost;
    }

    public void setArbitraryUnitCost(BigDecimal arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
    }

    public ChannelPartnerOrderItem autoOrderLastRebillDts(String autoOrderLastRebillDts) {
        this.autoOrderLastRebillDts = autoOrderLastRebillDts;
        return this;
    }

    @ApiModelProperty(value="Optional date/time of the last rebill if this item is part of an auto (recurring) order")
    public String getAutoOrderLastRebillDts() {
        return this.autoOrderLastRebillDts;
    }

    public void setAutoOrderLastRebillDts(String autoOrderLastRebillDts) {
        this.autoOrderLastRebillDts = autoOrderLastRebillDts;
    }

    public ChannelPartnerOrderItem autoOrderSchedule(AutoOrderScheduleEnum autoOrderSchedule) {
        this.autoOrderSchedule = autoOrderSchedule;
        return this;
    }

    @ApiModelProperty(value="The frequency schedule for this item if this item is part of an auto (recurring) order")
    public AutoOrderScheduleEnum getAutoOrderSchedule() {
        return this.autoOrderSchedule;
    }

    public void setAutoOrderSchedule(AutoOrderScheduleEnum autoOrderSchedule) {
        this.autoOrderSchedule = autoOrderSchedule;
    }

    public ChannelPartnerOrderItem merchantItemId(String merchantItemId) {
        this.merchantItemId = merchantItemId;
        return this;
    }

    @ApiModelProperty(value="Item ID")
    public String getMerchantItemId() {
        return this.merchantItemId;
    }

    public void setMerchantItemId(String merchantItemId) {
        this.merchantItemId = merchantItemId;
    }

    public ChannelPartnerOrderItem options(List<ChannelPartnerOrderItemOption> options) {
        this.options = options;
        return this;
    }

    public ChannelPartnerOrderItem addOptionsItem(ChannelPartnerOrderItemOption optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<ChannelPartnerOrderItemOption>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="Item options")
    public List<ChannelPartnerOrderItemOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<ChannelPartnerOrderItemOption> options) {
        this.options = options;
    }

    public ChannelPartnerOrderItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="Quantity")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public ChannelPartnerOrderItem upsell(Boolean upsell) {
        this.upsell = upsell;
        return this;
    }

    @ApiModelProperty(value="True if this item was an upsell item.")
    public Boolean isUpsell() {
        return this.upsell;
    }

    public void setUpsell(Boolean upsell) {
        this.upsell = upsell;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelPartnerOrderItem channelPartnerOrderItem = (ChannelPartnerOrderItem)o;
        return Objects.equals(this.arbitraryUnitCost, channelPartnerOrderItem.arbitraryUnitCost) && Objects.equals(this.autoOrderLastRebillDts, channelPartnerOrderItem.autoOrderLastRebillDts) && Objects.equals((Object)this.autoOrderSchedule, (Object)channelPartnerOrderItem.autoOrderSchedule) && Objects.equals(this.merchantItemId, channelPartnerOrderItem.merchantItemId) && Objects.equals(this.options, channelPartnerOrderItem.options) && Objects.equals(this.quantity, channelPartnerOrderItem.quantity) && Objects.equals(this.upsell, channelPartnerOrderItem.upsell);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arbitraryUnitCost, this.autoOrderLastRebillDts, this.autoOrderSchedule, this.merchantItemId, this.options, this.quantity, this.upsell});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChannelPartnerOrderItem {\n");
        sb.append("    arbitraryUnitCost: ").append(this.toIndentedString(this.arbitraryUnitCost)).append("\n");
        sb.append("    autoOrderLastRebillDts: ").append(this.toIndentedString(this.autoOrderLastRebillDts)).append("\n");
        sb.append("    autoOrderSchedule: ").append(this.toIndentedString((Object)this.autoOrderSchedule)).append("\n");
        sb.append("    merchantItemId: ").append(this.toIndentedString(this.merchantItemId)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    upsell: ").append(this.toIndentedString(this.upsell)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AutoOrderScheduleEnum {
        WEEKLY("Weekly"),
        EVERY_10_DAYS("Every 10 Days"),
        BIWEEKLY("Biweekly"),
        EVERY_24_DAYS("Every 24 Days"),
        EVERY_28_DAYS("Every 28 Days"),
        MONTHLY("Monthly"),
        EVERY_45_DAYS("Every 45 Days"),
        EVERY_2_MONTHS("Every 2 Months"),
        EVERY_3_MONTHS("Every 3 Months"),
        EVERY_4_MONTHS("Every 4 Months"),
        EVERY_6_MONTHS("Every 6 Months"),
        YEARLY("Yearly");

        private String value;

        private AutoOrderScheduleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AutoOrderScheduleEnum fromValue(String text) {
            for (AutoOrderScheduleEnum b : AutoOrderScheduleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AutoOrderScheduleEnum> {
            public void write(JsonWriter jsonWriter, AutoOrderScheduleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AutoOrderScheduleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AutoOrderScheduleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

