/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.CartItemMultimediaThumbnail;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CartItemMultimedia {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="exclude_from_gallery")
    private Boolean excludeFromGallery = null;
    @SerializedName(value="image_height")
    private Integer imageHeight = null;
    @SerializedName(value="image_width")
    private Integer imageWidth = null;
    @SerializedName(value="is_default")
    private Boolean isDefault = null;
    @SerializedName(value="thumbnails")
    private List<CartItemMultimediaThumbnail> thumbnails = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="url")
    private String url = null;

    public CartItemMultimedia code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="Code assigned to the multimedia")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public CartItemMultimedia description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CartItemMultimedia excludeFromGallery(Boolean excludeFromGallery) {
        this.excludeFromGallery = excludeFromGallery;
        return this;
    }

    @ApiModelProperty(value="True if the image should be excluded from galleries")
    public Boolean isExcludeFromGallery() {
        return this.excludeFromGallery;
    }

    public void setExcludeFromGallery(Boolean excludeFromGallery) {
        this.excludeFromGallery = excludeFromGallery;
    }

    public CartItemMultimedia imageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
        return this;
    }

    @ApiModelProperty(value="Image height")
    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public CartItemMultimedia imageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
        return this;
    }

    @ApiModelProperty(value="Image width")
    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public CartItemMultimedia isDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @ApiModelProperty(value="True if the multimedia is the default for this type")
    public Boolean isIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public CartItemMultimedia thumbnails(List<CartItemMultimediaThumbnail> thumbnails) {
        this.thumbnails = thumbnails;
        return this;
    }

    public CartItemMultimedia addThumbnailsItem(CartItemMultimediaThumbnail thumbnailsItem) {
        if (this.thumbnails == null) {
            this.thumbnails = new ArrayList<CartItemMultimediaThumbnail>();
        }
        this.thumbnails.add(thumbnailsItem);
        return this;
    }

    @ApiModelProperty(value="Thumbnails of the images")
    public List<CartItemMultimediaThumbnail> getThumbnails() {
        return this.thumbnails;
    }

    public void setThumbnails(List<CartItemMultimediaThumbnail> thumbnails) {
        this.thumbnails = thumbnails;
    }

    public CartItemMultimedia type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of multimedia")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CartItemMultimedia url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="URL to view multimedia at")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartItemMultimedia cartItemMultimedia = (CartItemMultimedia)o;
        return Objects.equals(this.code, cartItemMultimedia.code) && Objects.equals(this.description, cartItemMultimedia.description) && Objects.equals(this.excludeFromGallery, cartItemMultimedia.excludeFromGallery) && Objects.equals(this.imageHeight, cartItemMultimedia.imageHeight) && Objects.equals(this.imageWidth, cartItemMultimedia.imageWidth) && Objects.equals(this.isDefault, cartItemMultimedia.isDefault) && Objects.equals(this.thumbnails, cartItemMultimedia.thumbnails) && Objects.equals((Object)this.type, (Object)cartItemMultimedia.type) && Objects.equals(this.url, cartItemMultimedia.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.description, this.excludeFromGallery, this.imageHeight, this.imageWidth, this.isDefault, this.thumbnails, this.type, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CartItemMultimedia {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    excludeFromGallery: ").append(this.toIndentedString(this.excludeFromGallery)).append("\n");
        sb.append("    imageHeight: ").append(this.toIndentedString(this.imageHeight)).append("\n");
        sb.append("    imageWidth: ").append(this.toIndentedString(this.imageWidth)).append("\n");
        sb.append("    isDefault: ").append(this.toIndentedString(this.isDefault)).append("\n");
        sb.append("    thumbnails: ").append(this.toIndentedString(this.thumbnails)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        IMAGE("Image"),
        PDF("PDF"),
        TEXT("Text"),
        UNKNOWN("Unknown"),
        VIDEO("Video");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

