/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.CartCustomerProfileAddress;
import com.ultracart.admin.v2.models.CartCustomerProfileCreditCard;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CartCustomerProfile {
    @SerializedName(value="allow_3rd_party_billing")
    private Boolean allow3rdPartyBilling = null;
    @SerializedName(value="allow_cod")
    private Boolean allowCod = null;
    @SerializedName(value="allow_purchase_order")
    private Boolean allowPurchaseOrder = null;
    @SerializedName(value="billing_addresses")
    private List<CartCustomerProfileAddress> billingAddresses = null;
    @SerializedName(value="credit_cards")
    private List<CartCustomerProfileCreditCard> creditCards = null;
    @SerializedName(value="customer_profile_oid")
    private Integer customerProfileOid = null;
    @SerializedName(value="dhl_account_number")
    private String dhlAccountNumber = null;
    @SerializedName(value="dhl_duty_account_number")
    private String dhlDutyAccountNumber = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="fedex_account_number")
    private String fedexAccountNumber = null;
    @SerializedName(value="free_shipping")
    private Boolean freeShipping = null;
    @SerializedName(value="free_shipping_minimum")
    private BigDecimal freeShippingMinimum = null;
    @SerializedName(value="maximum_item_count")
    private Integer maximumItemCount = null;
    @SerializedName(value="minimum_item_count")
    private Integer minimumItemCount = null;
    @SerializedName(value="minimum_subtotal")
    private BigDecimal minimumSubtotal = null;
    @SerializedName(value="no_coupons")
    private Boolean noCoupons = null;
    @SerializedName(value="no_free_shipping")
    private Boolean noFreeShipping = null;
    @SerializedName(value="no_realtime_charge")
    private Boolean noRealtimeCharge = null;
    @SerializedName(value="pricing_tiers")
    private List<String> pricingTiers = null;
    @SerializedName(value="shipping_addresses")
    private List<CartCustomerProfileAddress> shippingAddresses = null;
    @SerializedName(value="tax_exempt")
    private Boolean taxExempt = null;
    @SerializedName(value="ups_account_number")
    private String upsAccountNumber = null;

    public CartCustomerProfile allow3rdPartyBilling(Boolean allow3rdPartyBilling) {
        this.allow3rdPartyBilling = allow3rdPartyBilling;
        return this;
    }

    @ApiModelProperty(value="True if profile is allowed to bill to their 3rd party shipping account")
    public Boolean isAllow3rdPartyBilling() {
        return this.allow3rdPartyBilling;
    }

    public void setAllow3rdPartyBilling(Boolean allow3rdPartyBilling) {
        this.allow3rdPartyBilling = allow3rdPartyBilling;
    }

    public CartCustomerProfile allowCod(Boolean allowCod) {
        this.allowCod = allowCod;
        return this;
    }

    @ApiModelProperty(value="True if this profile is allowed to use a COD")
    public Boolean isAllowCod() {
        return this.allowCod;
    }

    public void setAllowCod(Boolean allowCod) {
        this.allowCod = allowCod;
    }

    public CartCustomerProfile allowPurchaseOrder(Boolean allowPurchaseOrder) {
        this.allowPurchaseOrder = allowPurchaseOrder;
        return this;
    }

    @ApiModelProperty(value="True if this profile is allowed to use a purchase order")
    public Boolean isAllowPurchaseOrder() {
        return this.allowPurchaseOrder;
    }

    public void setAllowPurchaseOrder(Boolean allowPurchaseOrder) {
        this.allowPurchaseOrder = allowPurchaseOrder;
    }

    public CartCustomerProfile billingAddresses(List<CartCustomerProfileAddress> billingAddresses) {
        this.billingAddresses = billingAddresses;
        return this;
    }

    public CartCustomerProfile addBillingAddressesItem(CartCustomerProfileAddress billingAddressesItem) {
        if (this.billingAddresses == null) {
            this.billingAddresses = new ArrayList<CartCustomerProfileAddress>();
        }
        this.billingAddresses.add(billingAddressesItem);
        return this;
    }

    @ApiModelProperty(value="Billing addresses on file for this profile")
    public List<CartCustomerProfileAddress> getBillingAddresses() {
        return this.billingAddresses;
    }

    public void setBillingAddresses(List<CartCustomerProfileAddress> billingAddresses) {
        this.billingAddresses = billingAddresses;
    }

    public CartCustomerProfile creditCards(List<CartCustomerProfileCreditCard> creditCards) {
        this.creditCards = creditCards;
        return this;
    }

    public CartCustomerProfile addCreditCardsItem(CartCustomerProfileCreditCard creditCardsItem) {
        if (this.creditCards == null) {
            this.creditCards = new ArrayList<CartCustomerProfileCreditCard>();
        }
        this.creditCards.add(creditCardsItem);
        return this;
    }

    @ApiModelProperty(value="Credit cards on file for this profile (masked)")
    public List<CartCustomerProfileCreditCard> getCreditCards() {
        return this.creditCards;
    }

    public void setCreditCards(List<CartCustomerProfileCreditCard> creditCards) {
        this.creditCards = creditCards;
    }

    public CartCustomerProfile customerProfileOid(Integer customerProfileOid) {
        this.customerProfileOid = customerProfileOid;
        return this;
    }

    @ApiModelProperty(value="Unique identifier")
    public Integer getCustomerProfileOid() {
        return this.customerProfileOid;
    }

    public void setCustomerProfileOid(Integer customerProfileOid) {
        this.customerProfileOid = customerProfileOid;
    }

    public CartCustomerProfile dhlAccountNumber(String dhlAccountNumber) {
        this.dhlAccountNumber = dhlAccountNumber;
        return this;
    }

    @ApiModelProperty(value="DHL account number on file")
    public String getDhlAccountNumber() {
        return this.dhlAccountNumber;
    }

    public void setDhlAccountNumber(String dhlAccountNumber) {
        this.dhlAccountNumber = dhlAccountNumber;
    }

    public CartCustomerProfile dhlDutyAccountNumber(String dhlDutyAccountNumber) {
        this.dhlDutyAccountNumber = dhlDutyAccountNumber;
        return this;
    }

    @ApiModelProperty(value="DHL duty account number on file")
    public String getDhlDutyAccountNumber() {
        return this.dhlDutyAccountNumber;
    }

    public void setDhlDutyAccountNumber(String dhlDutyAccountNumber) {
        this.dhlDutyAccountNumber = dhlDutyAccountNumber;
    }

    public CartCustomerProfile email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public CartCustomerProfile fedexAccountNumber(String fedexAccountNumber) {
        this.fedexAccountNumber = fedexAccountNumber;
        return this;
    }

    @ApiModelProperty(value="FedEx account number on file")
    public String getFedexAccountNumber() {
        return this.fedexAccountNumber;
    }

    public void setFedexAccountNumber(String fedexAccountNumber) {
        this.fedexAccountNumber = fedexAccountNumber;
    }

    public CartCustomerProfile freeShipping(Boolean freeShipping) {
        this.freeShipping = freeShipping;
        return this;
    }

    @ApiModelProperty(value="True if this profile always qualifies for free shipping")
    public Boolean isFreeShipping() {
        return this.freeShipping;
    }

    public void setFreeShipping(Boolean freeShipping) {
        this.freeShipping = freeShipping;
    }

    public CartCustomerProfile freeShippingMinimum(BigDecimal freeShippingMinimum) {
        this.freeShippingMinimum = freeShippingMinimum;
        return this;
    }

    @ApiModelProperty(value="The minimum aount that this profile has to purchase to qualify for free shipping")
    public BigDecimal getFreeShippingMinimum() {
        return this.freeShippingMinimum;
    }

    public void setFreeShippingMinimum(BigDecimal freeShippingMinimum) {
        this.freeShippingMinimum = freeShippingMinimum;
    }

    public CartCustomerProfile maximumItemCount(Integer maximumItemCount) {
        this.maximumItemCount = maximumItemCount;
        return this;
    }

    @ApiModelProperty(value="Maximum item count this profile can purchase")
    public Integer getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(Integer maximumItemCount) {
        this.maximumItemCount = maximumItemCount;
    }

    public CartCustomerProfile minimumItemCount(Integer minimumItemCount) {
        this.minimumItemCount = minimumItemCount;
        return this;
    }

    @ApiModelProperty(value="Minimum item count this profile must purchase")
    public Integer getMinimumItemCount() {
        return this.minimumItemCount;
    }

    public void setMinimumItemCount(Integer minimumItemCount) {
        this.minimumItemCount = minimumItemCount;
    }

    public CartCustomerProfile minimumSubtotal(BigDecimal minimumSubtotal) {
        this.minimumSubtotal = minimumSubtotal;
        return this;
    }

    @ApiModelProperty(value="Minimum subtotal this profile must purchase")
    public BigDecimal getMinimumSubtotal() {
        return this.minimumSubtotal;
    }

    public void setMinimumSubtotal(BigDecimal minimumSubtotal) {
        this.minimumSubtotal = minimumSubtotal;
    }

    public CartCustomerProfile noCoupons(Boolean noCoupons) {
        this.noCoupons = noCoupons;
        return this;
    }

    @ApiModelProperty(value="True if this profile is prevented from using coupons")
    public Boolean isNoCoupons() {
        return this.noCoupons;
    }

    public void setNoCoupons(Boolean noCoupons) {
        this.noCoupons = noCoupons;
    }

    public CartCustomerProfile noFreeShipping(Boolean noFreeShipping) {
        this.noFreeShipping = noFreeShipping;
        return this;
    }

    @ApiModelProperty(value="True if this profile is never given free shipping")
    public Boolean isNoFreeShipping() {
        return this.noFreeShipping;
    }

    public void setNoFreeShipping(Boolean noFreeShipping) {
        this.noFreeShipping = noFreeShipping;
    }

    public CartCustomerProfile noRealtimeCharge(Boolean noRealtimeCharge) {
        this.noRealtimeCharge = noRealtimeCharge;
        return this;
    }

    @ApiModelProperty(value="True if this customers orders are not charged in real-time")
    public Boolean isNoRealtimeCharge() {
        return this.noRealtimeCharge;
    }

    public void setNoRealtimeCharge(Boolean noRealtimeCharge) {
        this.noRealtimeCharge = noRealtimeCharge;
    }

    public CartCustomerProfile pricingTiers(List<String> pricingTiers) {
        this.pricingTiers = pricingTiers;
        return this;
    }

    public CartCustomerProfile addPricingTiersItem(String pricingTiersItem) {
        if (this.pricingTiers == null) {
            this.pricingTiers = new ArrayList<String>();
        }
        this.pricingTiers.add(pricingTiersItem);
        return this;
    }

    @ApiModelProperty(value="Pricing tier names this profile qualifies for")
    public List<String> getPricingTiers() {
        return this.pricingTiers;
    }

    public void setPricingTiers(List<String> pricingTiers) {
        this.pricingTiers = pricingTiers;
    }

    public CartCustomerProfile shippingAddresses(List<CartCustomerProfileAddress> shippingAddresses) {
        this.shippingAddresses = shippingAddresses;
        return this;
    }

    public CartCustomerProfile addShippingAddressesItem(CartCustomerProfileAddress shippingAddressesItem) {
        if (this.shippingAddresses == null) {
            this.shippingAddresses = new ArrayList<CartCustomerProfileAddress>();
        }
        this.shippingAddresses.add(shippingAddressesItem);
        return this;
    }

    @ApiModelProperty(value="Shipping addresses on file for this profile")
    public List<CartCustomerProfileAddress> getShippingAddresses() {
        return this.shippingAddresses;
    }

    public void setShippingAddresses(List<CartCustomerProfileAddress> shippingAddresses) {
        this.shippingAddresses = shippingAddresses;
    }

    public CartCustomerProfile taxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
        return this;
    }

    @ApiModelProperty(value="True if this profile is exempt from sales tax")
    public Boolean isTaxExempt() {
        return this.taxExempt;
    }

    public void setTaxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
    }

    public CartCustomerProfile upsAccountNumber(String upsAccountNumber) {
        this.upsAccountNumber = upsAccountNumber;
        return this;
    }

    @ApiModelProperty(value="UPS account number on file")
    public String getUpsAccountNumber() {
        return this.upsAccountNumber;
    }

    public void setUpsAccountNumber(String upsAccountNumber) {
        this.upsAccountNumber = upsAccountNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartCustomerProfile cartCustomerProfile = (CartCustomerProfile)o;
        return Objects.equals(this.allow3rdPartyBilling, cartCustomerProfile.allow3rdPartyBilling) && Objects.equals(this.allowCod, cartCustomerProfile.allowCod) && Objects.equals(this.allowPurchaseOrder, cartCustomerProfile.allowPurchaseOrder) && Objects.equals(this.billingAddresses, cartCustomerProfile.billingAddresses) && Objects.equals(this.creditCards, cartCustomerProfile.creditCards) && Objects.equals(this.customerProfileOid, cartCustomerProfile.customerProfileOid) && Objects.equals(this.dhlAccountNumber, cartCustomerProfile.dhlAccountNumber) && Objects.equals(this.dhlDutyAccountNumber, cartCustomerProfile.dhlDutyAccountNumber) && Objects.equals(this.email, cartCustomerProfile.email) && Objects.equals(this.fedexAccountNumber, cartCustomerProfile.fedexAccountNumber) && Objects.equals(this.freeShipping, cartCustomerProfile.freeShipping) && Objects.equals(this.freeShippingMinimum, cartCustomerProfile.freeShippingMinimum) && Objects.equals(this.maximumItemCount, cartCustomerProfile.maximumItemCount) && Objects.equals(this.minimumItemCount, cartCustomerProfile.minimumItemCount) && Objects.equals(this.minimumSubtotal, cartCustomerProfile.minimumSubtotal) && Objects.equals(this.noCoupons, cartCustomerProfile.noCoupons) && Objects.equals(this.noFreeShipping, cartCustomerProfile.noFreeShipping) && Objects.equals(this.noRealtimeCharge, cartCustomerProfile.noRealtimeCharge) && Objects.equals(this.pricingTiers, cartCustomerProfile.pricingTiers) && Objects.equals(this.shippingAddresses, cartCustomerProfile.shippingAddresses) && Objects.equals(this.taxExempt, cartCustomerProfile.taxExempt) && Objects.equals(this.upsAccountNumber, cartCustomerProfile.upsAccountNumber);
    }

    public int hashCode() {
        return Objects.hash(this.allow3rdPartyBilling, this.allowCod, this.allowPurchaseOrder, this.billingAddresses, this.creditCards, this.customerProfileOid, this.dhlAccountNumber, this.dhlDutyAccountNumber, this.email, this.fedexAccountNumber, this.freeShipping, this.freeShippingMinimum, this.maximumItemCount, this.minimumItemCount, this.minimumSubtotal, this.noCoupons, this.noFreeShipping, this.noRealtimeCharge, this.pricingTiers, this.shippingAddresses, this.taxExempt, this.upsAccountNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CartCustomerProfile {\n");
        sb.append("    allow3rdPartyBilling: ").append(this.toIndentedString(this.allow3rdPartyBilling)).append("\n");
        sb.append("    allowCod: ").append(this.toIndentedString(this.allowCod)).append("\n");
        sb.append("    allowPurchaseOrder: ").append(this.toIndentedString(this.allowPurchaseOrder)).append("\n");
        sb.append("    billingAddresses: ").append(this.toIndentedString(this.billingAddresses)).append("\n");
        sb.append("    creditCards: ").append(this.toIndentedString(this.creditCards)).append("\n");
        sb.append("    customerProfileOid: ").append(this.toIndentedString(this.customerProfileOid)).append("\n");
        sb.append("    dhlAccountNumber: ").append(this.toIndentedString(this.dhlAccountNumber)).append("\n");
        sb.append("    dhlDutyAccountNumber: ").append(this.toIndentedString(this.dhlDutyAccountNumber)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fedexAccountNumber: ").append(this.toIndentedString(this.fedexAccountNumber)).append("\n");
        sb.append("    freeShipping: ").append(this.toIndentedString(this.freeShipping)).append("\n");
        sb.append("    freeShippingMinimum: ").append(this.toIndentedString(this.freeShippingMinimum)).append("\n");
        sb.append("    maximumItemCount: ").append(this.toIndentedString(this.maximumItemCount)).append("\n");
        sb.append("    minimumItemCount: ").append(this.toIndentedString(this.minimumItemCount)).append("\n");
        sb.append("    minimumSubtotal: ").append(this.toIndentedString(this.minimumSubtotal)).append("\n");
        sb.append("    noCoupons: ").append(this.toIndentedString(this.noCoupons)).append("\n");
        sb.append("    noFreeShipping: ").append(this.toIndentedString(this.noFreeShipping)).append("\n");
        sb.append("    noRealtimeCharge: ").append(this.toIndentedString(this.noRealtimeCharge)).append("\n");
        sb.append("    pricingTiers: ").append(this.toIndentedString(this.pricingTiers)).append("\n");
        sb.append("    shippingAddresses: ").append(this.toIndentedString(this.shippingAddresses)).append("\n");
        sb.append("    taxExempt: ").append(this.toIndentedString(this.taxExempt)).append("\n");
        sb.append("    upsAccountNumber: ").append(this.toIndentedString(this.upsAccountNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

