/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ultracart.admin.v2.models.AutoOrderItemFutureSchedule;
import com.ultracart.admin.v2.models.AutoOrderItemOption;
import com.ultracart.admin.v2.models.AutoOrderItemSimpleSchedule;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AutoOrderItem {
    @SerializedName(value="arbitrary_item_id")
    private String arbitraryItemId = null;
    @SerializedName(value="arbitrary_percentage_discount")
    private BigDecimal arbitraryPercentageDiscount = null;
    @SerializedName(value="arbitrary_quantity")
    private BigDecimal arbitraryQuantity = null;
    @SerializedName(value="arbitrary_schedule_days")
    private Integer arbitraryScheduleDays = null;
    @SerializedName(value="arbitrary_unit_cost")
    private BigDecimal arbitraryUnitCost = null;
    @SerializedName(value="arbitrary_unit_cost_remaining_orders")
    private Integer arbitraryUnitCostRemainingOrders = null;
    @SerializedName(value="auto_order_item_oid")
    private Integer autoOrderItemOid = null;
    @SerializedName(value="frequency")
    private FrequencyEnum frequency = null;
    @SerializedName(value="future_schedules")
    private List<AutoOrderItemFutureSchedule> futureSchedules = null;
    @SerializedName(value="last_order_dts")
    private String lastOrderDts = null;
    @SerializedName(value="life_time_value")
    private BigDecimal lifeTimeValue = null;
    @SerializedName(value="next_preshipment_notice_dts")
    private String nextPreshipmentNoticeDts = null;
    @SerializedName(value="next_shipment_dts")
    private String nextShipmentDts = null;
    @SerializedName(value="no_order_after_dts")
    private String noOrderAfterDts = null;
    @SerializedName(value="number_of_rebills")
    private Integer numberOfRebills = null;
    @SerializedName(value="options")
    private List<AutoOrderItemOption> options = null;
    @SerializedName(value="original_item_id")
    private String originalItemId = null;
    @SerializedName(value="original_quantity")
    private BigDecimal originalQuantity = null;
    @SerializedName(value="paypal_payer_id")
    private String paypalPayerId = null;
    @SerializedName(value="paypal_recurring_payment_profile_id")
    private String paypalRecurringPaymentProfileId = null;
    @SerializedName(value="preshipment_notice_sent")
    private Boolean preshipmentNoticeSent = null;
    @SerializedName(value="rebill_value")
    private BigDecimal rebillValue = null;
    @SerializedName(value="remaining_repeat_count")
    private Integer remainingRepeatCount = null;
    @SerializedName(value="simple_schedule")
    private AutoOrderItemSimpleSchedule simpleSchedule = null;

    public AutoOrderItem arbitraryItemId(String arbitraryItemId) {
        this.arbitraryItemId = arbitraryItemId;
        return this;
    }

    @ApiModelProperty(value="Arbitrary item id that should be rebilled instead of the normal schedule")
    public String getArbitraryItemId() {
        return this.arbitraryItemId;
    }

    public void setArbitraryItemId(String arbitraryItemId) {
        this.arbitraryItemId = arbitraryItemId;
    }

    public AutoOrderItem arbitraryPercentageDiscount(BigDecimal arbitraryPercentageDiscount) {
        this.arbitraryPercentageDiscount = arbitraryPercentageDiscount;
        return this;
    }

    @ApiModelProperty(value="An arbitrary percentage discount to provide on future rebills")
    public BigDecimal getArbitraryPercentageDiscount() {
        return this.arbitraryPercentageDiscount;
    }

    public void setArbitraryPercentageDiscount(BigDecimal arbitraryPercentageDiscount) {
        this.arbitraryPercentageDiscount = arbitraryPercentageDiscount;
    }

    public AutoOrderItem arbitraryQuantity(BigDecimal arbitraryQuantity) {
        this.arbitraryQuantity = arbitraryQuantity;
        return this;
    }

    @ApiModelProperty(value="Arbitrary quantity to rebill")
    public BigDecimal getArbitraryQuantity() {
        return this.arbitraryQuantity;
    }

    public void setArbitraryQuantity(BigDecimal arbitraryQuantity) {
        this.arbitraryQuantity = arbitraryQuantity;
    }

    public AutoOrderItem arbitraryScheduleDays(Integer arbitraryScheduleDays) {
        this.arbitraryScheduleDays = arbitraryScheduleDays;
        return this;
    }

    @ApiModelProperty(value="The number of days to rebill if the frequency is set to an arbitrary number of days")
    public Integer getArbitraryScheduleDays() {
        return this.arbitraryScheduleDays;
    }

    public void setArbitraryScheduleDays(Integer arbitraryScheduleDays) {
        this.arbitraryScheduleDays = arbitraryScheduleDays;
    }

    public AutoOrderItem arbitraryUnitCost(BigDecimal arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
        return this;
    }

    @ApiModelProperty(value="Arbitrary unit cost that rebills of this item should occur at")
    public BigDecimal getArbitraryUnitCost() {
        return this.arbitraryUnitCost;
    }

    public void setArbitraryUnitCost(BigDecimal arbitraryUnitCost) {
        this.arbitraryUnitCost = arbitraryUnitCost;
    }

    public AutoOrderItem arbitraryUnitCostRemainingOrders(Integer arbitraryUnitCostRemainingOrders) {
        this.arbitraryUnitCostRemainingOrders = arbitraryUnitCostRemainingOrders;
        return this;
    }

    @ApiModelProperty(value="The number of rebills to give the arbitrary unit cost on before reverting to normal pricing.")
    public Integer getArbitraryUnitCostRemainingOrders() {
        return this.arbitraryUnitCostRemainingOrders;
    }

    public void setArbitraryUnitCostRemainingOrders(Integer arbitraryUnitCostRemainingOrders) {
        this.arbitraryUnitCostRemainingOrders = arbitraryUnitCostRemainingOrders;
    }

    public AutoOrderItem autoOrderItemOid(Integer autoOrderItemOid) {
        this.autoOrderItemOid = autoOrderItemOid;
        return this;
    }

    @ApiModelProperty(value="Primary key of AutoOrderItem")
    public Integer getAutoOrderItemOid() {
        return this.autoOrderItemOid;
    }

    public void setAutoOrderItemOid(Integer autoOrderItemOid) {
        this.autoOrderItemOid = autoOrderItemOid;
    }

    public AutoOrderItem frequency(FrequencyEnum frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(value="Frequency of the rebill if not a fixed schedule")
    public FrequencyEnum getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyEnum frequency) {
        this.frequency = frequency;
    }

    public AutoOrderItem futureSchedules(List<AutoOrderItemFutureSchedule> futureSchedules) {
        this.futureSchedules = futureSchedules;
        return this;
    }

    public AutoOrderItem addFutureSchedulesItem(AutoOrderItemFutureSchedule futureSchedulesItem) {
        if (this.futureSchedules == null) {
            this.futureSchedules = new ArrayList<AutoOrderItemFutureSchedule>();
        }
        this.futureSchedules.add(futureSchedulesItem);
        return this;
    }

    @ApiModelProperty(value="The future rebill schedule for this item up to the next ten rebills")
    public List<AutoOrderItemFutureSchedule> getFutureSchedules() {
        return this.futureSchedules;
    }

    public void setFutureSchedules(List<AutoOrderItemFutureSchedule> futureSchedules) {
        this.futureSchedules = futureSchedules;
    }

    public AutoOrderItem lastOrderDts(String lastOrderDts) {
        this.lastOrderDts = lastOrderDts;
        return this;
    }

    @ApiModelProperty(value="Date/time of the last order of this item")
    public String getLastOrderDts() {
        return this.lastOrderDts;
    }

    public void setLastOrderDts(String lastOrderDts) {
        this.lastOrderDts = lastOrderDts;
    }

    public AutoOrderItem lifeTimeValue(BigDecimal lifeTimeValue) {
        this.lifeTimeValue = lifeTimeValue;
        return this;
    }

    @ApiModelProperty(value="The life time value of this item including the original purchase")
    public BigDecimal getLifeTimeValue() {
        return this.lifeTimeValue;
    }

    public void setLifeTimeValue(BigDecimal lifeTimeValue) {
        this.lifeTimeValue = lifeTimeValue;
    }

    public AutoOrderItem nextPreshipmentNoticeDts(String nextPreshipmentNoticeDts) {
        this.nextPreshipmentNoticeDts = nextPreshipmentNoticeDts;
        return this;
    }

    @ApiModelProperty(value="The date/time of when the next pre-shipment notice should be sent")
    public String getNextPreshipmentNoticeDts() {
        return this.nextPreshipmentNoticeDts;
    }

    public void setNextPreshipmentNoticeDts(String nextPreshipmentNoticeDts) {
        this.nextPreshipmentNoticeDts = nextPreshipmentNoticeDts;
    }

    public AutoOrderItem nextShipmentDts(String nextShipmentDts) {
        this.nextShipmentDts = nextShipmentDts;
        return this;
    }

    @ApiModelProperty(value="Date/time that this item is scheduled to rebill")
    public String getNextShipmentDts() {
        return this.nextShipmentDts;
    }

    public void setNextShipmentDts(String nextShipmentDts) {
        this.nextShipmentDts = nextShipmentDts;
    }

    public AutoOrderItem noOrderAfterDts(String noOrderAfterDts) {
        this.noOrderAfterDts = noOrderAfterDts;
        return this;
    }

    @ApiModelProperty(value="Date/time after which no additional rebills of this item should occur")
    public String getNoOrderAfterDts() {
        return this.noOrderAfterDts;
    }

    public void setNoOrderAfterDts(String noOrderAfterDts) {
        this.noOrderAfterDts = noOrderAfterDts;
    }

    public AutoOrderItem numberOfRebills(Integer numberOfRebills) {
        this.numberOfRebills = numberOfRebills;
        return this;
    }

    @ApiModelProperty(value="The number of times this item has rebilled")
    public Integer getNumberOfRebills() {
        return this.numberOfRebills;
    }

    public void setNumberOfRebills(Integer numberOfRebills) {
        this.numberOfRebills = numberOfRebills;
    }

    public AutoOrderItem options(List<AutoOrderItemOption> options) {
        this.options = options;
        return this;
    }

    public AutoOrderItem addOptionsItem(AutoOrderItemOption optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<AutoOrderItemOption>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="Options associated with this item")
    public List<AutoOrderItemOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<AutoOrderItemOption> options) {
        this.options = options;
    }

    public AutoOrderItem originalItemId(String originalItemId) {
        this.originalItemId = originalItemId;
        return this;
    }

    @ApiModelProperty(value="The original item id purchased.  This item controls scheduling.  If you wish to modify a schedule, for example, from monthly to yearly, change this item from your monthly item to your yearly item, and then change the next_shipment_dts to your desired date.")
    public String getOriginalItemId() {
        return this.originalItemId;
    }

    public void setOriginalItemId(String originalItemId) {
        this.originalItemId = originalItemId;
    }

    public AutoOrderItem originalQuantity(BigDecimal originalQuantity) {
        this.originalQuantity = originalQuantity;
        return this;
    }

    @ApiModelProperty(value="The original quantity purchased")
    public BigDecimal getOriginalQuantity() {
        return this.originalQuantity;
    }

    public void setOriginalQuantity(BigDecimal originalQuantity) {
        this.originalQuantity = originalQuantity;
    }

    public AutoOrderItem paypalPayerId(String paypalPayerId) {
        this.paypalPayerId = paypalPayerId;
        return this;
    }

    @ApiModelProperty(value="The PayPal Payer ID tied to this item")
    public String getPaypalPayerId() {
        return this.paypalPayerId;
    }

    public void setPaypalPayerId(String paypalPayerId) {
        this.paypalPayerId = paypalPayerId;
    }

    public AutoOrderItem paypalRecurringPaymentProfileId(String paypalRecurringPaymentProfileId) {
        this.paypalRecurringPaymentProfileId = paypalRecurringPaymentProfileId;
        return this;
    }

    @ApiModelProperty(value="The PayPal Profile ID tied to this item")
    public String getPaypalRecurringPaymentProfileId() {
        return this.paypalRecurringPaymentProfileId;
    }

    public void setPaypalRecurringPaymentProfileId(String paypalRecurringPaymentProfileId) {
        this.paypalRecurringPaymentProfileId = paypalRecurringPaymentProfileId;
    }

    public AutoOrderItem preshipmentNoticeSent(Boolean preshipmentNoticeSent) {
        this.preshipmentNoticeSent = preshipmentNoticeSent;
        return this;
    }

    @ApiModelProperty(value="True if the preshipment notice associated with the next rebill has been sent")
    public Boolean isPreshipmentNoticeSent() {
        return this.preshipmentNoticeSent;
    }

    public void setPreshipmentNoticeSent(Boolean preshipmentNoticeSent) {
        this.preshipmentNoticeSent = preshipmentNoticeSent;
    }

    public AutoOrderItem rebillValue(BigDecimal rebillValue) {
        this.rebillValue = rebillValue;
        return this;
    }

    @ApiModelProperty(value="The value of the rebills of this item")
    public BigDecimal getRebillValue() {
        return this.rebillValue;
    }

    public void setRebillValue(BigDecimal rebillValue) {
        this.rebillValue = rebillValue;
    }

    public AutoOrderItem remainingRepeatCount(Integer remainingRepeatCount) {
        this.remainingRepeatCount = remainingRepeatCount;
        return this;
    }

    @ApiModelProperty(value="The number of rebills remaining before this item is complete")
    public Integer getRemainingRepeatCount() {
        return this.remainingRepeatCount;
    }

    public void setRemainingRepeatCount(Integer remainingRepeatCount) {
        this.remainingRepeatCount = remainingRepeatCount;
    }

    public AutoOrderItem simpleSchedule(AutoOrderItemSimpleSchedule simpleSchedule) {
        this.simpleSchedule = simpleSchedule;
        return this;
    }

    @ApiModelProperty(value="")
    public AutoOrderItemSimpleSchedule getSimpleSchedule() {
        return this.simpleSchedule;
    }

    public void setSimpleSchedule(AutoOrderItemSimpleSchedule simpleSchedule) {
        this.simpleSchedule = simpleSchedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoOrderItem autoOrderItem = (AutoOrderItem)o;
        return Objects.equals(this.arbitraryItemId, autoOrderItem.arbitraryItemId) && Objects.equals(this.arbitraryPercentageDiscount, autoOrderItem.arbitraryPercentageDiscount) && Objects.equals(this.arbitraryQuantity, autoOrderItem.arbitraryQuantity) && Objects.equals(this.arbitraryScheduleDays, autoOrderItem.arbitraryScheduleDays) && Objects.equals(this.arbitraryUnitCost, autoOrderItem.arbitraryUnitCost) && Objects.equals(this.arbitraryUnitCostRemainingOrders, autoOrderItem.arbitraryUnitCostRemainingOrders) && Objects.equals(this.autoOrderItemOid, autoOrderItem.autoOrderItemOid) && Objects.equals((Object)this.frequency, (Object)autoOrderItem.frequency) && Objects.equals(this.futureSchedules, autoOrderItem.futureSchedules) && Objects.equals(this.lastOrderDts, autoOrderItem.lastOrderDts) && Objects.equals(this.lifeTimeValue, autoOrderItem.lifeTimeValue) && Objects.equals(this.nextPreshipmentNoticeDts, autoOrderItem.nextPreshipmentNoticeDts) && Objects.equals(this.nextShipmentDts, autoOrderItem.nextShipmentDts) && Objects.equals(this.noOrderAfterDts, autoOrderItem.noOrderAfterDts) && Objects.equals(this.numberOfRebills, autoOrderItem.numberOfRebills) && Objects.equals(this.options, autoOrderItem.options) && Objects.equals(this.originalItemId, autoOrderItem.originalItemId) && Objects.equals(this.originalQuantity, autoOrderItem.originalQuantity) && Objects.equals(this.paypalPayerId, autoOrderItem.paypalPayerId) && Objects.equals(this.paypalRecurringPaymentProfileId, autoOrderItem.paypalRecurringPaymentProfileId) && Objects.equals(this.preshipmentNoticeSent, autoOrderItem.preshipmentNoticeSent) && Objects.equals(this.rebillValue, autoOrderItem.rebillValue) && Objects.equals(this.remainingRepeatCount, autoOrderItem.remainingRepeatCount) && Objects.equals(this.simpleSchedule, autoOrderItem.simpleSchedule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arbitraryItemId, this.arbitraryPercentageDiscount, this.arbitraryQuantity, this.arbitraryScheduleDays, this.arbitraryUnitCost, this.arbitraryUnitCostRemainingOrders, this.autoOrderItemOid, this.frequency, this.futureSchedules, this.lastOrderDts, this.lifeTimeValue, this.nextPreshipmentNoticeDts, this.nextShipmentDts, this.noOrderAfterDts, this.numberOfRebills, this.options, this.originalItemId, this.originalQuantity, this.paypalPayerId, this.paypalRecurringPaymentProfileId, this.preshipmentNoticeSent, this.rebillValue, this.remainingRepeatCount, this.simpleSchedule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoOrderItem {\n");
        sb.append("    arbitraryItemId: ").append(this.toIndentedString(this.arbitraryItemId)).append("\n");
        sb.append("    arbitraryPercentageDiscount: ").append(this.toIndentedString(this.arbitraryPercentageDiscount)).append("\n");
        sb.append("    arbitraryQuantity: ").append(this.toIndentedString(this.arbitraryQuantity)).append("\n");
        sb.append("    arbitraryScheduleDays: ").append(this.toIndentedString(this.arbitraryScheduleDays)).append("\n");
        sb.append("    arbitraryUnitCost: ").append(this.toIndentedString(this.arbitraryUnitCost)).append("\n");
        sb.append("    arbitraryUnitCostRemainingOrders: ").append(this.toIndentedString(this.arbitraryUnitCostRemainingOrders)).append("\n");
        sb.append("    autoOrderItemOid: ").append(this.toIndentedString(this.autoOrderItemOid)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    futureSchedules: ").append(this.toIndentedString(this.futureSchedules)).append("\n");
        sb.append("    lastOrderDts: ").append(this.toIndentedString(this.lastOrderDts)).append("\n");
        sb.append("    lifeTimeValue: ").append(this.toIndentedString(this.lifeTimeValue)).append("\n");
        sb.append("    nextPreshipmentNoticeDts: ").append(this.toIndentedString(this.nextPreshipmentNoticeDts)).append("\n");
        sb.append("    nextShipmentDts: ").append(this.toIndentedString(this.nextShipmentDts)).append("\n");
        sb.append("    noOrderAfterDts: ").append(this.toIndentedString(this.noOrderAfterDts)).append("\n");
        sb.append("    numberOfRebills: ").append(this.toIndentedString(this.numberOfRebills)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    originalItemId: ").append(this.toIndentedString(this.originalItemId)).append("\n");
        sb.append("    originalQuantity: ").append(this.toIndentedString(this.originalQuantity)).append("\n");
        sb.append("    paypalPayerId: ").append(this.toIndentedString(this.paypalPayerId)).append("\n");
        sb.append("    paypalRecurringPaymentProfileId: ").append(this.toIndentedString(this.paypalRecurringPaymentProfileId)).append("\n");
        sb.append("    preshipmentNoticeSent: ").append(this.toIndentedString(this.preshipmentNoticeSent)).append("\n");
        sb.append("    rebillValue: ").append(this.toIndentedString(this.rebillValue)).append("\n");
        sb.append("    remainingRepeatCount: ").append(this.toIndentedString(this.remainingRepeatCount)).append("\n");
        sb.append("    simpleSchedule: ").append(this.toIndentedString(this.simpleSchedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FrequencyEnum {
        WEEKLY("Weekly"),
        BIWEEKLY("Biweekly"),
        EVERY_("Every..."),
        EVERY_10_DAYS("Every 10 Days"),
        EVERY_24_DAYS("Every 24 Days"),
        EVERY_28_DAYS("Every 28 Days"),
        MONTHLY("Monthly"),
        EVERY_45_DAYS("Every 45 Days"),
        EVERY_2_MONTHS("Every 2 Months"),
        EVERY_3_MONTHS("Every 3 Months"),
        EVERY_4_MONTHS("Every 4 Months"),
        EVERY_6_MONTHS("Every 6 Months"),
        YEARLY("Yearly");

        private String value;

        private FrequencyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FrequencyEnum fromValue(String text) {
            for (FrequencyEnum b : FrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FrequencyEnum> {
            public void write(JsonWriter jsonWriter, FrequencyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FrequencyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FrequencyEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

