/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class ApplyLibraryItemRequest {
    @SerializedName(value="email_uuid")
    private String emailUuid = null;
    @SerializedName(value="library_item_oid")
    private Integer libraryItemOid = null;
    @SerializedName(value="postcard_uuid")
    private String postcardUuid = null;
    @SerializedName(value="storefront_oid")
    private Integer storefrontOid = null;

    public ApplyLibraryItemRequest emailUuid(String emailUuid) {
        this.emailUuid = emailUuid;
        return this;
    }

    @ApiModelProperty(value="Normal emails are applied to an existing email object, so when requesting a library item to be applied to an email, supply the email uuid.  This is only for normal emails.  Transactional emails do not have a uuid.")
    public String getEmailUuid() {
        return this.emailUuid;
    }

    public void setEmailUuid(String emailUuid) {
        this.emailUuid = emailUuid;
    }

    public ApplyLibraryItemRequest libraryItemOid(Integer libraryItemOid) {
        this.libraryItemOid = libraryItemOid;
        return this;
    }

    @ApiModelProperty(value="Library item oid that you wish to apply to the given StoreFront")
    public Integer getLibraryItemOid() {
        return this.libraryItemOid;
    }

    public void setLibraryItemOid(Integer libraryItemOid) {
        this.libraryItemOid = libraryItemOid;
    }

    public ApplyLibraryItemRequest postcardUuid(String postcardUuid) {
        this.postcardUuid = postcardUuid;
        return this;
    }

    @ApiModelProperty(value="The postcard uuid you wish to apply to a given StoreFront.")
    public String getPostcardUuid() {
        return this.postcardUuid;
    }

    public void setPostcardUuid(String postcardUuid) {
        this.postcardUuid = postcardUuid;
    }

    public ApplyLibraryItemRequest storefrontOid(Integer storefrontOid) {
        this.storefrontOid = storefrontOid;
        return this;
    }

    @ApiModelProperty(value="StoreFront oid where content originates necessary for tracking down relative assets")
    public Integer getStorefrontOid() {
        return this.storefrontOid;
    }

    public void setStorefrontOid(Integer storefrontOid) {
        this.storefrontOid = storefrontOid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplyLibraryItemRequest applyLibraryItemRequest = (ApplyLibraryItemRequest)o;
        return Objects.equals(this.emailUuid, applyLibraryItemRequest.emailUuid) && Objects.equals(this.libraryItemOid, applyLibraryItemRequest.libraryItemOid) && Objects.equals(this.postcardUuid, applyLibraryItemRequest.postcardUuid) && Objects.equals(this.storefrontOid, applyLibraryItemRequest.storefrontOid);
    }

    public int hashCode() {
        return Objects.hash(this.emailUuid, this.libraryItemOid, this.postcardUuid, this.storefrontOid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplyLibraryItemRequest {\n");
        sb.append("    emailUuid: ").append(this.toIndentedString(this.emailUuid)).append("\n");
        sb.append("    libraryItemOid: ").append(this.toIndentedString(this.libraryItemOid)).append("\n");
        sb.append("    postcardUuid: ").append(this.toIndentedString(this.postcardUuid)).append("\n");
        sb.append("    storefrontOid: ").append(this.toIndentedString(this.storefrontOid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

