/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.LibraryItemAttribute;
import com.ultracart.admin.v2.models.LibraryItemScreenshot;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AddLibraryItemRequest {
    @SerializedName(value="attributes")
    private List<LibraryItemAttribute> attributes = null;
    @SerializedName(value="cjson")
    private String cjson = null;
    @SerializedName(value="content_type")
    private String contentType = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="email_name")
    private String emailName = null;
    @SerializedName(value="email_path")
    private String emailPath = null;
    @SerializedName(value="screenshots")
    private List<LibraryItemScreenshot> screenshots = null;
    @SerializedName(value="storefront_oid")
    private Integer storefrontOid = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="upsell_offer_oid")
    private Integer upsellOfferOid = null;
    @SerializedName(value="uuid")
    private String uuid = null;

    public AddLibraryItemRequest attributes(List<LibraryItemAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public AddLibraryItemRequest addAttributesItem(LibraryItemAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<LibraryItemAttribute>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @ApiModelProperty(value="Attributes associated with the library item to contain additional configuration.")
    public List<LibraryItemAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<LibraryItemAttribute> attributes) {
        this.attributes = attributes;
    }

    public AddLibraryItemRequest cjson(String cjson) {
        this.cjson = cjson;
        return this;
    }

    @ApiModelProperty(value="Cjson to be added to library")
    public String getCjson() {
        return this.cjson;
    }

    public void setCjson(String cjson) {
        this.cjson = cjson;
    }

    public AddLibraryItemRequest contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(value="flow, campaign, cjson, email, transactional_email, postcard or upsell")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public AddLibraryItemRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="description of library item")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AddLibraryItemRequest emailName(String emailName) {
        this.emailName = emailName;
        return this;
    }

    @ApiModelProperty(value="Required if content_type is transactional_email. This is the name of the email template (html, not text).  This name should have a .vm file extension.  An example is auto_order_cancel_html.vm")
    public String getEmailName() {
        return this.emailName;
    }

    public void setEmailName(String emailName) {
        this.emailName = emailName;
    }

    public AddLibraryItemRequest emailPath(String emailPath) {
        this.emailPath = emailPath;
        return this;
    }

    @ApiModelProperty(value="Required if content_type is transactional_email. This is the full path to the email template stored in the file system.  This defines which StoreFront contains the desired email template.  An example is /themes/Elements/core/emails/auto_order_cancel_html.vm")
    public String getEmailPath() {
        return this.emailPath;
    }

    public void setEmailPath(String emailPath) {
        this.emailPath = emailPath;
    }

    public AddLibraryItemRequest screenshots(List<LibraryItemScreenshot> screenshots) {
        this.screenshots = screenshots;
        return this;
    }

    public AddLibraryItemRequest addScreenshotsItem(LibraryItemScreenshot screenshotsItem) {
        if (this.screenshots == null) {
            this.screenshots = new ArrayList<LibraryItemScreenshot>();
        }
        this.screenshots.add(screenshotsItem);
        return this;
    }

    @ApiModelProperty(value="Screenshot urls for display")
    public List<LibraryItemScreenshot> getScreenshots() {
        return this.screenshots;
    }

    public void setScreenshots(List<LibraryItemScreenshot> screenshots) {
        this.screenshots = screenshots;
    }

    public AddLibraryItemRequest storefrontOid(Integer storefrontOid) {
        this.storefrontOid = storefrontOid;
        return this;
    }

    @ApiModelProperty(value="StoreFront oid where content originates necessary for tracking down relative assets")
    public Integer getStorefrontOid() {
        return this.storefrontOid;
    }

    public void setStorefrontOid(Integer storefrontOid) {
        this.storefrontOid = storefrontOid;
    }

    public AddLibraryItemRequest title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="title of library item, usually the name of the flow or campaign, or description of cjson")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AddLibraryItemRequest upsellOfferOid(Integer upsellOfferOid) {
        this.upsellOfferOid = upsellOfferOid;
        return this;
    }

    @ApiModelProperty(value="Required if content_type is upsell. This is object identifier of a StoreFront Upsell Offer.")
    public Integer getUpsellOfferOid() {
        return this.upsellOfferOid;
    }

    public void setUpsellOfferOid(Integer upsellOfferOid) {
        this.upsellOfferOid = upsellOfferOid;
    }

    public AddLibraryItemRequest uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(value="UUID of communication flow, campaign, email, postcard, or null if this item is something else. transactional_email do not have a uuid because they are singleton objects within a storefront and easily identifiable by name")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddLibraryItemRequest addLibraryItemRequest = (AddLibraryItemRequest)o;
        return Objects.equals(this.attributes, addLibraryItemRequest.attributes) && Objects.equals(this.cjson, addLibraryItemRequest.cjson) && Objects.equals(this.contentType, addLibraryItemRequest.contentType) && Objects.equals(this.description, addLibraryItemRequest.description) && Objects.equals(this.emailName, addLibraryItemRequest.emailName) && Objects.equals(this.emailPath, addLibraryItemRequest.emailPath) && Objects.equals(this.screenshots, addLibraryItemRequest.screenshots) && Objects.equals(this.storefrontOid, addLibraryItemRequest.storefrontOid) && Objects.equals(this.title, addLibraryItemRequest.title) && Objects.equals(this.upsellOfferOid, addLibraryItemRequest.upsellOfferOid) && Objects.equals(this.uuid, addLibraryItemRequest.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.cjson, this.contentType, this.description, this.emailName, this.emailPath, this.screenshots, this.storefrontOid, this.title, this.upsellOfferOid, this.uuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddLibraryItemRequest {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    cjson: ").append(this.toIndentedString(this.cjson)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    emailName: ").append(this.toIndentedString(this.emailName)).append("\n");
        sb.append("    emailPath: ").append(this.toIndentedString(this.emailPath)).append("\n");
        sb.append("    screenshots: ").append(this.toIndentedString(this.screenshots)).append("\n");
        sb.append("    storefrontOid: ").append(this.toIndentedString(this.storefrontOid)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    upsellOfferOid: ").append(this.toIndentedString(this.upsellOfferOid)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

