/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2.models;

import com.google.gson.annotations.SerializedName;
import com.ultracart.admin.v2.models.AccountsReceivableRetryDayActivity;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AccountsReceivableRetryConfig {
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="allow_process_linked_accounts")
    private Boolean allowProcessLinkedAccounts = null;
    @SerializedName(value="cancel_auto_order")
    private Boolean cancelAutoOrder = null;
    @SerializedName(value="current_service_plan")
    private String currentServicePlan = null;
    @SerializedName(value="daily_activity_list")
    private List<AccountsReceivableRetryDayActivity> dailyActivityList = null;
    @SerializedName(value="managed_by_linked_account_merchant_id")
    private Boolean managedByLinkedAccountMerchantId = null;
    @SerializedName(value="merchant_id")
    private String merchantId = null;
    @SerializedName(value="notify_emails")
    private List<String> notifyEmails = null;
    @SerializedName(value="notify_rejections")
    private Boolean notifyRejections = null;
    @SerializedName(value="notify_successes")
    private Boolean notifySuccesses = null;
    @SerializedName(value="process_linked_accounts")
    private Boolean processLinkedAccounts = null;
    @SerializedName(value="processing_percentage")
    private String processingPercentage = null;
    @SerializedName(value="reject_at_end")
    private Boolean rejectAtEnd = null;
    @SerializedName(value="trial_mode")
    private Boolean trialMode = null;
    @SerializedName(value="trial_mode_expiration_dts")
    private String trialModeExpirationDts = null;

    public AccountsReceivableRetryConfig active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="True if the retry should run daily.  False puts the retry service into an inactive state for this merchant.")
    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public AccountsReceivableRetryConfig allowProcessLinkedAccounts(Boolean allowProcessLinkedAccounts) {
        this.allowProcessLinkedAccounts = allowProcessLinkedAccounts;
        return this;
    }

    @ApiModelProperty(value="True if this account has linked accounts that it can process.")
    public Boolean isAllowProcessLinkedAccounts() {
        return this.allowProcessLinkedAccounts;
    }

    public void setAllowProcessLinkedAccounts(Boolean allowProcessLinkedAccounts) {
        this.allowProcessLinkedAccounts = allowProcessLinkedAccounts;
    }

    public AccountsReceivableRetryConfig cancelAutoOrder(Boolean cancelAutoOrder) {
        this.cancelAutoOrder = cancelAutoOrder;
        return this;
    }

    @ApiModelProperty(value="If true also cancel the auto order if the order is rejected at the end")
    public Boolean isCancelAutoOrder() {
        return this.cancelAutoOrder;
    }

    public void setCancelAutoOrder(Boolean cancelAutoOrder) {
        this.cancelAutoOrder = cancelAutoOrder;
    }

    public AccountsReceivableRetryConfig currentServicePlan(String currentServicePlan) {
        this.currentServicePlan = currentServicePlan;
        return this;
    }

    @ApiModelProperty(value="The current service plan that the account is on.")
    public String getCurrentServicePlan() {
        return this.currentServicePlan;
    }

    public void setCurrentServicePlan(String currentServicePlan) {
        this.currentServicePlan = currentServicePlan;
    }

    public AccountsReceivableRetryConfig dailyActivityList(List<AccountsReceivableRetryDayActivity> dailyActivityList) {
        this.dailyActivityList = dailyActivityList;
        return this;
    }

    public AccountsReceivableRetryConfig addDailyActivityListItem(AccountsReceivableRetryDayActivity dailyActivityListItem) {
        if (this.dailyActivityList == null) {
            this.dailyActivityList = new ArrayList<AccountsReceivableRetryDayActivity>();
        }
        this.dailyActivityList.add(dailyActivityListItem);
        return this;
    }

    @ApiModelProperty(value="A list of days and what actions should take place on those days after an order reaches accounts receivable")
    public List<AccountsReceivableRetryDayActivity> getDailyActivityList() {
        return this.dailyActivityList;
    }

    public void setDailyActivityList(List<AccountsReceivableRetryDayActivity> dailyActivityList) {
        this.dailyActivityList = dailyActivityList;
    }

    public AccountsReceivableRetryConfig managedByLinkedAccountMerchantId(Boolean managedByLinkedAccountMerchantId) {
        this.managedByLinkedAccountMerchantId = managedByLinkedAccountMerchantId;
        return this;
    }

    @ApiModelProperty(value="If not null, this account is managed by the specified parent merchant id.")
    public Boolean isManagedByLinkedAccountMerchantId() {
        return this.managedByLinkedAccountMerchantId;
    }

    public void setManagedByLinkedAccountMerchantId(Boolean managedByLinkedAccountMerchantId) {
        this.managedByLinkedAccountMerchantId = managedByLinkedAccountMerchantId;
    }

    public AccountsReceivableRetryConfig merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="UltraCart merchant ID")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public AccountsReceivableRetryConfig notifyEmails(List<String> notifyEmails) {
        this.notifyEmails = notifyEmails;
        return this;
    }

    public AccountsReceivableRetryConfig addNotifyEmailsItem(String notifyEmailsItem) {
        if (this.notifyEmails == null) {
            this.notifyEmails = new ArrayList<String>();
        }
        this.notifyEmails.add(notifyEmailsItem);
        return this;
    }

    @ApiModelProperty(value="A list of email addresses to receive summary notifications from the retry service.")
    public List<String> getNotifyEmails() {
        return this.notifyEmails;
    }

    public void setNotifyEmails(List<String> notifyEmails) {
        this.notifyEmails = notifyEmails;
    }

    public AccountsReceivableRetryConfig notifyRejections(Boolean notifyRejections) {
        this.notifyRejections = notifyRejections;
        return this;
    }

    @ApiModelProperty(value="If true, email addresses are notified of rejections.")
    public Boolean isNotifyRejections() {
        return this.notifyRejections;
    }

    public void setNotifyRejections(Boolean notifyRejections) {
        this.notifyRejections = notifyRejections;
    }

    public AccountsReceivableRetryConfig notifySuccesses(Boolean notifySuccesses) {
        this.notifySuccesses = notifySuccesses;
        return this;
    }

    @ApiModelProperty(value="If true, email addresses are notified of successful charges.")
    public Boolean isNotifySuccesses() {
        return this.notifySuccesses;
    }

    public void setNotifySuccesses(Boolean notifySuccesses) {
        this.notifySuccesses = notifySuccesses;
    }

    public AccountsReceivableRetryConfig processLinkedAccounts(Boolean processLinkedAccounts) {
        this.processLinkedAccounts = processLinkedAccounts;
        return this;
    }

    @ApiModelProperty(value="If true, all linked accounts are also processed using the same rules.")
    public Boolean isProcessLinkedAccounts() {
        return this.processLinkedAccounts;
    }

    public void setProcessLinkedAccounts(Boolean processLinkedAccounts) {
        this.processLinkedAccounts = processLinkedAccounts;
    }

    public AccountsReceivableRetryConfig processingPercentage(String processingPercentage) {
        this.processingPercentage = processingPercentage;
        return this;
    }

    @ApiModelProperty(value="The percentage rate charged for the service.")
    public String getProcessingPercentage() {
        return this.processingPercentage;
    }

    public void setProcessingPercentage(String processingPercentage) {
        this.processingPercentage = processingPercentage;
    }

    public AccountsReceivableRetryConfig rejectAtEnd(Boolean rejectAtEnd) {
        this.rejectAtEnd = rejectAtEnd;
        return this;
    }

    @ApiModelProperty(value="If true, the order is rejected the day after the last configured activity day")
    public Boolean isRejectAtEnd() {
        return this.rejectAtEnd;
    }

    public void setRejectAtEnd(Boolean rejectAtEnd) {
        this.rejectAtEnd = rejectAtEnd;
    }

    public AccountsReceivableRetryConfig trialMode(Boolean trialMode) {
        this.trialMode = trialMode;
        return this;
    }

    @ApiModelProperty(value="True if the account is currently in trial mode.  Set to false to exit trial mode.")
    public Boolean isTrialMode() {
        return this.trialMode;
    }

    public void setTrialMode(Boolean trialMode) {
        this.trialMode = trialMode;
    }

    public AccountsReceivableRetryConfig trialModeExpirationDts(String trialModeExpirationDts) {
        this.trialModeExpirationDts = trialModeExpirationDts;
        return this;
    }

    @ApiModelProperty(value="The date when trial mode expires.  If this date is reached without exiting trial mode, the service will de-activate.")
    public String getTrialModeExpirationDts() {
        return this.trialModeExpirationDts;
    }

    public void setTrialModeExpirationDts(String trialModeExpirationDts) {
        this.trialModeExpirationDts = trialModeExpirationDts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountsReceivableRetryConfig accountsReceivableRetryConfig = (AccountsReceivableRetryConfig)o;
        return Objects.equals(this.active, accountsReceivableRetryConfig.active) && Objects.equals(this.allowProcessLinkedAccounts, accountsReceivableRetryConfig.allowProcessLinkedAccounts) && Objects.equals(this.cancelAutoOrder, accountsReceivableRetryConfig.cancelAutoOrder) && Objects.equals(this.currentServicePlan, accountsReceivableRetryConfig.currentServicePlan) && Objects.equals(this.dailyActivityList, accountsReceivableRetryConfig.dailyActivityList) && Objects.equals(this.managedByLinkedAccountMerchantId, accountsReceivableRetryConfig.managedByLinkedAccountMerchantId) && Objects.equals(this.merchantId, accountsReceivableRetryConfig.merchantId) && Objects.equals(this.notifyEmails, accountsReceivableRetryConfig.notifyEmails) && Objects.equals(this.notifyRejections, accountsReceivableRetryConfig.notifyRejections) && Objects.equals(this.notifySuccesses, accountsReceivableRetryConfig.notifySuccesses) && Objects.equals(this.processLinkedAccounts, accountsReceivableRetryConfig.processLinkedAccounts) && Objects.equals(this.processingPercentage, accountsReceivableRetryConfig.processingPercentage) && Objects.equals(this.rejectAtEnd, accountsReceivableRetryConfig.rejectAtEnd) && Objects.equals(this.trialMode, accountsReceivableRetryConfig.trialMode) && Objects.equals(this.trialModeExpirationDts, accountsReceivableRetryConfig.trialModeExpirationDts);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.allowProcessLinkedAccounts, this.cancelAutoOrder, this.currentServicePlan, this.dailyActivityList, this.managedByLinkedAccountMerchantId, this.merchantId, this.notifyEmails, this.notifyRejections, this.notifySuccesses, this.processLinkedAccounts, this.processingPercentage, this.rejectAtEnd, this.trialMode, this.trialModeExpirationDts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountsReceivableRetryConfig {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    allowProcessLinkedAccounts: ").append(this.toIndentedString(this.allowProcessLinkedAccounts)).append("\n");
        sb.append("    cancelAutoOrder: ").append(this.toIndentedString(this.cancelAutoOrder)).append("\n");
        sb.append("    currentServicePlan: ").append(this.toIndentedString(this.currentServicePlan)).append("\n");
        sb.append("    dailyActivityList: ").append(this.toIndentedString(this.dailyActivityList)).append("\n");
        sb.append("    managedByLinkedAccountMerchantId: ").append(this.toIndentedString(this.managedByLinkedAccountMerchantId)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    notifyEmails: ").append(this.toIndentedString(this.notifyEmails)).append("\n");
        sb.append("    notifyRejections: ").append(this.toIndentedString(this.notifyRejections)).append("\n");
        sb.append("    notifySuccesses: ").append(this.toIndentedString(this.notifySuccesses)).append("\n");
        sb.append("    processLinkedAccounts: ").append(this.toIndentedString(this.processLinkedAccounts)).append("\n");
        sb.append("    processingPercentage: ").append(this.toIndentedString(this.processingPercentage)).append("\n");
        sb.append("    rejectAtEnd: ").append(this.toIndentedString(this.rejectAtEnd)).append("\n");
        sb.append("    trialMode: ").append(this.toIndentedString(this.trialMode)).append("\n");
        sb.append("    trialModeExpirationDts: ").append(this.toIndentedString(this.trialModeExpirationDts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

