/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.Webhook;
import com.ultracart.admin.v2.models.WebhookLogResponse;
import com.ultracart.admin.v2.models.WebhookLogSummariesResponse;
import com.ultracart.admin.v2.models.WebhookResponse;
import com.ultracart.admin.v2.models.WebhookSampleRequestResponse;
import com.ultracart.admin.v2.models.WebhooksResponse;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class WebhookApi {
    private ApiClient apiClient;

    public WebhookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhookApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WebhookApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public WebhookApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteWebhookCall(Integer webhookOid, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhook/webhooks/{webhookOid}".replaceAll("\\{webhookOid\\}", this.apiClient.escapeString(webhookOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteWebhookValidateBeforeCall(Integer webhookOid, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookOid == null) {
            throw new ApiException("Missing the required parameter 'webhookOid' when calling deleteWebhook(Async)");
        }
        Call call = this.deleteWebhookCall(webhookOid, progressListener, progressRequestListener);
        return call;
    }

    public void deleteWebhook(Integer webhookOid) throws ApiException {
        this.deleteWebhookWithHttpInfo(webhookOid);
    }

    public ApiResponse<Void> deleteWebhookWithHttpInfo(Integer webhookOid) throws ApiException {
        Call call = this.deleteWebhookValidateBeforeCall(webhookOid, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteWebhookAsync(Integer webhookOid, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWebhookValidateBeforeCall(webhookOid, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteWebhookByUrlCall(Webhook webhook, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Webhook localVarPostBody = webhook;
        String localVarPath = "/webhook/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteWebhookByUrlValidateBeforeCall(Webhook webhook, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhook == null) {
            throw new ApiException("Missing the required parameter 'webhook' when calling deleteWebhookByUrl(Async)");
        }
        Call call = this.deleteWebhookByUrlCall(webhook, progressListener, progressRequestListener);
        return call;
    }

    public WebhookResponse deleteWebhookByUrl(Webhook webhook) throws ApiException {
        ApiResponse<WebhookResponse> resp = this.deleteWebhookByUrlWithHttpInfo(webhook);
        return resp.getData();
    }

    public ApiResponse<WebhookResponse> deleteWebhookByUrlWithHttpInfo(Webhook webhook) throws ApiException {
        Call call = this.deleteWebhookByUrlValidateBeforeCall(webhook, null, null);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteWebhookByUrlAsync(Webhook webhook, final ApiCallback<WebhookResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWebhookByUrlValidateBeforeCall(webhook, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWebhookLogCall(Integer webhookOid, String requestId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhook/webhooks/{webhookOid}/logs/{requestId}".replaceAll("\\{webhookOid\\}", this.apiClient.escapeString(webhookOid.toString())).replaceAll("\\{requestId\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWebhookLogValidateBeforeCall(Integer webhookOid, String requestId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookOid == null) {
            throw new ApiException("Missing the required parameter 'webhookOid' when calling getWebhookLog(Async)");
        }
        if (requestId == null) {
            throw new ApiException("Missing the required parameter 'requestId' when calling getWebhookLog(Async)");
        }
        Call call = this.getWebhookLogCall(webhookOid, requestId, progressListener, progressRequestListener);
        return call;
    }

    public WebhookLogResponse getWebhookLog(Integer webhookOid, String requestId) throws ApiException {
        ApiResponse<WebhookLogResponse> resp = this.getWebhookLogWithHttpInfo(webhookOid, requestId);
        return resp.getData();
    }

    public ApiResponse<WebhookLogResponse> getWebhookLogWithHttpInfo(Integer webhookOid, String requestId) throws ApiException {
        Call call = this.getWebhookLogValidateBeforeCall(webhookOid, requestId, null, null);
        Type localVarReturnType = new TypeToken<WebhookLogResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWebhookLogAsync(Integer webhookOid, String requestId, final ApiCallback<WebhookLogResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWebhookLogValidateBeforeCall(webhookOid, requestId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookLogResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWebhookLogSummariesCall(Integer webhookOid, Integer limit, Integer offset, String since, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhook/webhooks/{webhookOid}/logs".replaceAll("\\{webhookOid\\}", this.apiClient.escapeString(webhookOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_since", since));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWebhookLogSummariesValidateBeforeCall(Integer webhookOid, Integer limit, Integer offset, String since, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookOid == null) {
            throw new ApiException("Missing the required parameter 'webhookOid' when calling getWebhookLogSummaries(Async)");
        }
        Call call = this.getWebhookLogSummariesCall(webhookOid, limit, offset, since, progressListener, progressRequestListener);
        return call;
    }

    public WebhookLogSummariesResponse getWebhookLogSummaries(Integer webhookOid, Integer limit, Integer offset, String since) throws ApiException {
        ApiResponse<WebhookLogSummariesResponse> resp = this.getWebhookLogSummariesWithHttpInfo(webhookOid, limit, offset, since);
        return resp.getData();
    }

    public ApiResponse<WebhookLogSummariesResponse> getWebhookLogSummariesWithHttpInfo(Integer webhookOid, Integer limit, Integer offset, String since) throws ApiException {
        Call call = this.getWebhookLogSummariesValidateBeforeCall(webhookOid, limit, offset, since, null, null);
        Type localVarReturnType = new TypeToken<WebhookLogSummariesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWebhookLogSummariesAsync(Integer webhookOid, Integer limit, Integer offset, String since, final ApiCallback<WebhookLogSummariesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWebhookLogSummariesValidateBeforeCall(webhookOid, limit, offset, since, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookLogSummariesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWebhooksCall(Integer limit, Integer offset, String sort, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhook/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_sort", sort));
        }
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWebhooksValidateBeforeCall(Integer limit, Integer offset, String sort, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getWebhooksCall(limit, offset, sort, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public WebhooksResponse getWebhooks(Integer limit, Integer offset, String sort, Boolean placeholders) throws ApiException {
        ApiResponse<WebhooksResponse> resp = this.getWebhooksWithHttpInfo(limit, offset, sort, placeholders);
        return resp.getData();
    }

    public ApiResponse<WebhooksResponse> getWebhooksWithHttpInfo(Integer limit, Integer offset, String sort, Boolean placeholders) throws ApiException {
        Call call = this.getWebhooksValidateBeforeCall(limit, offset, sort, placeholders, null, null);
        Type localVarReturnType = new TypeToken<WebhooksResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWebhooksAsync(Integer limit, Integer offset, String sort, Boolean placeholders, final ApiCallback<WebhooksResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWebhooksValidateBeforeCall(limit, offset, sort, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhooksResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call insertWebhookCall(Webhook webhook, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Webhook localVarPostBody = webhook;
        String localVarPath = "/webhook/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call insertWebhookValidateBeforeCall(Webhook webhook, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhook == null) {
            throw new ApiException("Missing the required parameter 'webhook' when calling insertWebhook(Async)");
        }
        Call call = this.insertWebhookCall(webhook, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public WebhookResponse insertWebhook(Webhook webhook, Boolean placeholders) throws ApiException {
        ApiResponse<WebhookResponse> resp = this.insertWebhookWithHttpInfo(webhook, placeholders);
        return resp.getData();
    }

    public ApiResponse<WebhookResponse> insertWebhookWithHttpInfo(Webhook webhook, Boolean placeholders) throws ApiException {
        Call call = this.insertWebhookValidateBeforeCall(webhook, placeholders, null, null);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call insertWebhookAsync(Webhook webhook, Boolean placeholders, final ApiCallback<WebhookResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.insertWebhookValidateBeforeCall(webhook, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resendEventCall(Integer webhookOid, String eventName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhook/webhooks/{webhookOid}/reflow/{eventName}".replaceAll("\\{webhookOid\\}", this.apiClient.escapeString(webhookOid.toString())).replaceAll("\\{eventName\\}", this.apiClient.escapeString(eventName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resendEventValidateBeforeCall(Integer webhookOid, String eventName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookOid == null) {
            throw new ApiException("Missing the required parameter 'webhookOid' when calling resendEvent(Async)");
        }
        if (eventName == null) {
            throw new ApiException("Missing the required parameter 'eventName' when calling resendEvent(Async)");
        }
        Call call = this.resendEventCall(webhookOid, eventName, progressListener, progressRequestListener);
        return call;
    }

    public WebhookSampleRequestResponse resendEvent(Integer webhookOid, String eventName) throws ApiException {
        ApiResponse<WebhookSampleRequestResponse> resp = this.resendEventWithHttpInfo(webhookOid, eventName);
        return resp.getData();
    }

    public ApiResponse<WebhookSampleRequestResponse> resendEventWithHttpInfo(Integer webhookOid, String eventName) throws ApiException {
        Call call = this.resendEventValidateBeforeCall(webhookOid, eventName, null, null);
        Type localVarReturnType = new TypeToken<WebhookSampleRequestResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call resendEventAsync(Integer webhookOid, String eventName, final ApiCallback<WebhookSampleRequestResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resendEventValidateBeforeCall(webhookOid, eventName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookSampleRequestResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateWebhookCall(Webhook webhook, Integer webhookOid, Boolean placeholders, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Webhook localVarPostBody = webhook;
        String localVarPath = "/webhook/webhooks/{webhookOid}".replaceAll("\\{webhookOid\\}", this.apiClient.escapeString(webhookOid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (placeholders != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_placeholders", placeholders));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateWebhookValidateBeforeCall(Webhook webhook, Integer webhookOid, Boolean placeholders, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhook == null) {
            throw new ApiException("Missing the required parameter 'webhook' when calling updateWebhook(Async)");
        }
        if (webhookOid == null) {
            throw new ApiException("Missing the required parameter 'webhookOid' when calling updateWebhook(Async)");
        }
        Call call = this.updateWebhookCall(webhook, webhookOid, placeholders, progressListener, progressRequestListener);
        return call;
    }

    public WebhookResponse updateWebhook(Webhook webhook, Integer webhookOid, Boolean placeholders) throws ApiException {
        ApiResponse<WebhookResponse> resp = this.updateWebhookWithHttpInfo(webhook, webhookOid, placeholders);
        return resp.getData();
    }

    public ApiResponse<WebhookResponse> updateWebhookWithHttpInfo(Webhook webhook, Integer webhookOid, Boolean placeholders) throws ApiException {
        Call call = this.updateWebhookValidateBeforeCall(webhook, webhookOid, placeholders, null, null);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateWebhookAsync(Webhook webhook, Integer webhookOid, Boolean placeholders, final ApiCallback<WebhookResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateWebhookValidateBeforeCall(webhook, webhookOid, placeholders, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WebhookResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

