/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.TaxCity;
import com.ultracart.admin.v2.models.TaxCountry;
import com.ultracart.admin.v2.models.TaxCounty;
import com.ultracart.admin.v2.models.TaxPostalCode;
import com.ultracart.admin.v2.models.TaxProviderActivateResult;
import com.ultracart.admin.v2.models.TaxProviderAvalara;
import com.ultracart.admin.v2.models.TaxProviderAvalaraCompaniesResult;
import com.ultracart.admin.v2.models.TaxProviderSelf;
import com.ultracart.admin.v2.models.TaxProviderSelfCountriesResponse;
import com.ultracart.admin.v2.models.TaxProviderSelfRegionsResponse;
import com.ultracart.admin.v2.models.TaxProviderSovos;
import com.ultracart.admin.v2.models.TaxProviderTaxJar;
import com.ultracart.admin.v2.models.TaxProviderTestResult;
import com.ultracart.admin.v2.models.TaxProviderUltraCart;
import com.ultracart.admin.v2.models.TaxProvidersResponse;
import com.ultracart.admin.v2.models.TaxState;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class TaxApi {
    private ApiClient apiClient;

    public TaxApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaxApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TaxApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public TaxApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteTaxProviderSelfCityCall(String city, TaxCity taxCity, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxCity localVarPostBody = taxCity;
        String localVarPath = "/tax/providers/self/city/{city}".replaceAll("\\{city\\}", this.apiClient.escapeString(city.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTaxProviderSelfCityValidateBeforeCall(String city, TaxCity taxCity, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (city == null) {
            throw new ApiException("Missing the required parameter 'city' when calling deleteTaxProviderSelfCity(Async)");
        }
        if (taxCity == null) {
            throw new ApiException("Missing the required parameter 'taxCity' when calling deleteTaxProviderSelfCity(Async)");
        }
        Call call = this.deleteTaxProviderSelfCityCall(city, taxCity, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTaxProviderSelfCity(String city, TaxCity taxCity) throws ApiException {
        this.deleteTaxProviderSelfCityWithHttpInfo(city, taxCity);
    }

    public ApiResponse<Void> deleteTaxProviderSelfCityWithHttpInfo(String city, TaxCity taxCity) throws ApiException {
        Call call = this.deleteTaxProviderSelfCityValidateBeforeCall(city, taxCity, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTaxProviderSelfCityAsync(String city, TaxCity taxCity, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTaxProviderSelfCityValidateBeforeCall(city, taxCity, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteTaxProviderSelfCountryCall(String countryCode, TaxCountry taxCountry, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxCountry localVarPostBody = taxCountry;
        String localVarPath = "/tax/providers/self/country/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTaxProviderSelfCountryValidateBeforeCall(String countryCode, TaxCountry taxCountry, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling deleteTaxProviderSelfCountry(Async)");
        }
        if (taxCountry == null) {
            throw new ApiException("Missing the required parameter 'taxCountry' when calling deleteTaxProviderSelfCountry(Async)");
        }
        Call call = this.deleteTaxProviderSelfCountryCall(countryCode, taxCountry, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTaxProviderSelfCountry(String countryCode, TaxCountry taxCountry) throws ApiException {
        this.deleteTaxProviderSelfCountryWithHttpInfo(countryCode, taxCountry);
    }

    public ApiResponse<Void> deleteTaxProviderSelfCountryWithHttpInfo(String countryCode, TaxCountry taxCountry) throws ApiException {
        Call call = this.deleteTaxProviderSelfCountryValidateBeforeCall(countryCode, taxCountry, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTaxProviderSelfCountryAsync(String countryCode, TaxCountry taxCountry, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTaxProviderSelfCountryValidateBeforeCall(countryCode, taxCountry, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteTaxProviderSelfCountyCall(String county, TaxCounty taxCounty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxCounty localVarPostBody = taxCounty;
        String localVarPath = "/tax/providers/self/county/{county}".replaceAll("\\{county\\}", this.apiClient.escapeString(county.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTaxProviderSelfCountyValidateBeforeCall(String county, TaxCounty taxCounty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (county == null) {
            throw new ApiException("Missing the required parameter 'county' when calling deleteTaxProviderSelfCounty(Async)");
        }
        if (taxCounty == null) {
            throw new ApiException("Missing the required parameter 'taxCounty' when calling deleteTaxProviderSelfCounty(Async)");
        }
        Call call = this.deleteTaxProviderSelfCountyCall(county, taxCounty, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTaxProviderSelfCounty(String county, TaxCounty taxCounty) throws ApiException {
        this.deleteTaxProviderSelfCountyWithHttpInfo(county, taxCounty);
    }

    public ApiResponse<Void> deleteTaxProviderSelfCountyWithHttpInfo(String county, TaxCounty taxCounty) throws ApiException {
        Call call = this.deleteTaxProviderSelfCountyValidateBeforeCall(county, taxCounty, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTaxProviderSelfCountyAsync(String county, TaxCounty taxCounty, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTaxProviderSelfCountyValidateBeforeCall(county, taxCounty, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteTaxProviderSelfPostalCodeCall(String postalCode, TaxPostalCode taxPostalCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxPostalCode localVarPostBody = taxPostalCode;
        String localVarPath = "/tax/providers/self/postalCode/{postal_code}".replaceAll("\\{postal_code\\}", this.apiClient.escapeString(postalCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTaxProviderSelfPostalCodeValidateBeforeCall(String postalCode, TaxPostalCode taxPostalCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (postalCode == null) {
            throw new ApiException("Missing the required parameter 'postalCode' when calling deleteTaxProviderSelfPostalCode(Async)");
        }
        if (taxPostalCode == null) {
            throw new ApiException("Missing the required parameter 'taxPostalCode' when calling deleteTaxProviderSelfPostalCode(Async)");
        }
        Call call = this.deleteTaxProviderSelfPostalCodeCall(postalCode, taxPostalCode, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTaxProviderSelfPostalCode(String postalCode, TaxPostalCode taxPostalCode) throws ApiException {
        this.deleteTaxProviderSelfPostalCodeWithHttpInfo(postalCode, taxPostalCode);
    }

    public ApiResponse<Void> deleteTaxProviderSelfPostalCodeWithHttpInfo(String postalCode, TaxPostalCode taxPostalCode) throws ApiException {
        Call call = this.deleteTaxProviderSelfPostalCodeValidateBeforeCall(postalCode, taxPostalCode, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTaxProviderSelfPostalCodeAsync(String postalCode, TaxPostalCode taxPostalCode, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTaxProviderSelfPostalCodeValidateBeforeCall(postalCode, taxPostalCode, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteTaxProviderSelfStateCall(String stateCode, TaxState taxState, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxState localVarPostBody = taxState;
        String localVarPath = "/tax/providers/self/state/{stateCode}".replaceAll("\\{stateCode\\}", this.apiClient.escapeString(stateCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTaxProviderSelfStateValidateBeforeCall(String stateCode, TaxState taxState, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (stateCode == null) {
            throw new ApiException("Missing the required parameter 'stateCode' when calling deleteTaxProviderSelfState(Async)");
        }
        if (taxState == null) {
            throw new ApiException("Missing the required parameter 'taxState' when calling deleteTaxProviderSelfState(Async)");
        }
        Call call = this.deleteTaxProviderSelfStateCall(stateCode, taxState, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTaxProviderSelfState(String stateCode, TaxState taxState) throws ApiException {
        this.deleteTaxProviderSelfStateWithHttpInfo(stateCode, taxState);
    }

    public ApiResponse<Void> deleteTaxProviderSelfStateWithHttpInfo(String stateCode, TaxState taxState) throws ApiException {
        Call call = this.deleteTaxProviderSelfStateValidateBeforeCall(stateCode, taxState, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTaxProviderSelfStateAsync(String stateCode, TaxState taxState, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTaxProviderSelfStateValidateBeforeCall(stateCode, taxState, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getTaxProviderAvalaraCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/avalara";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderAvalaraValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderAvalaraCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderAvalara getTaxProviderAvalara() throws ApiException {
        ApiResponse<TaxProviderAvalara> resp = this.getTaxProviderAvalaraWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderAvalara> getTaxProviderAvalaraWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderAvalaraValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderAvalara>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderAvalaraAsync(final ApiCallback<TaxProviderAvalara> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderAvalaraValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderAvalara>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderAvalaraCompaniesCall(TaxProviderAvalara taxProviderAvalara, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxProviderAvalara localVarPostBody = taxProviderAvalara;
        String localVarPath = "/tax/providers/avalara/companies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderAvalaraCompaniesValidateBeforeCall(TaxProviderAvalara taxProviderAvalara, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (taxProviderAvalara == null) {
            throw new ApiException("Missing the required parameter 'taxProviderAvalara' when calling getTaxProviderAvalaraCompanies(Async)");
        }
        Call call = this.getTaxProviderAvalaraCompaniesCall(taxProviderAvalara, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderAvalaraCompaniesResult getTaxProviderAvalaraCompanies(TaxProviderAvalara taxProviderAvalara) throws ApiException {
        ApiResponse<TaxProviderAvalaraCompaniesResult> resp = this.getTaxProviderAvalaraCompaniesWithHttpInfo(taxProviderAvalara);
        return resp.getData();
    }

    public ApiResponse<TaxProviderAvalaraCompaniesResult> getTaxProviderAvalaraCompaniesWithHttpInfo(TaxProviderAvalara taxProviderAvalara) throws ApiException {
        Call call = this.getTaxProviderAvalaraCompaniesValidateBeforeCall(taxProviderAvalara, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderAvalaraCompaniesResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderAvalaraCompaniesAsync(TaxProviderAvalara taxProviderAvalara, final ApiCallback<TaxProviderAvalaraCompaniesResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderAvalaraCompaniesValidateBeforeCall(taxProviderAvalara, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderAvalaraCompaniesResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderAvalaraTestCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/avalara/test";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderAvalaraTestValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderAvalaraTestCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderTestResult getTaxProviderAvalaraTest() throws ApiException {
        ApiResponse<TaxProviderTestResult> resp = this.getTaxProviderAvalaraTestWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderTestResult> getTaxProviderAvalaraTestWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderAvalaraTestValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderTestResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderAvalaraTestAsync(final ApiCallback<TaxProviderTestResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderAvalaraTestValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderTestResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderSelfCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/self";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderSelfValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderSelfCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderSelf getTaxProviderSelf() throws ApiException {
        ApiResponse<TaxProviderSelf> resp = this.getTaxProviderSelfWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderSelf> getTaxProviderSelfWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderSelfValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderSelf>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderSelfAsync(final ApiCallback<TaxProviderSelf> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderSelfValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderSelf>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderSelfCountriesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/self/countries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderSelfCountriesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderSelfCountriesCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderSelfCountriesResponse getTaxProviderSelfCountries() throws ApiException {
        ApiResponse<TaxProviderSelfCountriesResponse> resp = this.getTaxProviderSelfCountriesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderSelfCountriesResponse> getTaxProviderSelfCountriesWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderSelfCountriesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderSelfCountriesResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderSelfCountriesAsync(final ApiCallback<TaxProviderSelfCountriesResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderSelfCountriesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderSelfCountriesResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderSelfRegionsByCountryCodeCall(String countryCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/self/regions/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderSelfRegionsByCountryCodeValidateBeforeCall(String countryCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling getTaxProviderSelfRegionsByCountryCode(Async)");
        }
        Call call = this.getTaxProviderSelfRegionsByCountryCodeCall(countryCode, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderSelfRegionsResponse getTaxProviderSelfRegionsByCountryCode(String countryCode) throws ApiException {
        ApiResponse<TaxProviderSelfRegionsResponse> resp = this.getTaxProviderSelfRegionsByCountryCodeWithHttpInfo(countryCode);
        return resp.getData();
    }

    public ApiResponse<TaxProviderSelfRegionsResponse> getTaxProviderSelfRegionsByCountryCodeWithHttpInfo(String countryCode) throws ApiException {
        Call call = this.getTaxProviderSelfRegionsByCountryCodeValidateBeforeCall(countryCode, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderSelfRegionsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderSelfRegionsByCountryCodeAsync(String countryCode, final ApiCallback<TaxProviderSelfRegionsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderSelfRegionsByCountryCodeValidateBeforeCall(countryCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderSelfRegionsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderSovosCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/sovos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderSovosValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderSovosCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderSovos getTaxProviderSovos() throws ApiException {
        ApiResponse<TaxProviderSovos> resp = this.getTaxProviderSovosWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderSovos> getTaxProviderSovosWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderSovosValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderSovos>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderSovosAsync(final ApiCallback<TaxProviderSovos> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderSovosValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderSovos>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderSovosTestCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/sovos/test";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderSovosTestValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderSovosTestCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderTestResult getTaxProviderSovosTest() throws ApiException {
        ApiResponse<TaxProviderTestResult> resp = this.getTaxProviderSovosTestWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderTestResult> getTaxProviderSovosTestWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderSovosTestValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderTestResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderSovosTestAsync(final ApiCallback<TaxProviderTestResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderSovosTestValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderTestResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderTaxJarCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/taxjar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderTaxJarValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderTaxJarCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderTaxJar getTaxProviderTaxJar() throws ApiException {
        ApiResponse<TaxProviderTaxJar> resp = this.getTaxProviderTaxJarWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderTaxJar> getTaxProviderTaxJarWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderTaxJarValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderTaxJar>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderTaxJarAsync(final ApiCallback<TaxProviderTaxJar> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderTaxJarValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderTaxJar>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderTaxJarTestCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/taxjar/test";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderTaxJarTestValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderTaxJarTestCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderTestResult getTaxProviderTaxJarTest() throws ApiException {
        ApiResponse<TaxProviderTestResult> resp = this.getTaxProviderTaxJarTestWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderTestResult> getTaxProviderTaxJarTestWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderTaxJarTestValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderTestResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderTaxJarTestAsync(final ApiCallback<TaxProviderTestResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderTaxJarTestValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderTestResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProviderUltraCartCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/ultracart";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProviderUltraCartValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProviderUltraCartCall(progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderUltraCart getTaxProviderUltraCart() throws ApiException {
        ApiResponse<TaxProviderUltraCart> resp = this.getTaxProviderUltraCartWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<TaxProviderUltraCart> getTaxProviderUltraCartWithHttpInfo() throws ApiException {
        Call call = this.getTaxProviderUltraCartValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<TaxProviderUltraCart>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProviderUltraCartAsync(final ApiCallback<TaxProviderUltraCart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProviderUltraCartValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderUltraCart>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTaxProvidersCall(Integer limit, Integer offset, String expand, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_offset", offset));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("_expand", expand));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTaxProvidersValidateBeforeCall(Integer limit, Integer offset, String expand, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTaxProvidersCall(limit, offset, expand, progressListener, progressRequestListener);
        return call;
    }

    public TaxProvidersResponse getTaxProviders(Integer limit, Integer offset, String expand) throws ApiException {
        ApiResponse<TaxProvidersResponse> resp = this.getTaxProvidersWithHttpInfo(limit, offset, expand);
        return resp.getData();
    }

    public ApiResponse<TaxProvidersResponse> getTaxProvidersWithHttpInfo(Integer limit, Integer offset, String expand) throws ApiException {
        Call call = this.getTaxProvidersValidateBeforeCall(limit, offset, expand, null, null);
        Type localVarReturnType = new TypeToken<TaxProvidersResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTaxProvidersAsync(Integer limit, Integer offset, String expand, final ApiCallback<TaxProvidersResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTaxProvidersValidateBeforeCall(limit, offset, expand, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProvidersResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call setActiveTaxProviderCall(String providerName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/tax/providers/setActive/{providerName}".replaceAll("\\{providerName\\}", this.apiClient.escapeString(providerName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call setActiveTaxProviderValidateBeforeCall(String providerName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (providerName == null) {
            throw new ApiException("Missing the required parameter 'providerName' when calling setActiveTaxProvider(Async)");
        }
        Call call = this.setActiveTaxProviderCall(providerName, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderActivateResult setActiveTaxProvider(String providerName) throws ApiException {
        ApiResponse<TaxProviderActivateResult> resp = this.setActiveTaxProviderWithHttpInfo(providerName);
        return resp.getData();
    }

    public ApiResponse<TaxProviderActivateResult> setActiveTaxProviderWithHttpInfo(String providerName) throws ApiException {
        Call call = this.setActiveTaxProviderValidateBeforeCall(providerName, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderActivateResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call setActiveTaxProviderAsync(String providerName, final ApiCallback<TaxProviderActivateResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.setActiveTaxProviderValidateBeforeCall(providerName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderActivateResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderAvalaraCall(TaxProviderAvalara taxProviderAvalara, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxProviderAvalara localVarPostBody = taxProviderAvalara;
        String localVarPath = "/tax/providers/avalara";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderAvalaraValidateBeforeCall(TaxProviderAvalara taxProviderAvalara, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (taxProviderAvalara == null) {
            throw new ApiException("Missing the required parameter 'taxProviderAvalara' when calling updateTaxProviderAvalara(Async)");
        }
        Call call = this.updateTaxProviderAvalaraCall(taxProviderAvalara, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderAvalara updateTaxProviderAvalara(TaxProviderAvalara taxProviderAvalara) throws ApiException {
        ApiResponse<TaxProviderAvalara> resp = this.updateTaxProviderAvalaraWithHttpInfo(taxProviderAvalara);
        return resp.getData();
    }

    public ApiResponse<TaxProviderAvalara> updateTaxProviderAvalaraWithHttpInfo(TaxProviderAvalara taxProviderAvalara) throws ApiException {
        Call call = this.updateTaxProviderAvalaraValidateBeforeCall(taxProviderAvalara, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderAvalara>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderAvalaraAsync(TaxProviderAvalara taxProviderAvalara, final ApiCallback<TaxProviderAvalara> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderAvalaraValidateBeforeCall(taxProviderAvalara, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderAvalara>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderSelfCall(TaxProviderSelf taxProviderSelf, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxProviderSelf localVarPostBody = taxProviderSelf;
        String localVarPath = "/tax/providers/self";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderSelfValidateBeforeCall(TaxProviderSelf taxProviderSelf, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (taxProviderSelf == null) {
            throw new ApiException("Missing the required parameter 'taxProviderSelf' when calling updateTaxProviderSelf(Async)");
        }
        Call call = this.updateTaxProviderSelfCall(taxProviderSelf, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderSelf updateTaxProviderSelf(TaxProviderSelf taxProviderSelf) throws ApiException {
        ApiResponse<TaxProviderSelf> resp = this.updateTaxProviderSelfWithHttpInfo(taxProviderSelf);
        return resp.getData();
    }

    public ApiResponse<TaxProviderSelf> updateTaxProviderSelfWithHttpInfo(TaxProviderSelf taxProviderSelf) throws ApiException {
        Call call = this.updateTaxProviderSelfValidateBeforeCall(taxProviderSelf, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderSelf>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderSelfAsync(TaxProviderSelf taxProviderSelf, final ApiCallback<TaxProviderSelf> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderSelfValidateBeforeCall(taxProviderSelf, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderSelf>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderSelfCityCall(String city, TaxCity taxCity, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxCity localVarPostBody = taxCity;
        String localVarPath = "/tax/providers/self/city/{city}".replaceAll("\\{city\\}", this.apiClient.escapeString(city.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderSelfCityValidateBeforeCall(String city, TaxCity taxCity, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (city == null) {
            throw new ApiException("Missing the required parameter 'city' when calling updateTaxProviderSelfCity(Async)");
        }
        if (taxCity == null) {
            throw new ApiException("Missing the required parameter 'taxCity' when calling updateTaxProviderSelfCity(Async)");
        }
        Call call = this.updateTaxProviderSelfCityCall(city, taxCity, progressListener, progressRequestListener);
        return call;
    }

    public TaxCity updateTaxProviderSelfCity(String city, TaxCity taxCity) throws ApiException {
        ApiResponse<TaxCity> resp = this.updateTaxProviderSelfCityWithHttpInfo(city, taxCity);
        return resp.getData();
    }

    public ApiResponse<TaxCity> updateTaxProviderSelfCityWithHttpInfo(String city, TaxCity taxCity) throws ApiException {
        Call call = this.updateTaxProviderSelfCityValidateBeforeCall(city, taxCity, null, null);
        Type localVarReturnType = new TypeToken<TaxCity>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderSelfCityAsync(String city, TaxCity taxCity, final ApiCallback<TaxCity> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderSelfCityValidateBeforeCall(city, taxCity, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxCity>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderSelfCountryCall(String countryCode, TaxCountry taxCountry, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxCountry localVarPostBody = taxCountry;
        String localVarPath = "/tax/providers/self/country/{countryCode}".replaceAll("\\{countryCode\\}", this.apiClient.escapeString(countryCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderSelfCountryValidateBeforeCall(String countryCode, TaxCountry taxCountry, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (countryCode == null) {
            throw new ApiException("Missing the required parameter 'countryCode' when calling updateTaxProviderSelfCountry(Async)");
        }
        if (taxCountry == null) {
            throw new ApiException("Missing the required parameter 'taxCountry' when calling updateTaxProviderSelfCountry(Async)");
        }
        Call call = this.updateTaxProviderSelfCountryCall(countryCode, taxCountry, progressListener, progressRequestListener);
        return call;
    }

    public TaxCountry updateTaxProviderSelfCountry(String countryCode, TaxCountry taxCountry) throws ApiException {
        ApiResponse<TaxCountry> resp = this.updateTaxProviderSelfCountryWithHttpInfo(countryCode, taxCountry);
        return resp.getData();
    }

    public ApiResponse<TaxCountry> updateTaxProviderSelfCountryWithHttpInfo(String countryCode, TaxCountry taxCountry) throws ApiException {
        Call call = this.updateTaxProviderSelfCountryValidateBeforeCall(countryCode, taxCountry, null, null);
        Type localVarReturnType = new TypeToken<TaxCountry>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderSelfCountryAsync(String countryCode, TaxCountry taxCountry, final ApiCallback<TaxCountry> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderSelfCountryValidateBeforeCall(countryCode, taxCountry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxCountry>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderSelfCountyCall(String county, TaxCounty taxCounty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxCounty localVarPostBody = taxCounty;
        String localVarPath = "/tax/providers/self/county/{county}".replaceAll("\\{county\\}", this.apiClient.escapeString(county.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderSelfCountyValidateBeforeCall(String county, TaxCounty taxCounty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (county == null) {
            throw new ApiException("Missing the required parameter 'county' when calling updateTaxProviderSelfCounty(Async)");
        }
        if (taxCounty == null) {
            throw new ApiException("Missing the required parameter 'taxCounty' when calling updateTaxProviderSelfCounty(Async)");
        }
        Call call = this.updateTaxProviderSelfCountyCall(county, taxCounty, progressListener, progressRequestListener);
        return call;
    }

    public TaxCounty updateTaxProviderSelfCounty(String county, TaxCounty taxCounty) throws ApiException {
        ApiResponse<TaxCounty> resp = this.updateTaxProviderSelfCountyWithHttpInfo(county, taxCounty);
        return resp.getData();
    }

    public ApiResponse<TaxCounty> updateTaxProviderSelfCountyWithHttpInfo(String county, TaxCounty taxCounty) throws ApiException {
        Call call = this.updateTaxProviderSelfCountyValidateBeforeCall(county, taxCounty, null, null);
        Type localVarReturnType = new TypeToken<TaxCounty>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderSelfCountyAsync(String county, TaxCounty taxCounty, final ApiCallback<TaxCounty> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderSelfCountyValidateBeforeCall(county, taxCounty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxCounty>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderSelfPostalCodeCall(String postalCode, TaxPostalCode taxPostalCode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxPostalCode localVarPostBody = taxPostalCode;
        String localVarPath = "/tax/providers/self/postalCode/{postal_code}".replaceAll("\\{postal_code\\}", this.apiClient.escapeString(postalCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderSelfPostalCodeValidateBeforeCall(String postalCode, TaxPostalCode taxPostalCode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (postalCode == null) {
            throw new ApiException("Missing the required parameter 'postalCode' when calling updateTaxProviderSelfPostalCode(Async)");
        }
        if (taxPostalCode == null) {
            throw new ApiException("Missing the required parameter 'taxPostalCode' when calling updateTaxProviderSelfPostalCode(Async)");
        }
        Call call = this.updateTaxProviderSelfPostalCodeCall(postalCode, taxPostalCode, progressListener, progressRequestListener);
        return call;
    }

    public TaxPostalCode updateTaxProviderSelfPostalCode(String postalCode, TaxPostalCode taxPostalCode) throws ApiException {
        ApiResponse<TaxPostalCode> resp = this.updateTaxProviderSelfPostalCodeWithHttpInfo(postalCode, taxPostalCode);
        return resp.getData();
    }

    public ApiResponse<TaxPostalCode> updateTaxProviderSelfPostalCodeWithHttpInfo(String postalCode, TaxPostalCode taxPostalCode) throws ApiException {
        Call call = this.updateTaxProviderSelfPostalCodeValidateBeforeCall(postalCode, taxPostalCode, null, null);
        Type localVarReturnType = new TypeToken<TaxPostalCode>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderSelfPostalCodeAsync(String postalCode, TaxPostalCode taxPostalCode, final ApiCallback<TaxPostalCode> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderSelfPostalCodeValidateBeforeCall(postalCode, taxPostalCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxPostalCode>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderSelfStateCall(String stateCode, TaxState taxState, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxState localVarPostBody = taxState;
        String localVarPath = "/tax/providers/self/state/{stateCode}".replaceAll("\\{stateCode\\}", this.apiClient.escapeString(stateCode.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderSelfStateValidateBeforeCall(String stateCode, TaxState taxState, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (stateCode == null) {
            throw new ApiException("Missing the required parameter 'stateCode' when calling updateTaxProviderSelfState(Async)");
        }
        if (taxState == null) {
            throw new ApiException("Missing the required parameter 'taxState' when calling updateTaxProviderSelfState(Async)");
        }
        Call call = this.updateTaxProviderSelfStateCall(stateCode, taxState, progressListener, progressRequestListener);
        return call;
    }

    public TaxState updateTaxProviderSelfState(String stateCode, TaxState taxState) throws ApiException {
        ApiResponse<TaxState> resp = this.updateTaxProviderSelfStateWithHttpInfo(stateCode, taxState);
        return resp.getData();
    }

    public ApiResponse<TaxState> updateTaxProviderSelfStateWithHttpInfo(String stateCode, TaxState taxState) throws ApiException {
        Call call = this.updateTaxProviderSelfStateValidateBeforeCall(stateCode, taxState, null, null);
        Type localVarReturnType = new TypeToken<TaxState>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderSelfStateAsync(String stateCode, TaxState taxState, final ApiCallback<TaxState> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderSelfStateValidateBeforeCall(stateCode, taxState, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxState>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderSovosCall(TaxProviderSovos taxProviderSovos, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxProviderSovos localVarPostBody = taxProviderSovos;
        String localVarPath = "/tax/providers/sovos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderSovosValidateBeforeCall(TaxProviderSovos taxProviderSovos, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (taxProviderSovos == null) {
            throw new ApiException("Missing the required parameter 'taxProviderSovos' when calling updateTaxProviderSovos(Async)");
        }
        Call call = this.updateTaxProviderSovosCall(taxProviderSovos, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderSovos updateTaxProviderSovos(TaxProviderSovos taxProviderSovos) throws ApiException {
        ApiResponse<TaxProviderSovos> resp = this.updateTaxProviderSovosWithHttpInfo(taxProviderSovos);
        return resp.getData();
    }

    public ApiResponse<TaxProviderSovos> updateTaxProviderSovosWithHttpInfo(TaxProviderSovos taxProviderSovos) throws ApiException {
        Call call = this.updateTaxProviderSovosValidateBeforeCall(taxProviderSovos, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderSovos>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderSovosAsync(TaxProviderSovos taxProviderSovos, final ApiCallback<TaxProviderSovos> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderSovosValidateBeforeCall(taxProviderSovos, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderSovos>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderTaxJarCall(TaxProviderTaxJar taxProviderTaxJar, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxProviderTaxJar localVarPostBody = taxProviderTaxJar;
        String localVarPath = "/tax/providers/taxjar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderTaxJarValidateBeforeCall(TaxProviderTaxJar taxProviderTaxJar, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (taxProviderTaxJar == null) {
            throw new ApiException("Missing the required parameter 'taxProviderTaxJar' when calling updateTaxProviderTaxJar(Async)");
        }
        Call call = this.updateTaxProviderTaxJarCall(taxProviderTaxJar, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderTaxJar updateTaxProviderTaxJar(TaxProviderTaxJar taxProviderTaxJar) throws ApiException {
        ApiResponse<TaxProviderTaxJar> resp = this.updateTaxProviderTaxJarWithHttpInfo(taxProviderTaxJar);
        return resp.getData();
    }

    public ApiResponse<TaxProviderTaxJar> updateTaxProviderTaxJarWithHttpInfo(TaxProviderTaxJar taxProviderTaxJar) throws ApiException {
        Call call = this.updateTaxProviderTaxJarValidateBeforeCall(taxProviderTaxJar, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderTaxJar>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderTaxJarAsync(TaxProviderTaxJar taxProviderTaxJar, final ApiCallback<TaxProviderTaxJar> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderTaxJarValidateBeforeCall(taxProviderTaxJar, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderTaxJar>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateTaxProviderUltraCartCall(TaxProviderUltraCart taxProviderUltracart, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TaxProviderUltraCart localVarPostBody = taxProviderUltracart;
        String localVarPath = "/tax/providers/ultracart";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateTaxProviderUltraCartValidateBeforeCall(TaxProviderUltraCart taxProviderUltracart, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (taxProviderUltracart == null) {
            throw new ApiException("Missing the required parameter 'taxProviderUltracart' when calling updateTaxProviderUltraCart(Async)");
        }
        Call call = this.updateTaxProviderUltraCartCall(taxProviderUltracart, progressListener, progressRequestListener);
        return call;
    }

    public TaxProviderUltraCart updateTaxProviderUltraCart(TaxProviderUltraCart taxProviderUltracart) throws ApiException {
        ApiResponse<TaxProviderUltraCart> resp = this.updateTaxProviderUltraCartWithHttpInfo(taxProviderUltracart);
        return resp.getData();
    }

    public ApiResponse<TaxProviderUltraCart> updateTaxProviderUltraCartWithHttpInfo(TaxProviderUltraCart taxProviderUltracart) throws ApiException {
        Call call = this.updateTaxProviderUltraCartValidateBeforeCall(taxProviderUltracart, null, null);
        Type localVarReturnType = new TypeToken<TaxProviderUltraCart>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateTaxProviderUltraCartAsync(TaxProviderUltraCart taxProviderUltracart, final ApiCallback<TaxProviderUltraCart> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateTaxProviderUltraCartValidateBeforeCall(taxProviderUltracart, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TaxProviderUltraCart>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

