/*
 * Decompiled with CFR 0.152.
 */
package com.ultracart.admin.v2;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.ultracart.admin.v2.models.SingleSignOnAuthorizeRequest;
import com.ultracart.admin.v2.models.SingleSignOnAuthorizeResponse;
import com.ultracart.admin.v2.models.SingleSignOnTokenRequest;
import com.ultracart.admin.v2.models.SingleSignOnTokenResponse;
import com.ultracart.admin.v2.models.User;
import com.ultracart.admin.v2.swagger.ApiCallback;
import com.ultracart.admin.v2.swagger.ApiClient;
import com.ultracart.admin.v2.swagger.ApiException;
import com.ultracart.admin.v2.swagger.ApiResponse;
import com.ultracart.admin.v2.swagger.Configuration;
import com.ultracart.admin.v2.swagger.Pair;
import com.ultracart.admin.v2.swagger.ProgressRequestBody;
import com.ultracart.admin.v2.swagger.ProgressResponseBody;
import com.ultracart.admin.v2.swagger.auth.ApiKeyAuth;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SsoApi {
    private ApiClient apiClient;

    public SsoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SsoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SsoApi(String apiKey) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        this.apiClient = client;
    }

    public SsoApi(String apiKey, boolean verifySsl, boolean debugging) {
        ApiClient client = new ApiClient();
        ApiKeyAuth ultraCartSimpleApiKey = (ApiKeyAuth)client.getAuthentication("ultraCartSimpleApiKey");
        ultraCartSimpleApiKey.setApiKey(apiKey);
        client.addDefaultHeader("X-UltraCart-Api-Version", "2017-03-01");
        client.setDebugging(debugging);
        client.setVerifyingSsl(verifySsl);
        this.apiClient = client;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getSsoSessionUserCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sso/session/user";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSsoSessionUserValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSsoSessionUserCall(progressListener, progressRequestListener);
        return call;
    }

    public User getSsoSessionUser() throws ApiException {
        ApiResponse<User> resp = this.getSsoSessionUserWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<User> getSsoSessionUserWithHttpInfo() throws ApiException {
        Call call = this.getSsoSessionUserValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSsoSessionUserAsync(final ApiCallback<User> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSsoSessionUserValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call ssoAuthorizeCall(SingleSignOnAuthorizeRequest authorizationRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SingleSignOnAuthorizeRequest localVarPostBody = authorizationRequest;
        String localVarPath = "/sso/authorize";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call ssoAuthorizeValidateBeforeCall(SingleSignOnAuthorizeRequest authorizationRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (authorizationRequest == null) {
            throw new ApiException("Missing the required parameter 'authorizationRequest' when calling ssoAuthorize(Async)");
        }
        Call call = this.ssoAuthorizeCall(authorizationRequest, progressListener, progressRequestListener);
        return call;
    }

    public SingleSignOnAuthorizeResponse ssoAuthorize(SingleSignOnAuthorizeRequest authorizationRequest) throws ApiException {
        ApiResponse<SingleSignOnAuthorizeResponse> resp = this.ssoAuthorizeWithHttpInfo(authorizationRequest);
        return resp.getData();
    }

    public ApiResponse<SingleSignOnAuthorizeResponse> ssoAuthorizeWithHttpInfo(SingleSignOnAuthorizeRequest authorizationRequest) throws ApiException {
        Call call = this.ssoAuthorizeValidateBeforeCall(authorizationRequest, null, null);
        Type localVarReturnType = new TypeToken<SingleSignOnAuthorizeResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call ssoAuthorizeAsync(SingleSignOnAuthorizeRequest authorizationRequest, final ApiCallback<SingleSignOnAuthorizeResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.ssoAuthorizeValidateBeforeCall(authorizationRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SingleSignOnAuthorizeResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call ssoSessionRevokeCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/sso/session/revoke";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call ssoSessionRevokeValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.ssoSessionRevokeCall(progressListener, progressRequestListener);
        return call;
    }

    public void ssoSessionRevoke() throws ApiException {
        this.ssoSessionRevokeWithHttpInfo();
    }

    public ApiResponse<Void> ssoSessionRevokeWithHttpInfo() throws ApiException {
        Call call = this.ssoSessionRevokeValidateBeforeCall(null, null);
        return this.apiClient.execute(call);
    }

    public Call ssoSessionRevokeAsync(final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.ssoSessionRevokeValidateBeforeCall(progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call ssoTokenCall(SingleSignOnTokenRequest tokenRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SingleSignOnTokenRequest localVarPostBody = tokenRequest;
        String localVarPath = "/sso/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json; charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"ultraCartOauth", "ultraCartSimpleApiKey"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call ssoTokenValidateBeforeCall(SingleSignOnTokenRequest tokenRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenRequest == null) {
            throw new ApiException("Missing the required parameter 'tokenRequest' when calling ssoToken(Async)");
        }
        Call call = this.ssoTokenCall(tokenRequest, progressListener, progressRequestListener);
        return call;
    }

    public SingleSignOnTokenResponse ssoToken(SingleSignOnTokenRequest tokenRequest) throws ApiException {
        ApiResponse<SingleSignOnTokenResponse> resp = this.ssoTokenWithHttpInfo(tokenRequest);
        return resp.getData();
    }

    public ApiResponse<SingleSignOnTokenResponse> ssoTokenWithHttpInfo(SingleSignOnTokenRequest tokenRequest) throws ApiException {
        Call call = this.ssoTokenValidateBeforeCall(tokenRequest, null, null);
        Type localVarReturnType = new TypeToken<SingleSignOnTokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call ssoTokenAsync(SingleSignOnTokenRequest tokenRequest, final ApiCallback<SingleSignOnTokenResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.ssoTokenValidateBeforeCall(tokenRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SingleSignOnTokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

